//start of DynamicHuffman.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * DynamicHuffman.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.lang.Cloneable;

//import exceptions
import java.io.IOException;

/**
 * Int}NXB
 * 
 * <pre>
 * -- revision history --
 * $Log: DynamicHuffman.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     addLeaf() ŗt̐ 1  2ւƑƂ
 *     ŏ炠t̏d 1 ƌߕtĂB
 * [change]
 *     RXgN^ DynamicHuffman( int, int ) 
 *     Jñnt}؂̃TCYłȂ Jn̗t̐n悤ɕύXB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̕ύX
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class DynamicHuffman implements Cloneable{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  public static final int ROOT
    //  private static final int MAX_WEIGHT
    //------------------------------------------------------------------
    /**
     * nt}؂̃[gB
     */
    public static final int ROOT = 0;

    /**
     * nt}؂č\zd
     */
    private static final int MAX_WEIGHT = 0x8000;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman tree
    //------------------------------------------------------------------
    //  private int[] weight
    //  private int[] child
    //  private int[] parent
    //  private int[] leafs
    //  private int size
    //------------------------------------------------------------------
    /**
     * Ỹm[h̏dB
     */
    private int[] weight;

    /**
     * Ỹm[h̎qm[h̃m[hԍێ
     * Z𗘗p邽߁A
     * child      m[h̃m[hԍ
     * child - 1  傫m[h̃m[hԍƂȂB
     * t̏ꍇ̓f[^bit]̂ĂB
     */
    private int[] child;

    /**
     * Ỹm[h̐em[h̃m[hԍێ
     */
    private int[] parent;

    /**
     * t̃m[hԍێB
     */
    private int[] leafs;

    /**
     * ݂̃nt}؂̑傫
     */
    private int size;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private DynamicHuffman()
    //  public DynamicHuffman( int count )
    //  public DynamicHuffman( int max, int first )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private DynamicHuffman(){   }

    /**
     * RXgN^
     * 
     * @param count t̐
     */
    public DynamicHuffman( int count ){
        this( count, count );
    }

    /**
     * RXgN^
     * 
     * @param max   t̍ő吔
     * @param start Jn̗t̐ 
     */
    public DynamicHuffman( int max, int first ){
        if( 1 <= first && first <= max ){

            this.weight = new int[ max * 2 - 1 ];
            this.child  = new int[ max * 2 - 1 ];
            this.parent = new int[ max * 2 - 1 ];
            this.leafs  = new int[ max ];
            this.size   = Math.max( 0, first * 2 - 1 );

            //t𐶐ĂB
            int node = this.size - 1;
            for( int code = 0 ; code < first ; code++, node-- ){
                this.weight[ node ] = 1;
                this.child[ node ]  = ~code;
                this.leafs[ code ]  = node;
            }

            //}𐶐ĂB
            int child = this.size - 1;
            while( 0 <= node && node != child ){
                this.weight[node]  = this.weight[child] + this.weight[child-1];

                this.child[node]   = child;
                this.parent[child] = this.parent[child-1] = node;

                child -= 2;
                node--;
            }
        }else if( max < first ){
            throw new IllegalArgumentException( "\"max\" must be larger than \"first\"." );
        }else{
            throw new IllegalArgumentException( "\"first\" must be one or more." );
        }
    }


    //------------------------------------------------------------------
    //  method of java.lang.Object
    //------------------------------------------------------------------
    //  public Object clone()
    //------------------------------------------------------------------
    /**
     * ̃IuWFNǧ݂̏ԂRs[쐬ĕԂB
     * 
     * @return ̃IuWFNǧ݂̏ԂRs[
     */
    public Object clone(){
        DynamicHuffman clone = new DynamicHuffman();
        clone.weight = (int[])this.weight.clone();
        clone.child  = (int[])this.child.clone();
        clone.parent = (int[])this.parent.clone();
        clone.leafs  = (int[])this.leafs.clone();
        clone.size   = this.size;
        return clone;
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  access to huffman tree
    //------------------------------------------------------------------
    //  public int codeToNode( int code )
    //  public int childNode( int node )
    //  public int parentNode( int node )
    //------------------------------------------------------------------
    /**
     * f[^m[hԍ𓾂B
     * 
     * @param code f[^
     * 
     * @return codẽm[hԍ
     */
    public int codeToNode( int code ){
        return this.leafs[code];
    }

    /**
     * m[htłȂm[hȂqm[h̃m[hԍA
     * m[htȂm[h̎f[^Srbg]̂𓾂B
     * qm[h̃m[hԍ͌ZƗp邽߁A<br>
     * node  0 ̎qm[h̏ꍇ childNode( node )<br>
     * node  1 ̎qm[h̏ꍇ childNode( node ) - 1<br>
     * ƂȂB
     * 
     * @param node m[h
     * 
     * @return node ̎qm[h̃m[hԍ
     */
    public int childNode( int node ){
        return this.child[node];
    }

    /**
     * node ̐em[h̃m[hԍ𓾂B
     * 
     * @param node m[h
     * 
     * @return node ̐em[h̃m[hԍB
     */
    public int parentNode( int node ){
        return this.parent[node];
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  update huffman tree
    //------------------------------------------------------------------
    //  public void update( int code )
    //  public void addLeaf( int code )
    //------------------------------------------------------------------
    /**
     * code ̏d݂悤Ƀnt}؂XVB
     * 
     * @param code d݂𑝂₷t
     */
    public void update( int code ){
        if( this.weight[ DynamicHuffman.ROOT ] == DynamicHuffman.MAX_WEIGHT ){
            this.rebuildTree();
        }

        int node = this.leafs[code];
        while( DynamicHuffman.ROOT != node ){
            int swapNode = node;
            while( this.weight[swapNode - 1] == this.weight[node]
                && DynamicHuffman.ROOT < swapNode - 1 ){
                swapNode--;
            }

            if( node != swapNode ) this.swap( node, swapNode );

            this.weight[swapNode]++;
            node = this.parent[swapNode];
        }
        this.weight[ DynamicHuffman.ROOT ]++;
    }

    /**
     * nt}؂ code tǉB
     * 
     * @param code t̎
     * 
     * @exception IllegalStateException
     *              nt}؂\ɑ傫
     *              tǉłȂꍇ
     */
    public void addLeaf( int code ){
        if( this.size < this.weight.length - 1 ){
            int last  = this.size - 1;
            int large = this.size;
            int small = this.size + 1;
            this.child[ large ] = this.child[ last ];
            this.child[ small ] = ~code;
            this.child[ last ]  = small;
            this.weight[ large ] = this.weight[ last ];
            this.weight[ small ] = 0;
            this.leafs[ ~this.child[ large ] ] = large;
            this.leafs[ ~this.child[ small ] ] = small;
            this.parent[ large ] = this.parent[ small ] = last;
            this.size = small + 1;

            if( last == DynamicHuffman.ROOT ){
                this.weight[ last  ] -= 1;
            }

            this.update( code );
        }else{
            throw new IllegalStateException();
        }
    }

    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void rebuildTree()
    //  private void swap( int i, int j )
    //------------------------------------------------------------------
    /**
     * nt}؂č\zB
     * d݂ privateȒ萔 MAX_WEIGHT 𒴂
     * update(int)ĂяoB
     * SẴm[h̏d݂ 悻ɂB
     */
    private void rebuildTree(){
        int leafCount = 0;
        for( int i = 0 ; i < this.size ; i++ )
            if( this.child[i] < 0 ){
                this.weight[leafCount] = ( this.weight[i] + 1 ) / 2;
                this.child[leafCount]  = this.child[i];
                leafCount++;
            }

        leafCount--;
        int position     = this.size - 1;
        int leafPosition = this.size - 2;
        while( 0 <= position ){
            while( leafPosition <= position ){
                this.leafs[~this.child[leafCount]] = position;
                this.weight[ position ]  = this.weight[ leafCount ];
                this.child[ position-- ] = this.child[ leafCount-- ];
            }

            int weight = this.weight[leafPosition]
                       + this.weight[leafPosition + 1];

            while( 0 <= leafCount && this.weight[leafCount] <= weight ){
                this.leafs[~this.child[leafCount]] = position;
                this.weight[ position ]  = this.weight[ leafCount ];
                this.child[ position-- ] = this.child[ leafCount-- ];
            }

            this.weight[position] = weight;
            this.child[position]  = leafPosition + 1;
            this.parent[leafPosition]
                = this.parent[leafPosition + 1]
                = position;

            position--;
            leafPosition -= 2;
        }
    }

    /**
     * m[hԍĩm[h
     * m[hԍj̃m[hꊷ鏈sB
     * 
     * @param i ꊷΏۂ̃m[h
     * @param j ꊷΏۂ̃m[h
     */
    private void swap( int i, int j ){
        if( this.child[i] < 0 ){
            this.leafs[ ~this.child[i] ] = j;
        }else{
            this.parent[ this.child[i] ]
                = this.parent[ this.child[i] - 1 ]
                = j;
        }

        if( this.child[j] < 0 ){
            this.leafs[ ~this.child[j] ] = i;
        }else{
            this.parent[ this.child[j] ]
                = this.parent[ this.child[j] - 1 ]
                = i;
        }

        int temp      = this.child[i];
        this.child[i] = this.child[j];
        this.child[j] = temp;

        temp           = this.weight[i];
        this.weight[i] = this.weight[j];
        this.weight[j] = temp;
    }

}
//end of DynamicHuffman.java
