/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import jdepend.framework.JavaPackage;

public class PropertyConfigurator {
    private Properties properties;
    public static final String DEFAULT_PROPERTY_FILE = "jdepend.properties";
    static /* synthetic */ Class class$jdepend$framework$PropertyConfigurator;

    public PropertyConfigurator() {
        this(PropertyConfigurator.getDefaultPropertyFile());
    }

    public PropertyConfigurator(Properties p) {
        this.properties = p;
    }

    public PropertyConfigurator(File f) {
        this(PropertyConfigurator.loadProperties(f));
    }

    public Collection getFilteredPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("ignore")) continue;
            String path = this.properties.getProperty(key);
            StringTokenizer st = new StringTokenizer(path, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                name = name.trim();
                packages.add(name);
            }
        }
        return packages;
    }

    public Collection getConfiguredPackages() {
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("ignore") || key.equals("analyzeInnerClasses")) continue;
            String v = this.properties.getProperty(key);
            packages.add(new JavaPackage(key, new Integer(v)));
        }
        return packages;
    }

    public boolean getAnalyzeInnerClasses() {
        String key = "analyzeInnerClasses";
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            return new Boolean(value);
        }
        return true;
    }

    public static File getDefaultPropertyFile() {
        String home = System.getProperty("user.home");
        return new File(home, DEFAULT_PROPERTY_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadProperties(File file) {
        Properties p;
        block14: {
            InputStream is;
            block13: {
                p = new Properties();
                is = null;
                try {
                    is = new FileInputStream(file);
                }
                catch (Exception e) {
                    is = (class$jdepend$framework$PropertyConfigurator == null ? (class$jdepend$framework$PropertyConfigurator = PropertyConfigurator.class$("jdepend.framework.PropertyConfigurator")) : class$jdepend$framework$PropertyConfigurator).getResourceAsStream("/jdepend.properties");
                }
                if (is == null) break block13;
                p.load(is);
            }
            Object var5_5 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block14;
            }
            catch (IOException ignore) {}
            break block14;
            {
                catch (IOException iOException) {
                    Object var5_6 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

