--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.SGIX
-- Copyright   :  (c) Sven Panne 2018
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- A convenience module, combining all raw modules containing SGIX extensions.
--
--------------------------------------------------------------------------------

module Graphics.GL.SGIX (
  module Graphics.GL.SGIX.Async,
  module Graphics.GL.SGIX.AsyncHistogram,
  module Graphics.GL.SGIX.AsyncPixel,
  module Graphics.GL.SGIX.BlendAlphaMinmax,
  module Graphics.GL.SGIX.CalligraphicFragment,
  module Graphics.GL.SGIX.Clipmap,
  module Graphics.GL.SGIX.ConvolutionAccuracy,
  module Graphics.GL.SGIX.DepthTexture,
  module Graphics.GL.SGIX.FlushRaster,
  module Graphics.GL.SGIX.FogOffset,
  module Graphics.GL.SGIX.FragmentLighting,
  module Graphics.GL.SGIX.Framezoom,
  module Graphics.GL.SGIX.IglooInterface,
  module Graphics.GL.SGIX.Instruments,
  module Graphics.GL.SGIX.Interlace,
  module Graphics.GL.SGIX.IrInstrument1,
  module Graphics.GL.SGIX.ListPriority,
  module Graphics.GL.SGIX.PixelTexture,
  module Graphics.GL.SGIX.PixelTiles,
  module Graphics.GL.SGIX.PolynomialFFD,
  module Graphics.GL.SGIX.ReferencePlane,
  module Graphics.GL.SGIX.Resample,
  module Graphics.GL.SGIX.ScalebiasHint,
  module Graphics.GL.SGIX.Shadow,
  module Graphics.GL.SGIX.ShadowAmbient,
  module Graphics.GL.SGIX.Sprite,
  module Graphics.GL.SGIX.Subsample,
  module Graphics.GL.SGIX.TagSampleBuffer,
  module Graphics.GL.SGIX.TextureAddEnv,
  module Graphics.GL.SGIX.TextureCoordinateClamp,
  module Graphics.GL.SGIX.TextureLODBias,
  module Graphics.GL.SGIX.TextureMultiBuffer,
  module Graphics.GL.SGIX.TextureScaleBias,
  module Graphics.GL.SGIX.VertexPreclip,
  module Graphics.GL.SGIX.YCrCb,
  module Graphics.GL.SGIX.YCrCbA
) where

import Graphics.GL.SGIX.Async
import Graphics.GL.SGIX.AsyncHistogram
import Graphics.GL.SGIX.AsyncPixel
import Graphics.GL.SGIX.BlendAlphaMinmax
import Graphics.GL.SGIX.CalligraphicFragment
import Graphics.GL.SGIX.Clipmap
import Graphics.GL.SGIX.ConvolutionAccuracy
import Graphics.GL.SGIX.DepthTexture
import Graphics.GL.SGIX.FlushRaster
import Graphics.GL.SGIX.FogOffset
import Graphics.GL.SGIX.FragmentLighting
import Graphics.GL.SGIX.Framezoom
import Graphics.GL.SGIX.IglooInterface
import Graphics.GL.SGIX.Instruments
import Graphics.GL.SGIX.Interlace
import Graphics.GL.SGIX.IrInstrument1
import Graphics.GL.SGIX.ListPriority
import Graphics.GL.SGIX.PixelTexture
import Graphics.GL.SGIX.PixelTiles
import Graphics.GL.SGIX.PolynomialFFD
import Graphics.GL.SGIX.ReferencePlane
import Graphics.GL.SGIX.Resample
import Graphics.GL.SGIX.ScalebiasHint
import Graphics.GL.SGIX.Shadow
import Graphics.GL.SGIX.ShadowAmbient
import Graphics.GL.SGIX.Sprite
import Graphics.GL.SGIX.Subsample
import Graphics.GL.SGIX.TagSampleBuffer
import Graphics.GL.SGIX.TextureAddEnv
import Graphics.GL.SGIX.TextureCoordinateClamp
import Graphics.GL.SGIX.TextureLODBias
import Graphics.GL.SGIX.TextureMultiBuffer
import Graphics.GL.SGIX.TextureScaleBias
import Graphics.GL.SGIX.VertexPreclip
import Graphics.GL.SGIX.YCrCb
import Graphics.GL.SGIX.YCrCbA
