<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exslt="http://exslt.org/common"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:doc="http://www.w3.org/2000/10/swap/pim/doc#"
    xmlns:mat="http://www.w3.org/2002/05/matrix/vocab#"
    xmlns:org="http://www.w3.org/2001/04/roadmap/org#"
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:rec="http://www.w3.org/2001/02pd/rec54#">

  <xsl:import href="w3-tr-lib.xsl" />
  <xsl:output method="text" />

  <xsl:template match="/">
    <xsl:variable name="trs"> <!-- selected technical reports -->
      <xsl:call-template name="find_trs" />
    </xsl:variable>

    <xsl:variable name="entries"> <!-- (wrapped) rendered index entries -->
      <xsl:for-each select="exslt:node-set($trs)/*">
        <xsl:element name="wrapper">
          <xsl:text>  * </xsl:text>
          <xsl:call-template name="title_of_tr">
            <xsl:with-param name="rec" select="." />
          </xsl:call-template>
          <xsl:text>&#x0A;</xsl:text>
        </xsl:element>
      </xsl:for-each>
    </xsl:variable>

    <!-- sort and output -->
    <xsl:for-each select="exslt:node-set($entries)/*">
      <xsl:sort />
      <xsl:value-of select="." />
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
