/*
 * sprite_tevent.c: ˥᡼󥹥ץ饤Ȥȥץ饤Ȥΰư
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/* $Id: sprite_tevent.c,v 1.2 2003/04/25 17:23:55 chikama Exp $ */

#include "config.h"

#include <stdio.h>
#include <glib.h>

#include "portab.h"
#include "system.h"
#include "menu.h"
#include "imput.h"
#include "nact.h"
#include "sact.h"
#include "sprite.h"
#include "counter.h"

/*

 ޥ٥Ȥˤ륹ץ饤Ȥΰưȥ˥᡼󥹥ץ饤Ȥι

 ºݤˤϡnact->callback()ϤǸƤӽФǤ뤳ȤۤȤɤǡ
 ޥ٥Ȥߤץ饤ΥХåǷв֤׻
 ֤򹹿Ƥ롣

 ¾ˤ system35 Υᥤ롼 nact_main() ƤФ뤳Ȥ䡢
 X|SDLΥԤ˸ƤФ롣
 
 ץ饤Ȥΰư SACT.Draw ƤФƤư򳫻Ϥưλޤ
 ԤäƤΤǡnact_mainƤФȤϥ˥᡼󥹥ץ饤
 ι
 
*/

static void tevent_callback(agsevent_t *e);


/*
 ޥ٥ callback ᥤ
*/
static void tevent_callback(agsevent_t *e) {
	GSList *node;
	int update = 0;
	
	// SP_MOVE ƱưΤΥ󥿤ɤ߹
	sact.movecurtime = get_high_counter(SYSTEMCOUNTER_MSEC);
	
	for (node = sact.teventlisteners; node; node = node->next) {
		sprite_t *sp = (sprite_t *)node->data;
		if (sp == NULL) continue;
		if (sp->teventcb == NULL) continue;
		
		// ɽǤϥ٥Ȥȿʤ
		if (!sp->show) continue;

		// ץ饤Υޥ٥ȥϥɥθƤӽФ
		update += sp->teventcb(sp, e);
	}
	
	// ѹв̤򹹿
	if (update) {
		sp_update_clipped();
	}
	
	// timer event litener κ (Υ롼ǺǤʤΤ)
	for (node = sact.teventremovelist; node; node = node->next) {
		sprite_t *sp = (sprite_t *)node->data;
		if (sp == NULL) continue;
		sact.teventlisteners = g_slist_remove(sact.teventlisteners, sp);
	}
	g_slist_free(sact.teventremovelist);
	sact.teventremovelist = NULL;
}

/*
  ޥ٥ callback Ͽ
  @param sp: Ͽ륹ץ饤
  @param cb: ƤӽФcallback
*/
void spev_add_teventlistener(sprite_t *sp, int (*cb)(sprite_t *, agsevent_t *)) {
	sp->teventcb = cb;
	sact.teventlisteners = g_slist_append(sact.teventlisteners, sp);
}

/*
  Ͽ callback κ
  @param sp: 륹ץ饤
*/
void spev_remove_teventlistener(sprite_t *sp) {
	sact.teventlisteners = g_slist_remove(sact.teventlisteners, sp);
}

/*
  system35Υᥤ롼פǸƤФ륳Хå
*/
void spev_main() {
	agsevent_t e;
	
	e.type = AGSEVENT_TIMER;
	tevent_callback(&e);

	// ǥեȤΥХåΤɬפʤΤ
	// (VAޥcallbackϤʤ)
	if (nact->popupmenu_opened) {
		menu_gtkmainiteration();
		if (nact->is_quit) sys_exit(0);
        }
}
