/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.FormatCase;
import org.javia.arity.MoreMath;
import org.javia.arity.Util;

class TestFormat {
    static FormatCase[] cases = new FormatCase[]{new FormatCase(0, 0.1, "0.1"), new FormatCase(0, 0.12, "0.12"), new FormatCase(0, 0.001, "0.001"), new FormatCase(0, 0.0012, "0.0012"), new FormatCase(0, 1.0E-7, "1E-7"), new FormatCase(0, 1.2E-7, "1.2E-7"), new FormatCase(0, 0.123456789012345, "0.123456789012345"), new FormatCase(0, 0.0, "0"), new FormatCase(0, 1.0, "1"), new FormatCase(0, 12.0, "12"), new FormatCase(0, 1.23456789E9, "1234567890"), new FormatCase(0, 1.0E9, "1000000000"), new FormatCase(0, 1.23456789012345, "1.23456789012345"), new FormatCase(0, 12345.6789012345, "12345.6789012345"), new FormatCase(0, 1.23456789012345E9, "1234567890.12345"), new FormatCase(0, 1.23456789012345E14, "1.23456789012345E14"), new FormatCase(0, 1.0E14, "1E14"), new FormatCase(0, 1.2E14, "1.2E14"), new FormatCase(0, 1.00000000000001E14, "1.00000000000001E14"), new FormatCase(2, 0.1, "0.1"), new FormatCase(2, 1.2E-7, "1.2E-7"), new FormatCase(1, 0.123456789012345, "0.12345678901235"), new FormatCase(2, 0.0, "0"), new FormatCase(1, 1.23456789012345, "1.2345678901235"), new FormatCase(2, 1.23456789012345, "1.234567890123"), new FormatCase(0, 12345.6789012345, "12345.6789012345"), new FormatCase(1, 1.23456789012345E9, "1234567890.1235"), new FormatCase(2, 1.23456789012345E14, "1.234567890123E14"), new FormatCase(1, 1.00000000000001E14, "1E14"), new FormatCase(0, 1.2345678901234568E16, "1.2345678901234568E16"), new FormatCase(1, 1.2345678901234568E16, "1.2345678901235E16"), new FormatCase(0, 1.0E17, "1E17"), new FormatCase(0, 1.0E16, "1E16"), new FormatCase(0, 9.99999999999999E14, "9.99999999999999E14"), new FormatCase(1, 9.99999999999999E14, "1E15"), new FormatCase(1, 9.99999999999994E14, "9.9999999999999E14"), new FormatCase(1, MoreMath.log2(1.00002), "00000.28853612282487")};

    TestFormat() {
    }

    static boolean testFormat() {
        boolean bl = true;
        for (int i = 0; i < cases.length; ++i) {
            String string;
            FormatCase formatCase = cases[i];
            double d = Double.parseDouble(formatCase.res);
            if (formatCase.rounding == 0 && d != formatCase.val) {
                System.out.println("wrong test? " + formatCase.res + " " + d + " " + formatCase.val);
            }
            if (!(string = Util.doubleToString(formatCase.val, formatCase.rounding)).equals(formatCase.res)) {
                System.out.println("Expected '" + formatCase.res + "', got '" + string + "'. " + Double.toString(formatCase.val));
                bl = false;
            }
            int n = formatCase.rounding == 0 ? 17 : 15 - formatCase.rounding;
        }
        return bl;
    }
}

