---
layout: post
title: Polyglot 1.4.0
lang: en
---

Polyglot [version 1.4.0](https://rubygems.org/gems/jekyll-polyglot/versions/1.4.0) is out!

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

## static unrelativized `href`

This release provides a new liquid block tag {% raw %} {% static_href %}href="..."{% endstatic_href %} {% endraw %} which can be used to create href attributes in anchor tags that are not relativized by Polyglot.

Jekyll-Polyglot is fairly greedy and naive in it's relativization, and so if you want a url that is explicitly static (such as for [making a language switcher](https://github.com/untra/polyglot/blob/master/site/_includes/sidebar.html#L40-L42), hint hint), this liquid tag will help you construct that unmangled href="..." tag in anchor elements.

## Exclusive site language generation

Polyglot 1.4.0 adds support for `lang-exclusive: [ ]` frontmatter in documents. If added to a document, this frontmatter will limit generation of the document to that specific language.

{% highlight yaml %}
---
lang-exclusive: ['{{ site.active_lang }}']
---
{% endhighlight %}

This is a way to control which languages may see a document, even if that document may not have an equivalent in the default language site.

## Renaming a few liquid tags

The {% raw %} {% static_href %} {% endraw %} tag is also available as {% raw %} {% Static_Href %} {% endraw %}, and the existing {% raw %} {% I18n_Headers %} {% endraw %} tag now can be called as {% raw %} {% i18n_headers %} {% endraw %}

## Want to see your language featured?

I am looking for any volunteers that would like to see the [Jekyll-Polyglot homepage](https://polyglot.untra.io/) represented in your language of origin! If you find this software helpful and want to see your language represented, just reach out on the [github issues](https://github.com/untra/polyglot/issues).
