---
layout: post
title: Polyglot 1.2.4
lang: en
---

A new version of Polyglot has been released! Give it a try!

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

This release was made possible due to the kind support of github user [vlsi](https://github.com/vlsi), who helped fix a few bugs and added new features:

### Support translation of absolute URLs
Polyglot will now translate your `site.url`, so absolute urls will now get translated as well.

### Translation of all Jekyll Collections
[Jekyll collections](https://jekyllrb.com/docs/collections/) are a fairly new feature. This update translates all registered collections, not just site posts and pages.

### Use language-specific `_data` for `site.data` rich text when `site.data[:lang]` is present
Top level rich text organized by language will be assigned to the site.data when building. Before, when rendering rich text, you would have to use:
{% highlight html %}
{% raw %}
{{ site.data[site.active_lang].richTextString }}
{% endraw %}
{% endhighlight %}
Now rich text can be rendered with just:
{% highlight html %}
{% raw %}
{{ site.data.richTextString }}
{% endraw %}
{% endhighlight %}

### The `I18n_Headers` tag now defaults to `site.url` when left blank
Users can now use
{% highlight html %}
{% raw %}
{% I18n_Headers %}
{% endraw %}
{% endhighlight %}
without specifying a url, defaulting it to your `site.url`
