% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{str_unique}
\alias{str_unique}
\title{Remove duplicated strings}
\usage{
str_unique(string, locale = "en", ignore_case = FALSE, ...)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{locale}{Locale to use for comparisons. See
\code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}} for all possible options.
Defaults to "en" (English) to ensure that default behaviour is
consistent across platforms.}

\item{ignore_case}{Ignore case when comparing strings?}

\item{...}{Other options used to control collation. Passed on to
\code{\link[stringi:stri_opts_collator]{stringi::stri_opts_collator()}}.}
}
\value{
A character vector, usually shorter than \code{string}.
}
\description{
\code{str_unique()} removes duplicated values, with optional control over
how duplication is measured.
}
\examples{
str_unique(c("a", "b", "c", "b", "a"))

str_unique(c("a", "b", "c", "B", "A"))
str_unique(c("a", "b", "c", "B", "A"), ignore_case = TRUE)

# Use ... to pass additional arguments to stri_unique()
str_unique(c("motley", "mötley", "pinguino", "pingüino"))
str_unique(c("motley", "mötley", "pinguino", "pingüino"), strength = 1)
}
\seealso{
\code{\link[=unique]{unique()}}, \code{\link[stringi:stri_unique]{stringi::stri_unique()}} which this function wraps.
}
