\name{dclf.test}
\alias{dclf.test}
\alias{mad.test}
\title{
  Diggle-Cressie-Loosmore-Ford and Maximum Absolute Deviation Tests
}
\description{
  Perform the Diggle (1986) / Cressie (1991) / Loosmore and Ford (2006)
  test or the Maximum Absolute Deviation test for a spatial point pattern.
}
\usage{
dclf.test(X, \dots, alternative=c("two.sided", "less", "greater"),
                  rinterval = NULL, leaveout=1,
                  scale=NULL, clamp=FALSE, interpolate=FALSE)

mad.test(X, \dots,  alternative=c("two.sided", "less", "greater"),
                  rinterval = NULL, leaveout=1,
                  scale=NULL, clamp=FALSE, interpolate=FALSE)
}
\arguments{
  \item{X}{
    Data for the test.
    Either a point pattern (object of class \code{"ppp"}, \code{"lpp"}
    or other class), a fitted point process model (object of class \code{"ppm"},
    \code{"kppm"} or other class), a simulation envelope (object of class
    \code{"envelope"}) or a previous result of \code{dclf.test} or
    \code{mad.test}. 
  }
  \item{\dots}{
    Arguments passed to \code{\link{envelope}}.
    Useful arguments include \code{fun} to determine the summary
    function, \code{nsim} to specify the number of Monte Carlo
    simulations, \code{verbose=FALSE} to turn off the messages,
    \code{savefuns} or \code{savepatterns} to save the simulation
    results, and \code{use.theory} described under Details. 
  }
  \item{alternative}{
    The alternative hypothesis. A character string.
    The default is a two-sided alternative. See Details.
  }
  \item{rinterval}{
    Interval of values of the summary function argument \code{r}
    over which the maximum absolute deviation, or the integral,
    will be computed for the test. A numeric vector of length 2.
  }
  \item{leaveout}{
    Optional integer 0, 1 or 2 indicating how to calculate the
    deviation between the observed summary function and the
    nominal reference value, when the reference value must be estimated
    by simulation. See Details.
  }
  \item{scale}{
    Optional. A function in the \R language which determines the
    relative scale of deviations, as a function of
    distance \eqn{r}. Summary function values for distance \code{r}
    will be \emph{divided} by \code{scale(r)} before the
    test statistic is computed.
  }
  \item{clamp}{
    Logical value indicating how to compute deviations
    in a one-sided test. Deviations of the observed
    summary function from the theoretical summary function are initially
    evaluated as signed real numbers, with large positive values indicating
    consistency with the alternative hypothesis.
    If \code{clamp=FALSE} (the default), these values are not changed.
    If \code{clamp=TRUE}, any negative values are replaced by zero.
  }
  \item{interpolate}{
    Logical value specifying whether to calculate the \eqn{p}-value
    by interpolation.
    If \code{interpolate=FALSE} (the default), a standard Monte Carlo test
    is performed, yielding a \eqn{p}-value of the form \eqn{(k+1)/(n+1)}
    where \eqn{n} is the number of simulations and \eqn{k} is the number
    of simulated values which are more extreme than the observed value.
    If \code{interpolate=TRUE}, the \eqn{p}-value is calculated by
    applying kernel density estimation to the simulated values, and
    computing the tail probability for this estimated distribution.
  }
}
\details{
  These functions perform hypothesis tests for goodness-of-fit
  of a point pattern dataset to a point process model, based on
  Monte Carlo simulation from the model.

  \code{dclf.test} performs the test advocated by Loosmore and Ford (2006)
  which is also described in Diggle (1986), Cressie (1991, page 667, equation
  (8.5.42)) and Diggle (2003, page 14). See Baddeley et al (2014) for
  detailed discussion.

  \code{mad.test} performs the \sQuote{global} or
  \sQuote{Maximum Absolute Deviation} test described by Ripley (1977, 1981).
  See Baddeley et al (2014).
  
  The type of test depends on the type of argument \code{X}.
  \itemize{
    \item 
    If \code{X} is some kind of point pattern, then a test of Complete
    Spatial Randomness (CSR) will be performed. That is,
    the null hypothesis is that the point pattern is completely random.
    \item
    If \code{X} is a fitted point process model, then a test of
    goodness-of-fit for the fitted model will be performed. The model object
    contains the data point pattern to which it was originally fitted.
    The null hypothesis is that the data point pattern is a realisation
    of the model.
    \item
    If \code{X} is an envelope object generated by \code{\link{envelope}},
    then it should have been generated with \code{savefuns=TRUE} or
    \code{savepatterns=TRUE} so that it contains simulation results.
    These simulations will be treated as realisations from the null
    hypothesis.
    \item
    Alternatively \code{X} could be a previously-performed
    test of the same kind (i.e. the result of calling
    \code{dclf.test} or \code{mad.test}).
    The simulations used to perform the original test
    will be re-used to perform the new test (provided these simulations
    were saved in the original test, by setting \code{savefuns=TRUE} or
    \code{savepatterns=TRUE}).
  }

  The argument \code{alternative} specifies the alternative hypothesis,
  that is, the direction of deviation that will be considered
  statistically significant. If \code{alternative="two.sided"} (the
  default), both positive and negative deviations (between
  the observed summary function and the theoretical function)
  are significant. If \code{alternative="less"}, then only negative
  deviations (where the observed summary function is lower than the
  theoretical function) are considered. If \code{alternative="greater"},
  then only positive deviations (where the observed summary function is
  higher than the theoretical function) are considered.
  
  In all cases, the algorithm will first call \code{\link{envelope}} to
  generate or extract the simulated summary functions.
  The number of simulations that will be generated or extracted,
  is determined by the argument \code{nsim}, and defaults to 99.
  The summary function that will be computed is determined by the
  argument \code{fun} (or the first unnamed argument in the list
  \code{\dots}) and defaults to \code{\link{Kest}} (except when
  \code{X} is an envelope object generated with \code{savefuns=TRUE},
  when these functions will be taken).

  The choice of summary function \code{fun} affects the power of the
  test. It is normally recommended to apply a variance-stabilising
  transformation (Ripley, 1981). If you are using the \eqn{K} function,
  the normal practice is to replace this by the \eqn{L} function
  (Besag, 1977) computed by \code{\link{Lest}}. If you are using
  the \eqn{F} or \eqn{G} functions, the recommended practice is to apply
  Fisher's variance-stabilising transformation
  \eqn{\sin^{-1}\sqrt x}{asin(sqrt(x))} using the argument
  \code{transform}. See the Examples.

  The argument \code{rinterval} specifies the interval of
  distance values \eqn{r} which will contribute to the
  test statistic (either maximising over this range of values
  for \code{mad.test}, or integrating over this range of values
  for \code{dclf.test}). This affects the power of the test.
  General advice and experiments in Baddeley et al (2014) suggest
  that the maximum \eqn{r} value should be slightly larger than
  the maximum possible range of interaction between points. The
  \code{dclf.test} is quite sensitive to this choice, while the
  \code{mad.test} is relatively insensitive.

  It is also possible to specify a pointwise test (i.e. taking
  a single, fixed value of distance \eqn{r}) by specifing
  \code{rinterval = c(r,r)}.

  The argument \code{use.theory} passed to \code{\link{envelope}}
  determines whether to compare the summary function for the data
  to its theoretical value for CSR (\code{use.theory=TRUE})
  or to the sample mean of simulations from CSR
  (\code{use.theory=FALSE}).

  The argument \code{leaveout} specifies how to calculate the
  discrepancy between the summary function for the data and the
  nominal reference value, when the reference value must be estimated
  by simulation. The values \code{leaveout=0} and
  \code{leaveout=1} are both algebraically equivalent (Baddeley et al, 2014,
  Appendix) to computing the difference \code{observed - reference}
  where the \code{reference} is the mean of simulated values.
  The value \code{leaveout=2} gives the leave-two-out discrepancy
  proposed by Dao and Genton (2014).
}
\section{Handling Ties}{
  If the observed value of the test statistic is equal to one or more of the
  simulated values (called a \emph{tied value}), then the tied values
  will be assigned a random ordering, and a message will be printed.
}
\value{
  An object of class \code{"htest"}.
  Printing this object gives a report on the result of the test.
  The \eqn{p}-value is contained in the component \code{p.value}.
}
\references{
  Baddeley, A., Diggle, P.J., Hardegen, A., Lawrence, T., Milne,
  R.K. and Nair, G. (2014) On tests of spatial pattern based on
  simulation envelopes. 
  \emph{Ecological Monographs} \bold{84}(3) 477--489.
  
  Baddeley, A., Hardegen, A., Lawrence, T., Milne, R.K. and Nair,
  G. (2015) \emph{Pushing the envelope}. In preparation.
  
  Besag, J. (1977) 
  Discussion of Dr Ripley's paper.
  \emph{Journal of the Royal Statistical Society, Series B},
  \bold{39}, 193--195.
  
  Cressie, N.A.C. (1991)
  \emph{Statistics for spatial data}.
  John Wiley and Sons, 1991.

  Dao, N.A. and Genton, M. (2014)
  A Monte Carlo adjusted goodness-of-fit test for
  parametric models describing spatial point patterns.
  \emph{Journal of Graphical and Computational Statistics}
  \bold{23}, 497--517.

  Diggle, P. J. (1986).
  Displaced amacrine cells in the retina of a
  rabbit : analysis of a bivariate spatial point pattern. 
  \emph{J. Neuroscience Methods} \bold{18}, 115--125.
 
  Diggle, P.J. (2003)
  \emph{Statistical analysis of spatial point patterns},
  Second edition. Arnold.

  Loosmore, N.B. and Ford, E.D. (2006)
  Statistical inference using the \emph{G} or \emph{K} point
  pattern spatial statistics. \emph{Ecology} \bold{87}, 1925--1931.

  Ripley, B.D. (1977)
  Modelling spatial patterns (with discussion).
  \emph{Journal of the Royal Statistical Society, Series B},
  \bold{39}, 172 -- 212.

  Ripley, B.D. (1981) 
  \emph{Spatial statistics}.
  John Wiley and Sons.
 }
\author{
  \adrian,
  Andrew Hardegen and Suman Rakshit.
}
\seealso{
  \code{\link{envelope}},
  \code{\link{dclf.progress}}
}
\examples{
  dclf.test(cells, Lest, nsim=39)
  m <- mad.test(cells, Lest, verbose=FALSE, rinterval=c(0, 0.1), nsim=19)
  m
  # extract the p-value
  m$p.value
  # variance stabilised G function
  dclf.test(cells, Gest, transform=expression(asin(sqrt(.))),
                   verbose=FALSE, nsim=19)

  ## one-sided test
  ml <- mad.test(cells, Lest, verbose=FALSE, nsim=19, alternative="less")

  ## scaled
  mad.test(cells, Kest, verbose=FALSE, nsim=19,
           rinterval=c(0.05, 0.2),
           scale=function(r) { r })
}
\keyword{spatial}
\keyword{htest}

