% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityClust.R
\name{plotTSNE}
\alias{plotTSNE}
\title{Plot observations using t-distributed neighbor embedding and colour by cluster}
\usage{
plotTSNE(x, ...)
}
\arguments{
\item{x}{A densityCluster object as produced by \code{\link[=densityClust]{densityClust()}}}

\item{...}{Additional parameters. Currently ignored}
}
\description{
This function produces an t-SNE scatterplot based on the distance matrix of the
densityCluster object (if there is only the coordinates information, a distance
matrix will be calculate first), and, if clusters are defined, colours each
observation according to cluster affiliation. Observations belonging to a cluster
core is plotted with filled circles and observations belonging to the halo with
hollow circles.
}
\examples{
irisDist <- dist(iris[,1:4])
irisClust <- densityClust(irisDist, gaussian=TRUE)
plot(irisClust) # Inspect clustering attributes to define thresholds

irisClust <- findClusters(irisClust, rho=2, delta=2)
plotTSNE(irisClust)
split(iris[,5], irisClust$clusters)

}
\seealso{
\code{\link[=densityClust]{densityClust()}} for creating \code{densityCluster}
objects, and \code{\link[=plotMDS]{plotMDS()}} for an alternative plotting approach.
}
