% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cutpointr.R
\name{plot.cutpointr}
\alias{plot.cutpointr}
\title{Plot cutpointr objects}
\usage{
\method{plot}{cutpointr}(x, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{...}{Further arguments.}
}
\description{
The plot layout depends on whether subgroups were defined and whether
bootstrapping was run.
}
\details{
The \code{...} argument can be used to apply \pkg{ggplot2} functions to every individual
plot, for example for changing the theme.
}
\examples{
opt_cut <- cutpointr(suicide, dsi, suicide, gender)
plot(opt_cut)
plot(opt_cut, ggplot2::theme_bw())
}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot_cut_boot}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_metric}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}
}
\concept{cutpointr plotting functions}
