% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/letter-to-from-num.R
\name{letter-num-conversion}
\alias{letter-num-conversion}
\alias{letter_to_num}
\alias{num_to_letter}
\title{Convert between letter and integer representations of column IDs}
\usage{
letter_to_num(x)

num_to_letter(y)
}
\arguments{
\item{x}{a character vector of "A1" style column IDs (case insensitive)}

\item{y}{a vector of integer column IDs}
}
\value{
a vector of column IDs, either character or integer
}
\description{
Convert "A1"-style column IDs from a letter representation to an integer,
e.g. column A becomes 1, column D becomes 4, etc. Or go the other way around.
}
\details{
\itemize{
\item Google Sheets have up to 300 columns (column KN).
\item Excel 2010 spreadsheets have up to 16,384 columns (column XFD).
\item ZZ is column 702.
\item ZZZ is column 18,278 (no known spreadsheet actually goes that high).
}
}
\examples{
letter_to_num('Z')
letter_to_num(c('AA', 'ZZ', 'ABD', 'ZZZ'))
letter_to_num(c(NA, ''))
num_to_letter(28)
num_to_letter(900)
num_to_letter(18278)
num_to_letter(c(25, 52, 900, 18278))
num_to_letter(c(NA, 0, 4.8, -4))
}

