import create from 'core-js-pure/full/object/create';
import defineMetadata from 'core-js-pure/full/reflect/define-metadata';
import getOwnMetadataKeys from 'core-js-pure/full/reflect/get-own-metadata-keys';

QUnit.test('Reflect.getOwnMetadataKeys', assert => {
  assert.isFunction(getOwnMetadataKeys);
  assert.arity(getOwnMetadataKeys, 1);
  assert.throws(() => getOwnMetadataKeys(undefined, undefined), TypeError);
  assert.deepEqual(getOwnMetadataKeys({}, undefined), []);
  let object = {};
  defineMetadata('key', 'value', object, undefined);
  assert.deepEqual(getOwnMetadataKeys(object, undefined), ['key']);
  let prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, undefined);
  assert.deepEqual(getOwnMetadataKeys(object, undefined), []);
  object = {};
  defineMetadata('key0', 'value', object, undefined);
  defineMetadata('key1', 'value', object, undefined);
  assert.deepEqual(getOwnMetadataKeys(object, undefined), ['key0', 'key1']);
  object = {};
  defineMetadata('key0', 'value', object, undefined);
  defineMetadata('key1', 'value', object, undefined);
  defineMetadata('key0', 'value', object, undefined);
  assert.deepEqual(getOwnMetadataKeys(object, undefined), ['key0', 'key1']);
  prototype = {};
  defineMetadata('key2', 'value', prototype, undefined);
  object = create(prototype);
  defineMetadata('key0', 'value', object, undefined);
  defineMetadata('key1', 'value', object, undefined);
  assert.deepEqual(getOwnMetadataKeys(object, undefined), ['key0', 'key1']);
  object = {};
  assert.deepEqual(getOwnMetadataKeys({}, 'name'), []);
  object = {};
  defineMetadata('key', 'value', object, 'name');
  assert.deepEqual(getOwnMetadataKeys(object, 'name'), ['key']);
  prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, 'name');
  assert.deepEqual(getOwnMetadataKeys(object, 'name'), []);
  object = {};
  defineMetadata('key0', 'value', object, 'name');
  defineMetadata('key1', 'value', object, 'name');
  defineMetadata('key0', 'value', object, 'name');
  assert.deepEqual(getOwnMetadataKeys(object, 'name'), ['key0', 'key1']);
  prototype = {};
  defineMetadata('key2', 'value', prototype, 'name');
  object = create(prototype);
  defineMetadata('key0', 'value', object, 'name');
  defineMetadata('key1', 'value', object, 'name');
  assert.deepEqual(getOwnMetadataKeys(object, 'name'), ['key0', 'key1']);
});
