'use strict';
module.exports = {
  // use transforms which does not use ES5+ builtins
  plugins: [
    ['@babel/proposal-class-static-block'],
    // private instance props in IE8- only with polyfills
    ['@babel/proposal-class-properties'],
    ['@babel/proposal-private-methods'],
    ['@babel/proposal-private-property-in-object'],
    ['@babel/proposal-logical-assignment-operators'],
    ['@babel/proposal-nullish-coalescing-operator'],
    ['@babel/proposal-numeric-separator'],
    ['@babel/proposal-object-rest-spread'],
    ['@babel/proposal-optional-catch-binding'],
    ['@babel/proposal-optional-chaining'],
    ['@babel/transform-member-expression-literals'],
    ['@babel/transform-property-literals'],
    ['@babel/transform-arrow-functions'],
    ['@babel/transform-block-scoped-functions'],
    ['@babel/transform-block-scoping'],
    // it seems `setClassMethods` unlike `loose` does not work
    ['@babel/transform-classes', { loose: true }],
    ['@babel/transform-computed-properties'],
    ['@babel/transform-destructuring'],
    ['@babel/transform-exponentiation-operator'],
    ['@babel/transform-for-of'],
    ['@babel/transform-literals'],
    ['@babel/transform-new-target'],
    ['@babel/transform-object-super'],
    ['@babel/transform-parameters'],
    ['@babel/transform-reserved-words'],
    ['@babel/transform-shorthand-properties'],
    ['@babel/transform-spread'],
    ['@babel/transform-template-literals'],
    ['@babel/transform-unicode-regex'],
    // use it instead of webpack es modules for support engines without descriptors
    ['@babel/transform-modules-commonjs'],
  ],
  assumptions: {
    constantReexports: true,
    constantSuper: true,
    enumerableModuleMeta: true,
    iterableIsArray: true,
    mutableTemplateObject: true,
    noClassCalls: true,
    noDocumentAll: true,
    noIncompleteNsImportDetection: true,
    noNewArrows: true,
    objectRestNoSymbols: true,
    privateFieldsAsProperties: true,
    setClassMethods: true,
    setComputedProperties: true,
    setPublicClassFields: true,
    setSpreadProperties: true,
    skipForOfIteratorClosing: true,
    superIsCallableConstructor: true,
  },
};
