/*
 * Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: snprintf.c,v 1.3 1998/09/07 04:29:12 onoe Exp $
 */

#include <stdio.h>
#include <stdarg.h>

extern int _doprnt();
extern FILE *_findiop();

int
vsnprintf(char *string, int n, const char *fmt, va_list ap)
{
	int ret;
	FILE *fp;

	if (n < 1)
		return EOF;
	fp = _findiop();
	fp->_file = -1;
	fp->_cnt = n;
	fp->_base = fp->_ptr = (unsigned char *)string;
#ifdef HAVE__SETBUFEND
	_setbufend(fp, string + n);
#else
	fp->_bufsiz = n;
#endif
	fp->_flag = _IOWRT;
	ret = _doprnt(fmt, ap, fp);
	if (fp->_flag & _IOERR) {
		string[n - 1] = '\0';
		return n;
	}
	*fp->_ptr = '\0';
	fp->_base = fp->_ptr = 0;
	fp->_cnt = 0;
	fp->_flag = 0;
	return ret;
}


int
snprintf(char *string, int n, const char *fmt, ...)
{
	int ret;
	va_list ap;

	va_start(ap, fmt);
	ret = vsnprintf(string, n, fmt, ap);
	va_end(ap);
	return ret;
}
