# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.implicit_function import ImplicitFunction


class ImplicitProjectOnPlaneDistance(ImplicitFunction):
    r"""
    ImplicitProjectOnPlaneDistance - This class recieve a plannar
    polygon as input.
    
    Superclass: ImplicitFunction
    
    Given a point, it can evaluate the L0 or L2 norm between the
    projection of this point on the plan of the polygon and the polygon
    itself.
    
    An interesting use of this class is to enable the L0 norm and
    evaluate the "projected distance" between every vertex of a mesh and
    the given plannar polygon. As a reslut, all the vertices that project
    onto the polygon will corresond to the value 0 and ohter ones will
    recieve the value 1. From there, we can use a clip to keep only the
    part of the mesh "below" the polygon.
    
    TLDR: This filter allows to clip using the extrusion of any plannar
    polygon.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImplicitProjectOnPlaneDistance, obj, update, **traits)
    
    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        r"""
        Set/get the Locator used by to compute the distance. A
        StaticCellLocator is provided by default if none is given by
        the user.
        """
    )

    tolerance = traits.Float(0.01, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def set_input(self, *args):
        """
        set_input(self, input:PolyData) -> None
        C++: void set_input(PolyData *input)
        Set the input PolyData used for the implicit function
        evaluation. This polydata needs to be planar.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInput, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('tolerance', 'GetTolerance'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImplicitProjectOnPlaneDistance, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImplicitProjectOnPlaneDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['tolerance']),
            title='Edit ImplicitProjectOnPlaneDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImplicitProjectOnPlaneDistance properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

