# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Property(Object):
    r"""
    Property - represent surface properties of a geometric object
    
    Superclass: Object
    
    Property is an object that represents lighting and other surface
    properties of a geometric object. The primary properties that can be
    set are colors (overall, ambient, diffuse, specular, and edge color);
    specular power; opacity of the object; the representation of the
    object (points, wireframe, or surface); and the shading method to be
    used (flat, Gouraud, and Phong). Also, some special graphics features
    like backface properties can be set and manipulated with this object.
    
    @sa
    Actor PropertyDevice
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkProperty, obj, update, **traits)
    
    backface_culling = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _backface_culling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackfaceCulling,
                        self.backface_culling_)

    edge_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _edge_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeVisibility,
                        self.edge_visibility_)

    frontface_culling = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _frontface_culling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrontfaceCulling,
                        self.frontface_culling_)

    lighting = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _lighting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLighting,
                        self.lighting_)

    render_lines_as_tubes = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _render_lines_as_tubes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderLinesAsTubes,
                        self.render_lines_as_tubes_)

    render_points_as_spheres = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _render_points_as_spheres_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderPointsAsSpheres,
                        self.render_points_as_spheres_)

    shading = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/Disable shading. When shading is enabled, the Material
        must be set.
        """
    )

    def _shading_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShading,
                        self.shading_)

    show_textures_on_backface = tvtk_base.true_bool_trait(desc=\
        r"""
        Show texture maps when the geometry is backfacing. Texture maps
        are always shown when frontfacing. By default this is true.
        """
    )

    def _show_textures_on_backface_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShowTexturesOnBackface,
                        self.show_textures_on_backface_)

    vertex_visibility = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _vertex_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexVisibility,
                        self.vertex_visibility_)

    interpolation = tvtk_base.RevPrefixMap({'gouraud': 1, 'flat': 0, 'pbr': 3, 'phong': 2}, default_value='gouraud', desc=\
        r"""
        Set the shading interpolation method for an object.
        """
    )

    def _interpolation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolation,
                        self.interpolation_)

    representation = tvtk_base.RevPrefixMap({'surface': 2, 'points': 0, 'wireframe': 1}, default_value='surface', desc=\
        r"""
        Control the surface geometry representation for the object.
        """
    )

    def _representation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRepresentation,
                        self.representation_)

    ambient = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the ambient lighting coefficient.
        """
    )

    def _ambient_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbient,
                        self.ambient)

    ambient_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/Get the ambient surface color. Not all renderers support
        separate ambient and diffuse colors. From a physical standpoint
        it really doesn't make too much sense to have both. For the
        rendering libraries that don't support both, the diffuse color is
        used.
        """
    )

    def _ambient_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbientColor,
                        self.ambient_color, True)

    anisotropy = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the anisotropy coefficient. This value controls the
        anisotropy of the material (0.0 means isotropic) This parameter
        is only used by PBR Interpolation. Default value is 0.0
        """
    )

    def _anisotropy_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnisotropy,
                        self.anisotropy)

    anisotropy_rotation = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the anisotropy rotation coefficient. This value controls
        the rotation of the direction of the anisotropy. This parameter
        is only used by PBR Interpolation. Default value is 0.0
        """
    )

    def _anisotropy_rotation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAnisotropyRotation,
                        self.anisotropy_rotation)

    base_ior = traits.Trait(1.5, traits.Range(1.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the Index Of Refraction of the base layer. It controls
        the amount of light reflected at normal incidence (the
        reflectance F0), depending on the IOR of the upper layer (eg.
        coat layer, or environment). For example, with a base IOR of 1.5
        and an IOR of 1.0 outside (IOR of the air), 4% of the amount of
        the light is reflected at normal incidence. Notice that modifying
        this value is only useful for dielectrics materials, as the
        reflectance for metallic is the albedo. This parameter is only
        used by PBR Interpolation. Default value is 1.5
        """
    )

    def _base_ior_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBaseIOR,
                        self.base_ior)

    coat_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/Get the color of the coat layer. This value is only used by
        PBR Interpolation. Default value is white [1.0, 1.0, 1.0]
        """
    )

    def _coat_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoatColor,
                        self.coat_color, True)

    coat_ior = traits.Trait(2.0, traits.Range(1.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the coat layer Index Of Refraction. This parameter is
        only used by PBR Interpolation. Default value is 2.0
        """
    )

    def _coat_ior_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoatIOR,
                        self.coat_ior)

    coat_normal_scale = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the coat layer normal scale coefficient. This value
        affects the strength of the normal deviation from the coat normal
        texture. This parameter is only used by PBR Interpolation.
        Default value is 1.0
        """
    )

    def _coat_normal_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoatNormalScale,
                        self.coat_normal_scale)

    coat_roughness = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the coat layer roughness coefficient. This value has to
        be between 0 (glossy) and 1 (rough). This parameter is only used
        by PBR Interpolation. Default value is 0.0
        """
    )

    def _coat_roughness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoatRoughness,
                        self.coat_roughness)

    coat_strength = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the coat layer strength coefficient. This value affects
        the strength of the coat layer reflection. This parameter is only
        used by PBR Interpolation. Default value is 0.0
        """
    )

    def _coat_strength_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCoatStrength,
                        self.coat_strength)

    color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set the color of the object. Has the side effect of setting the
        ambient diffuse and specular colors as well. This is basically a
        quick overall color setting method.
        """
    )

    def _color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColor,
                        self.color, True)

    diffuse = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the diffuse lighting coefficient.
        """
    )

    def _diffuse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuse,
                        self.diffuse)

    diffuse_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/Get the diffuse surface color. For PBR Interpolation,
        diffuse_color is used as the base color
        """
    )

    def _diffuse_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuseColor,
                        self.diffuse_color, True)

    edge_color = tvtk_base.vtk_color_trait((0.0, 0.0, 0.0), desc=\
        r"""
        Set/Get the color of primitive edges (if edge visibility is
        enabled).
        """
    )

    def _edge_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeColor,
                        self.edge_color, True)

    edge_tint = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the edge tint (for metals only). Set the color at grazing
        angle (fresnel reflectance). This parameter is only used by PBR
        Interpolation. Default value is [1.0, 1.0, 1.0]
        """
    )

    def _edge_tint_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeTint,
                        self.edge_tint)

    emissive_factor = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the emissive factor. This value is multiplied with the
        emissive color when an emissive texture is present. This
        parameter is only used by PBR Interpolation. Default value is
        [1.0, 1.0, 1.0]
        """
    )

    def _emissive_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEmissiveFactor,
                        self.emissive_factor)

    def _get_information(self):
        return wrap_vtk(self._vtk_obj.GetInformation())
    def _set_information(self, arg):
        old_val = self._get_information()
        self._wrap_call(self._vtk_obj.SetInformation,
                        deref_vtk(arg))
        self.trait_property_changed('information', old_val, arg)
    information = traits.Property(_get_information, _set_information, desc=\
        r"""
        Set/Get the information object associated with the Property.
        """
    )

    line_stipple_pattern = traits.Int(65535, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the stippling pattern of a Line, as a 16-bit binary
        pattern (1 = pixel on, 0 = pixel off). This is only implemented
        for open_gl, not open_gl2. The default is 0xFFFF.
        """
    )

    def _line_stipple_pattern_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineStipplePattern,
                        self.line_stipple_pattern)

    line_stipple_repeat_factor = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the stippling repeat factor of a Line, which specifies
        how many times each bit in the pattern is to be repeated. This is
        only implemented for open_gl, not open_gl2. The default is 1.
        """
    )

    def _line_stipple_repeat_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineStippleRepeatFactor,
                        self.line_stipple_repeat_factor)

    line_width = traits.Trait(1.0, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the width of a Line. The width is expressed in screen
        units. This is only implemented for open_gl. The default is 1.0.
        """
    )

    def _line_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineWidth,
                        self.line_width)

    material_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Returns the name of the material currently loaded, if any.
        """
    )

    def _material_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaterialName,
                        self.material_name)

    metallic = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the metallic coefficient. Usually this value is either 0
        or 1 for real material but any value in between is valid. This
        parameter is only used by PBR Interpolation. Default value is 0.0
        """
    )

    def _metallic_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMetallic,
                        self.metallic)

    normal_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the normal scale coefficient. This value affects the
        strength of the normal deviation from the texture. Default value
        is 1.0
        """
    )

    def _normal_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalScale,
                        self.normal_scale)

    occlusion_strength = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the occlusion strength coefficient. This value affects
        the strength of the occlusion if a material texture is present.
        This parameter is only used by PBR Interpolation. Default value
        is 1.0
        """
    )

    def _occlusion_strength_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOcclusionStrength,
                        self.occlusion_strength)

    opacity = traits.Trait(1.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the object's opacity. 1.0 is totally opaque and 0.0 is
        completely transparent.
        """
    )

    def _opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOpacity,
                        self.opacity)

    point_size = traits.Trait(1.0, traits.Range(0.0, 9.999999680285692e+37, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the diameter of a point. The size is expressed in screen
        units. This is only implemented for open_gl. The default is 1.0.
        """
    )

    def _point_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointSize,
                        self.point_size)

    roughness = traits.Trait(0.5, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the roughness coefficient. This value has to be between 0
        (glossy) and 1 (rough). A glossy material has reflections and a
        high specular part. This parameter is only used by PBR
        Interpolation. Default value is 0.5
        """
    )

    def _roughness_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRoughness,
                        self.roughness)

    selection_color = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(1.0, 0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the RGBA color of selection primitives (if a selection is
        active on the mapper). Default is red and opaque.
        """
    )

    def _selection_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSelectionColor,
                        self.selection_color)

    selection_line_width = traits.Float(2.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the selection line width. Default is 2.
        """
    )

    def _selection_line_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSelectionLineWidth,
                        self.selection_line_width)

    selection_point_size = traits.Float(2.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the selection point size. Default is 2.
        """
    )

    def _selection_point_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSelectionPointSize,
                        self.selection_point_size)

    specular = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the specular lighting coefficient.
        """
    )

    def _specular_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecular,
                        self.specular)

    specular_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Set/Get the specular surface color.
        """
    )

    def _specular_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularColor,
                        self.specular_color, True)

    specular_power = traits.Trait(1.0, traits.Range(0.0, 128.0, enter_set=True, auto_set=False), desc=\
        r"""
        Set/Get the specular power.
        """
    )

    def _specular_power_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularPower,
                        self.specular_power)

    def get_texture(self, *args):
        """
        get_texture(self, name:str) -> Texture
        C++: Texture *get_texture(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetTexture, *args)
        return wrap_vtk(ret)

    def set_texture(self, *args):
        """
        set_texture(self, name:str, texture:Texture) -> None
        C++: void set_texture(const char *name, Texture *texture)
        Set/Get the texture object to control rendering texture maps.
        This will be a Texture object. A property does not need to
        have an associated texture map and multiple properties can share
        one texture. Textures must be assigned unique names. Note that
        for texture blending the textures will be rendering is
        alphabetical order and after any texture defined in the actor.
        There exists 6 special textures with reserved names: "albedoTex",
        "materialTex", "normalTex", "emissiveTex", "anisotropyTex" and
        "coatnormal_tex". While these textures can be added with the
        regular set_texture method, it is preferred to use the methods
        set_base_color_texture, set_orm_texture, set_normal_texture,
        set_emissive_texture, set_anisotropy_texture and set_coat_normal_tex
        respectively.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTexture, *my_args)
        return ret

    vertex_color = tvtk_base.vtk_color_trait((0.5, 1.0, 0.5), desc=\
        r"""
        Set/Get the color of primitive vertices (if vertex visibility is
        enabled).
        """
    )

    def _vertex_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVertexColor,
                        self.vertex_color, True)

    def _get_number_of_textures(self):
        return self._vtk_obj.GetNumberOfTextures()
    number_of_textures = traits.Property(_get_number_of_textures, desc=\
        r"""
        Returns the number of textures in this property.
        """
    )

    def add_shader_variable(self, *args):
        """
        add_shader_variable(self, name:str, numVars:int, x:[int, ...])
            -> None
        C++: virtual void add_shader_variable(const char *name, int numVars,
             int *x)
        add_shader_variable(self, name:str, numVars:int, x:[float, ...])
            -> None
        C++: virtual void add_shader_variable(const char *name, int numVars,
             double *x)
        add_shader_variable(self, name:str, v:int) -> None
        C++: void add_shader_variable(const char *name, int v)
        add_shader_variable(self, name:str, v:float) -> None
        C++: void add_shader_variable(const char *name, double v)
        add_shader_variable(self, name:str, v1:int, v2:int) -> None
        C++: void add_shader_variable(const char *name, int v1, int v2)
        add_shader_variable(self, name:str, v1:float, v2:float) -> None
        C++: void add_shader_variable(const char *name, double v1,
            double v2)
        add_shader_variable(self, name:str, v1:int, v2:int, v3:int) -> None
        C++: void add_shader_variable(const char *name, int v1, int v2,
            int v3)
        add_shader_variable(self, name:str, v1:float, v2:float, v3:float)
            -> None
        C++: void add_shader_variable(const char *name, double v1,
            double v2, double v3)
        Provide values to initialize shader variables. Useful to
        initialize shader variables that change over time (animation, GUI
        widgets inputs, etc. )
        - name - hardware name of the uniform variable
        - numVars - number of variables being set
        - x - values
        """
        ret = self._wrap_call(self._vtk_obj.AddShaderVariable, *args)
        return ret

    def backface_render(self, *args):
        """
        backface_render(self, __a:Actor, __b:Renderer) -> None
        C++: virtual void backface_render(Actor *, Renderer *)
        This method renders the property as a backface property.
        two_sided_lighting must be turned off to see any backface
        properties. Note that only colors and opacity are used for
        backface properties. Other properties such as Representation,
        Culling are specified by the Property.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BackfaceRender, *my_args)
        return ret

    def compute_ior_from_reflectance(self, *args):
        """
        compute_ior_from_reflectance(reflectance:float, ior:float) -> float
        C++: static double compute_ior_from_reflectance(double reflectance,
            double ior)
        For PBR, calculate the refractive index from the reflectance of
        the interface and the refractive index of one of both medium.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeIORFromReflectance, *args)
        return ret

    def compute_reflectance_from_ior(self, *args):
        """
        compute_reflectance_from_ior(IORTo:float, IORFrom:float) -> float
        C++: static double compute_reflectance_from_ior(double IORTo,
            double IORFrom)
        For PBR, calculate the reflectance from the refractive index of
        ingoing and outgoing interfaces.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeReflectanceFromIOR, *args)
        return ret

    def compute_reflectance_of_base_layer(self):
        """
        compute_reflectance_of_base_layer(self) -> float
        C++: double compute_reflectance_of_base_layer()
        For PBR, calculate the reflectance of the base layer depending on
        the presence of a coat layer. If there is no coat layer, the
        reflectance is the one at the interface environment - base layer.
        If a coat layer is present, the reflectance is the one at the
        interface between the base and the coat layer.
        """
        ret = self._vtk_obj.ComputeReflectanceOfBaseLayer()
        return ret
        

    def deep_copy(self, *args):
        """
        deep_copy(self, p:Property) -> None
        C++: void deep_copy(Property *p)
        Assign one property to another.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def post_render(self, *args):
        """
        post_render(self, __a:Actor, __b:Renderer) -> None
        C++: virtual void post_render(Actor *, Renderer *)
        This method is called after the actor has been rendered. Don't
        call this directly. This method cleans up any shaders allocated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PostRender, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:Window) -> None
        C++: virtual void release_graphics_resources(Window *win)
        Release any graphics resources that are being consumed by this
        property. The parameter window could be used to determine which
        graphic resources to release.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def remove_all_textures(self):
        """
        remove_all_textures(self) -> None
        C++: void remove_all_textures()
        Remove all the textures.
        """
        ret = self._vtk_obj.RemoveAllTextures()
        return ret
        

    def remove_texture(self, *args):
        """
        remove_texture(self, name:str) -> None
        C++: void remove_texture(const char *name)
        Remove a texture from the collection.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveTexture, *args)
        return ret

    def render(self, *args):
        """
        render(self, __a:Actor, __b:Renderer) -> None
        C++: virtual void render(Actor *, Renderer *)
        This method causes the property to set up whatever is required
        for its instance variables. This is actually handled by a
        subclass of Property, which is created automatically. This
        method includes the invoking actor as an argument which can be
        used by property devices that require the actor.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def set_anisotropy_texture(self, *args):
        """
        set_anisotropy_texture(self, texture:Texture) -> None
        C++: void set_anisotropy_texture(Texture *texture)
        Set the anisotropy texture. This texture contains two independent
        components corresponding to the anisotropy value and anisotropy
        rotation. The last component (blue channel) is discarded. The
        anisotropy value is scaled by the anisotropy coefficient of the
        material. The anisotropy rotation rotates the direction of the
        anisotropy (ie. the tangent) around the normal and is not scaled
        by the anisotropy rotation coefficient. This texture must be in
        linear color space. This is only used by the PBR shading model.
        @sa set_interpolation_to_pbr set_anisotropy
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetAnisotropyTexture, *my_args)
        return ret

    def set_base_color_texture(self, *args):
        """
        set_base_color_texture(self, texture:Texture) -> None
        C++: void set_base_color_texture(Texture *texture)
        Set the base color texture. Also called albedo, this texture is
        only used while rendering with PBR interpolation. This is the
        color of the object. This texture must be in sRGB color space.
        @sa set_interpolation_to_pbr Texture::UseSRGBColorSpaceOn
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBaseColorTexture, *my_args)
        return ret

    def set_coat_normal_texture(self, *args):
        """
        set_coat_normal_texture(self, texture:Texture) -> None
        C++: void set_coat_normal_texture(Texture *texture)
        Set the coat normal texture. This texture is required for coat
        normal mapping. It is valid only for PBR interpolation. The coat
        normal mapping is enabled if this texture is present and both
        normals and tangents are presents in the PolyData. This
        texture must be in linear color space.
        @sa PolyDataTangents set_coat_normal_scale
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetCoatNormalTexture, *my_args)
        return ret

    def set_emissive_texture(self, *args):
        """
        set_emissive_texture(self, texture:Texture) -> None
        C++: void set_emissive_texture(Texture *texture)
        Set the emissive texture. When present, this RGB texture provides
        location and color to the shader where the PolyData should
        emit light. Emited light is scaled by emissive_factor. This is
        only supported by PBR interpolation model. This texture must be
        in sRGB color space.
        @sa set_interpolation_to_pbr set_emissive_factor
            Texture::UseSRGBColorSpaceOn
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEmissiveTexture, *my_args)
        return ret

    def set_normal_texture(self, *args):
        """
        set_normal_texture(self, texture:Texture) -> None
        C++: void set_normal_texture(Texture *texture)
        Set the normal texture. This texture is required for normal
        mapping. It is valid for both PBR and Phong interpolation. The
        normal mapping is enabled if this texture is present and both
        normals and tangents are presents in the PolyData. This
        texture must be in linear color space.
        @sa PolyDataTangents set_normal_scale
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNormalTexture, *my_args)
        return ret

    def set_orm_texture(self, *args):
        """
        set_orm_texture(self, texture:Texture) -> None
        C++: void set_orm_texture(Texture *texture)
        Set the ORM texture. This texture contains three RGB independent
        components corresponding to the Occlusion value, Roughness value
        and Metallic value respectively. Each texture value is scaled by
        the Occlusion strength, roughness coefficient and metallic
        coefficient. This texture must be in linear color space. This is
        only used by the PBR shading model.
        @sa set_interpolation_to_pbr set_occlusion_strength set_metallic
            set_roughness
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetORMTexture, *my_args)
        return ret

    _updateable_traits_ = \
    (('backface_culling', 'GetBackfaceCulling'), ('edge_visibility',
    'GetEdgeVisibility'), ('frontface_culling', 'GetFrontfaceCulling'),
    ('lighting', 'GetLighting'), ('render_lines_as_tubes',
    'GetRenderLinesAsTubes'), ('render_points_as_spheres',
    'GetRenderPointsAsSpheres'), ('shading', 'GetShading'),
    ('show_textures_on_backface', 'GetShowTexturesOnBackface'),
    ('vertex_visibility', 'GetVertexVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation', 'GetInterpolation'), ('representation',
    'GetRepresentation'), ('ambient', 'GetAmbient'), ('ambient_color',
    'GetAmbientColor'), ('anisotropy', 'GetAnisotropy'),
    ('anisotropy_rotation', 'GetAnisotropyRotation'), ('base_ior',
    'GetBaseIOR'), ('coat_color', 'GetCoatColor'), ('coat_ior',
    'GetCoatIOR'), ('coat_normal_scale', 'GetCoatNormalScale'),
    ('coat_roughness', 'GetCoatRoughness'), ('coat_strength',
    'GetCoatStrength'), ('color', 'GetColor'), ('diffuse', 'GetDiffuse'),
    ('diffuse_color', 'GetDiffuseColor'), ('edge_color', 'GetEdgeColor'),
    ('edge_tint', 'GetEdgeTint'), ('emissive_factor',
    'GetEmissiveFactor'), ('line_stipple_pattern',
    'GetLineStipplePattern'), ('line_stipple_repeat_factor',
    'GetLineStippleRepeatFactor'), ('line_width', 'GetLineWidth'),
    ('material_name', 'GetMaterialName'), ('metallic', 'GetMetallic'),
    ('normal_scale', 'GetNormalScale'), ('occlusion_strength',
    'GetOcclusionStrength'), ('opacity', 'GetOpacity'), ('point_size',
    'GetPointSize'), ('roughness', 'GetRoughness'), ('selection_color',
    'GetSelectionColor'), ('selection_line_width',
    'GetSelectionLineWidth'), ('selection_point_size',
    'GetSelectionPointSize'), ('specular', 'GetSpecular'),
    ('specular_color', 'GetSpecularColor'), ('specular_power',
    'GetSpecularPower'), ('vertex_color', 'GetVertexColor'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['backface_culling', 'debug', 'edge_visibility', 'frontface_culling',
    'global_warning_display', 'lighting', 'render_lines_as_tubes',
    'render_points_as_spheres', 'shading', 'show_textures_on_backface',
    'vertex_visibility', 'interpolation', 'representation', 'ambient',
    'ambient_color', 'anisotropy', 'anisotropy_rotation', 'base_ior',
    'coat_color', 'coat_ior', 'coat_normal_scale', 'coat_roughness',
    'coat_strength', 'color', 'diffuse', 'diffuse_color', 'edge_color',
    'edge_tint', 'emissive_factor', 'line_stipple_pattern',
    'line_stipple_repeat_factor', 'line_width', 'material_name',
    'metallic', 'normal_scale', 'occlusion_strength', 'opacity',
    'point_size', 'roughness', 'selection_color', 'selection_line_width',
    'selection_point_size', 'specular', 'specular_color',
    'specular_power', 'vertex_color'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Property, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['backface_culling', 'edge_visibility', 'frontface_culling',
            'lighting', 'render_lines_as_tubes', 'render_points_as_spheres',
            'shading', 'show_textures_on_backface', 'vertex_visibility'],
            ['interpolation', 'representation'], ['ambient', 'ambient_color',
            'anisotropy', 'anisotropy_rotation', 'base_ior', 'coat_color',
            'coat_ior', 'coat_normal_scale', 'coat_roughness', 'coat_strength',
            'color', 'diffuse', 'diffuse_color', 'edge_color', 'edge_tint',
            'emissive_factor', 'line_stipple_pattern',
            'line_stipple_repeat_factor', 'line_width', 'material_name',
            'metallic', 'normal_scale', 'occlusion_strength', 'opacity',
            'point_size', 'roughness', 'selection_color', 'selection_line_width',
            'selection_point_size', 'specular', 'specular_color',
            'specular_power', 'vertex_color']),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Property properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def __getstate__(self):
        d = tvtk_base.TVTKBase.__getstate__(self)
        if 'color' in d:
            del d['color']
        return d
    
    def __setstate__(self, dict):
        tvtk_base.TVTKBase.__setstate__(self, dict)
        self.update_traits()

