//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package virtualmachineimagebuilder

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/virtualmachineimagebuilder/mgmt/2021-10-01/virtualmachineimagebuilder"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type ProvisioningErrorCode = original.ProvisioningErrorCode

const (
	ProvisioningErrorCodeBadCustomizerType           ProvisioningErrorCode = original.ProvisioningErrorCodeBadCustomizerType
	ProvisioningErrorCodeBadDistributeType           ProvisioningErrorCode = original.ProvisioningErrorCodeBadDistributeType
	ProvisioningErrorCodeBadManagedImageSource       ProvisioningErrorCode = original.ProvisioningErrorCodeBadManagedImageSource
	ProvisioningErrorCodeBadPIRSource                ProvisioningErrorCode = original.ProvisioningErrorCodeBadPIRSource
	ProvisioningErrorCodeBadSharedImageDistribute    ProvisioningErrorCode = original.ProvisioningErrorCodeBadSharedImageDistribute
	ProvisioningErrorCodeBadSharedImageVersionSource ProvisioningErrorCode = original.ProvisioningErrorCodeBadSharedImageVersionSource
	ProvisioningErrorCodeBadSourceType               ProvisioningErrorCode = original.ProvisioningErrorCodeBadSourceType
	ProvisioningErrorCodeNoCustomizerScript          ProvisioningErrorCode = original.ProvisioningErrorCodeNoCustomizerScript
	ProvisioningErrorCodeOther                       ProvisioningErrorCode = original.ProvisioningErrorCodeOther
	ProvisioningErrorCodeServerError                 ProvisioningErrorCode = original.ProvisioningErrorCodeServerError
	ProvisioningErrorCodeUnsupportedCustomizerType   ProvisioningErrorCode = original.ProvisioningErrorCodeUnsupportedCustomizerType
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreating  ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating  ProvisioningState = original.ProvisioningStateUpdating
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone         ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeUserAssigned ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type RunState = original.RunState

const (
	RunStateCanceled           RunState = original.RunStateCanceled
	RunStateCanceling          RunState = original.RunStateCanceling
	RunStateFailed             RunState = original.RunStateFailed
	RunStatePartiallySucceeded RunState = original.RunStatePartiallySucceeded
	RunStateRunning            RunState = original.RunStateRunning
	RunStateSucceeded          RunState = original.RunStateSucceeded
)

type RunSubState = original.RunSubState

const (
	RunSubStateBuilding     RunSubState = original.RunSubStateBuilding
	RunSubStateCustomizing  RunSubState = original.RunSubStateCustomizing
	RunSubStateDistributing RunSubState = original.RunSubStateDistributing
	RunSubStateQueued       RunSubState = original.RunSubStateQueued
)

type SharedImageStorageAccountType = original.SharedImageStorageAccountType

const (
	SharedImageStorageAccountTypeStandardLRS SharedImageStorageAccountType = original.SharedImageStorageAccountTypeStandardLRS
	SharedImageStorageAccountTypeStandardZRS SharedImageStorageAccountType = original.SharedImageStorageAccountTypeStandardZRS
)

type Type = original.Type

const (
	TypeImageTemplateSource Type = original.TypeImageTemplateSource
	TypeManagedImage        Type = original.TypeManagedImage
	TypePlatformImage       Type = original.TypePlatformImage
	TypeSharedImageVersion  Type = original.TypeSharedImageVersion
)

type TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizer

const (
	TypeBasicImageTemplateCustomizerTypeFile                    TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypeFile
	TypeBasicImageTemplateCustomizerTypeImageTemplateCustomizer TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypeImageTemplateCustomizer
	TypeBasicImageTemplateCustomizerTypePowerShell              TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypePowerShell
	TypeBasicImageTemplateCustomizerTypeShell                   TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypeShell
	TypeBasicImageTemplateCustomizerTypeWindowsRestart          TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypeWindowsRestart
	TypeBasicImageTemplateCustomizerTypeWindowsUpdate           TypeBasicImageTemplateCustomizer = original.TypeBasicImageTemplateCustomizerTypeWindowsUpdate
)

type TypeBasicImageTemplateDistributor = original.TypeBasicImageTemplateDistributor

const (
	TypeBasicImageTemplateDistributorTypeImageTemplateDistributor TypeBasicImageTemplateDistributor = original.TypeBasicImageTemplateDistributorTypeImageTemplateDistributor
	TypeBasicImageTemplateDistributorTypeManagedImage             TypeBasicImageTemplateDistributor = original.TypeBasicImageTemplateDistributorTypeManagedImage
	TypeBasicImageTemplateDistributorTypeSharedImage              TypeBasicImageTemplateDistributor = original.TypeBasicImageTemplateDistributorTypeSharedImage
	TypeBasicImageTemplateDistributorTypeVHD                      TypeBasicImageTemplateDistributor = original.TypeBasicImageTemplateDistributorTypeVHD
)

type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicImageTemplateCustomizer = original.BasicImageTemplateCustomizer
type BasicImageTemplateDistributor = original.BasicImageTemplateDistributor
type BasicImageTemplateSource = original.BasicImageTemplateSource
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type ImageTemplate = original.ImageTemplate
type ImageTemplateCustomizer = original.ImageTemplateCustomizer
type ImageTemplateDistributor = original.ImageTemplateDistributor
type ImageTemplateFileCustomizer = original.ImageTemplateFileCustomizer
type ImageTemplateIdentity = original.ImageTemplateIdentity
type ImageTemplateIdentityUserAssignedIdentitiesValue = original.ImageTemplateIdentityUserAssignedIdentitiesValue
type ImageTemplateLastRunStatus = original.ImageTemplateLastRunStatus
type ImageTemplateListResult = original.ImageTemplateListResult
type ImageTemplateListResultIterator = original.ImageTemplateListResultIterator
type ImageTemplateListResultPage = original.ImageTemplateListResultPage
type ImageTemplateManagedImageDistributor = original.ImageTemplateManagedImageDistributor
type ImageTemplateManagedImageSource = original.ImageTemplateManagedImageSource
type ImageTemplatePlatformImageSource = original.ImageTemplatePlatformImageSource
type ImageTemplatePowerShellCustomizer = original.ImageTemplatePowerShellCustomizer
type ImageTemplateProperties = original.ImageTemplateProperties
type ImageTemplateRestartCustomizer = original.ImageTemplateRestartCustomizer
type ImageTemplateSharedImageDistributor = original.ImageTemplateSharedImageDistributor
type ImageTemplateSharedImageVersionSource = original.ImageTemplateSharedImageVersionSource
type ImageTemplateShellCustomizer = original.ImageTemplateShellCustomizer
type ImageTemplateSource = original.ImageTemplateSource
type ImageTemplateUpdateParameters = original.ImageTemplateUpdateParameters
type ImageTemplateVMProfile = original.ImageTemplateVMProfile
type ImageTemplateVhdDistributor = original.ImageTemplateVhdDistributor
type ImageTemplateWindowsUpdateCustomizer = original.ImageTemplateWindowsUpdateCustomizer
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type PlatformImagePurchasePlan = original.PlatformImagePurchasePlan
type ProvisioningError = original.ProvisioningError
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type RunOutput = original.RunOutput
type RunOutputCollection = original.RunOutputCollection
type RunOutputCollectionIterator = original.RunOutputCollectionIterator
type RunOutputCollectionPage = original.RunOutputCollectionPage
type RunOutputProperties = original.RunOutputProperties
type SubResource = original.SubResource
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type VirtualMachineImageTemplatesCancelFuture = original.VirtualMachineImageTemplatesCancelFuture
type VirtualMachineImageTemplatesClient = original.VirtualMachineImageTemplatesClient
type VirtualMachineImageTemplatesCreateOrUpdateFuture = original.VirtualMachineImageTemplatesCreateOrUpdateFuture
type VirtualMachineImageTemplatesDeleteFuture = original.VirtualMachineImageTemplatesDeleteFuture
type VirtualMachineImageTemplatesRunFuture = original.VirtualMachineImageTemplatesRunFuture
type VirtualMachineImageTemplatesUpdateFuture = original.VirtualMachineImageTemplatesUpdateFuture
type VirtualNetworkConfig = original.VirtualNetworkConfig

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewImageTemplateListResultIterator(page ImageTemplateListResultPage) ImageTemplateListResultIterator {
	return original.NewImageTemplateListResultIterator(page)
}
func NewImageTemplateListResultPage(cur ImageTemplateListResult, getNextPage func(context.Context, ImageTemplateListResult) (ImageTemplateListResult, error)) ImageTemplateListResultPage {
	return original.NewImageTemplateListResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRunOutputCollectionIterator(page RunOutputCollectionPage) RunOutputCollectionIterator {
	return original.NewRunOutputCollectionIterator(page)
}
func NewRunOutputCollectionPage(cur RunOutputCollection, getNextPage func(context.Context, RunOutputCollection) (RunOutputCollection, error)) RunOutputCollectionPage {
	return original.NewRunOutputCollectionPage(cur, getNextPage)
}
func NewVirtualMachineImageTemplatesClient(subscriptionID string) VirtualMachineImageTemplatesClient {
	return original.NewVirtualMachineImageTemplatesClient(subscriptionID)
}
func NewVirtualMachineImageTemplatesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImageTemplatesClient {
	return original.NewVirtualMachineImageTemplatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleProvisioningErrorCodeValues() []ProvisioningErrorCode {
	return original.PossibleProvisioningErrorCodeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRunStateValues() []RunState {
	return original.PossibleRunStateValues()
}
func PossibleRunSubStateValues() []RunSubState {
	return original.PossibleRunSubStateValues()
}
func PossibleSharedImageStorageAccountTypeValues() []SharedImageStorageAccountType {
	return original.PossibleSharedImageStorageAccountTypeValues()
}
func PossibleTypeBasicImageTemplateCustomizerValues() []TypeBasicImageTemplateCustomizer {
	return original.PossibleTypeBasicImageTemplateCustomizerValues()
}
func PossibleTypeBasicImageTemplateDistributorValues() []TypeBasicImageTemplateDistributor {
	return original.PossibleTypeBasicImageTemplateDistributorValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
