// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"math"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/role"
	"entgo.io/ent/entc/integration/edgeschema/ent/roleuser"
	"entgo.io/ent/entc/integration/edgeschema/ent/user"
)

// RoleUserQuery is the builder for querying RoleUser entities.
type RoleUserQuery struct {
	config
	limit      *int
	offset     *int
	unique     *bool
	order      []OrderFunc
	fields     []string
	predicates []predicate.RoleUser
	withRole   *RoleQuery
	withUser   *UserQuery
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the RoleUserQuery builder.
func (ruq *RoleUserQuery) Where(ps ...predicate.RoleUser) *RoleUserQuery {
	ruq.predicates = append(ruq.predicates, ps...)
	return ruq
}

// Limit adds a limit step to the query.
func (ruq *RoleUserQuery) Limit(limit int) *RoleUserQuery {
	ruq.limit = &limit
	return ruq
}

// Offset adds an offset step to the query.
func (ruq *RoleUserQuery) Offset(offset int) *RoleUserQuery {
	ruq.offset = &offset
	return ruq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (ruq *RoleUserQuery) Unique(unique bool) *RoleUserQuery {
	ruq.unique = &unique
	return ruq
}

// Order adds an order step to the query.
func (ruq *RoleUserQuery) Order(o ...OrderFunc) *RoleUserQuery {
	ruq.order = append(ruq.order, o...)
	return ruq
}

// QueryRole chains the current query on the "role" edge.
func (ruq *RoleUserQuery) QueryRole() *RoleQuery {
	query := &RoleQuery{config: ruq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ruq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ruq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(roleuser.Table, roleuser.RoleColumn, selector),
			sqlgraph.To(role.Table, role.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, roleuser.RoleTable, roleuser.RoleColumn),
		)
		fromU = sqlgraph.SetNeighbors(ruq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// QueryUser chains the current query on the "user" edge.
func (ruq *RoleUserQuery) QueryUser() *UserQuery {
	query := &UserQuery{config: ruq.config}
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := ruq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := ruq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(roleuser.Table, roleuser.UserColumn, selector),
			sqlgraph.To(user.Table, user.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, false, roleuser.UserTable, roleuser.UserColumn),
		)
		fromU = sqlgraph.SetNeighbors(ruq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first RoleUser entity from the query.
// Returns a *NotFoundError when no RoleUser was found.
func (ruq *RoleUserQuery) First(ctx context.Context) (*RoleUser, error) {
	nodes, err := ruq.Limit(1).All(ctx)
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{roleuser.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (ruq *RoleUserQuery) FirstX(ctx context.Context) *RoleUser {
	node, err := ruq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// Only returns a single RoleUser entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one RoleUser entity is found.
// Returns a *NotFoundError when no RoleUser entities are found.
func (ruq *RoleUserQuery) Only(ctx context.Context) (*RoleUser, error) {
	nodes, err := ruq.Limit(2).All(ctx)
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{roleuser.Label}
	default:
		return nil, &NotSingularError{roleuser.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (ruq *RoleUserQuery) OnlyX(ctx context.Context) *RoleUser {
	node, err := ruq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// All executes the query and returns a list of RoleUsers.
func (ruq *RoleUserQuery) All(ctx context.Context) ([]*RoleUser, error) {
	if err := ruq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	return ruq.sqlAll(ctx)
}

// AllX is like All, but panics if an error occurs.
func (ruq *RoleUserQuery) AllX(ctx context.Context) []*RoleUser {
	nodes, err := ruq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// Count returns the count of the given query.
func (ruq *RoleUserQuery) Count(ctx context.Context) (int, error) {
	if err := ruq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return ruq.sqlCount(ctx)
}

// CountX is like Count, but panics if an error occurs.
func (ruq *RoleUserQuery) CountX(ctx context.Context) int {
	count, err := ruq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (ruq *RoleUserQuery) Exist(ctx context.Context) (bool, error) {
	if err := ruq.prepareQuery(ctx); err != nil {
		return false, err
	}
	return ruq.sqlExist(ctx)
}

// ExistX is like Exist, but panics if an error occurs.
func (ruq *RoleUserQuery) ExistX(ctx context.Context) bool {
	exist, err := ruq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the RoleUserQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (ruq *RoleUserQuery) Clone() *RoleUserQuery {
	if ruq == nil {
		return nil
	}
	return &RoleUserQuery{
		config:     ruq.config,
		limit:      ruq.limit,
		offset:     ruq.offset,
		order:      append([]OrderFunc{}, ruq.order...),
		predicates: append([]predicate.RoleUser{}, ruq.predicates...),
		withRole:   ruq.withRole.Clone(),
		withUser:   ruq.withUser.Clone(),
		// clone intermediate query.
		sql:    ruq.sql.Clone(),
		path:   ruq.path,
		unique: ruq.unique,
	}
}

// WithRole tells the query-builder to eager-load the nodes that are connected to
// the "role" edge. The optional arguments are used to configure the query builder of the edge.
func (ruq *RoleUserQuery) WithRole(opts ...func(*RoleQuery)) *RoleUserQuery {
	query := &RoleQuery{config: ruq.config}
	for _, opt := range opts {
		opt(query)
	}
	ruq.withRole = query
	return ruq
}

// WithUser tells the query-builder to eager-load the nodes that are connected to
// the "user" edge. The optional arguments are used to configure the query builder of the edge.
func (ruq *RoleUserQuery) WithUser(opts ...func(*UserQuery)) *RoleUserQuery {
	query := &UserQuery{config: ruq.config}
	for _, opt := range opts {
		opt(query)
	}
	ruq.withUser = query
	return ruq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.RoleUser.Query().
//		GroupBy(roleuser.FieldCreatedAt).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (ruq *RoleUserQuery) GroupBy(field string, fields ...string) *RoleUserGroupBy {
	grbuild := &RoleUserGroupBy{config: ruq.config}
	grbuild.fields = append([]string{field}, fields...)
	grbuild.path = func(ctx context.Context) (prev *sql.Selector, err error) {
		if err := ruq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		return ruq.sqlQuery(ctx), nil
	}
	grbuild.label = roleuser.Label
	grbuild.flds, grbuild.scan = &grbuild.fields, grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//	}
//
//	client.RoleUser.Query().
//		Select(roleuser.FieldCreatedAt).
//		Scan(ctx, &v)
func (ruq *RoleUserQuery) Select(fields ...string) *RoleUserSelect {
	ruq.fields = append(ruq.fields, fields...)
	selbuild := &RoleUserSelect{RoleUserQuery: ruq}
	selbuild.label = roleuser.Label
	selbuild.flds, selbuild.scan = &ruq.fields, selbuild.Scan
	return selbuild
}

func (ruq *RoleUserQuery) prepareQuery(ctx context.Context) error {
	for _, f := range ruq.fields {
		if !roleuser.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if ruq.path != nil {
		prev, err := ruq.path(ctx)
		if err != nil {
			return err
		}
		ruq.sql = prev
	}
	return nil
}

func (ruq *RoleUserQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*RoleUser, error) {
	var (
		nodes       = []*RoleUser{}
		_spec       = ruq.querySpec()
		loadedTypes = [2]bool{
			ruq.withRole != nil,
			ruq.withUser != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*RoleUser).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &RoleUser{config: ruq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, ruq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := ruq.withRole; query != nil {
		if err := ruq.loadRole(ctx, query, nodes, nil,
			func(n *RoleUser, e *Role) { n.Edges.Role = e }); err != nil {
			return nil, err
		}
	}
	if query := ruq.withUser; query != nil {
		if err := ruq.loadUser(ctx, query, nodes, nil,
			func(n *RoleUser, e *User) { n.Edges.User = e }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (ruq *RoleUserQuery) loadRole(ctx context.Context, query *RoleQuery, nodes []*RoleUser, init func(*RoleUser), assign func(*RoleUser, *Role)) error {
	ids := make([]int, 0, len(nodes))
	nodeids := make(map[int][]*RoleUser)
	for i := range nodes {
		fk := nodes[i].RoleID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	query.Where(role.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "role_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}
func (ruq *RoleUserQuery) loadUser(ctx context.Context, query *UserQuery, nodes []*RoleUser, init func(*RoleUser), assign func(*RoleUser, *User)) error {
	ids := make([]int, 0, len(nodes))
	nodeids := make(map[int][]*RoleUser)
	for i := range nodes {
		fk := nodes[i].UserID
		if _, ok := nodeids[fk]; !ok {
			ids = append(ids, fk)
		}
		nodeids[fk] = append(nodeids[fk], nodes[i])
	}
	query.Where(user.IDIn(ids...))
	neighbors, err := query.All(ctx)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nodeids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected foreign-key "user_id" returned %v`, n.ID)
		}
		for i := range nodes {
			assign(nodes[i], n)
		}
	}
	return nil
}

func (ruq *RoleUserQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := ruq.querySpec()
	_spec.Unique = false
	_spec.Node.Columns = nil
	return sqlgraph.CountNodes(ctx, ruq.driver, _spec)
}

func (ruq *RoleUserQuery) sqlExist(ctx context.Context) (bool, error) {
	switch _, err := ruq.First(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("ent: check existence: %w", err)
	default:
		return true, nil
	}
}

func (ruq *RoleUserQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := &sqlgraph.QuerySpec{
		Node: &sqlgraph.NodeSpec{
			Table:   roleuser.Table,
			Columns: roleuser.Columns,
		},
		From:   ruq.sql,
		Unique: true,
	}
	if unique := ruq.unique; unique != nil {
		_spec.Unique = *unique
	}
	if fields := ruq.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		for i := range fields {
			_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
		}
	}
	if ps := ruq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := ruq.limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := ruq.offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := ruq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (ruq *RoleUserQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(ruq.driver.Dialect())
	t1 := builder.Table(roleuser.Table)
	columns := ruq.fields
	if len(columns) == 0 {
		columns = roleuser.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if ruq.sql != nil {
		selector = ruq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if ruq.unique != nil && *ruq.unique {
		selector.Distinct()
	}
	for _, p := range ruq.predicates {
		p(selector)
	}
	for _, p := range ruq.order {
		p(selector)
	}
	if offset := ruq.offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := ruq.limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// RoleUserGroupBy is the group-by builder for RoleUser entities.
type RoleUserGroupBy struct {
	config
	selector
	fields []string
	fns    []AggregateFunc
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Aggregate adds the given aggregation functions to the group-by query.
func (rugb *RoleUserGroupBy) Aggregate(fns ...AggregateFunc) *RoleUserGroupBy {
	rugb.fns = append(rugb.fns, fns...)
	return rugb
}

// Scan applies the group-by query and scans the result into the given value.
func (rugb *RoleUserGroupBy) Scan(ctx context.Context, v any) error {
	query, err := rugb.path(ctx)
	if err != nil {
		return err
	}
	rugb.sql = query
	return rugb.sqlScan(ctx, v)
}

func (rugb *RoleUserGroupBy) sqlScan(ctx context.Context, v any) error {
	for _, f := range rugb.fields {
		if !roleuser.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("invalid field %q for group-by", f)}
		}
	}
	selector := rugb.sqlQuery()
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := rugb.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

func (rugb *RoleUserGroupBy) sqlQuery() *sql.Selector {
	selector := rugb.sql.Select()
	aggregation := make([]string, 0, len(rugb.fns))
	for _, fn := range rugb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	// If no columns were selected in a custom aggregation function, the default
	// selection is the fields used for "group-by", and the aggregation functions.
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(rugb.fields)+len(rugb.fns))
		for _, f := range rugb.fields {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	return selector.GroupBy(selector.Columns(rugb.fields...)...)
}

// RoleUserSelect is the builder for selecting fields of RoleUser entities.
type RoleUserSelect struct {
	*RoleUserQuery
	selector
	// intermediate query (i.e. traversal path).
	sql *sql.Selector
}

// Scan applies the selector query and scans the result into the given value.
func (rus *RoleUserSelect) Scan(ctx context.Context, v any) error {
	if err := rus.prepareQuery(ctx); err != nil {
		return err
	}
	rus.sql = rus.RoleUserQuery.sqlQuery(ctx)
	return rus.sqlScan(ctx, v)
}

func (rus *RoleUserSelect) sqlScan(ctx context.Context, v any) error {
	rows := &sql.Rows{}
	query, args := rus.sql.Query()
	if err := rus.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
