// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"entgo.io/ent/entc/integration/edgeschema/ent/friendship"
	"entgo.io/ent/entc/integration/edgeschema/ent/group"
	"entgo.io/ent/entc/integration/edgeschema/ent/predicate"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationship"
	"entgo.io/ent/entc/integration/edgeschema/ent/relationshipinfo"
	"entgo.io/ent/entc/integration/edgeschema/ent/role"
	"entgo.io/ent/entc/integration/edgeschema/ent/roleuser"
	"entgo.io/ent/entc/integration/edgeschema/ent/tag"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweet"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweetlike"
	"entgo.io/ent/entc/integration/edgeschema/ent/tweettag"
	"entgo.io/ent/entc/integration/edgeschema/ent/user"
	"entgo.io/ent/entc/integration/edgeschema/ent/usergroup"
	"entgo.io/ent/entc/integration/edgeschema/ent/usertweet"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entql"
	"entgo.io/ent/schema/field"
)

// schemaGraph holds a representation of ent/schema at runtime.
var schemaGraph = func() *sqlgraph.Schema {
	graph := &sqlgraph.Schema{Nodes: make([]*sqlgraph.Node, 13)}
	graph.Nodes[0] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   friendship.Table,
			Columns: friendship.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: friendship.FieldID,
			},
		},
		Type: "Friendship",
		Fields: map[string]*sqlgraph.FieldSpec{
			friendship.FieldWeight:    {Type: field.TypeInt, Column: friendship.FieldWeight},
			friendship.FieldCreatedAt: {Type: field.TypeTime, Column: friendship.FieldCreatedAt},
			friendship.FieldUserID:    {Type: field.TypeInt, Column: friendship.FieldUserID},
			friendship.FieldFriendID:  {Type: field.TypeInt, Column: friendship.FieldFriendID},
		},
	}
	graph.Nodes[1] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   group.Table,
			Columns: group.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: group.FieldID,
			},
		},
		Type: "Group",
		Fields: map[string]*sqlgraph.FieldSpec{
			group.FieldName: {Type: field.TypeString, Column: group.FieldName},
		},
	}
	graph.Nodes[2] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   relationship.Table,
			Columns: relationship.Columns,
			CompositeID: []*sqlgraph.FieldSpec{
				{
					Type:   field.TypeInt,
					Column: relationship.FieldUserID,
				},
				{
					Type:   field.TypeInt,
					Column: relationship.FieldRelativeID,
				},
			},
		},
		Type: "Relationship",
		Fields: map[string]*sqlgraph.FieldSpec{
			relationship.FieldWeight:     {Type: field.TypeInt, Column: relationship.FieldWeight},
			relationship.FieldUserID:     {Type: field.TypeInt, Column: relationship.FieldUserID},
			relationship.FieldRelativeID: {Type: field.TypeInt, Column: relationship.FieldRelativeID},
			relationship.FieldInfoID:     {Type: field.TypeInt, Column: relationship.FieldInfoID},
		},
	}
	graph.Nodes[3] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   relationshipinfo.Table,
			Columns: relationshipinfo.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: relationshipinfo.FieldID,
			},
		},
		Type: "RelationshipInfo",
		Fields: map[string]*sqlgraph.FieldSpec{
			relationshipinfo.FieldText: {Type: field.TypeString, Column: relationshipinfo.FieldText},
		},
	}
	graph.Nodes[4] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   role.Table,
			Columns: role.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: role.FieldID,
			},
		},
		Type: "Role",
		Fields: map[string]*sqlgraph.FieldSpec{
			role.FieldName:      {Type: field.TypeString, Column: role.FieldName},
			role.FieldCreatedAt: {Type: field.TypeTime, Column: role.FieldCreatedAt},
		},
	}
	graph.Nodes[5] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   roleuser.Table,
			Columns: roleuser.Columns,
			CompositeID: []*sqlgraph.FieldSpec{
				{
					Type:   field.TypeInt,
					Column: roleuser.FieldUserID,
				},
				{
					Type:   field.TypeInt,
					Column: roleuser.FieldRoleID,
				},
			},
		},
		Type: "RoleUser",
		Fields: map[string]*sqlgraph.FieldSpec{
			roleuser.FieldCreatedAt: {Type: field.TypeTime, Column: roleuser.FieldCreatedAt},
			roleuser.FieldRoleID:    {Type: field.TypeInt, Column: roleuser.FieldRoleID},
			roleuser.FieldUserID:    {Type: field.TypeInt, Column: roleuser.FieldUserID},
		},
	}
	graph.Nodes[6] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   tag.Table,
			Columns: tag.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: tag.FieldID,
			},
		},
		Type: "Tag",
		Fields: map[string]*sqlgraph.FieldSpec{
			tag.FieldValue: {Type: field.TypeString, Column: tag.FieldValue},
		},
	}
	graph.Nodes[7] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   tweet.Table,
			Columns: tweet.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: tweet.FieldID,
			},
		},
		Type: "Tweet",
		Fields: map[string]*sqlgraph.FieldSpec{
			tweet.FieldText: {Type: field.TypeString, Column: tweet.FieldText},
		},
	}
	graph.Nodes[8] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   tweetlike.Table,
			Columns: tweetlike.Columns,
			CompositeID: []*sqlgraph.FieldSpec{
				{
					Type:   field.TypeInt,
					Column: tweetlike.FieldUserID,
				},
				{
					Type:   field.TypeInt,
					Column: tweetlike.FieldTweetID,
				},
			},
		},
		Type: "TweetLike",
		Fields: map[string]*sqlgraph.FieldSpec{
			tweetlike.FieldLikedAt: {Type: field.TypeTime, Column: tweetlike.FieldLikedAt},
			tweetlike.FieldUserID:  {Type: field.TypeInt, Column: tweetlike.FieldUserID},
			tweetlike.FieldTweetID: {Type: field.TypeInt, Column: tweetlike.FieldTweetID},
		},
	}
	graph.Nodes[9] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   tweettag.Table,
			Columns: tweettag.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeUUID,
				Column: tweettag.FieldID,
			},
		},
		Type: "TweetTag",
		Fields: map[string]*sqlgraph.FieldSpec{
			tweettag.FieldAddedAt: {Type: field.TypeTime, Column: tweettag.FieldAddedAt},
			tweettag.FieldTagID:   {Type: field.TypeInt, Column: tweettag.FieldTagID},
			tweettag.FieldTweetID: {Type: field.TypeInt, Column: tweettag.FieldTweetID},
		},
	}
	graph.Nodes[10] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   user.Table,
			Columns: user.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: user.FieldID,
			},
		},
		Type: "User",
		Fields: map[string]*sqlgraph.FieldSpec{
			user.FieldName: {Type: field.TypeString, Column: user.FieldName},
		},
	}
	graph.Nodes[11] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   usergroup.Table,
			Columns: usergroup.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: usergroup.FieldID,
			},
		},
		Type: "UserGroup",
		Fields: map[string]*sqlgraph.FieldSpec{
			usergroup.FieldJoinedAt: {Type: field.TypeTime, Column: usergroup.FieldJoinedAt},
			usergroup.FieldUserID:   {Type: field.TypeInt, Column: usergroup.FieldUserID},
			usergroup.FieldGroupID:  {Type: field.TypeInt, Column: usergroup.FieldGroupID},
		},
	}
	graph.Nodes[12] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   usertweet.Table,
			Columns: usertweet.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: usertweet.FieldID,
			},
		},
		Type: "UserTweet",
		Fields: map[string]*sqlgraph.FieldSpec{
			usertweet.FieldCreatedAt: {Type: field.TypeTime, Column: usertweet.FieldCreatedAt},
			usertweet.FieldUserID:    {Type: field.TypeInt, Column: usertweet.FieldUserID},
			usertweet.FieldTweetID:   {Type: field.TypeInt, Column: usertweet.FieldTweetID},
		},
	}
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   friendship.UserTable,
			Columns: []string{friendship.UserColumn},
			Bidi:    false,
		},
		"Friendship",
		"User",
	)
	graph.MustAddE(
		"friend",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   friendship.FriendTable,
			Columns: []string{friendship.FriendColumn},
			Bidi:    false,
		},
		"Friendship",
		"User",
	)
	graph.MustAddE(
		"users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   group.UsersTable,
			Columns: group.UsersPrimaryKey,
			Bidi:    false,
		},
		"Group",
		"User",
	)
	graph.MustAddE(
		"joined_users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   group.JoinedUsersTable,
			Columns: []string{group.JoinedUsersColumn},
			Bidi:    false,
		},
		"Group",
		"UserGroup",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   relationship.UserTable,
			Columns: []string{relationship.UserColumn},
			Bidi:    false,
		},
		"Relationship",
		"User",
	)
	graph.MustAddE(
		"relative",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   relationship.RelativeTable,
			Columns: []string{relationship.RelativeColumn},
			Bidi:    false,
		},
		"Relationship",
		"User",
	)
	graph.MustAddE(
		"info",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   relationship.InfoTable,
			Columns: []string{relationship.InfoColumn},
			Bidi:    false,
		},
		"Relationship",
		"RelationshipInfo",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   role.UserTable,
			Columns: role.UserPrimaryKey,
			Bidi:    false,
		},
		"Role",
		"User",
	)
	graph.MustAddE(
		"roles_users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   role.RolesUsersTable,
			Columns: []string{role.RolesUsersColumn},
			Bidi:    false,
		},
		"Role",
		"RoleUser",
	)
	graph.MustAddE(
		"role",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   roleuser.RoleTable,
			Columns: []string{roleuser.RoleColumn},
			Bidi:    false,
		},
		"RoleUser",
		"Role",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   roleuser.UserTable,
			Columns: []string{roleuser.UserColumn},
			Bidi:    false,
		},
		"RoleUser",
		"User",
	)
	graph.MustAddE(
		"tweets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   tag.TweetsTable,
			Columns: tag.TweetsPrimaryKey,
			Bidi:    false,
		},
		"Tag",
		"Tweet",
	)
	graph.MustAddE(
		"tweet_tags",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   tag.TweetTagsTable,
			Columns: []string{tag.TweetTagsColumn},
			Bidi:    false,
		},
		"Tag",
		"TweetTag",
	)
	graph.MustAddE(
		"liked_users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   tweet.LikedUsersTable,
			Columns: tweet.LikedUsersPrimaryKey,
			Bidi:    false,
		},
		"Tweet",
		"User",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   tweet.UserTable,
			Columns: tweet.UserPrimaryKey,
			Bidi:    false,
		},
		"Tweet",
		"User",
	)
	graph.MustAddE(
		"tags",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   tweet.TagsTable,
			Columns: tweet.TagsPrimaryKey,
			Bidi:    false,
		},
		"Tweet",
		"Tag",
	)
	graph.MustAddE(
		"likes",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   tweet.LikesTable,
			Columns: []string{tweet.LikesColumn},
			Bidi:    false,
		},
		"Tweet",
		"TweetLike",
	)
	graph.MustAddE(
		"tweet_user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   tweet.TweetUserTable,
			Columns: []string{tweet.TweetUserColumn},
			Bidi:    false,
		},
		"Tweet",
		"UserTweet",
	)
	graph.MustAddE(
		"tweet_tags",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   tweet.TweetTagsTable,
			Columns: []string{tweet.TweetTagsColumn},
			Bidi:    false,
		},
		"Tweet",
		"TweetTag",
	)
	graph.MustAddE(
		"tweet",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.TweetTable,
			Columns: []string{tweetlike.TweetColumn},
			Bidi:    false,
		},
		"TweetLike",
		"Tweet",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweetlike.UserTable,
			Columns: []string{tweetlike.UserColumn},
			Bidi:    false,
		},
		"TweetLike",
		"User",
	)
	graph.MustAddE(
		"tag",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweettag.TagTable,
			Columns: []string{tweettag.TagColumn},
			Bidi:    false,
		},
		"TweetTag",
		"Tag",
	)
	graph.MustAddE(
		"tweet",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   tweettag.TweetTable,
			Columns: []string{tweettag.TweetColumn},
			Bidi:    false,
		},
		"TweetTag",
		"Tweet",
	)
	graph.MustAddE(
		"groups",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.GroupsTable,
			Columns: user.GroupsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Group",
	)
	graph.MustAddE(
		"friends",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.FriendsTable,
			Columns: user.FriendsPrimaryKey,
			Bidi:    true,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"relatives",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.RelativesTable,
			Columns: user.RelativesPrimaryKey,
			Bidi:    true,
		},
		"User",
		"User",
	)
	graph.MustAddE(
		"liked_tweets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.LikedTweetsTable,
			Columns: user.LikedTweetsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Tweet",
	)
	graph.MustAddE(
		"tweets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.TweetsTable,
			Columns: user.TweetsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Tweet",
	)
	graph.MustAddE(
		"roles",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.RolesTable,
			Columns: user.RolesPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Role",
	)
	graph.MustAddE(
		"joined_groups",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.JoinedGroupsTable,
			Columns: []string{user.JoinedGroupsColumn},
			Bidi:    false,
		},
		"User",
		"UserGroup",
	)
	graph.MustAddE(
		"friendships",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.FriendshipsTable,
			Columns: []string{user.FriendshipsColumn},
			Bidi:    false,
		},
		"User",
		"Friendship",
	)
	graph.MustAddE(
		"relationship",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.RelationshipTable,
			Columns: []string{user.RelationshipColumn},
			Bidi:    false,
		},
		"User",
		"Relationship",
	)
	graph.MustAddE(
		"likes",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.LikesTable,
			Columns: []string{user.LikesColumn},
			Bidi:    false,
		},
		"User",
		"TweetLike",
	)
	graph.MustAddE(
		"user_tweets",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.UserTweetsTable,
			Columns: []string{user.UserTweetsColumn},
			Bidi:    false,
		},
		"User",
		"UserTweet",
	)
	graph.MustAddE(
		"roles_users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: true,
			Table:   user.RolesUsersTable,
			Columns: []string{user.RolesUsersColumn},
			Bidi:    false,
		},
		"User",
		"RoleUser",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.UserTable,
			Columns: []string{usergroup.UserColumn},
			Bidi:    false,
		},
		"UserGroup",
		"User",
	)
	graph.MustAddE(
		"group",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usergroup.GroupTable,
			Columns: []string{usergroup.GroupColumn},
			Bidi:    false,
		},
		"UserGroup",
		"Group",
	)
	graph.MustAddE(
		"user",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usertweet.UserTable,
			Columns: []string{usertweet.UserColumn},
			Bidi:    false,
		},
		"UserTweet",
		"User",
	)
	graph.MustAddE(
		"tweet",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   usertweet.TweetTable,
			Columns: []string{usertweet.TweetColumn},
			Bidi:    false,
		},
		"UserTweet",
		"Tweet",
	)
	return graph
}()

// predicateAdder wraps the addPredicate method.
// All update, update-one and query builders implement this interface.
type predicateAdder interface {
	addPredicate(func(s *sql.Selector))
}

// addPredicate implements the predicateAdder interface.
func (fq *FriendshipQuery) addPredicate(pred func(s *sql.Selector)) {
	fq.predicates = append(fq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the FriendshipQuery builder.
func (fq *FriendshipQuery) Filter() *FriendshipFilter {
	return &FriendshipFilter{config: fq.config, predicateAdder: fq}
}

// addPredicate implements the predicateAdder interface.
func (m *FriendshipMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the FriendshipMutation builder.
func (m *FriendshipMutation) Filter() *FriendshipFilter {
	return &FriendshipFilter{config: m.config, predicateAdder: m}
}

// FriendshipFilter provides a generic filtering capability at runtime for FriendshipQuery.
type FriendshipFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *FriendshipFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[0].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *FriendshipFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(friendship.FieldID))
}

// WhereWeight applies the entql int predicate on the weight field.
func (f *FriendshipFilter) WhereWeight(p entql.IntP) {
	f.Where(p.Field(friendship.FieldWeight))
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *FriendshipFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(friendship.FieldCreatedAt))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *FriendshipFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(friendship.FieldUserID))
}

// WhereFriendID applies the entql int predicate on the friend_id field.
func (f *FriendshipFilter) WhereFriendID(p entql.IntP) {
	f.Where(p.Field(friendship.FieldFriendID))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *FriendshipFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *FriendshipFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFriend applies a predicate to check if query has an edge friend.
func (f *FriendshipFilter) WhereHasFriend() {
	f.Where(entql.HasEdge("friend"))
}

// WhereHasFriendWith applies a predicate to check if query has an edge friend with a given conditions (other predicates).
func (f *FriendshipFilter) WhereHasFriendWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("friend", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (gq *GroupQuery) addPredicate(pred func(s *sql.Selector)) {
	gq.predicates = append(gq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the GroupQuery builder.
func (gq *GroupQuery) Filter() *GroupFilter {
	return &GroupFilter{config: gq.config, predicateAdder: gq}
}

// addPredicate implements the predicateAdder interface.
func (m *GroupMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the GroupMutation builder.
func (m *GroupMutation) Filter() *GroupFilter {
	return &GroupFilter{config: m.config, predicateAdder: m}
}

// GroupFilter provides a generic filtering capability at runtime for GroupQuery.
type GroupFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *GroupFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[1].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *GroupFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(group.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *GroupFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(group.FieldName))
}

// WhereHasUsers applies a predicate to check if query has an edge users.
func (f *GroupFilter) WhereHasUsers() {
	f.Where(entql.HasEdge("users"))
}

// WhereHasUsersWith applies a predicate to check if query has an edge users with a given conditions (other predicates).
func (f *GroupFilter) WhereHasUsersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasJoinedUsers applies a predicate to check if query has an edge joined_users.
func (f *GroupFilter) WhereHasJoinedUsers() {
	f.Where(entql.HasEdge("joined_users"))
}

// WhereHasJoinedUsersWith applies a predicate to check if query has an edge joined_users with a given conditions (other predicates).
func (f *GroupFilter) WhereHasJoinedUsersWith(preds ...predicate.UserGroup) {
	f.Where(entql.HasEdgeWith("joined_users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (rq *RelationshipQuery) addPredicate(pred func(s *sql.Selector)) {
	rq.predicates = append(rq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the RelationshipQuery builder.
func (rq *RelationshipQuery) Filter() *RelationshipFilter {
	return &RelationshipFilter{config: rq.config, predicateAdder: rq}
}

// addPredicate implements the predicateAdder interface.
func (m *RelationshipMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the RelationshipMutation builder.
func (m *RelationshipMutation) Filter() *RelationshipFilter {
	return &RelationshipFilter{config: m.config, predicateAdder: m}
}

// RelationshipFilter provides a generic filtering capability at runtime for RelationshipQuery.
type RelationshipFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *RelationshipFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[2].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereWeight applies the entql int predicate on the weight field.
func (f *RelationshipFilter) WhereWeight(p entql.IntP) {
	f.Where(p.Field(relationship.FieldWeight))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *RelationshipFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(relationship.FieldUserID))
}

// WhereRelativeID applies the entql int predicate on the relative_id field.
func (f *RelationshipFilter) WhereRelativeID(p entql.IntP) {
	f.Where(p.Field(relationship.FieldRelativeID))
}

// WhereInfoID applies the entql int predicate on the info_id field.
func (f *RelationshipFilter) WhereInfoID(p entql.IntP) {
	f.Where(p.Field(relationship.FieldInfoID))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *RelationshipFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *RelationshipFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRelative applies a predicate to check if query has an edge relative.
func (f *RelationshipFilter) WhereHasRelative() {
	f.Where(entql.HasEdge("relative"))
}

// WhereHasRelativeWith applies a predicate to check if query has an edge relative with a given conditions (other predicates).
func (f *RelationshipFilter) WhereHasRelativeWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("relative", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasInfo applies a predicate to check if query has an edge info.
func (f *RelationshipFilter) WhereHasInfo() {
	f.Where(entql.HasEdge("info"))
}

// WhereHasInfoWith applies a predicate to check if query has an edge info with a given conditions (other predicates).
func (f *RelationshipFilter) WhereHasInfoWith(preds ...predicate.RelationshipInfo) {
	f.Where(entql.HasEdgeWith("info", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (riq *RelationshipInfoQuery) addPredicate(pred func(s *sql.Selector)) {
	riq.predicates = append(riq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the RelationshipInfoQuery builder.
func (riq *RelationshipInfoQuery) Filter() *RelationshipInfoFilter {
	return &RelationshipInfoFilter{config: riq.config, predicateAdder: riq}
}

// addPredicate implements the predicateAdder interface.
func (m *RelationshipInfoMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the RelationshipInfoMutation builder.
func (m *RelationshipInfoMutation) Filter() *RelationshipInfoFilter {
	return &RelationshipInfoFilter{config: m.config, predicateAdder: m}
}

// RelationshipInfoFilter provides a generic filtering capability at runtime for RelationshipInfoQuery.
type RelationshipInfoFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *RelationshipInfoFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[3].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *RelationshipInfoFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(relationshipinfo.FieldID))
}

// WhereText applies the entql string predicate on the text field.
func (f *RelationshipInfoFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(relationshipinfo.FieldText))
}

// addPredicate implements the predicateAdder interface.
func (rq *RoleQuery) addPredicate(pred func(s *sql.Selector)) {
	rq.predicates = append(rq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the RoleQuery builder.
func (rq *RoleQuery) Filter() *RoleFilter {
	return &RoleFilter{config: rq.config, predicateAdder: rq}
}

// addPredicate implements the predicateAdder interface.
func (m *RoleMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the RoleMutation builder.
func (m *RoleMutation) Filter() *RoleFilter {
	return &RoleFilter{config: m.config, predicateAdder: m}
}

// RoleFilter provides a generic filtering capability at runtime for RoleQuery.
type RoleFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *RoleFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[4].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *RoleFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(role.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *RoleFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(role.FieldName))
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *RoleFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(role.FieldCreatedAt))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *RoleFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *RoleFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRolesUsers applies a predicate to check if query has an edge roles_users.
func (f *RoleFilter) WhereHasRolesUsers() {
	f.Where(entql.HasEdge("roles_users"))
}

// WhereHasRolesUsersWith applies a predicate to check if query has an edge roles_users with a given conditions (other predicates).
func (f *RoleFilter) WhereHasRolesUsersWith(preds ...predicate.RoleUser) {
	f.Where(entql.HasEdgeWith("roles_users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (ruq *RoleUserQuery) addPredicate(pred func(s *sql.Selector)) {
	ruq.predicates = append(ruq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the RoleUserQuery builder.
func (ruq *RoleUserQuery) Filter() *RoleUserFilter {
	return &RoleUserFilter{config: ruq.config, predicateAdder: ruq}
}

// addPredicate implements the predicateAdder interface.
func (m *RoleUserMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the RoleUserMutation builder.
func (m *RoleUserMutation) Filter() *RoleUserFilter {
	return &RoleUserFilter{config: m.config, predicateAdder: m}
}

// RoleUserFilter provides a generic filtering capability at runtime for RoleUserQuery.
type RoleUserFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *RoleUserFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[5].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *RoleUserFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(roleuser.FieldCreatedAt))
}

// WhereRoleID applies the entql int predicate on the role_id field.
func (f *RoleUserFilter) WhereRoleID(p entql.IntP) {
	f.Where(p.Field(roleuser.FieldRoleID))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *RoleUserFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(roleuser.FieldUserID))
}

// WhereHasRole applies a predicate to check if query has an edge role.
func (f *RoleUserFilter) WhereHasRole() {
	f.Where(entql.HasEdge("role"))
}

// WhereHasRoleWith applies a predicate to check if query has an edge role with a given conditions (other predicates).
func (f *RoleUserFilter) WhereHasRoleWith(preds ...predicate.Role) {
	f.Where(entql.HasEdgeWith("role", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *RoleUserFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *RoleUserFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tq *TagQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TagQuery builder.
func (tq *TagQuery) Filter() *TagFilter {
	return &TagFilter{config: tq.config, predicateAdder: tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TagMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TagMutation builder.
func (m *TagMutation) Filter() *TagFilter {
	return &TagFilter{config: m.config, predicateAdder: m}
}

// TagFilter provides a generic filtering capability at runtime for TagQuery.
type TagFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TagFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[6].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *TagFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(tag.FieldID))
}

// WhereValue applies the entql string predicate on the value field.
func (f *TagFilter) WhereValue(p entql.StringP) {
	f.Where(p.Field(tag.FieldValue))
}

// WhereHasTweets applies a predicate to check if query has an edge tweets.
func (f *TagFilter) WhereHasTweets() {
	f.Where(entql.HasEdge("tweets"))
}

// WhereHasTweetsWith applies a predicate to check if query has an edge tweets with a given conditions (other predicates).
func (f *TagFilter) WhereHasTweetsWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("tweets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweetTags applies a predicate to check if query has an edge tweet_tags.
func (f *TagFilter) WhereHasTweetTags() {
	f.Where(entql.HasEdge("tweet_tags"))
}

// WhereHasTweetTagsWith applies a predicate to check if query has an edge tweet_tags with a given conditions (other predicates).
func (f *TagFilter) WhereHasTweetTagsWith(preds ...predicate.TweetTag) {
	f.Where(entql.HasEdgeWith("tweet_tags", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tq *TweetQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TweetQuery builder.
func (tq *TweetQuery) Filter() *TweetFilter {
	return &TweetFilter{config: tq.config, predicateAdder: tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TweetMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TweetMutation builder.
func (m *TweetMutation) Filter() *TweetFilter {
	return &TweetFilter{config: m.config, predicateAdder: m}
}

// TweetFilter provides a generic filtering capability at runtime for TweetQuery.
type TweetFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TweetFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[7].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *TweetFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(tweet.FieldID))
}

// WhereText applies the entql string predicate on the text field.
func (f *TweetFilter) WhereText(p entql.StringP) {
	f.Where(p.Field(tweet.FieldText))
}

// WhereHasLikedUsers applies a predicate to check if query has an edge liked_users.
func (f *TweetFilter) WhereHasLikedUsers() {
	f.Where(entql.HasEdge("liked_users"))
}

// WhereHasLikedUsersWith applies a predicate to check if query has an edge liked_users with a given conditions (other predicates).
func (f *TweetFilter) WhereHasLikedUsersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("liked_users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *TweetFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *TweetFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTags applies a predicate to check if query has an edge tags.
func (f *TweetFilter) WhereHasTags() {
	f.Where(entql.HasEdge("tags"))
}

// WhereHasTagsWith applies a predicate to check if query has an edge tags with a given conditions (other predicates).
func (f *TweetFilter) WhereHasTagsWith(preds ...predicate.Tag) {
	f.Where(entql.HasEdgeWith("tags", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasLikes applies a predicate to check if query has an edge likes.
func (f *TweetFilter) WhereHasLikes() {
	f.Where(entql.HasEdge("likes"))
}

// WhereHasLikesWith applies a predicate to check if query has an edge likes with a given conditions (other predicates).
func (f *TweetFilter) WhereHasLikesWith(preds ...predicate.TweetLike) {
	f.Where(entql.HasEdgeWith("likes", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweetUser applies a predicate to check if query has an edge tweet_user.
func (f *TweetFilter) WhereHasTweetUser() {
	f.Where(entql.HasEdge("tweet_user"))
}

// WhereHasTweetUserWith applies a predicate to check if query has an edge tweet_user with a given conditions (other predicates).
func (f *TweetFilter) WhereHasTweetUserWith(preds ...predicate.UserTweet) {
	f.Where(entql.HasEdgeWith("tweet_user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweetTags applies a predicate to check if query has an edge tweet_tags.
func (f *TweetFilter) WhereHasTweetTags() {
	f.Where(entql.HasEdge("tweet_tags"))
}

// WhereHasTweetTagsWith applies a predicate to check if query has an edge tweet_tags with a given conditions (other predicates).
func (f *TweetFilter) WhereHasTweetTagsWith(preds ...predicate.TweetTag) {
	f.Where(entql.HasEdgeWith("tweet_tags", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tlq *TweetLikeQuery) addPredicate(pred func(s *sql.Selector)) {
	tlq.predicates = append(tlq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TweetLikeQuery builder.
func (tlq *TweetLikeQuery) Filter() *TweetLikeFilter {
	return &TweetLikeFilter{config: tlq.config, predicateAdder: tlq}
}

// addPredicate implements the predicateAdder interface.
func (m *TweetLikeMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TweetLikeMutation builder.
func (m *TweetLikeMutation) Filter() *TweetLikeFilter {
	return &TweetLikeFilter{config: m.config, predicateAdder: m}
}

// TweetLikeFilter provides a generic filtering capability at runtime for TweetLikeQuery.
type TweetLikeFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TweetLikeFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[8].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereLikedAt applies the entql time.Time predicate on the liked_at field.
func (f *TweetLikeFilter) WhereLikedAt(p entql.TimeP) {
	f.Where(p.Field(tweetlike.FieldLikedAt))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *TweetLikeFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(tweetlike.FieldUserID))
}

// WhereTweetID applies the entql int predicate on the tweet_id field.
func (f *TweetLikeFilter) WhereTweetID(p entql.IntP) {
	f.Where(p.Field(tweetlike.FieldTweetID))
}

// WhereHasTweet applies a predicate to check if query has an edge tweet.
func (f *TweetLikeFilter) WhereHasTweet() {
	f.Where(entql.HasEdge("tweet"))
}

// WhereHasTweetWith applies a predicate to check if query has an edge tweet with a given conditions (other predicates).
func (f *TweetLikeFilter) WhereHasTweetWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("tweet", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *TweetLikeFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *TweetLikeFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (ttq *TweetTagQuery) addPredicate(pred func(s *sql.Selector)) {
	ttq.predicates = append(ttq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TweetTagQuery builder.
func (ttq *TweetTagQuery) Filter() *TweetTagFilter {
	return &TweetTagFilter{config: ttq.config, predicateAdder: ttq}
}

// addPredicate implements the predicateAdder interface.
func (m *TweetTagMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TweetTagMutation builder.
func (m *TweetTagMutation) Filter() *TweetTagFilter {
	return &TweetTagFilter{config: m.config, predicateAdder: m}
}

// TweetTagFilter provides a generic filtering capability at runtime for TweetTagQuery.
type TweetTagFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *TweetTagFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[9].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql [16]byte predicate on the id field.
func (f *TweetTagFilter) WhereID(p entql.ValueP) {
	f.Where(p.Field(tweettag.FieldID))
}

// WhereAddedAt applies the entql time.Time predicate on the added_at field.
func (f *TweetTagFilter) WhereAddedAt(p entql.TimeP) {
	f.Where(p.Field(tweettag.FieldAddedAt))
}

// WhereTagID applies the entql int predicate on the tag_id field.
func (f *TweetTagFilter) WhereTagID(p entql.IntP) {
	f.Where(p.Field(tweettag.FieldTagID))
}

// WhereTweetID applies the entql int predicate on the tweet_id field.
func (f *TweetTagFilter) WhereTweetID(p entql.IntP) {
	f.Where(p.Field(tweettag.FieldTweetID))
}

// WhereHasTag applies a predicate to check if query has an edge tag.
func (f *TweetTagFilter) WhereHasTag() {
	f.Where(entql.HasEdge("tag"))
}

// WhereHasTagWith applies a predicate to check if query has an edge tag with a given conditions (other predicates).
func (f *TweetTagFilter) WhereHasTagWith(preds ...predicate.Tag) {
	f.Where(entql.HasEdgeWith("tag", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweet applies a predicate to check if query has an edge tweet.
func (f *TweetTagFilter) WhereHasTweet() {
	f.Where(entql.HasEdge("tweet"))
}

// WhereHasTweetWith applies a predicate to check if query has an edge tweet with a given conditions (other predicates).
func (f *TweetTagFilter) WhereHasTweetWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("tweet", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (uq *UserQuery) addPredicate(pred func(s *sql.Selector)) {
	uq.predicates = append(uq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserQuery builder.
func (uq *UserQuery) Filter() *UserFilter {
	return &UserFilter{config: uq.config, predicateAdder: uq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserMutation builder.
func (m *UserMutation) Filter() *UserFilter {
	return &UserFilter{config: m.config, predicateAdder: m}
}

// UserFilter provides a generic filtering capability at runtime for UserQuery.
type UserFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *UserFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[10].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(user.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *UserFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(user.FieldName))
}

// WhereHasGroups applies a predicate to check if query has an edge groups.
func (f *UserFilter) WhereHasGroups() {
	f.Where(entql.HasEdge("groups"))
}

// WhereHasGroupsWith applies a predicate to check if query has an edge groups with a given conditions (other predicates).
func (f *UserFilter) WhereHasGroupsWith(preds ...predicate.Group) {
	f.Where(entql.HasEdgeWith("groups", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFriends applies a predicate to check if query has an edge friends.
func (f *UserFilter) WhereHasFriends() {
	f.Where(entql.HasEdge("friends"))
}

// WhereHasFriendsWith applies a predicate to check if query has an edge friends with a given conditions (other predicates).
func (f *UserFilter) WhereHasFriendsWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("friends", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRelatives applies a predicate to check if query has an edge relatives.
func (f *UserFilter) WhereHasRelatives() {
	f.Where(entql.HasEdge("relatives"))
}

// WhereHasRelativesWith applies a predicate to check if query has an edge relatives with a given conditions (other predicates).
func (f *UserFilter) WhereHasRelativesWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("relatives", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasLikedTweets applies a predicate to check if query has an edge liked_tweets.
func (f *UserFilter) WhereHasLikedTweets() {
	f.Where(entql.HasEdge("liked_tweets"))
}

// WhereHasLikedTweetsWith applies a predicate to check if query has an edge liked_tweets with a given conditions (other predicates).
func (f *UserFilter) WhereHasLikedTweetsWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("liked_tweets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweets applies a predicate to check if query has an edge tweets.
func (f *UserFilter) WhereHasTweets() {
	f.Where(entql.HasEdge("tweets"))
}

// WhereHasTweetsWith applies a predicate to check if query has an edge tweets with a given conditions (other predicates).
func (f *UserFilter) WhereHasTweetsWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("tweets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRoles applies a predicate to check if query has an edge roles.
func (f *UserFilter) WhereHasRoles() {
	f.Where(entql.HasEdge("roles"))
}

// WhereHasRolesWith applies a predicate to check if query has an edge roles with a given conditions (other predicates).
func (f *UserFilter) WhereHasRolesWith(preds ...predicate.Role) {
	f.Where(entql.HasEdgeWith("roles", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasJoinedGroups applies a predicate to check if query has an edge joined_groups.
func (f *UserFilter) WhereHasJoinedGroups() {
	f.Where(entql.HasEdge("joined_groups"))
}

// WhereHasJoinedGroupsWith applies a predicate to check if query has an edge joined_groups with a given conditions (other predicates).
func (f *UserFilter) WhereHasJoinedGroupsWith(preds ...predicate.UserGroup) {
	f.Where(entql.HasEdgeWith("joined_groups", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasFriendships applies a predicate to check if query has an edge friendships.
func (f *UserFilter) WhereHasFriendships() {
	f.Where(entql.HasEdge("friendships"))
}

// WhereHasFriendshipsWith applies a predicate to check if query has an edge friendships with a given conditions (other predicates).
func (f *UserFilter) WhereHasFriendshipsWith(preds ...predicate.Friendship) {
	f.Where(entql.HasEdgeWith("friendships", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRelationship applies a predicate to check if query has an edge relationship.
func (f *UserFilter) WhereHasRelationship() {
	f.Where(entql.HasEdge("relationship"))
}

// WhereHasRelationshipWith applies a predicate to check if query has an edge relationship with a given conditions (other predicates).
func (f *UserFilter) WhereHasRelationshipWith(preds ...predicate.Relationship) {
	f.Where(entql.HasEdgeWith("relationship", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasLikes applies a predicate to check if query has an edge likes.
func (f *UserFilter) WhereHasLikes() {
	f.Where(entql.HasEdge("likes"))
}

// WhereHasLikesWith applies a predicate to check if query has an edge likes with a given conditions (other predicates).
func (f *UserFilter) WhereHasLikesWith(preds ...predicate.TweetLike) {
	f.Where(entql.HasEdgeWith("likes", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUserTweets applies a predicate to check if query has an edge user_tweets.
func (f *UserFilter) WhereHasUserTweets() {
	f.Where(entql.HasEdge("user_tweets"))
}

// WhereHasUserTweetsWith applies a predicate to check if query has an edge user_tweets with a given conditions (other predicates).
func (f *UserFilter) WhereHasUserTweetsWith(preds ...predicate.UserTweet) {
	f.Where(entql.HasEdgeWith("user_tweets", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasRolesUsers applies a predicate to check if query has an edge roles_users.
func (f *UserFilter) WhereHasRolesUsers() {
	f.Where(entql.HasEdge("roles_users"))
}

// WhereHasRolesUsersWith applies a predicate to check if query has an edge roles_users with a given conditions (other predicates).
func (f *UserFilter) WhereHasRolesUsersWith(preds ...predicate.RoleUser) {
	f.Where(entql.HasEdgeWith("roles_users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (ugq *UserGroupQuery) addPredicate(pred func(s *sql.Selector)) {
	ugq.predicates = append(ugq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserGroupQuery builder.
func (ugq *UserGroupQuery) Filter() *UserGroupFilter {
	return &UserGroupFilter{config: ugq.config, predicateAdder: ugq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserGroupMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserGroupMutation builder.
func (m *UserGroupMutation) Filter() *UserGroupFilter {
	return &UserGroupFilter{config: m.config, predicateAdder: m}
}

// UserGroupFilter provides a generic filtering capability at runtime for UserGroupQuery.
type UserGroupFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *UserGroupFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[11].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserGroupFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(usergroup.FieldID))
}

// WhereJoinedAt applies the entql time.Time predicate on the joined_at field.
func (f *UserGroupFilter) WhereJoinedAt(p entql.TimeP) {
	f.Where(p.Field(usergroup.FieldJoinedAt))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *UserGroupFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(usergroup.FieldUserID))
}

// WhereGroupID applies the entql int predicate on the group_id field.
func (f *UserGroupFilter) WhereGroupID(p entql.IntP) {
	f.Where(p.Field(usergroup.FieldGroupID))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *UserGroupFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *UserGroupFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasGroup applies a predicate to check if query has an edge group.
func (f *UserGroupFilter) WhereHasGroup() {
	f.Where(entql.HasEdge("group"))
}

// WhereHasGroupWith applies a predicate to check if query has an edge group with a given conditions (other predicates).
func (f *UserGroupFilter) WhereHasGroupWith(preds ...predicate.Group) {
	f.Where(entql.HasEdgeWith("group", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (utq *UserTweetQuery) addPredicate(pred func(s *sql.Selector)) {
	utq.predicates = append(utq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserTweetQuery builder.
func (utq *UserTweetQuery) Filter() *UserTweetFilter {
	return &UserTweetFilter{config: utq.config, predicateAdder: utq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserTweetMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserTweetMutation builder.
func (m *UserTweetMutation) Filter() *UserTweetFilter {
	return &UserTweetFilter{config: m.config, predicateAdder: m}
}

// UserTweetFilter provides a generic filtering capability at runtime for UserTweetQuery.
type UserTweetFilter struct {
	predicateAdder
	config
}

// Where applies the entql predicate on the query filter.
func (f *UserTweetFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[12].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserTweetFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(usertweet.FieldID))
}

// WhereCreatedAt applies the entql time.Time predicate on the created_at field.
func (f *UserTweetFilter) WhereCreatedAt(p entql.TimeP) {
	f.Where(p.Field(usertweet.FieldCreatedAt))
}

// WhereUserID applies the entql int predicate on the user_id field.
func (f *UserTweetFilter) WhereUserID(p entql.IntP) {
	f.Where(p.Field(usertweet.FieldUserID))
}

// WhereTweetID applies the entql int predicate on the tweet_id field.
func (f *UserTweetFilter) WhereTweetID(p entql.IntP) {
	f.Where(p.Field(usertweet.FieldTweetID))
}

// WhereHasUser applies a predicate to check if query has an edge user.
func (f *UserTweetFilter) WhereHasUser() {
	f.Where(entql.HasEdge("user"))
}

// WhereHasUserWith applies a predicate to check if query has an edge user with a given conditions (other predicates).
func (f *UserTweetFilter) WhereHasUserWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("user", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTweet applies a predicate to check if query has an edge tweet.
func (f *UserTweetFilter) WhereHasTweet() {
	f.Where(entql.HasEdge("tweet"))
}

// WhereHasTweetWith applies a predicate to check if query has an edge tweet with a given conditions (other predicates).
func (f *UserTweetFilter) WhereHasTweetWith(preds ...predicate.Tweet) {
	f.Where(entql.HasEdgeWith("tweet", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}
