=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'cgi'

module OpenbaoClient
  class SecretsApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # Deletes the secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cubbyhole_delete(path, opts = {})
      cubbyhole_delete_with_http_info(path, opts)
      nil
    end

    # Deletes the secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cubbyhole_delete_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.cubbyhole_delete ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.cubbyhole_delete"
      end
      # resource path
      local_var_path = '/cubbyhole/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.cubbyhole_delete",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#cubbyhole_delete\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve the secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [nil]
    def cubbyhole_read(path, opts = {})
      cubbyhole_read_with_http_info(path, opts)
      nil
    end

    # Retrieve the secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cubbyhole_read_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.cubbyhole_read ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.cubbyhole_read"
      end
      # resource path
      local_var_path = '/cubbyhole/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.cubbyhole_read",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#cubbyhole_read\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Store a secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cubbyhole_write(path, opts = {})
      cubbyhole_write_with_http_info(path, opts)
      nil
    end

    # Store a secret at the specified location.
    # @param path [String] Specifies the path of the secret.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cubbyhole_write_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.cubbyhole_write ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.cubbyhole_write"
      end
      # resource path
      local_var_path = '/cubbyhole/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.cubbyhole_write",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#cubbyhole_write\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_configure_connection_request [DatabaseConfigureConnectionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_configure_connection(name, database_mount_path, database_configure_connection_request, opts = {})
      database_configure_connection_with_http_info(name, database_mount_path, database_configure_connection_request, opts)
      nil
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_configure_connection_request [DatabaseConfigureConnectionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_configure_connection_with_http_info(name, database_mount_path, database_configure_connection_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_configure_connection ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_configure_connection"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_configure_connection"
      end
      # verify the required parameter 'database_configure_connection_request' is set
      if @api_client.config.client_side_validation && database_configure_connection_request.nil?
        fail ArgumentError, "Missing the required parameter 'database_configure_connection_request' when calling SecretsApi.database_configure_connection"
      end
      # resource path
      local_var_path = '/{database_mount_path}/config/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(database_configure_connection_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_configure_connection",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_configure_connection\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_delete_connection_configuration(name, database_mount_path, opts = {})
      database_delete_connection_configuration_with_http_info(name, database_mount_path, opts)
      nil
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_delete_connection_configuration_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_delete_connection_configuration ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_delete_connection_configuration"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_delete_connection_configuration"
      end
      # resource path
      local_var_path = '/{database_mount_path}/config/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_delete_connection_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_delete_connection_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_delete_role(name, database_mount_path, opts = {})
      database_delete_role_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_delete_role_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_delete_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_delete_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_delete_static_role(name, database_mount_path, opts = {})
      database_delete_static_role_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_delete_static_role_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_delete_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_delete_static_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_delete_static_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/static-roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_delete_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_delete_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Request database credentials for a certain role.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_generate_credentials(name, database_mount_path, opts = {})
      database_generate_credentials_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Request database credentials for a certain role.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_generate_credentials_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_generate_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_generate_credentials"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_generate_credentials"
      end
      # resource path
      local_var_path = '/{database_mount_path}/creds/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_generate_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_generate_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure connection details to a database plugin.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_list_connections(database_mount_path, list, opts = {})
      database_list_connections_with_http_info(database_mount_path, list, opts)
      nil
    end

    # Configure connection details to a database plugin.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_list_connections_with_http_info(database_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_list_connections ...'
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_list_connections"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.database_list_connections"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{database_mount_path}/config'.sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_list_connections",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_list_connections\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_list_roles(database_mount_path, list, opts = {})
      database_list_roles_with_http_info(database_mount_path, list, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_list_roles_with_http_info(database_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_list_roles ...'
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.database_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{database_mount_path}/roles'.sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the static roles that can be created with this backend.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_list_static_roles(database_mount_path, list, opts = {})
      database_list_static_roles_with_http_info(database_mount_path, list, opts)
      nil
    end

    # Manage the static roles that can be created with this backend.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_list_static_roles_with_http_info(database_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_list_static_roles ...'
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_list_static_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.database_list_static_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{database_mount_path}/static-roles'.sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_list_static_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_list_static_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_read_connection_configuration(name, database_mount_path, opts = {})
      database_read_connection_configuration_with_http_info(name, database_mount_path, opts)
      nil
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_read_connection_configuration_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_read_connection_configuration ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_read_connection_configuration"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_read_connection_configuration"
      end
      # resource path
      local_var_path = '/{database_mount_path}/config/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_read_connection_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_read_connection_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_read_role(name, database_mount_path, opts = {})
      database_read_role_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_read_role_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_read_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_read_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_read_static_role(name, database_mount_path, opts = {})
      database_read_static_role_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_read_static_role_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_read_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_read_static_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_read_static_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/static-roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_read_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_read_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Request database credentials for a certain static role. These credentials are rotated periodically.
    # @param name [String] Name of the static role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_read_static_role_credentials(name, database_mount_path, opts = {})
      database_read_static_role_credentials_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Request database credentials for a certain static role. These credentials are rotated periodically.
    # @param name [String] Name of the static role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_read_static_role_credentials_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_read_static_role_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_read_static_role_credentials"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_read_static_role_credentials"
      end
      # resource path
      local_var_path = '/{database_mount_path}/static-creds/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_read_static_role_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_read_static_role_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Resets a database plugin.
    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_reset_connection(name, database_mount_path, opts = {})
      database_reset_connection_with_http_info(name, database_mount_path, opts)
      nil
    end

    # Resets a database plugin.
    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_reset_connection_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_reset_connection ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_reset_connection"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_reset_connection"
      end
      # resource path
      local_var_path = '/{database_mount_path}/reset/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_reset_connection",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_reset_connection\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_rotate_root_credentials(name, database_mount_path, opts = {})
      database_rotate_root_credentials_with_http_info(name, database_mount_path, opts)
      nil
    end

    # @param name [String] Name of this database connection
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_rotate_root_credentials_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_rotate_root_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_rotate_root_credentials"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_rotate_root_credentials"
      end
      # resource path
      local_var_path = '/{database_mount_path}/rotate-root/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_rotate_root_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_rotate_root_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the static role
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_rotate_static_role_credentials(name, database_mount_path, opts = {})
      database_rotate_static_role_credentials_with_http_info(name, database_mount_path, opts)
      nil
    end

    # @param name [String] Name of the static role
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_rotate_static_role_credentials_with_http_info(name, database_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_rotate_static_role_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_rotate_static_role_credentials"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_rotate_static_role_credentials"
      end
      # resource path
      local_var_path = '/{database_mount_path}/rotate-role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_rotate_static_role_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_rotate_static_role_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_write_role_request [DatabaseWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_write_role(name, database_mount_path, database_write_role_request, opts = {})
      database_write_role_with_http_info(name, database_mount_path, database_write_role_request, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_write_role_request [DatabaseWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_write_role_with_http_info(name, database_mount_path, database_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_write_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_write_role"
      end
      # verify the required parameter 'database_write_role_request' is set
      if @api_client.config.client_side_validation && database_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'database_write_role_request' when calling SecretsApi.database_write_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(database_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_write_static_role_request [DatabaseWriteStaticRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def database_write_static_role(name, database_mount_path, database_write_static_role_request, opts = {})
      database_write_static_role_with_http_info(name, database_mount_path, database_write_static_role_request, opts)
      nil
    end

    # Manage the static roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param database_mount_path [String] Path that the backend was mounted at
    # @param database_write_static_role_request [DatabaseWriteStaticRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def database_write_static_role_with_http_info(name, database_mount_path, database_write_static_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.database_write_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.database_write_static_role"
      end
      # verify the required parameter 'database_mount_path' is set
      if @api_client.config.client_side_validation && database_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'database_mount_path' when calling SecretsApi.database_write_static_role"
      end
      # verify the required parameter 'database_write_static_role_request' is set
      if @api_client.config.client_side_validation && database_write_static_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'database_write_static_role_request' when calling SecretsApi.database_write_static_role"
      end
      # resource path
      local_var_path = '/{database_mount_path}/static-roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'database_mount_path' + '}', CGI.escape(database_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(database_write_static_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.database_write_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#database_write_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_check_configuration(kubernetes_mount_path, opts = {})
      kubernetes_check_configuration_with_http_info(kubernetes_mount_path, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_check_configuration_with_http_info(kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_check_configuration ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_check_configuration"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/check'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_check_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_check_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_configure_request [KubernetesConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_configure(kubernetes_mount_path, kubernetes_configure_request, opts = {})
      kubernetes_configure_with_http_info(kubernetes_mount_path, kubernetes_configure_request, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_configure_request [KubernetesConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_configure_with_http_info(kubernetes_mount_path, kubernetes_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_configure ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_configure"
      end
      # verify the required parameter 'kubernetes_configure_request' is set
      if @api_client.config.client_side_validation && kubernetes_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_configure_request' when calling SecretsApi.kubernetes_configure"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/config'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_delete_configuration(kubernetes_mount_path, opts = {})
      kubernetes_delete_configuration_with_http_info(kubernetes_mount_path, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_delete_configuration_with_http_info(kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_delete_configuration ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_delete_configuration"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/config'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_delete_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_delete_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_delete_role(name, kubernetes_mount_path, opts = {})
      kubernetes_delete_role_with_http_info(name, kubernetes_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_delete_role_with_http_info(name, kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.kubernetes_delete_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_delete_role"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the OpenBao role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_generate_credentials_request [KubernetesGenerateCredentialsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_generate_credentials(name, kubernetes_mount_path, kubernetes_generate_credentials_request, opts = {})
      kubernetes_generate_credentials_with_http_info(name, kubernetes_mount_path, kubernetes_generate_credentials_request, opts)
      nil
    end

    # @param name [String] Name of the OpenBao role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_generate_credentials_request [KubernetesGenerateCredentialsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_generate_credentials_with_http_info(name, kubernetes_mount_path, kubernetes_generate_credentials_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_generate_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.kubernetes_generate_credentials"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_generate_credentials"
      end
      # verify the required parameter 'kubernetes_generate_credentials_request' is set
      if @api_client.config.client_side_validation && kubernetes_generate_credentials_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_generate_credentials_request' when calling SecretsApi.kubernetes_generate_credentials"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/creds/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_generate_credentials_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_generate_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_generate_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_list_roles(kubernetes_mount_path, list, opts = {})
      kubernetes_list_roles_with_http_info(kubernetes_mount_path, list, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_list_roles_with_http_info(kubernetes_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_list_roles ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.kubernetes_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/roles'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_read_configuration(kubernetes_mount_path, opts = {})
      kubernetes_read_configuration_with_http_info(kubernetes_mount_path, opts)
      nil
    end

    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_read_configuration_with_http_info(kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_read_configuration ...'
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_read_configuration"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/config'.sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_read_role(name, kubernetes_mount_path, opts = {})
      kubernetes_read_role_with_http_info(name, kubernetes_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_read_role_with_http_info(name, kubernetes_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.kubernetes_read_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_read_role"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_write_role_request [KubernetesWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kubernetes_write_role(name, kubernetes_mount_path, kubernetes_write_role_request, opts = {})
      kubernetes_write_role_with_http_info(name, kubernetes_mount_path, kubernetes_write_role_request, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param kubernetes_mount_path [String] Path that the backend was mounted at
    # @param kubernetes_write_role_request [KubernetesWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kubernetes_write_role_with_http_info(name, kubernetes_mount_path, kubernetes_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kubernetes_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.kubernetes_write_role"
      end
      # verify the required parameter 'kubernetes_mount_path' is set
      if @api_client.config.client_side_validation && kubernetes_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_mount_path' when calling SecretsApi.kubernetes_write_role"
      end
      # verify the required parameter 'kubernetes_write_role_request' is set
      if @api_client.config.client_side_validation && kubernetes_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'kubernetes_write_role_request' when calling SecretsApi.kubernetes_write_role"
      end
      # resource path
      local_var_path = '/{kubernetes_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'kubernetes_mount_path' + '}', CGI.escape(kubernetes_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kubernetes_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kubernetes_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kubernetes_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_delete_data_path(path, kv_v2_mount_path, opts = {})
      kv_delete_data_path_with_http_info(path, kv_v2_mount_path, opts)
      nil
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_delete_data_path_with_http_info(path, kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_delete_data_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_delete_data_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_delete_data_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/data/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_delete_data_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_delete_data_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_delete_metadata_path(path, kv_v2_mount_path, opts = {})
      kv_delete_metadata_path_with_http_info(path, kv_v2_mount_path, opts)
      nil
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_delete_metadata_path_with_http_info(path, kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_delete_metadata_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_delete_metadata_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_delete_metadata_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/metadata/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_delete_metadata_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_delete_metadata_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_delete_path(path, kv_v1_mount_path, opts = {})
      kv_delete_path_with_http_info(path, kv_v1_mount_path, opts)
      nil
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_delete_path_with_http_info(path, kv_v1_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_delete_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_delete_path"
      end
      # verify the required parameter 'kv_v1_mount_path' is set
      if @api_client.config.client_side_validation && kv_v1_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v1_mount_path' when calling SecretsApi.kv_delete_path"
      end
      # resource path
      local_var_path = '/{kv_v1_mount_path}/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v1_mount_path' + '}', CGI.escape(kv_v1_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_delete_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_delete_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the backend level settings.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_read_config(kv_v2_mount_path, opts = {})
      kv_read_config_with_http_info(kv_v2_mount_path, opts)
      nil
    end

    # Read the backend level settings.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_read_config_with_http_info(kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_read_config ...'
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_read_config"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/config'.sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_read_config",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_read_config\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_read_data_path(path, kv_v2_mount_path, opts = {})
      kv_read_data_path_with_http_info(path, kv_v2_mount_path, opts)
      nil
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_read_data_path_with_http_info(path, kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_read_data_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_read_data_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_read_data_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/data/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_read_data_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_read_data_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [nil]
    def kv_read_metadata_path(path, kv_v2_mount_path, opts = {})
      kv_read_metadata_path_with_http_info(path, kv_v2_mount_path, opts)
      nil
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_read_metadata_path_with_http_info(path, kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_read_metadata_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_read_metadata_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_read_metadata_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/metadata/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_read_metadata_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_read_metadata_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [nil]
    def kv_read_path(path, kv_v1_mount_path, opts = {})
      kv_read_path_with_http_info(path, kv_v1_mount_path, opts)
      nil
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_read_path_with_http_info(path, kv_v1_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_read_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_read_path"
      end
      # verify the required parameter 'kv_v1_mount_path' is set
      if @api_client.config.client_side_validation && kv_v1_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v1_mount_path' when calling SecretsApi.kv_read_path"
      end
      # resource path
      local_var_path = '/{kv_v1_mount_path}/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v1_mount_path' + '}', CGI.escape(kv_v1_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_read_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_read_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the structure of a secret entry from the Key-Value store with the values removed.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_read_subkeys_path(path, kv_v2_mount_path, opts = {})
      kv_read_subkeys_path_with_http_info(path, kv_v2_mount_path, opts)
      nil
    end

    # Read the structure of a secret entry from the Key-Value store with the values removed.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_read_subkeys_path_with_http_info(path, kv_v2_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_read_subkeys_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_read_subkeys_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_read_subkeys_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/subkeys/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_read_subkeys_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_read_subkeys_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure backend level settings that are applied to every key in the key-value store.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_config_request [KvWriteConfigRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_config(kv_v2_mount_path, kv_write_config_request, opts = {})
      kv_write_config_with_http_info(kv_v2_mount_path, kv_write_config_request, opts)
      nil
    end

    # Configure backend level settings that are applied to every key in the key-value store.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_config_request [KvWriteConfigRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_config_with_http_info(kv_v2_mount_path, kv_write_config_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_config ...'
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_config"
      end
      # verify the required parameter 'kv_write_config_request' is set
      if @api_client.config.client_side_validation && kv_write_config_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_config_request' when calling SecretsApi.kv_write_config"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/config'.sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_config_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_config",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_config\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_data_path_request [KvWriteDataPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_data_path(path, kv_v2_mount_path, kv_write_data_path_request, opts = {})
      kv_write_data_path_with_http_info(path, kv_v2_mount_path, kv_write_data_path_request, opts)
      nil
    end

    # Write, Patch, Read, and Delete data in the Key-Value Store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_data_path_request [KvWriteDataPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_data_path_with_http_info(path, kv_v2_mount_path, kv_write_data_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_data_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_data_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_data_path"
      end
      # verify the required parameter 'kv_write_data_path_request' is set
      if @api_client.config.client_side_validation && kv_write_data_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_data_path_request' when calling SecretsApi.kv_write_data_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/data/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_data_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_data_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_data_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Marks one or more versions as deleted in the KV store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_delete_path_request [KvWriteDeletePathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_delete_path(path, kv_v2_mount_path, kv_write_delete_path_request, opts = {})
      kv_write_delete_path_with_http_info(path, kv_v2_mount_path, kv_write_delete_path_request, opts)
      nil
    end

    # Marks one or more versions as deleted in the KV store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_delete_path_request [KvWriteDeletePathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_delete_path_with_http_info(path, kv_v2_mount_path, kv_write_delete_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_delete_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_delete_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_delete_path"
      end
      # verify the required parameter 'kv_write_delete_path_request' is set
      if @api_client.config.client_side_validation && kv_write_delete_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_delete_path_request' when calling SecretsApi.kv_write_delete_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/delete/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_delete_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_delete_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_delete_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Permanently removes one or more versions in the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_destroy_path_request [KvWriteDestroyPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_destroy_path(path, kv_v2_mount_path, kv_write_destroy_path_request, opts = {})
      kv_write_destroy_path_with_http_info(path, kv_v2_mount_path, kv_write_destroy_path_request, opts)
      nil
    end

    # Permanently removes one or more versions in the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_destroy_path_request [KvWriteDestroyPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_destroy_path_with_http_info(path, kv_v2_mount_path, kv_write_destroy_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_destroy_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_destroy_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_destroy_path"
      end
      # verify the required parameter 'kv_write_destroy_path_request' is set
      if @api_client.config.client_side_validation && kv_write_destroy_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_destroy_path_request' when calling SecretsApi.kv_write_destroy_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/destroy/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_destroy_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_destroy_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_destroy_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_metadata_path_request [KvWriteMetadataPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_metadata_path(path, kv_v2_mount_path, kv_write_metadata_path_request, opts = {})
      kv_write_metadata_path_with_http_info(path, kv_v2_mount_path, kv_write_metadata_path_request, opts)
      nil
    end

    # Configures settings for the KV store
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_metadata_path_request [KvWriteMetadataPathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_metadata_path_with_http_info(path, kv_v2_mount_path, kv_write_metadata_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_metadata_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_metadata_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_metadata_path"
      end
      # verify the required parameter 'kv_write_metadata_path_request' is set
      if @api_client.config.client_side_validation && kv_write_metadata_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_metadata_path_request' when calling SecretsApi.kv_write_metadata_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/metadata/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_metadata_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_metadata_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_metadata_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_path(path, kv_v1_mount_path, opts = {})
      kv_write_path_with_http_info(path, kv_v1_mount_path, opts)
      nil
    end

    # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
    # @param path [String] Location of the secret.
    # @param kv_v1_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_path_with_http_info(path, kv_v1_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_path"
      end
      # verify the required parameter 'kv_v1_mount_path' is set
      if @api_client.config.client_side_validation && kv_v1_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v1_mount_path' when calling SecretsApi.kv_write_path"
      end
      # resource path
      local_var_path = '/{kv_v1_mount_path}/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v1_mount_path' + '}', CGI.escape(kv_v1_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Undeletes one or more versions from the KV store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_undelete_path_request [KvWriteUndeletePathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def kv_write_undelete_path(path, kv_v2_mount_path, kv_write_undelete_path_request, opts = {})
      kv_write_undelete_path_with_http_info(path, kv_v2_mount_path, kv_write_undelete_path_request, opts)
      nil
    end

    # Undeletes one or more versions from the KV store.
    # @param path [String] Location of the secret.
    # @param kv_v2_mount_path [String] Path that the backend was mounted at
    # @param kv_write_undelete_path_request [KvWriteUndeletePathRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def kv_write_undelete_path_with_http_info(path, kv_v2_mount_path, kv_write_undelete_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.kv_write_undelete_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SecretsApi.kv_write_undelete_path"
      end
      # verify the required parameter 'kv_v2_mount_path' is set
      if @api_client.config.client_side_validation && kv_v2_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'kv_v2_mount_path' when calling SecretsApi.kv_write_undelete_path"
      end
      # verify the required parameter 'kv_write_undelete_path_request' is set
      if @api_client.config.client_side_validation && kv_write_undelete_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'kv_write_undelete_path_request' when calling SecretsApi.kv_write_undelete_path"
      end
      # resource path
      local_var_path = '/{kv_v2_mount_path}/undelete/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s)).sub('{' + 'kv_v2_mount_path' + '}', CGI.escape(kv_v2_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(kv_write_undelete_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.kv_write_undelete_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#kv_write_undelete_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_configure_request [LdapConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_configure(ldap_mount_path, ldap_configure_request, opts = {})
      ldap_configure_with_http_info(ldap_mount_path, ldap_configure_request, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_configure_request [LdapConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_configure_with_http_info(ldap_mount_path, ldap_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_configure ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_configure"
      end
      # verify the required parameter 'ldap_configure_request' is set
      if @api_client.config.client_side_validation && ldap_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_configure_request' when calling SecretsApi.ldap_configure"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/config'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_delete_configuration(ldap_mount_path, opts = {})
      ldap_delete_configuration_with_http_info(ldap_mount_path, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_delete_configuration_with_http_info(ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_delete_configuration ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_delete_configuration"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/config'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_delete_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_delete_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_delete_dynamic_role(name, ldap_mount_path, opts = {})
      ldap_delete_dynamic_role_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_delete_dynamic_role_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_delete_dynamic_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_delete_dynamic_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_delete_dynamic_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_delete_dynamic_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_delete_dynamic_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_delete_static_role(name, ldap_mount_path, opts = {})
      ldap_delete_static_role_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_delete_static_role_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_delete_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_delete_static_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_delete_static_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/static-role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_delete_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_delete_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check service accounts in to the library.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_check_in_request [LdapLibraryCheckInRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_check_in(name, ldap_mount_path, ldap_library_check_in_request, opts = {})
      ldap_library_check_in_with_http_info(name, ldap_mount_path, ldap_library_check_in_request, opts)
      nil
    end

    # Check service accounts in to the library.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_check_in_request [LdapLibraryCheckInRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_check_in_with_http_info(name, ldap_mount_path, ldap_library_check_in_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_check_in ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_check_in"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_check_in"
      end
      # verify the required parameter 'ldap_library_check_in_request' is set
      if @api_client.config.client_side_validation && ldap_library_check_in_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_library_check_in_request' when calling SecretsApi.ldap_library_check_in"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}/check-in'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_library_check_in_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_check_in",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_check_in\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check a service account out from the library.
    # @param name [String] Name of the set
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_check_out_request [LdapLibraryCheckOutRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_check_out(name, ldap_mount_path, ldap_library_check_out_request, opts = {})
      ldap_library_check_out_with_http_info(name, ldap_mount_path, ldap_library_check_out_request, opts)
      nil
    end

    # Check a service account out from the library.
    # @param name [String] Name of the set
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_check_out_request [LdapLibraryCheckOutRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_check_out_with_http_info(name, ldap_mount_path, ldap_library_check_out_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_check_out ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_check_out"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_check_out"
      end
      # verify the required parameter 'ldap_library_check_out_request' is set
      if @api_client.config.client_side_validation && ldap_library_check_out_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_library_check_out_request' when calling SecretsApi.ldap_library_check_out"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}/check-out'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_library_check_out_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_check_out",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_check_out\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check the status of the service accounts in a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_check_status(name, ldap_mount_path, opts = {})
      ldap_library_check_status_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Check the status of the service accounts in a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_check_status_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_check_status ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_check_status"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_check_status"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}/status'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_check_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_check_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_configure_request [LdapLibraryConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_configure(name, ldap_mount_path, ldap_library_configure_request, opts = {})
      ldap_library_configure_with_http_info(name, ldap_mount_path, ldap_library_configure_request, opts)
      nil
    end

    # Update a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_configure_request [LdapLibraryConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_configure_with_http_info(name, ldap_mount_path, ldap_library_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_configure ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_configure"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_configure"
      end
      # verify the required parameter 'ldap_library_configure_request' is set
      if @api_client.config.client_side_validation && ldap_library_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_library_configure_request' when calling SecretsApi.ldap_library_configure"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_library_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_delete(name, ldap_mount_path, opts = {})
      ldap_library_delete_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Delete a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_delete_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_delete ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_delete"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_delete"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_delete",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_delete\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check service accounts in to the library.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_force_check_in_request [LdapLibraryForceCheckInRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_force_check_in(name, ldap_mount_path, ldap_library_force_check_in_request, opts = {})
      ldap_library_force_check_in_with_http_info(name, ldap_mount_path, ldap_library_force_check_in_request, opts)
      nil
    end

    # Check service accounts in to the library.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_library_force_check_in_request [LdapLibraryForceCheckInRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_force_check_in_with_http_info(name, ldap_mount_path, ldap_library_force_check_in_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_force_check_in ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_force_check_in"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_force_check_in"
      end
      # verify the required parameter 'ldap_library_force_check_in_request' is set
      if @api_client.config.client_side_validation && ldap_library_force_check_in_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_library_force_check_in_request' when calling SecretsApi.ldap_library_force_check_in"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/manage/{name}/check-in'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_library_force_check_in_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_force_check_in",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_force_check_in\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_list(ldap_mount_path, list, opts = {})
      ldap_library_list_with_http_info(ldap_mount_path, list, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_list_with_http_info(ldap_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_list ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_list"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.ldap_library_list"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_library_read(name, ldap_mount_path, opts = {})
      ldap_library_read_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # Read a library set.
    # @param name [String] Name of the set.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_library_read_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_library_read ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_library_read"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_library_read"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/library/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_library_read",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_library_read\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_list_dynamic_roles(ldap_mount_path, list, opts = {})
      ldap_list_dynamic_roles_with_http_info(ldap_mount_path, list, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_list_dynamic_roles_with_http_info(ldap_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_list_dynamic_roles ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_list_dynamic_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.ldap_list_dynamic_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/role'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_list_dynamic_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_list_dynamic_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_list_static_roles(ldap_mount_path, list, opts = {})
      ldap_list_static_roles_with_http_info(ldap_mount_path, list, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_list_static_roles_with_http_info(ldap_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_list_static_roles ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_list_static_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.ldap_list_static_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/static-role'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_list_static_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_list_static_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_configuration(ldap_mount_path, opts = {})
      ldap_read_configuration_with_http_info(ldap_mount_path, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_configuration_with_http_info(ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_read_configuration ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_read_configuration"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/config'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_dynamic_role(name, ldap_mount_path, opts = {})
      ldap_read_dynamic_role_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_dynamic_role_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_read_dynamic_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_read_dynamic_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_read_dynamic_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_read_dynamic_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_read_dynamic_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_read_static_role(name, ldap_mount_path, opts = {})
      ldap_read_static_role_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_read_static_role_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_read_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_read_static_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_read_static_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/static-role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_read_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_read_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the dynamic role.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_request_dynamic_role_credentials(name, ldap_mount_path, opts = {})
      ldap_request_dynamic_role_credentials_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the dynamic role.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_request_dynamic_role_credentials_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_request_dynamic_role_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_request_dynamic_role_credentials"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_request_dynamic_role_credentials"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/creds/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_request_dynamic_role_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_request_dynamic_role_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the static role.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_request_static_role_credentials(name, ldap_mount_path, opts = {})
      ldap_request_static_role_credentials_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the static role.
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_request_static_role_credentials_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_request_static_role_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_request_static_role_credentials"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_request_static_role_credentials"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/static-cred/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_request_static_role_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_request_static_role_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_rotate_root_credentials(ldap_mount_path, opts = {})
      ldap_rotate_root_credentials_with_http_info(ldap_mount_path, opts)
      nil
    end

    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_rotate_root_credentials_with_http_info(ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_rotate_root_credentials ...'
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_rotate_root_credentials"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/rotate-root'.sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_rotate_root_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_rotate_root_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the static role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_rotate_static_role(name, ldap_mount_path, opts = {})
      ldap_rotate_static_role_with_http_info(name, ldap_mount_path, opts)
      nil
    end

    # @param name [String] Name of the static role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_rotate_static_role_with_http_info(name, ldap_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_rotate_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_rotate_static_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_rotate_static_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/rotate-role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_rotate_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_rotate_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_dynamic_role_request [LdapWriteDynamicRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_write_dynamic_role(name, ldap_mount_path, ldap_write_dynamic_role_request, opts = {})
      ldap_write_dynamic_role_with_http_info(name, ldap_mount_path, ldap_write_dynamic_role_request, opts)
      nil
    end

    # @param name [String] Name of the role (lowercase)
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_dynamic_role_request [LdapWriteDynamicRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_write_dynamic_role_with_http_info(name, ldap_mount_path, ldap_write_dynamic_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_write_dynamic_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_write_dynamic_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_write_dynamic_role"
      end
      # verify the required parameter 'ldap_write_dynamic_role_request' is set
      if @api_client.config.client_side_validation && ldap_write_dynamic_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_write_dynamic_role_request' when calling SecretsApi.ldap_write_dynamic_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_write_dynamic_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_write_dynamic_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_write_dynamic_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_static_role_request [LdapWriteStaticRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ldap_write_static_role(name, ldap_mount_path, ldap_write_static_role_request, opts = {})
      ldap_write_static_role_with_http_info(name, ldap_mount_path, ldap_write_static_role_request, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param ldap_mount_path [String] Path that the backend was mounted at
    # @param ldap_write_static_role_request [LdapWriteStaticRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ldap_write_static_role_with_http_info(name, ldap_mount_path, ldap_write_static_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ldap_write_static_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.ldap_write_static_role"
      end
      # verify the required parameter 'ldap_mount_path' is set
      if @api_client.config.client_side_validation && ldap_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_mount_path' when calling SecretsApi.ldap_write_static_role"
      end
      # verify the required parameter 'ldap_write_static_role_request' is set
      if @api_client.config.client_side_validation && ldap_write_static_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'ldap_write_static_role_request' when calling SecretsApi.ldap_write_static_role"
      end
      # resource path
      local_var_path = '/{ldap_mount_path}/static-role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'ldap_mount_path' + '}', CGI.escape(ldap_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ldap_write_static_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ldap_write_static_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ldap_write_static_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_acme_request [PkiConfigureAcmeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_configure_acme(pki_mount_path, pki_configure_acme_request, opts = {})
      pki_configure_acme_with_http_info(pki_mount_path, pki_configure_acme_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_acme_request [PkiConfigureAcmeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_configure_acme_with_http_info(pki_mount_path, pki_configure_acme_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_acme ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_acme"
      end
      # verify the required parameter 'pki_configure_acme_request' is set
      if @api_client.config.client_side_validation && pki_configure_acme_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_acme_request' when calling SecretsApi.pki_configure_acme"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/acme'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_acme_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_acme",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_acme\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_auto_tidy_request [PkiConfigureAutoTidyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureAutoTidyResponse]
    def pki_configure_auto_tidy(pki_mount_path, pki_configure_auto_tidy_request, opts = {})
      data, _status_code, _headers = pki_configure_auto_tidy_with_http_info(pki_mount_path, pki_configure_auto_tidy_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_auto_tidy_request [PkiConfigureAutoTidyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureAutoTidyResponse, Integer, Hash)>] PkiConfigureAutoTidyResponse data, response status code and response headers
    def pki_configure_auto_tidy_with_http_info(pki_mount_path, pki_configure_auto_tidy_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_auto_tidy ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_auto_tidy"
      end
      # verify the required parameter 'pki_configure_auto_tidy_request' is set
      if @api_client.config.client_side_validation && pki_configure_auto_tidy_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_auto_tidy_request' when calling SecretsApi.pki_configure_auto_tidy"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/auto-tidy'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_auto_tidy_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureAutoTidyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_auto_tidy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_auto_tidy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_ca_request [PkiConfigureCaRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureCaResponse]
    def pki_configure_ca(pki_mount_path, pki_configure_ca_request, opts = {})
      data, _status_code, _headers = pki_configure_ca_with_http_info(pki_mount_path, pki_configure_ca_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_ca_request [PkiConfigureCaRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureCaResponse, Integer, Hash)>] PkiConfigureCaResponse data, response status code and response headers
    def pki_configure_ca_with_http_info(pki_mount_path, pki_configure_ca_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_ca ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_ca"
      end
      # verify the required parameter 'pki_configure_ca_request' is set
      if @api_client.config.client_side_validation && pki_configure_ca_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_ca_request' when calling SecretsApi.pki_configure_ca"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/ca'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_ca_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureCaResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_ca",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_ca\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_cluster_request [PkiConfigureClusterRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureClusterResponse]
    def pki_configure_cluster(pki_mount_path, pki_configure_cluster_request, opts = {})
      data, _status_code, _headers = pki_configure_cluster_with_http_info(pki_mount_path, pki_configure_cluster_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_cluster_request [PkiConfigureClusterRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureClusterResponse, Integer, Hash)>] PkiConfigureClusterResponse data, response status code and response headers
    def pki_configure_cluster_with_http_info(pki_mount_path, pki_configure_cluster_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_cluster ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_cluster"
      end
      # verify the required parameter 'pki_configure_cluster_request' is set
      if @api_client.config.client_side_validation && pki_configure_cluster_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_cluster_request' when calling SecretsApi.pki_configure_cluster"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/cluster'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_cluster_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureClusterResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_cluster",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_cluster\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_crl_request [PkiConfigureCrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureCrlResponse]
    def pki_configure_crl(pki_mount_path, pki_configure_crl_request, opts = {})
      data, _status_code, _headers = pki_configure_crl_with_http_info(pki_mount_path, pki_configure_crl_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_crl_request [PkiConfigureCrlRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureCrlResponse, Integer, Hash)>] PkiConfigureCrlResponse data, response status code and response headers
    def pki_configure_crl_with_http_info(pki_mount_path, pki_configure_crl_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_crl ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_crl"
      end
      # verify the required parameter 'pki_configure_crl_request' is set
      if @api_client.config.client_side_validation && pki_configure_crl_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_crl_request' when calling SecretsApi.pki_configure_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/crl'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_crl_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_issuers_request [PkiConfigureIssuersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureIssuersResponse]
    def pki_configure_issuers(pki_mount_path, pki_configure_issuers_request, opts = {})
      data, _status_code, _headers = pki_configure_issuers_with_http_info(pki_mount_path, pki_configure_issuers_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_issuers_request [PkiConfigureIssuersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureIssuersResponse, Integer, Hash)>] PkiConfigureIssuersResponse data, response status code and response headers
    def pki_configure_issuers_with_http_info(pki_mount_path, pki_configure_issuers_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_issuers ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_issuers"
      end
      # verify the required parameter 'pki_configure_issuers_request' is set
      if @api_client.config.client_side_validation && pki_configure_issuers_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_issuers_request' when calling SecretsApi.pki_configure_issuers"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/issuers'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_issuers_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureIssuersResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_issuers",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_issuers\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_keys_request [PkiConfigureKeysRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureKeysResponse]
    def pki_configure_keys(pki_mount_path, pki_configure_keys_request, opts = {})
      data, _status_code, _headers = pki_configure_keys_with_http_info(pki_mount_path, pki_configure_keys_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_keys_request [PkiConfigureKeysRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureKeysResponse, Integer, Hash)>] PkiConfigureKeysResponse data, response status code and response headers
    def pki_configure_keys_with_http_info(pki_mount_path, pki_configure_keys_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_keys ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_keys"
      end
      # verify the required parameter 'pki_configure_keys_request' is set
      if @api_client.config.client_side_validation && pki_configure_keys_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_keys_request' when calling SecretsApi.pki_configure_keys"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/keys'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_keys_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureKeysResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_urls_request [PkiConfigureUrlsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiConfigureUrlsResponse]
    def pki_configure_urls(pki_mount_path, pki_configure_urls_request, opts = {})
      data, _status_code, _headers = pki_configure_urls_with_http_info(pki_mount_path, pki_configure_urls_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_configure_urls_request [PkiConfigureUrlsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiConfigureUrlsResponse, Integer, Hash)>] PkiConfigureUrlsResponse data, response status code and response headers
    def pki_configure_urls_with_http_info(pki_mount_path, pki_configure_urls_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_configure_urls ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_configure_urls"
      end
      # verify the required parameter 'pki_configure_urls_request' is set
      if @api_client.config.client_side_validation && pki_configure_urls_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_configure_urls_request' when calling SecretsApi.pki_configure_urls"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/urls'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_configure_urls_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiConfigureUrlsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_configure_urls",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_configure_urls\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_cross_sign_intermediate_request [PkiCrossSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiCrossSignIntermediateResponse]
    def pki_cross_sign_intermediate(pki_mount_path, pki_cross_sign_intermediate_request, opts = {})
      data, _status_code, _headers = pki_cross_sign_intermediate_with_http_info(pki_mount_path, pki_cross_sign_intermediate_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_cross_sign_intermediate_request [PkiCrossSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiCrossSignIntermediateResponse, Integer, Hash)>] PkiCrossSignIntermediateResponse data, response status code and response headers
    def pki_cross_sign_intermediate_with_http_info(pki_mount_path, pki_cross_sign_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_cross_sign_intermediate ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_cross_sign_intermediate"
      end
      # verify the required parameter 'pki_cross_sign_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_cross_sign_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_cross_sign_intermediate_request' when calling SecretsApi.pki_cross_sign_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/intermediate/cross-sign'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_cross_sign_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiCrossSignIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_cross_sign_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_cross_sign_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param key_id [String] EAB key identifier
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_delete_eab_key(key_id, pki_mount_path, opts = {})
      pki_delete_eab_key_with_http_info(key_id, pki_mount_path, opts)
      nil
    end

    # @param key_id [String] EAB key identifier
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_delete_eab_key_with_http_info(key_id, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_delete_eab_key ...'
      end
      # verify the required parameter 'key_id' is set
      if @api_client.config.client_side_validation && key_id.nil?
        fail ArgumentError, "Missing the required parameter 'key_id' when calling SecretsApi.pki_delete_eab_key"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_delete_eab_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/eab/{key_id}'.sub('{' + 'key_id' + '}', CGI.escape(key_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_delete_eab_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_delete_eab_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_delete_issuer(issuer_ref, pki_mount_path, opts = {})
      pki_delete_issuer_with_http_info(issuer_ref, pki_mount_path, opts)
      nil
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_delete_issuer_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_delete_issuer ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_delete_issuer"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_delete_issuer"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_delete_issuer",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_delete_issuer\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_delete_key(key_ref, pki_mount_path, opts = {})
      pki_delete_key_with_http_info(key_ref, pki_mount_path, opts)
      nil
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_delete_key_with_http_info(key_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_delete_key ...'
      end
      # verify the required parameter 'key_ref' is set
      if @api_client.config.client_side_validation && key_ref.nil?
        fail ArgumentError, "Missing the required parameter 'key_ref' when calling SecretsApi.pki_delete_key"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_delete_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/key/{key_ref}'.sub('{' + 'key_ref' + '}', CGI.escape(key_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_delete_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_delete_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_delete_role(name, pki_mount_path, opts = {})
      pki_delete_role_with_http_info(name, pki_mount_path, opts)
      nil
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_delete_role_with_http_info(name, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.pki_delete_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_delete_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_delete_root(pki_mount_path, opts = {})
      pki_delete_root_with_http_info(pki_mount_path, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_delete_root_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_delete_root ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_delete_root"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_delete_root",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_delete_root\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateEabKeyResponse]
    def pki_generate_eab_key(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_generate_eab_key_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateEabKeyResponse, Integer, Hash)>] PkiGenerateEabKeyResponse data, response status code and response headers
    def pki_generate_eab_key_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_eab_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_eab_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/new-eab'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateEabKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_eab_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_eab_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateEabKeyForIssuerResponse]
    def pki_generate_eab_key_for_issuer(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_generate_eab_key_for_issuer_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateEabKeyForIssuerResponse, Integer, Hash)>] PkiGenerateEabKeyForIssuerResponse data, response status code and response headers
    def pki_generate_eab_key_for_issuer_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_eab_key_for_issuer ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_generate_eab_key_for_issuer"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_eab_key_for_issuer"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/new-eab'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateEabKeyForIssuerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_eab_key_for_issuer",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_eab_key_for_issuer\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateEabKeyForIssuerAndRoleResponse]
    def pki_generate_eab_key_for_issuer_and_role(issuer_ref, role, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_generate_eab_key_for_issuer_and_role_with_http_info(issuer_ref, role, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateEabKeyForIssuerAndRoleResponse, Integer, Hash)>] PkiGenerateEabKeyForIssuerAndRoleResponse data, response status code and response headers
    def pki_generate_eab_key_for_issuer_and_role_with_http_info(issuer_ref, role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_eab_key_for_issuer_and_role ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_generate_eab_key_for_issuer_and_role"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_generate_eab_key_for_issuer_and_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_eab_key_for_issuer_and_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-eab'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateEabKeyForIssuerAndRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_eab_key_for_issuer_and_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_eab_key_for_issuer_and_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateEabKeyForRoleResponse]
    def pki_generate_eab_key_for_role(role, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_generate_eab_key_for_role_with_http_info(role, pki_mount_path, opts)
      data
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateEabKeyForRoleResponse, Integer, Hash)>] PkiGenerateEabKeyForRoleResponse data, response status code and response headers
    def pki_generate_eab_key_for_role_with_http_info(role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_eab_key_for_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_generate_eab_key_for_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_eab_key_for_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/new-eab'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateEabKeyForRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_eab_key_for_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_eab_key_for_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_exported_key_request [PkiGenerateExportedKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateExportedKeyResponse]
    def pki_generate_exported_key(pki_mount_path, pki_generate_exported_key_request, opts = {})
      data, _status_code, _headers = pki_generate_exported_key_with_http_info(pki_mount_path, pki_generate_exported_key_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_exported_key_request [PkiGenerateExportedKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateExportedKeyResponse, Integer, Hash)>] PkiGenerateExportedKeyResponse data, response status code and response headers
    def pki_generate_exported_key_with_http_info(pki_mount_path, pki_generate_exported_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_exported_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_exported_key"
      end
      # verify the required parameter 'pki_generate_exported_key_request' is set
      if @api_client.config.client_side_validation && pki_generate_exported_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_generate_exported_key_request' when calling SecretsApi.pki_generate_exported_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/keys/generate/exported'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_generate_exported_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateExportedKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_exported_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_exported_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_intermediate_request [PkiGenerateIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateIntermediateResponse]
    def pki_generate_intermediate(exported, pki_mount_path, pki_generate_intermediate_request, opts = {})
      data, _status_code, _headers = pki_generate_intermediate_with_http_info(exported, pki_mount_path, pki_generate_intermediate_request, opts)
      data
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_intermediate_request [PkiGenerateIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateIntermediateResponse, Integer, Hash)>] PkiGenerateIntermediateResponse data, response status code and response headers
    def pki_generate_intermediate_with_http_info(exported, pki_mount_path, pki_generate_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_intermediate ...'
      end
      # verify the required parameter 'exported' is set
      if @api_client.config.client_side_validation && exported.nil?
        fail ArgumentError, "Missing the required parameter 'exported' when calling SecretsApi.pki_generate_intermediate"
      end
      # verify enum value
      allowable_values = ["internal", "external", "kms"]
      if @api_client.config.client_side_validation && !allowable_values.include?(exported)
        fail ArgumentError, "invalid value for \"exported\", must be one of #{allowable_values}"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_intermediate"
      end
      # verify the required parameter 'pki_generate_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_generate_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_generate_intermediate_request' when calling SecretsApi.pki_generate_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/intermediate/generate/{exported}'.sub('{' + 'exported' + '}', CGI.escape(exported.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_generate_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_internal_key_request [PkiGenerateInternalKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateInternalKeyResponse]
    def pki_generate_internal_key(pki_mount_path, pki_generate_internal_key_request, opts = {})
      data, _status_code, _headers = pki_generate_internal_key_with_http_info(pki_mount_path, pki_generate_internal_key_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_internal_key_request [PkiGenerateInternalKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateInternalKeyResponse, Integer, Hash)>] PkiGenerateInternalKeyResponse data, response status code and response headers
    def pki_generate_internal_key_with_http_info(pki_mount_path, pki_generate_internal_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_internal_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_internal_key"
      end
      # verify the required parameter 'pki_generate_internal_key_request' is set
      if @api_client.config.client_side_validation && pki_generate_internal_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_generate_internal_key_request' when calling SecretsApi.pki_generate_internal_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/keys/generate/internal'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_generate_internal_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateInternalKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_internal_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_internal_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_kms_key_request [PkiGenerateKmsKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateKmsKeyResponse]
    def pki_generate_kms_key(pki_mount_path, pki_generate_kms_key_request, opts = {})
      data, _status_code, _headers = pki_generate_kms_key_with_http_info(pki_mount_path, pki_generate_kms_key_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_kms_key_request [PkiGenerateKmsKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateKmsKeyResponse, Integer, Hash)>] PkiGenerateKmsKeyResponse data, response status code and response headers
    def pki_generate_kms_key_with_http_info(pki_mount_path, pki_generate_kms_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_kms_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_kms_key"
      end
      # verify the required parameter 'pki_generate_kms_key_request' is set
      if @api_client.config.client_side_validation && pki_generate_kms_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_generate_kms_key_request' when calling SecretsApi.pki_generate_kms_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/keys/generate/kms'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_generate_kms_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateKmsKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_kms_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_kms_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_root_request [PkiGenerateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiGenerateRootResponse]
    def pki_generate_root(exported, pki_mount_path, pki_generate_root_request, opts = {})
      data, _status_code, _headers = pki_generate_root_with_http_info(exported, pki_mount_path, pki_generate_root_request, opts)
      data
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_generate_root_request [PkiGenerateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiGenerateRootResponse, Integer, Hash)>] PkiGenerateRootResponse data, response status code and response headers
    def pki_generate_root_with_http_info(exported, pki_mount_path, pki_generate_root_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_generate_root ...'
      end
      # verify the required parameter 'exported' is set
      if @api_client.config.client_side_validation && exported.nil?
        fail ArgumentError, "Missing the required parameter 'exported' when calling SecretsApi.pki_generate_root"
      end
      # verify enum value
      allowable_values = ["internal", "external", "kms"]
      if @api_client.config.client_side_validation && !allowable_values.include?(exported)
        fail ArgumentError, "invalid value for \"exported\", must be one of #{allowable_values}"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_generate_root"
      end
      # verify the required parameter 'pki_generate_root_request' is set
      if @api_client.config.client_side_validation && pki_generate_root_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_generate_root_request' when calling SecretsApi.pki_generate_root"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root/generate/{exported}'.sub('{' + 'exported' + '}', CGI.escape(exported.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_generate_root_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiGenerateRootResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_generate_root",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_generate_root\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_import_key_request [PkiImportKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiImportKeyResponse]
    def pki_import_key(pki_mount_path, pki_import_key_request, opts = {})
      data, _status_code, _headers = pki_import_key_with_http_info(pki_mount_path, pki_import_key_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_import_key_request [PkiImportKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiImportKeyResponse, Integer, Hash)>] PkiImportKeyResponse data, response status code and response headers
    def pki_import_key_with_http_info(pki_mount_path, pki_import_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_import_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_import_key"
      end
      # verify the required parameter 'pki_import_key_request' is set
      if @api_client.config.client_side_validation && pki_import_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_import_key_request' when calling SecretsApi.pki_import_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/keys/import'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_import_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiImportKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_import_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_import_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issue_with_role_request [PkiIssueWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssueWithRoleResponse]
    def pki_issue_with_role(role, pki_mount_path, pki_issue_with_role_request, opts = {})
      data, _status_code, _headers = pki_issue_with_role_with_http_info(role, pki_mount_path, pki_issue_with_role_request, opts)
      data
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issue_with_role_request [PkiIssueWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssueWithRoleResponse, Integer, Hash)>] PkiIssueWithRoleResponse data, response status code and response headers
    def pki_issue_with_role_with_http_info(role, pki_mount_path, pki_issue_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issue_with_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_issue_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issue_with_role"
      end
      # verify the required parameter 'pki_issue_with_role_request' is set
      if @api_client.config.client_side_validation && pki_issue_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issue_with_role_request' when calling SecretsApi.pki_issue_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issue/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issue_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssueWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issue_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issue_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_issue_with_role_request [PkiIssuerIssueWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerIssueWithRoleResponse]
    def pki_issuer_issue_with_role(issuer_ref, role, pki_mount_path, pki_issuer_issue_with_role_request, opts = {})
      data, _status_code, _headers = pki_issuer_issue_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_issue_with_role_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_issue_with_role_request [PkiIssuerIssueWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerIssueWithRoleResponse, Integer, Hash)>] PkiIssuerIssueWithRoleResponse data, response status code and response headers
    def pki_issuer_issue_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_issue_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_issue_with_role ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_issue_with_role"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_issuer_issue_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_issue_with_role"
      end
      # verify the required parameter 'pki_issuer_issue_with_role_request' is set
      if @api_client.config.client_side_validation && pki_issuer_issue_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_issue_with_role_request' when calling SecretsApi.pki_issuer_issue_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/issue/{role}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_issue_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerIssueWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_issue_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_issue_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlResponse]
    def pki_issuer_read_crl(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlResponse, Integer, Hash)>] PkiIssuerReadCrlResponse data, response status code and response headers
    def pki_issuer_read_crl_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlDeltaResponse]
    def pki_issuer_read_crl_delta(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_delta_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlDeltaResponse, Integer, Hash)>] PkiIssuerReadCrlDeltaResponse data, response status code and response headers
    def pki_issuer_read_crl_delta_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl_delta ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl_delta"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl_delta"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl/delta'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlDeltaResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl_delta",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl_delta\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlDeltaDerResponse]
    def pki_issuer_read_crl_delta_der(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_delta_der_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlDeltaDerResponse, Integer, Hash)>] PkiIssuerReadCrlDeltaDerResponse data, response status code and response headers
    def pki_issuer_read_crl_delta_der_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl_delta_der ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl_delta_der"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl_delta_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl/delta/der'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlDeltaDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl_delta_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl_delta_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlDeltaPemResponse]
    def pki_issuer_read_crl_delta_pem(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_delta_pem_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlDeltaPemResponse, Integer, Hash)>] PkiIssuerReadCrlDeltaPemResponse data, response status code and response headers
    def pki_issuer_read_crl_delta_pem_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl_delta_pem ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl_delta_pem"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl_delta_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl/delta/pem'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlDeltaPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl_delta_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl_delta_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlDerResponse]
    def pki_issuer_read_crl_der(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_der_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlDerResponse, Integer, Hash)>] PkiIssuerReadCrlDerResponse data, response status code and response headers
    def pki_issuer_read_crl_der_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl_der ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl_der"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl/der'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerReadCrlPemResponse]
    def pki_issuer_read_crl_pem(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_issuer_read_crl_pem_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerReadCrlPemResponse, Integer, Hash)>] PkiIssuerReadCrlPemResponse data, response status code and response headers
    def pki_issuer_read_crl_pem_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_read_crl_pem ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_read_crl_pem"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_read_crl_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/crl/pem'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerReadCrlPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_read_crl_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_read_crl_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_resign_crls_request [PkiIssuerResignCrlsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerResignCrlsResponse]
    def pki_issuer_resign_crls(issuer_ref, pki_mount_path, pki_issuer_resign_crls_request, opts = {})
      data, _status_code, _headers = pki_issuer_resign_crls_with_http_info(issuer_ref, pki_mount_path, pki_issuer_resign_crls_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_resign_crls_request [PkiIssuerResignCrlsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerResignCrlsResponse, Integer, Hash)>] PkiIssuerResignCrlsResponse data, response status code and response headers
    def pki_issuer_resign_crls_with_http_info(issuer_ref, pki_mount_path, pki_issuer_resign_crls_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_resign_crls ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_resign_crls"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_resign_crls"
      end
      # verify the required parameter 'pki_issuer_resign_crls_request' is set
      if @api_client.config.client_side_validation && pki_issuer_resign_crls_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_resign_crls_request' when calling SecretsApi.pki_issuer_resign_crls"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/resign-crls'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_resign_crls_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerResignCrlsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_resign_crls",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_resign_crls\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_intermediate_request [PkiIssuerSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignIntermediateResponse]
    def pki_issuer_sign_intermediate(issuer_ref, pki_mount_path, pki_issuer_sign_intermediate_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_intermediate_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_intermediate_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_intermediate_request [PkiIssuerSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignIntermediateResponse, Integer, Hash)>] PkiIssuerSignIntermediateResponse data, response status code and response headers
    def pki_issuer_sign_intermediate_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_intermediate ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_intermediate"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_intermediate"
      end
      # verify the required parameter 'pki_issuer_sign_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_intermediate_request' when calling SecretsApi.pki_issuer_sign_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign-intermediate'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_revocation_list_request [PkiIssuerSignRevocationListRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignRevocationListResponse]
    def pki_issuer_sign_revocation_list(issuer_ref, pki_mount_path, pki_issuer_sign_revocation_list_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_revocation_list_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_revocation_list_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_revocation_list_request [PkiIssuerSignRevocationListRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignRevocationListResponse, Integer, Hash)>] PkiIssuerSignRevocationListResponse data, response status code and response headers
    def pki_issuer_sign_revocation_list_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_revocation_list_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_revocation_list ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_revocation_list"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_revocation_list"
      end
      # verify the required parameter 'pki_issuer_sign_revocation_list_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_revocation_list_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_revocation_list_request' when calling SecretsApi.pki_issuer_sign_revocation_list"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign-revocation-list'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_revocation_list_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignRevocationListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_revocation_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_revocation_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_self_issued_request [PkiIssuerSignSelfIssuedRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignSelfIssuedResponse]
    def pki_issuer_sign_self_issued(issuer_ref, pki_mount_path, pki_issuer_sign_self_issued_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_self_issued_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_self_issued_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_self_issued_request [PkiIssuerSignSelfIssuedRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignSelfIssuedResponse, Integer, Hash)>] PkiIssuerSignSelfIssuedResponse data, response status code and response headers
    def pki_issuer_sign_self_issued_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_self_issued_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_self_issued ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_self_issued"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_self_issued"
      end
      # verify the required parameter 'pki_issuer_sign_self_issued_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_self_issued_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_self_issued_request' when calling SecretsApi.pki_issuer_sign_self_issued"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign-self-issued'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_self_issued_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignSelfIssuedResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_self_issued",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_self_issued\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_verbatim_request [PkiIssuerSignVerbatimRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignVerbatimResponse]
    def pki_issuer_sign_verbatim(issuer_ref, pki_mount_path, pki_issuer_sign_verbatim_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_verbatim_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_verbatim_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_verbatim_request [PkiIssuerSignVerbatimRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignVerbatimResponse, Integer, Hash)>] PkiIssuerSignVerbatimResponse data, response status code and response headers
    def pki_issuer_sign_verbatim_with_http_info(issuer_ref, pki_mount_path, pki_issuer_sign_verbatim_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_verbatim ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_verbatim"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_verbatim"
      end
      # verify the required parameter 'pki_issuer_sign_verbatim_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_verbatim_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_verbatim_request' when calling SecretsApi.pki_issuer_sign_verbatim"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign-verbatim'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_verbatim_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignVerbatimResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_verbatim",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_verbatim\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_verbatim_with_role_request [PkiIssuerSignVerbatimWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignVerbatimWithRoleResponse]
    def pki_issuer_sign_verbatim_with_role(issuer_ref, role, pki_mount_path, pki_issuer_sign_verbatim_with_role_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_verbatim_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_sign_verbatim_with_role_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_verbatim_with_role_request [PkiIssuerSignVerbatimWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignVerbatimWithRoleResponse, Integer, Hash)>] PkiIssuerSignVerbatimWithRoleResponse data, response status code and response headers
    def pki_issuer_sign_verbatim_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_sign_verbatim_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_verbatim_with_role ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_verbatim_with_role"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_issuer_sign_verbatim_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_verbatim_with_role"
      end
      # verify the required parameter 'pki_issuer_sign_verbatim_with_role_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_verbatim_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_verbatim_with_role_request' when calling SecretsApi.pki_issuer_sign_verbatim_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign-verbatim/{role}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_verbatim_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignVerbatimWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_verbatim_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_verbatim_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_with_role_request [PkiIssuerSignWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuerSignWithRoleResponse]
    def pki_issuer_sign_with_role(issuer_ref, role, pki_mount_path, pki_issuer_sign_with_role_request, opts = {})
      data, _status_code, _headers = pki_issuer_sign_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_sign_with_role_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuer_sign_with_role_request [PkiIssuerSignWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuerSignWithRoleResponse, Integer, Hash)>] PkiIssuerSignWithRoleResponse data, response status code and response headers
    def pki_issuer_sign_with_role_with_http_info(issuer_ref, role, pki_mount_path, pki_issuer_sign_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuer_sign_with_role ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_issuer_sign_with_role"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_issuer_sign_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuer_sign_with_role"
      end
      # verify the required parameter 'pki_issuer_sign_with_role_request' is set
      if @api_client.config.client_side_validation && pki_issuer_sign_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuer_sign_with_role_request' when calling SecretsApi.pki_issuer_sign_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/sign/{role}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuer_sign_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuerSignWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuer_sign_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuer_sign_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_generate_intermediate_request [PkiIssuersGenerateIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuersGenerateIntermediateResponse]
    def pki_issuers_generate_intermediate(exported, pki_mount_path, pki_issuers_generate_intermediate_request, opts = {})
      data, _status_code, _headers = pki_issuers_generate_intermediate_with_http_info(exported, pki_mount_path, pki_issuers_generate_intermediate_request, opts)
      data
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_generate_intermediate_request [PkiIssuersGenerateIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuersGenerateIntermediateResponse, Integer, Hash)>] PkiIssuersGenerateIntermediateResponse data, response status code and response headers
    def pki_issuers_generate_intermediate_with_http_info(exported, pki_mount_path, pki_issuers_generate_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuers_generate_intermediate ...'
      end
      # verify the required parameter 'exported' is set
      if @api_client.config.client_side_validation && exported.nil?
        fail ArgumentError, "Missing the required parameter 'exported' when calling SecretsApi.pki_issuers_generate_intermediate"
      end
      # verify enum value
      allowable_values = ["internal", "external", "kms"]
      if @api_client.config.client_side_validation && !allowable_values.include?(exported)
        fail ArgumentError, "invalid value for \"exported\", must be one of #{allowable_values}"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuers_generate_intermediate"
      end
      # verify the required parameter 'pki_issuers_generate_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_issuers_generate_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuers_generate_intermediate_request' when calling SecretsApi.pki_issuers_generate_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuers/generate/intermediate/{exported}'.sub('{' + 'exported' + '}', CGI.escape(exported.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuers_generate_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuersGenerateIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuers_generate_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuers_generate_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_generate_root_request [PkiIssuersGenerateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuersGenerateRootResponse]
    def pki_issuers_generate_root(exported, pki_mount_path, pki_issuers_generate_root_request, opts = {})
      data, _status_code, _headers = pki_issuers_generate_root_with_http_info(exported, pki_mount_path, pki_issuers_generate_root_request, opts)
      data
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_generate_root_request [PkiIssuersGenerateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuersGenerateRootResponse, Integer, Hash)>] PkiIssuersGenerateRootResponse data, response status code and response headers
    def pki_issuers_generate_root_with_http_info(exported, pki_mount_path, pki_issuers_generate_root_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuers_generate_root ...'
      end
      # verify the required parameter 'exported' is set
      if @api_client.config.client_side_validation && exported.nil?
        fail ArgumentError, "Missing the required parameter 'exported' when calling SecretsApi.pki_issuers_generate_root"
      end
      # verify enum value
      allowable_values = ["internal", "external", "kms"]
      if @api_client.config.client_side_validation && !allowable_values.include?(exported)
        fail ArgumentError, "invalid value for \"exported\", must be one of #{allowable_values}"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuers_generate_root"
      end
      # verify the required parameter 'pki_issuers_generate_root_request' is set
      if @api_client.config.client_side_validation && pki_issuers_generate_root_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuers_generate_root_request' when calling SecretsApi.pki_issuers_generate_root"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuers/generate/root/{exported}'.sub('{' + 'exported' + '}', CGI.escape(exported.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuers_generate_root_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuersGenerateRootResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuers_generate_root",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuers_generate_root\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_import_bundle_request [PkiIssuersImportBundleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuersImportBundleResponse]
    def pki_issuers_import_bundle(pki_mount_path, pki_issuers_import_bundle_request, opts = {})
      data, _status_code, _headers = pki_issuers_import_bundle_with_http_info(pki_mount_path, pki_issuers_import_bundle_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_import_bundle_request [PkiIssuersImportBundleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuersImportBundleResponse, Integer, Hash)>] PkiIssuersImportBundleResponse data, response status code and response headers
    def pki_issuers_import_bundle_with_http_info(pki_mount_path, pki_issuers_import_bundle_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuers_import_bundle ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuers_import_bundle"
      end
      # verify the required parameter 'pki_issuers_import_bundle_request' is set
      if @api_client.config.client_side_validation && pki_issuers_import_bundle_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuers_import_bundle_request' when calling SecretsApi.pki_issuers_import_bundle"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuers/import/bundle'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuers_import_bundle_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuersImportBundleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuers_import_bundle",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuers_import_bundle\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_import_cert_request [PkiIssuersImportCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiIssuersImportCertResponse]
    def pki_issuers_import_cert(pki_mount_path, pki_issuers_import_cert_request, opts = {})
      data, _status_code, _headers = pki_issuers_import_cert_with_http_info(pki_mount_path, pki_issuers_import_cert_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_issuers_import_cert_request [PkiIssuersImportCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiIssuersImportCertResponse, Integer, Hash)>] PkiIssuersImportCertResponse data, response status code and response headers
    def pki_issuers_import_cert_with_http_info(pki_mount_path, pki_issuers_import_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_issuers_import_cert ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_issuers_import_cert"
      end
      # verify the required parameter 'pki_issuers_import_cert_request' is set
      if @api_client.config.client_side_validation && pki_issuers_import_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_issuers_import_cert_request' when calling SecretsApi.pki_issuers_import_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuers/import/cert'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_issuers_import_cert_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiIssuersImportCertResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_issuers_import_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_issuers_import_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListCertsResponse]
    def pki_list_certs(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_certs_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListCertsResponse, Integer, Hash)>] PkiListCertsResponse data, response status code and response headers
    def pki_list_certs_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_certs ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_certs"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_certs"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/certs'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListCertsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_certs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_certs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListEabKeysResponse]
    def pki_list_eab_keys(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_eab_keys_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListEabKeysResponse, Integer, Hash)>] PkiListEabKeysResponse data, response status code and response headers
    def pki_list_eab_keys_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_eab_keys ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_eab_keys"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_eab_keys"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/eab'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListEabKeysResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_eab_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_eab_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListIssuersResponse]
    def pki_list_issuers(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_issuers_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListIssuersResponse, Integer, Hash)>] PkiListIssuersResponse data, response status code and response headers
    def pki_list_issuers_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_issuers ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_issuers"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_issuers"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuers'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListIssuersResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_issuers",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_issuers\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListKeysResponse]
    def pki_list_keys(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_keys_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListKeysResponse, Integer, Hash)>] PkiListKeysResponse data, response status code and response headers
    def pki_list_keys_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_keys ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_keys"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_keys"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/keys'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListKeysResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListRevokedCertsResponse]
    def pki_list_revoked_certs(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_revoked_certs_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListRevokedCertsResponse, Integer, Hash)>] PkiListRevokedCertsResponse data, response status code and response headers
    def pki_list_revoked_certs_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_revoked_certs ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_revoked_certs"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_revoked_certs"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/certs/revoked'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListRevokedCertsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_revoked_certs",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_revoked_certs\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PkiListRolesResponse]
    def pki_list_roles(pki_mount_path, list, opts = {})
      data, _status_code, _headers = pki_list_roles_with_http_info(pki_mount_path, list, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiListRolesResponse, Integer, Hash)>] PkiListRolesResponse data, response status code and response headers
    def pki_list_roles_with_http_info(pki_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_list_roles ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.pki_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiListRolesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_query_ocsp(pki_mount_path, opts = {})
      pki_query_ocsp_with_http_info(pki_mount_path, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_query_ocsp_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_query_ocsp ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_query_ocsp"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/ocsp'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_query_ocsp",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_query_ocsp\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param req [String] base-64 encoded ocsp request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_query_ocsp_with_get_req(req, pki_mount_path, opts = {})
      pki_query_ocsp_with_get_req_with_http_info(req, pki_mount_path, opts)
      nil
    end

    # @param req [String] base-64 encoded ocsp request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_query_ocsp_with_get_req_with_http_info(req, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_query_ocsp_with_get_req ...'
      end
      # verify the required parameter 'req' is set
      if @api_client.config.client_side_validation && req.nil?
        fail ArgumentError, "Missing the required parameter 'req' when calling SecretsApi.pki_query_ocsp_with_get_req"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_query_ocsp_with_get_req"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/ocsp/{req}'.sub('{' + 'req' + '}', CGI.escape(req.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_query_ocsp_with_get_req",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_query_ocsp_with_get_req\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_acme_configuration(pki_mount_path, opts = {})
      pki_read_acme_configuration_with_http_info(pki_mount_path, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_acme_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_acme_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_acme_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/acme'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_acme_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_acme_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_acme_directory(pki_mount_path, opts = {})
      pki_read_acme_directory_with_http_info(pki_mount_path, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_acme_directory_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_acme_directory ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_acme_directory"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/directory'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_acme_directory",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_acme_directory\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_acme_new_nonce(pki_mount_path, opts = {})
      pki_read_acme_new_nonce_with_http_info(pki_mount_path, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_acme_new_nonce_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_acme_new_nonce ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_acme_new_nonce"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/new-nonce'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_acme_new_nonce",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_acme_new_nonce\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadAutoTidyConfigurationResponse]
    def pki_read_auto_tidy_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_auto_tidy_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadAutoTidyConfigurationResponse, Integer, Hash)>] PkiReadAutoTidyConfigurationResponse data, response status code and response headers
    def pki_read_auto_tidy_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_auto_tidy_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_auto_tidy_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/auto-tidy'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadAutoTidyConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_auto_tidy_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_auto_tidy_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCaChainPemResponse]
    def pki_read_ca_chain_pem(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_ca_chain_pem_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCaChainPemResponse, Integer, Hash)>] PkiReadCaChainPemResponse data, response status code and response headers
    def pki_read_ca_chain_pem_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_ca_chain_pem ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_ca_chain_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/ca_chain'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCaChainPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_ca_chain_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_ca_chain_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCaDerResponse]
    def pki_read_ca_der(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_ca_der_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCaDerResponse, Integer, Hash)>] PkiReadCaDerResponse data, response status code and response headers
    def pki_read_ca_der_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_ca_der ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_ca_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/ca'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCaDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_ca_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_ca_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCaPemResponse]
    def pki_read_ca_pem(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_ca_pem_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCaPemResponse, Integer, Hash)>] PkiReadCaPemResponse data, response status code and response headers
    def pki_read_ca_pem_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_ca_pem ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_ca_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/ca/pem'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCaPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_ca_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_ca_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertResponse]
    def pki_read_cert(serial, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_with_http_info(serial, pki_mount_path, opts)
      data
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertResponse, Integer, Hash)>] PkiReadCertResponse data, response status code and response headers
    def pki_read_cert_with_http_info(serial, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert ...'
      end
      # verify the required parameter 'serial' is set
      if @api_client.config.client_side_validation && serial.nil?
        fail ArgumentError, "Missing the required parameter 'serial' when calling SecretsApi.pki_read_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/{serial}'.sub('{' + 'serial' + '}', CGI.escape(serial.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertCaChainResponse]
    def pki_read_cert_ca_chain(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_ca_chain_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertCaChainResponse, Integer, Hash)>] PkiReadCertCaChainResponse data, response status code and response headers
    def pki_read_cert_ca_chain_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert_ca_chain ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert_ca_chain"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/ca_chain'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertCaChainResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert_ca_chain",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert_ca_chain\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertCrlResponse]
    def pki_read_cert_crl(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_crl_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertCrlResponse, Integer, Hash)>] PkiReadCertCrlResponse data, response status code and response headers
    def pki_read_cert_crl_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert_crl ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/crl'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertDeltaCrlResponse]
    def pki_read_cert_delta_crl(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_delta_crl_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertDeltaCrlResponse, Integer, Hash)>] PkiReadCertDeltaCrlResponse data, response status code and response headers
    def pki_read_cert_delta_crl_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert_delta_crl ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert_delta_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/delta-crl'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertDeltaCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert_delta_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert_delta_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertRawDerResponse]
    def pki_read_cert_raw_der(serial, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_raw_der_with_http_info(serial, pki_mount_path, opts)
      data
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertRawDerResponse, Integer, Hash)>] PkiReadCertRawDerResponse data, response status code and response headers
    def pki_read_cert_raw_der_with_http_info(serial, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert_raw_der ...'
      end
      # verify the required parameter 'serial' is set
      if @api_client.config.client_side_validation && serial.nil?
        fail ArgumentError, "Missing the required parameter 'serial' when calling SecretsApi.pki_read_cert_raw_der"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert_raw_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/{serial}/raw'.sub('{' + 'serial' + '}', CGI.escape(serial.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertRawDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert_raw_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert_raw_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCertRawPemResponse]
    def pki_read_cert_raw_pem(serial, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cert_raw_pem_with_http_info(serial, pki_mount_path, opts)
      data
    end

    # @param serial [String] Certificate serial number, in colon- or hyphen-separated octal
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCertRawPemResponse, Integer, Hash)>] PkiReadCertRawPemResponse data, response status code and response headers
    def pki_read_cert_raw_pem_with_http_info(serial, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cert_raw_pem ...'
      end
      # verify the required parameter 'serial' is set
      if @api_client.config.client_side_validation && serial.nil?
        fail ArgumentError, "Missing the required parameter 'serial' when calling SecretsApi.pki_read_cert_raw_pem"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cert_raw_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/cert/{serial}/raw/pem'.sub('{' + 'serial' + '}', CGI.escape(serial.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCertRawPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cert_raw_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cert_raw_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadClusterConfigurationResponse]
    def pki_read_cluster_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_cluster_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadClusterConfigurationResponse, Integer, Hash)>] PkiReadClusterConfigurationResponse data, response status code and response headers
    def pki_read_cluster_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_cluster_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_cluster_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/cluster'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadClusterConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_cluster_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_cluster_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCrlConfigurationResponse]
    def pki_read_crl_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_crl_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCrlConfigurationResponse, Integer, Hash)>] PkiReadCrlConfigurationResponse data, response status code and response headers
    def pki_read_crl_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_crl_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_crl_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/crl'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCrlConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_crl_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_crl_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCrlDeltaResponse]
    def pki_read_crl_delta(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_crl_delta_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCrlDeltaResponse, Integer, Hash)>] PkiReadCrlDeltaResponse data, response status code and response headers
    def pki_read_crl_delta_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_crl_delta ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_crl_delta"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl/delta'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCrlDeltaResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_crl_delta",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_crl_delta\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCrlDeltaPemResponse]
    def pki_read_crl_delta_pem(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_crl_delta_pem_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCrlDeltaPemResponse, Integer, Hash)>] PkiReadCrlDeltaPemResponse data, response status code and response headers
    def pki_read_crl_delta_pem_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_crl_delta_pem ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_crl_delta_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl/delta/pem'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCrlDeltaPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_crl_delta_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_crl_delta_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCrlDerResponse]
    def pki_read_crl_der(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_crl_der_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCrlDerResponse, Integer, Hash)>] PkiReadCrlDerResponse data, response status code and response headers
    def pki_read_crl_der_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_crl_der ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_crl_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCrlDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_crl_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_crl_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadCrlPemResponse]
    def pki_read_crl_pem(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_crl_pem_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadCrlPemResponse, Integer, Hash)>] PkiReadCrlPemResponse data, response status code and response headers
    def pki_read_crl_pem_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_crl_pem ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_crl_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl/pem'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadCrlPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_crl_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_crl_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadIssuerResponse]
    def pki_read_issuer(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_issuer_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadIssuerResponse, Integer, Hash)>] PkiReadIssuerResponse data, response status code and response headers
    def pki_read_issuer_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadIssuerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadIssuerDerResponse]
    def pki_read_issuer_der(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_issuer_der_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadIssuerDerResponse, Integer, Hash)>] PkiReadIssuerDerResponse data, response status code and response headers
    def pki_read_issuer_der_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_der ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_der"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_der"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/der'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadIssuerDerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_der",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_der\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_issuer_issuer_ref_acme_directory(issuer_ref, pki_mount_path, opts = {})
      pki_read_issuer_issuer_ref_acme_directory_with_http_info(issuer_ref, pki_mount_path, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_issuer_issuer_ref_acme_directory_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_issuer_ref_acme_directory ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_issuer_ref_acme_directory"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_issuer_ref_acme_directory"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/directory'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_issuer_ref_acme_directory",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_issuer_ref_acme_directory\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_issuer_issuer_ref_acme_new_nonce(issuer_ref, pki_mount_path, opts = {})
      pki_read_issuer_issuer_ref_acme_new_nonce_with_http_info(issuer_ref, pki_mount_path, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_issuer_issuer_ref_acme_new_nonce_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_issuer_ref_acme_new_nonce ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_issuer_ref_acme_new_nonce"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_issuer_ref_acme_new_nonce"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/new-nonce'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_issuer_ref_acme_new_nonce",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_issuer_ref_acme_new_nonce\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_issuer_issuer_ref_roles_role_acme_directory(issuer_ref, role, pki_mount_path, opts = {})
      pki_read_issuer_issuer_ref_roles_role_acme_directory_with_http_info(issuer_ref, role, pki_mount_path, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_issuer_issuer_ref_roles_role_acme_directory_with_http_info(issuer_ref, role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_directory ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_directory"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_directory"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_directory"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/directory'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_directory",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_issuer_ref_roles_role_acme_directory\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_issuer_issuer_ref_roles_role_acme_new_nonce(issuer_ref, role, pki_mount_path, opts = {})
      pki_read_issuer_issuer_ref_roles_role_acme_new_nonce_with_http_info(issuer_ref, role, pki_mount_path, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_issuer_issuer_ref_roles_role_acme_new_nonce_with_http_info(issuer_ref, role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_new_nonce ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_new_nonce"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_new_nonce"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_new_nonce"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-nonce'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_issuer_ref_roles_role_acme_new_nonce",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_issuer_ref_roles_role_acme_new_nonce\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadIssuerJsonResponse]
    def pki_read_issuer_json(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_issuer_json_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadIssuerJsonResponse, Integer, Hash)>] PkiReadIssuerJsonResponse data, response status code and response headers
    def pki_read_issuer_json_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_json ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_json"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_json"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/json'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadIssuerJsonResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_json",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_json\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadIssuerPemResponse]
    def pki_read_issuer_pem(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_issuer_pem_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadIssuerPemResponse, Integer, Hash)>] PkiReadIssuerPemResponse data, response status code and response headers
    def pki_read_issuer_pem_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuer_pem ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_read_issuer_pem"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuer_pem"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/pem'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadIssuerPemResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuer_pem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuer_pem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadIssuersConfigurationResponse]
    def pki_read_issuers_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_issuers_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadIssuersConfigurationResponse, Integer, Hash)>] PkiReadIssuersConfigurationResponse data, response status code and response headers
    def pki_read_issuers_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_issuers_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_issuers_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/issuers'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadIssuersConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_issuers_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_issuers_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadKeyResponse]
    def pki_read_key(key_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_key_with_http_info(key_ref, pki_mount_path, opts)
      data
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadKeyResponse, Integer, Hash)>] PkiReadKeyResponse data, response status code and response headers
    def pki_read_key_with_http_info(key_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_key ...'
      end
      # verify the required parameter 'key_ref' is set
      if @api_client.config.client_side_validation && key_ref.nil?
        fail ArgumentError, "Missing the required parameter 'key_ref' when calling SecretsApi.pki_read_key"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/key/{key_ref}'.sub('{' + 'key_ref' + '}', CGI.escape(key_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadKeysConfigurationResponse]
    def pki_read_keys_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_keys_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadKeysConfigurationResponse, Integer, Hash)>] PkiReadKeysConfigurationResponse data, response status code and response headers
    def pki_read_keys_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_keys_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_keys_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/keys'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadKeysConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_keys_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_keys_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadRoleResponse]
    def pki_read_role(name, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_role_with_http_info(name, pki_mount_path, opts)
      data
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadRoleResponse, Integer, Hash)>] PkiReadRoleResponse data, response status code and response headers
    def pki_read_role_with_http_info(name, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.pki_read_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_roles_role_acme_directory(role, pki_mount_path, opts = {})
      pki_read_roles_role_acme_directory_with_http_info(role, pki_mount_path, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_roles_role_acme_directory_with_http_info(role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_roles_role_acme_directory ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_read_roles_role_acme_directory"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_roles_role_acme_directory"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/directory'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_roles_role_acme_directory",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_roles_role_acme_directory\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_read_roles_role_acme_new_nonce(role, pki_mount_path, opts = {})
      pki_read_roles_role_acme_new_nonce_with_http_info(role, pki_mount_path, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_read_roles_role_acme_new_nonce_with_http_info(role, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_roles_role_acme_new_nonce ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_read_roles_role_acme_new_nonce"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_roles_role_acme_new_nonce"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/new-nonce'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_roles_role_acme_new_nonce",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_roles_role_acme_new_nonce\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiReadUrlsConfigurationResponse]
    def pki_read_urls_configuration(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_read_urls_configuration_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReadUrlsConfigurationResponse, Integer, Hash)>] PkiReadUrlsConfigurationResponse data, response status code and response headers
    def pki_read_urls_configuration_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_read_urls_configuration ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_read_urls_configuration"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/config/urls'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReadUrlsConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_read_urls_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_read_urls_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_replace_root_request [PkiReplaceRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiReplaceRootResponse]
    def pki_replace_root(pki_mount_path, pki_replace_root_request, opts = {})
      data, _status_code, _headers = pki_replace_root_with_http_info(pki_mount_path, pki_replace_root_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_replace_root_request [PkiReplaceRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiReplaceRootResponse, Integer, Hash)>] PkiReplaceRootResponse data, response status code and response headers
    def pki_replace_root_with_http_info(pki_mount_path, pki_replace_root_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_replace_root ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_replace_root"
      end
      # verify the required parameter 'pki_replace_root_request' is set
      if @api_client.config.client_side_validation && pki_replace_root_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_replace_root_request' when calling SecretsApi.pki_replace_root"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root/replace'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_replace_root_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiReplaceRootResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_replace_root",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_replace_root\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_revoke_request [PkiRevokeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiRevokeResponse]
    def pki_revoke(pki_mount_path, pki_revoke_request, opts = {})
      data, _status_code, _headers = pki_revoke_with_http_info(pki_mount_path, pki_revoke_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_revoke_request [PkiRevokeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRevokeResponse, Integer, Hash)>] PkiRevokeResponse data, response status code and response headers
    def pki_revoke_with_http_info(pki_mount_path, pki_revoke_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_revoke ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_revoke"
      end
      # verify the required parameter 'pki_revoke_request' is set
      if @api_client.config.client_side_validation && pki_revoke_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_revoke_request' when calling SecretsApi.pki_revoke"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/revoke'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_revoke_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRevokeResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_revoke",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_revoke\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiRevokeIssuerResponse]
    def pki_revoke_issuer(issuer_ref, pki_mount_path, opts = {})
      data, _status_code, _headers = pki_revoke_issuer_with_http_info(issuer_ref, pki_mount_path, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRevokeIssuerResponse, Integer, Hash)>] PkiRevokeIssuerResponse data, response status code and response headers
    def pki_revoke_issuer_with_http_info(issuer_ref, pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_revoke_issuer ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_revoke_issuer"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_revoke_issuer"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/revoke'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRevokeIssuerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_revoke_issuer",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_revoke_issuer\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_revoke_with_key_request [PkiRevokeWithKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiRevokeWithKeyResponse]
    def pki_revoke_with_key(pki_mount_path, pki_revoke_with_key_request, opts = {})
      data, _status_code, _headers = pki_revoke_with_key_with_http_info(pki_mount_path, pki_revoke_with_key_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_revoke_with_key_request [PkiRevokeWithKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRevokeWithKeyResponse, Integer, Hash)>] PkiRevokeWithKeyResponse data, response status code and response headers
    def pki_revoke_with_key_with_http_info(pki_mount_path, pki_revoke_with_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_revoke_with_key ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_revoke_with_key"
      end
      # verify the required parameter 'pki_revoke_with_key_request' is set
      if @api_client.config.client_side_validation && pki_revoke_with_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_revoke_with_key_request' when calling SecretsApi.pki_revoke_with_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/revoke-with-key'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_revoke_with_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRevokeWithKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_revoke_with_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_revoke_with_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_root_sign_intermediate_request [PkiRootSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiRootSignIntermediateResponse]
    def pki_root_sign_intermediate(pki_mount_path, pki_root_sign_intermediate_request, opts = {})
      data, _status_code, _headers = pki_root_sign_intermediate_with_http_info(pki_mount_path, pki_root_sign_intermediate_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_root_sign_intermediate_request [PkiRootSignIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRootSignIntermediateResponse, Integer, Hash)>] PkiRootSignIntermediateResponse data, response status code and response headers
    def pki_root_sign_intermediate_with_http_info(pki_mount_path, pki_root_sign_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_root_sign_intermediate ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_root_sign_intermediate"
      end
      # verify the required parameter 'pki_root_sign_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_root_sign_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_root_sign_intermediate_request' when calling SecretsApi.pki_root_sign_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root/sign-intermediate'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_root_sign_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRootSignIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_root_sign_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_root_sign_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_root_sign_self_issued_request [PkiRootSignSelfIssuedRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiRootSignSelfIssuedResponse]
    def pki_root_sign_self_issued(pki_mount_path, pki_root_sign_self_issued_request, opts = {})
      data, _status_code, _headers = pki_root_sign_self_issued_with_http_info(pki_mount_path, pki_root_sign_self_issued_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_root_sign_self_issued_request [PkiRootSignSelfIssuedRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRootSignSelfIssuedResponse, Integer, Hash)>] PkiRootSignSelfIssuedResponse data, response status code and response headers
    def pki_root_sign_self_issued_with_http_info(pki_mount_path, pki_root_sign_self_issued_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_root_sign_self_issued ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_root_sign_self_issued"
      end
      # verify the required parameter 'pki_root_sign_self_issued_request' is set
      if @api_client.config.client_side_validation && pki_root_sign_self_issued_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_root_sign_self_issued_request' when calling SecretsApi.pki_root_sign_self_issued"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root/sign-self-issued'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_root_sign_self_issued_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRootSignSelfIssuedResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_root_sign_self_issued",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_root_sign_self_issued\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiRotateCrlResponse]
    def pki_rotate_crl(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_rotate_crl_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRotateCrlResponse, Integer, Hash)>] PkiRotateCrlResponse data, response status code and response headers
    def pki_rotate_crl_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_rotate_crl ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_rotate_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl/rotate'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRotateCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_rotate_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_rotate_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiRotateDeltaCrlResponse]
    def pki_rotate_delta_crl(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_rotate_delta_crl_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRotateDeltaCrlResponse, Integer, Hash)>] PkiRotateDeltaCrlResponse data, response status code and response headers
    def pki_rotate_delta_crl_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_rotate_delta_crl ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_rotate_delta_crl"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/crl/rotate-delta'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRotateDeltaCrlResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_rotate_delta_crl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_rotate_delta_crl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_rotate_root_request [PkiRotateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiRotateRootResponse]
    def pki_rotate_root(exported, pki_mount_path, pki_rotate_root_request, opts = {})
      data, _status_code, _headers = pki_rotate_root_with_http_info(exported, pki_mount_path, pki_rotate_root_request, opts)
      data
    end

    # @param exported [String] Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_rotate_root_request [PkiRotateRootRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiRotateRootResponse, Integer, Hash)>] PkiRotateRootResponse data, response status code and response headers
    def pki_rotate_root_with_http_info(exported, pki_mount_path, pki_rotate_root_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_rotate_root ...'
      end
      # verify the required parameter 'exported' is set
      if @api_client.config.client_side_validation && exported.nil?
        fail ArgumentError, "Missing the required parameter 'exported' when calling SecretsApi.pki_rotate_root"
      end
      # verify enum value
      allowable_values = ["internal", "external", "kms"]
      if @api_client.config.client_side_validation && !allowable_values.include?(exported)
        fail ArgumentError, "invalid value for \"exported\", must be one of #{allowable_values}"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_rotate_root"
      end
      # verify the required parameter 'pki_rotate_root_request' is set
      if @api_client.config.client_side_validation && pki_rotate_root_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_rotate_root_request' when calling SecretsApi.pki_rotate_root"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/root/rotate/{exported}'.sub('{' + 'exported' + '}', CGI.escape(exported.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_rotate_root_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiRotateRootResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_rotate_root",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_rotate_root\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_set_signed_intermediate_request [PkiSetSignedIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiSetSignedIntermediateResponse]
    def pki_set_signed_intermediate(pki_mount_path, pki_set_signed_intermediate_request, opts = {})
      data, _status_code, _headers = pki_set_signed_intermediate_with_http_info(pki_mount_path, pki_set_signed_intermediate_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_set_signed_intermediate_request [PkiSetSignedIntermediateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiSetSignedIntermediateResponse, Integer, Hash)>] PkiSetSignedIntermediateResponse data, response status code and response headers
    def pki_set_signed_intermediate_with_http_info(pki_mount_path, pki_set_signed_intermediate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_set_signed_intermediate ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_set_signed_intermediate"
      end
      # verify the required parameter 'pki_set_signed_intermediate_request' is set
      if @api_client.config.client_side_validation && pki_set_signed_intermediate_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_set_signed_intermediate_request' when calling SecretsApi.pki_set_signed_intermediate"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/intermediate/set-signed'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_set_signed_intermediate_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiSetSignedIntermediateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_set_signed_intermediate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_set_signed_intermediate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_verbatim_request [PkiSignVerbatimRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiSignVerbatimResponse]
    def pki_sign_verbatim(pki_mount_path, pki_sign_verbatim_request, opts = {})
      data, _status_code, _headers = pki_sign_verbatim_with_http_info(pki_mount_path, pki_sign_verbatim_request, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_verbatim_request [PkiSignVerbatimRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiSignVerbatimResponse, Integer, Hash)>] PkiSignVerbatimResponse data, response status code and response headers
    def pki_sign_verbatim_with_http_info(pki_mount_path, pki_sign_verbatim_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_sign_verbatim ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_sign_verbatim"
      end
      # verify the required parameter 'pki_sign_verbatim_request' is set
      if @api_client.config.client_side_validation && pki_sign_verbatim_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_sign_verbatim_request' when calling SecretsApi.pki_sign_verbatim"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/sign-verbatim'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_sign_verbatim_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiSignVerbatimResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_sign_verbatim",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_sign_verbatim\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_verbatim_with_role_request [PkiSignVerbatimWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiSignVerbatimWithRoleResponse]
    def pki_sign_verbatim_with_role(role, pki_mount_path, pki_sign_verbatim_with_role_request, opts = {})
      data, _status_code, _headers = pki_sign_verbatim_with_role_with_http_info(role, pki_mount_path, pki_sign_verbatim_with_role_request, opts)
      data
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_verbatim_with_role_request [PkiSignVerbatimWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiSignVerbatimWithRoleResponse, Integer, Hash)>] PkiSignVerbatimWithRoleResponse data, response status code and response headers
    def pki_sign_verbatim_with_role_with_http_info(role, pki_mount_path, pki_sign_verbatim_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_sign_verbatim_with_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_sign_verbatim_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_sign_verbatim_with_role"
      end
      # verify the required parameter 'pki_sign_verbatim_with_role_request' is set
      if @api_client.config.client_side_validation && pki_sign_verbatim_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_sign_verbatim_with_role_request' when calling SecretsApi.pki_sign_verbatim_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/sign-verbatim/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_sign_verbatim_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiSignVerbatimWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_sign_verbatim_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_sign_verbatim_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_with_role_request [PkiSignWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiSignWithRoleResponse]
    def pki_sign_with_role(role, pki_mount_path, pki_sign_with_role_request, opts = {})
      data, _status_code, _headers = pki_sign_with_role_with_http_info(role, pki_mount_path, pki_sign_with_role_request, opts)
      data
    end

    # @param role [String] The desired role with configuration for this request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_sign_with_role_request [PkiSignWithRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiSignWithRoleResponse, Integer, Hash)>] PkiSignWithRoleResponse data, response status code and response headers
    def pki_sign_with_role_with_http_info(role, pki_mount_path, pki_sign_with_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_sign_with_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_sign_with_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_sign_with_role"
      end
      # verify the required parameter 'pki_sign_with_role_request' is set
      if @api_client.config.client_side_validation && pki_sign_with_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_sign_with_role_request' when calling SecretsApi.pki_sign_with_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/sign/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_sign_with_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiSignWithRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_sign_with_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_sign_with_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_tidy_request [PkiTidyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_tidy(pki_mount_path, pki_tidy_request, opts = {})
      pki_tidy_with_http_info(pki_mount_path, pki_tidy_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_tidy_request [PkiTidyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_tidy_with_http_info(pki_mount_path, pki_tidy_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_tidy ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_tidy"
      end
      # verify the required parameter 'pki_tidy_request' is set
      if @api_client.config.client_side_validation && pki_tidy_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_tidy_request' when calling SecretsApi.pki_tidy"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/tidy'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_tidy_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_tidy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_tidy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiTidyCancelResponse]
    def pki_tidy_cancel(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_tidy_cancel_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiTidyCancelResponse, Integer, Hash)>] PkiTidyCancelResponse data, response status code and response headers
    def pki_tidy_cancel_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_tidy_cancel ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_tidy_cancel"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/tidy-cancel'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiTidyCancelResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_tidy_cancel",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_tidy_cancel\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [PkiTidyStatusResponse]
    def pki_tidy_status(pki_mount_path, opts = {})
      data, _status_code, _headers = pki_tidy_status_with_http_info(pki_mount_path, opts)
      data
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiTidyStatusResponse, Integer, Hash)>] PkiTidyStatusResponse data, response status code and response headers
    def pki_tidy_status_with_http_info(pki_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_tidy_status ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_tidy_status"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/tidy-status'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PkiTidyStatusResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_tidy_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_tidy_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kid [String] The key identifier provided by the CA
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_account_kid_request [PkiWriteAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_account_kid(kid, pki_mount_path, pki_write_acme_account_kid_request, opts = {})
      pki_write_acme_account_kid_with_http_info(kid, pki_mount_path, pki_write_acme_account_kid_request, opts)
      nil
    end

    # @param kid [String] The key identifier provided by the CA
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_account_kid_request [PkiWriteAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_account_kid_with_http_info(kid, pki_mount_path, pki_write_acme_account_kid_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_account_kid ...'
      end
      # verify the required parameter 'kid' is set
      if @api_client.config.client_side_validation && kid.nil?
        fail ArgumentError, "Missing the required parameter 'kid' when calling SecretsApi.pki_write_acme_account_kid"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_account_kid"
      end
      # verify the required parameter 'pki_write_acme_account_kid_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_account_kid_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_account_kid_request' when calling SecretsApi.pki_write_acme_account_kid"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/account/{kid}'.sub('{' + 'kid' + '}', CGI.escape(kid.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_account_kid_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_account_kid",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_account_kid\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_authorization_auth_id_request [PkiWriteAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_authorization_auth_id(auth_id, pki_mount_path, pki_write_acme_authorization_auth_id_request, opts = {})
      pki_write_acme_authorization_auth_id_with_http_info(auth_id, pki_mount_path, pki_write_acme_authorization_auth_id_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_authorization_auth_id_request [PkiWriteAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_authorization_auth_id_with_http_info(auth_id, pki_mount_path, pki_write_acme_authorization_auth_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_authorization_auth_id ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_write_acme_authorization_auth_id_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_authorization_auth_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_authorization_auth_id_request' when calling SecretsApi.pki_write_acme_authorization_auth_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/authorization/{auth_id}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_authorization_auth_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_authorization_auth_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_authorization_auth_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_challenge_auth_id_challenge_type_request [PkiWriteAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_challenge_auth_id_challenge_type(auth_id, challenge_type, pki_mount_path, pki_write_acme_challenge_auth_id_challenge_type_request, opts = {})
      pki_write_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, pki_mount_path, pki_write_acme_challenge_auth_id_challenge_type_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_challenge_auth_id_challenge_type_request [PkiWriteAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, pki_mount_path, pki_write_acme_challenge_auth_id_challenge_type_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_challenge_auth_id_challenge_type ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'challenge_type' is set
      if @api_client.config.client_side_validation && challenge_type.nil?
        fail ArgumentError, "Missing the required parameter 'challenge_type' when calling SecretsApi.pki_write_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_write_acme_challenge_auth_id_challenge_type_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_challenge_auth_id_challenge_type_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_challenge_auth_id_challenge_type_request' when calling SecretsApi.pki_write_acme_challenge_auth_id_challenge_type"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/challenge/{auth_id}/{challenge_type}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'challenge_type' + '}', CGI.escape(challenge_type.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_challenge_auth_id_challenge_type_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_challenge_auth_id_challenge_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_challenge_auth_id_challenge_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_new_account_request [PkiWriteAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_new_account(pki_mount_path, pki_write_acme_new_account_request, opts = {})
      pki_write_acme_new_account_with_http_info(pki_mount_path, pki_write_acme_new_account_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_new_account_request [PkiWriteAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_new_account_with_http_info(pki_mount_path, pki_write_acme_new_account_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_new_account ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_new_account"
      end
      # verify the required parameter 'pki_write_acme_new_account_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_new_account_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_new_account_request' when calling SecretsApi.pki_write_acme_new_account"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/new-account'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_new_account_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_new_account",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_new_account\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_new_order_request [PkiWriteAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_new_order(pki_mount_path, pki_write_acme_new_order_request, opts = {})
      pki_write_acme_new_order_with_http_info(pki_mount_path, pki_write_acme_new_order_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_new_order_request [PkiWriteAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_new_order_with_http_info(pki_mount_path, pki_write_acme_new_order_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_new_order ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_new_order"
      end
      # verify the required parameter 'pki_write_acme_new_order_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_new_order_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_new_order_request' when calling SecretsApi.pki_write_acme_new_order"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/new-order'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_new_order_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_new_order",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_new_order\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_request [PkiWriteAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_order_order_id(order_id, pki_mount_path, pki_write_acme_order_order_id_request, opts = {})
      pki_write_acme_order_order_id_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_request [PkiWriteAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_order_order_id_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_order_order_id ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_acme_order_order_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_order_order_id"
      end
      # verify the required parameter 'pki_write_acme_order_order_id_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_order_order_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_order_order_id_request' when calling SecretsApi.pki_write_acme_order_order_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/order/{order_id}'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_order_order_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_order_order_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_order_order_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_cert_request [PkiWriteAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_order_order_id_cert(order_id, pki_mount_path, pki_write_acme_order_order_id_cert_request, opts = {})
      pki_write_acme_order_order_id_cert_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_cert_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_cert_request [PkiWriteAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_order_order_id_cert_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_order_order_id_cert ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_write_acme_order_order_id_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_order_order_id_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_order_order_id_cert_request' when calling SecretsApi.pki_write_acme_order_order_id_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/order/{order_id}/cert'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_order_order_id_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_order_order_id_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_order_order_id_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_finalize_request [PkiWriteAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_order_order_id_finalize(order_id, pki_mount_path, pki_write_acme_order_order_id_finalize_request, opts = {})
      pki_write_acme_order_order_id_finalize_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_finalize_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_order_order_id_finalize_request [PkiWriteAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_order_order_id_finalize_with_http_info(order_id, pki_mount_path, pki_write_acme_order_order_id_finalize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_order_order_id_finalize ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_write_acme_order_order_id_finalize_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_order_order_id_finalize_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_order_order_id_finalize_request' when calling SecretsApi.pki_write_acme_order_order_id_finalize"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/order/{order_id}/finalize'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_order_order_id_finalize_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_order_order_id_finalize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_order_order_id_finalize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_orders_request [PkiWriteAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_orders(pki_mount_path, pki_write_acme_orders_request, opts = {})
      pki_write_acme_orders_with_http_info(pki_mount_path, pki_write_acme_orders_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_orders_request [PkiWriteAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_orders_with_http_info(pki_mount_path, pki_write_acme_orders_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_orders ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_orders"
      end
      # verify the required parameter 'pki_write_acme_orders_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_orders_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_orders_request' when calling SecretsApi.pki_write_acme_orders"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/orders'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_orders_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_orders",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_orders\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_revoke_cert_request [PkiWriteAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_acme_revoke_cert(pki_mount_path, pki_write_acme_revoke_cert_request, opts = {})
      pki_write_acme_revoke_cert_with_http_info(pki_mount_path, pki_write_acme_revoke_cert_request, opts)
      nil
    end

    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_acme_revoke_cert_request [PkiWriteAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_acme_revoke_cert_with_http_info(pki_mount_path, pki_write_acme_revoke_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_acme_revoke_cert ...'
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_acme_revoke_cert"
      end
      # verify the required parameter 'pki_write_acme_revoke_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_acme_revoke_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_acme_revoke_cert_request' when calling SecretsApi.pki_write_acme_revoke_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/acme/revoke-cert'.sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_acme_revoke_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_acme_revoke_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_acme_revoke_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_request [PkiWriteIssuerRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiWriteIssuerResponse]
    def pki_write_issuer(issuer_ref, pki_mount_path, pki_write_issuer_request, opts = {})
      data, _status_code, _headers = pki_write_issuer_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_request, opts)
      data
    end

    # @param issuer_ref [String] Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_request [PkiWriteIssuerRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiWriteIssuerResponse, Integer, Hash)>] PkiWriteIssuerResponse data, response status code and response headers
    def pki_write_issuer_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer"
      end
      # verify the required parameter 'pki_write_issuer_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_request' when calling SecretsApi.pki_write_issuer"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiWriteIssuerResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param kid [String] The key identifier provided by the CA
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_account_kid_request [PkiWriteIssuerIssuerRefAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_account_kid(issuer_ref, kid, pki_mount_path, pki_write_issuer_issuer_ref_acme_account_kid_request, opts = {})
      pki_write_issuer_issuer_ref_acme_account_kid_with_http_info(issuer_ref, kid, pki_mount_path, pki_write_issuer_issuer_ref_acme_account_kid_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param kid [String] The key identifier provided by the CA
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_account_kid_request [PkiWriteIssuerIssuerRefAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_account_kid_with_http_info(issuer_ref, kid, pki_mount_path, pki_write_issuer_issuer_ref_acme_account_kid_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid"
      end
      # verify the required parameter 'kid' is set
      if @api_client.config.client_side_validation && kid.nil?
        fail ArgumentError, "Missing the required parameter 'kid' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_account_kid_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_account_kid_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_account_kid_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/account/{kid}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'kid' + '}', CGI.escape(kid.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_account_kid_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_account_kid",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_account_kid\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_authorization_auth_id_request [PkiWriteIssuerIssuerRefAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_authorization_auth_id(auth_id, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_authorization_auth_id_request, opts = {})
      pki_write_issuer_issuer_ref_acme_authorization_auth_id_with_http_info(auth_id, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_authorization_auth_id_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_authorization_auth_id_request [PkiWriteIssuerIssuerRefAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_authorization_auth_id_with_http_info(auth_id, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_authorization_auth_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id"
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_authorization_auth_id_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_authorization_auth_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_authorization_auth_id_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/authorization/{auth_id}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_authorization_auth_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_authorization_auth_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_authorization_auth_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request [PkiWriteIssuerIssuerRefAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type(auth_id, challenge_type, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request, opts = {})
      pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request [PkiWriteIssuerIssuerRefAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'challenge_type' is set
      if @api_client.config.client_side_validation && challenge_type.nil?
        fail ArgumentError, "Missing the required parameter 'challenge_type' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/challenge/{auth_id}/{challenge_type}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'challenge_type' + '}', CGI.escape(challenge_type.to_s)).sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_new_account_request [PkiWriteIssuerIssuerRefAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_new_account(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_account_request, opts = {})
      pki_write_issuer_issuer_ref_acme_new_account_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_account_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_new_account_request [PkiWriteIssuerIssuerRefAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_new_account_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_account_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_new_account ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_account"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_account"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_new_account_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_new_account_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_new_account_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_account"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/new-account'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_new_account_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_new_account",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_new_account\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_new_order_request [PkiWriteIssuerIssuerRefAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_new_order(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_order_request, opts = {})
      pki_write_issuer_issuer_ref_acme_new_order_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_order_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_new_order_request [PkiWriteIssuerIssuerRefAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_new_order_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_new_order_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_new_order ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_order"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_order"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_new_order_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_new_order_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_new_order_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_new_order"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/new-order'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_new_order_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_new_order",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_new_order\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_order_order_id(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_request, opts = {})
      pki_write_issuer_issuer_ref_acme_order_order_id_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_order_order_id_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_order_order_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_order_order_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_order_order_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_cert_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_order_order_id_cert(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_cert_request, opts = {})
      pki_write_issuer_issuer_ref_acme_order_order_id_cert_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_cert_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_cert_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_order_order_id_cert_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_order_order_id_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_cert_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id}/cert'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_order_order_id_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_order_order_id_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_order_order_id_finalize(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request, opts = {})
      pki_write_issuer_issuer_ref_acme_order_order_id_finalize_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request [PkiWriteIssuerIssuerRefAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_order_order_id_finalize_with_http_info(issuer_ref, order_id, pki_mount_path, pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/order/{order_id}/finalize'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_order_order_id_finalize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_order_order_id_finalize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_orders_request [PkiWriteIssuerIssuerRefAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_orders(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_orders_request, opts = {})
      pki_write_issuer_issuer_ref_acme_orders_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_orders_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_orders_request [PkiWriteIssuerIssuerRefAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_orders_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_orders_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_orders ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_orders"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_orders"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_orders_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_orders_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_orders_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_orders"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/orders'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_orders_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_orders",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_orders\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_revoke_cert_request [PkiWriteIssuerIssuerRefAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_acme_revoke_cert(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_revoke_cert_request, opts = {})
      pki_write_issuer_issuer_ref_acme_revoke_cert_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_revoke_cert_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_acme_revoke_cert_request [PkiWriteIssuerIssuerRefAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_acme_revoke_cert_with_http_info(issuer_ref, pki_mount_path, pki_write_issuer_issuer_ref_acme_revoke_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_acme_revoke_cert ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_revoke_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_revoke_cert"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_acme_revoke_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_acme_revoke_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_acme_revoke_cert_request' when calling SecretsApi.pki_write_issuer_issuer_ref_acme_revoke_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/acme/revoke-cert'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_acme_revoke_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_acme_revoke_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_acme_revoke_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param kid [String] The key identifier provided by the CA
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request [PkiWriteIssuerIssuerRefRolesRoleAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_account_kid(issuer_ref, kid, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_account_kid_with_http_info(issuer_ref, kid, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param kid [String] The key identifier provided by the CA
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request [PkiWriteIssuerIssuerRefRolesRoleAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_account_kid_with_http_info(issuer_ref, kid, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid"
      end
      # verify the required parameter 'kid' is set
      if @api_client.config.client_side_validation && kid.nil?
        fail ArgumentError, "Missing the required parameter 'kid' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/account/{kid}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'kid' + '}', CGI.escape(kid.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_account_kid",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_account_kid\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request [PkiWriteIssuerIssuerRefRolesRoleAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id(auth_id, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_with_http_info(auth_id, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request [PkiWriteIssuerIssuerRefRolesRoleAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_with_http_info(auth_id, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/authorization/{auth_id}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request [PkiWriteIssuerIssuerRefRolesRoleAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type(auth_id, challenge_type, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request [PkiWriteIssuerIssuerRefRolesRoleAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'challenge_type' is set
      if @api_client.config.client_side_validation && challenge_type.nil?
        fail ArgumentError, "Missing the required parameter 'challenge_type' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/challenge/{auth_id}/{challenge_type}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'challenge_type' + '}', CGI.escape(challenge_type.to_s)).sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_new_account_request [PkiWriteIssuerIssuerRefRolesRoleAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_new_account(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_account_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_new_account_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_account_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_new_account_request [PkiWriteIssuerIssuerRefRolesRoleAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_new_account_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_account_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_new_account_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_new_account_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_new_account_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-account'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_new_account_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_account",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_new_account\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_new_order_request [PkiWriteIssuerIssuerRefRolesRoleAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_new_order(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_order_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_new_order_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_order_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_new_order_request [PkiWriteIssuerIssuerRefRolesRoleAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_new_order_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_new_order_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_new_order_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_new_order_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_new_order_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/new-order'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_new_order_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_new_order",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_new_order\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id}'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id}/cert'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_with_http_info(issuer_ref, order_id, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/order/{order_id}/finalize'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_orders_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_orders(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_orders_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_orders_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_orders_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_orders_request [PkiWriteIssuerIssuerRefRolesRoleAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_orders_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_orders_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_orders_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_orders_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_orders_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/orders'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_orders_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_orders",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_orders\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request [PkiWriteIssuerIssuerRefRolesRoleAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request, opts = {})
      pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request, opts)
      nil
    end

    # @param issuer_ref [String] Reference to an existing issuer name or issuer id
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request [PkiWriteIssuerIssuerRefRolesRoleAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_with_http_info(issuer_ref, role, pki_mount_path, pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert ...'
      end
      # verify the required parameter 'issuer_ref' is set
      if @api_client.config.client_side_validation && issuer_ref.nil?
        fail ArgumentError, "Missing the required parameter 'issuer_ref' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert"
      end
      # verify the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request' when calling SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/issuer/{issuer_ref}/roles/{role}/acme/revoke-cert'.sub('{' + 'issuer_ref' + '}', CGI.escape(issuer_ref.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_key_request [PkiWriteKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiWriteKeyResponse]
    def pki_write_key(key_ref, pki_mount_path, pki_write_key_request, opts = {})
      data, _status_code, _headers = pki_write_key_with_http_info(key_ref, pki_mount_path, pki_write_key_request, opts)
      data
    end

    # @param key_ref [String] Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_key_request [PkiWriteKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiWriteKeyResponse, Integer, Hash)>] PkiWriteKeyResponse data, response status code and response headers
    def pki_write_key_with_http_info(key_ref, pki_mount_path, pki_write_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_key ...'
      end
      # verify the required parameter 'key_ref' is set
      if @api_client.config.client_side_validation && key_ref.nil?
        fail ArgumentError, "Missing the required parameter 'key_ref' when calling SecretsApi.pki_write_key"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_key"
      end
      # verify the required parameter 'pki_write_key_request' is set
      if @api_client.config.client_side_validation && pki_write_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_key_request' when calling SecretsApi.pki_write_key"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/key/{key_ref}'.sub('{' + 'key_ref' + '}', CGI.escape(key_ref.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_key_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiWriteKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_role_request [PkiWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [PkiWriteRoleResponse]
    def pki_write_role(name, pki_mount_path, pki_write_role_request, opts = {})
      data, _status_code, _headers = pki_write_role_with_http_info(name, pki_mount_path, pki_write_role_request, opts)
      data
    end

    # @param name [String] Name of the role
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_role_request [PkiWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(PkiWriteRoleResponse, Integer, Hash)>] PkiWriteRoleResponse data, response status code and response headers
    def pki_write_role_with_http_info(name, pki_mount_path, pki_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.pki_write_role"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_role"
      end
      # verify the required parameter 'pki_write_role_request' is set
      if @api_client.config.client_side_validation && pki_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_role_request' when calling SecretsApi.pki_write_role"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_role_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PkiWriteRoleResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param kid [String] The key identifier provided by the CA
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_account_kid_request [PkiWriteRolesRoleAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_account_kid(kid, role, pki_mount_path, pki_write_roles_role_acme_account_kid_request, opts = {})
      pki_write_roles_role_acme_account_kid_with_http_info(kid, role, pki_mount_path, pki_write_roles_role_acme_account_kid_request, opts)
      nil
    end

    # @param kid [String] The key identifier provided by the CA
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_account_kid_request [PkiWriteRolesRoleAcmeAccountKidRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_account_kid_with_http_info(kid, role, pki_mount_path, pki_write_roles_role_acme_account_kid_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_account_kid ...'
      end
      # verify the required parameter 'kid' is set
      if @api_client.config.client_side_validation && kid.nil?
        fail ArgumentError, "Missing the required parameter 'kid' when calling SecretsApi.pki_write_roles_role_acme_account_kid"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_account_kid"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_account_kid"
      end
      # verify the required parameter 'pki_write_roles_role_acme_account_kid_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_account_kid_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_account_kid_request' when calling SecretsApi.pki_write_roles_role_acme_account_kid"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/account/{kid}'.sub('{' + 'kid' + '}', CGI.escape(kid.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_account_kid_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_account_kid",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_account_kid\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_authorization_auth_id_request [PkiWriteRolesRoleAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_authorization_auth_id(auth_id, role, pki_mount_path, pki_write_roles_role_acme_authorization_auth_id_request, opts = {})
      pki_write_roles_role_acme_authorization_auth_id_with_http_info(auth_id, role, pki_mount_path, pki_write_roles_role_acme_authorization_auth_id_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_authorization_auth_id_request [PkiWriteRolesRoleAcmeAuthorizationAuthIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_authorization_auth_id_with_http_info(auth_id, role, pki_mount_path, pki_write_roles_role_acme_authorization_auth_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_authorization_auth_id ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_authorization_auth_id"
      end
      # verify the required parameter 'pki_write_roles_role_acme_authorization_auth_id_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_authorization_auth_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_authorization_auth_id_request' when calling SecretsApi.pki_write_roles_role_acme_authorization_auth_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/authorization/{auth_id}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_authorization_auth_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_authorization_auth_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_authorization_auth_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_challenge_auth_id_challenge_type_request [PkiWriteRolesRoleAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_challenge_auth_id_challenge_type(auth_id, challenge_type, role, pki_mount_path, pki_write_roles_role_acme_challenge_auth_id_challenge_type_request, opts = {})
      pki_write_roles_role_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, role, pki_mount_path, pki_write_roles_role_acme_challenge_auth_id_challenge_type_request, opts)
      nil
    end

    # @param auth_id [String] ACME authorization identifier value
    # @param challenge_type [String] ACME challenge type
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_challenge_auth_id_challenge_type_request [PkiWriteRolesRoleAcmeChallengeAuthIdChallengeTypeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_challenge_auth_id_challenge_type_with_http_info(auth_id, challenge_type, role, pki_mount_path, pki_write_roles_role_acme_challenge_auth_id_challenge_type_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type ...'
      end
      # verify the required parameter 'auth_id' is set
      if @api_client.config.client_side_validation && auth_id.nil?
        fail ArgumentError, "Missing the required parameter 'auth_id' when calling SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'challenge_type' is set
      if @api_client.config.client_side_validation && challenge_type.nil?
        fail ArgumentError, "Missing the required parameter 'challenge_type' when calling SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # verify the required parameter 'pki_write_roles_role_acme_challenge_auth_id_challenge_type_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_challenge_auth_id_challenge_type_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_challenge_auth_id_challenge_type_request' when calling SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/challenge/{auth_id}/{challenge_type}'.sub('{' + 'auth_id' + '}', CGI.escape(auth_id.to_s)).sub('{' + 'challenge_type' + '}', CGI.escape(challenge_type.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_challenge_auth_id_challenge_type_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_challenge_auth_id_challenge_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_challenge_auth_id_challenge_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_new_account_request [PkiWriteRolesRoleAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_new_account(role, pki_mount_path, pki_write_roles_role_acme_new_account_request, opts = {})
      pki_write_roles_role_acme_new_account_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_new_account_request, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_new_account_request [PkiWriteRolesRoleAcmeNewAccountRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_new_account_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_new_account_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_new_account ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_new_account"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_new_account"
      end
      # verify the required parameter 'pki_write_roles_role_acme_new_account_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_new_account_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_new_account_request' when calling SecretsApi.pki_write_roles_role_acme_new_account"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/new-account'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_new_account_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_new_account",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_new_account\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_new_order_request [PkiWriteRolesRoleAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_new_order(role, pki_mount_path, pki_write_roles_role_acme_new_order_request, opts = {})
      pki_write_roles_role_acme_new_order_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_new_order_request, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_new_order_request [PkiWriteRolesRoleAcmeNewOrderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_new_order_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_new_order_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_new_order ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_new_order"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_new_order"
      end
      # verify the required parameter 'pki_write_roles_role_acme_new_order_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_new_order_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_new_order_request' when calling SecretsApi.pki_write_roles_role_acme_new_order"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/new-order'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_new_order_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_new_order",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_new_order\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_request [PkiWriteRolesRoleAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_order_order_id(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_request, opts = {})
      pki_write_roles_role_acme_order_order_id_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_request [PkiWriteRolesRoleAcmeOrderOrderIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_order_order_id_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_order_order_id ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_order_order_id"
      end
      # verify the required parameter 'pki_write_roles_role_acme_order_order_id_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_order_order_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_order_order_id_request' when calling SecretsApi.pki_write_roles_role_acme_order_order_id"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/order/{order_id}'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_order_order_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_order_order_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_order_order_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_cert_request [PkiWriteRolesRoleAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_order_order_id_cert(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_cert_request, opts = {})
      pki_write_roles_role_acme_order_order_id_cert_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_cert_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_cert_request [PkiWriteRolesRoleAcmeOrderOrderIdCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_order_order_id_cert_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_order_order_id_cert ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_cert"
      end
      # verify the required parameter 'pki_write_roles_role_acme_order_order_id_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_order_order_id_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_order_order_id_cert_request' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/order/{order_id}/cert'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_order_order_id_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_order_order_id_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_order_order_id_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_finalize_request [PkiWriteRolesRoleAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_order_order_id_finalize(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_finalize_request, opts = {})
      pki_write_roles_role_acme_order_order_id_finalize_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_finalize_request, opts)
      nil
    end

    # @param order_id [String] The ACME order identifier to fetch
    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_order_order_id_finalize_request [PkiWriteRolesRoleAcmeOrderOrderIdFinalizeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_order_order_id_finalize_with_http_info(order_id, role, pki_mount_path, pki_write_roles_role_acme_order_order_id_finalize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_order_order_id_finalize ...'
      end
      # verify the required parameter 'order_id' is set
      if @api_client.config.client_side_validation && order_id.nil?
        fail ArgumentError, "Missing the required parameter 'order_id' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_finalize"
      end
      # verify the required parameter 'pki_write_roles_role_acme_order_order_id_finalize_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_order_order_id_finalize_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_order_order_id_finalize_request' when calling SecretsApi.pki_write_roles_role_acme_order_order_id_finalize"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/order/{order_id}/finalize'.sub('{' + 'order_id' + '}', CGI.escape(order_id.to_s)).sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_order_order_id_finalize_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_order_order_id_finalize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_order_order_id_finalize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_orders_request [PkiWriteRolesRoleAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_orders(role, pki_mount_path, pki_write_roles_role_acme_orders_request, opts = {})
      pki_write_roles_role_acme_orders_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_orders_request, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_orders_request [PkiWriteRolesRoleAcmeOrdersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_orders_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_orders_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_orders ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_orders"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_orders"
      end
      # verify the required parameter 'pki_write_roles_role_acme_orders_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_orders_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_orders_request' when calling SecretsApi.pki_write_roles_role_acme_orders"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/orders'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_orders_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_orders",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_orders\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_revoke_cert_request [PkiWriteRolesRoleAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pki_write_roles_role_acme_revoke_cert(role, pki_mount_path, pki_write_roles_role_acme_revoke_cert_request, opts = {})
      pki_write_roles_role_acme_revoke_cert_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_revoke_cert_request, opts)
      nil
    end

    # @param role [String] The desired role for the acme request
    # @param pki_mount_path [String] Path that the backend was mounted at
    # @param pki_write_roles_role_acme_revoke_cert_request [PkiWriteRolesRoleAcmeRevokeCertRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pki_write_roles_role_acme_revoke_cert_with_http_info(role, pki_mount_path, pki_write_roles_role_acme_revoke_cert_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.pki_write_roles_role_acme_revoke_cert ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.pki_write_roles_role_acme_revoke_cert"
      end
      # verify the required parameter 'pki_mount_path' is set
      if @api_client.config.client_side_validation && pki_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'pki_mount_path' when calling SecretsApi.pki_write_roles_role_acme_revoke_cert"
      end
      # verify the required parameter 'pki_write_roles_role_acme_revoke_cert_request' is set
      if @api_client.config.client_side_validation && pki_write_roles_role_acme_revoke_cert_request.nil?
        fail ArgumentError, "Missing the required parameter 'pki_write_roles_role_acme_revoke_cert_request' when calling SecretsApi.pki_write_roles_role_acme_revoke_cert"
      end
      # resource path
      local_var_path = '/{pki_mount_path}/roles/{role}/acme/revoke-cert'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'pki_mount_path' + '}', CGI.escape(pki_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pki_write_roles_role_acme_revoke_cert_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.pki_write_roles_role_acme_revoke_cert",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#pki_write_roles_role_acme_revoke_cert\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure the connection URI, username, and password to talk to RabbitMQ management HTTP API.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_configure_connection_request [RabbitMqConfigureConnectionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_configure_connection(rabbitmq_mount_path, rabbit_mq_configure_connection_request, opts = {})
      rabbit_mq_configure_connection_with_http_info(rabbitmq_mount_path, rabbit_mq_configure_connection_request, opts)
      nil
    end

    # Configure the connection URI, username, and password to talk to RabbitMQ management HTTP API.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_configure_connection_request [RabbitMqConfigureConnectionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_configure_connection_with_http_info(rabbitmq_mount_path, rabbit_mq_configure_connection_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_configure_connection ...'
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_configure_connection"
      end
      # verify the required parameter 'rabbit_mq_configure_connection_request' is set
      if @api_client.config.client_side_validation && rabbit_mq_configure_connection_request.nil?
        fail ArgumentError, "Missing the required parameter 'rabbit_mq_configure_connection_request' when calling SecretsApi.rabbit_mq_configure_connection"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/config/connection'.sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rabbit_mq_configure_connection_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_configure_connection",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_configure_connection\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_configure_lease_request [RabbitMqConfigureLeaseRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_configure_lease(rabbitmq_mount_path, rabbit_mq_configure_lease_request, opts = {})
      rabbit_mq_configure_lease_with_http_info(rabbitmq_mount_path, rabbit_mq_configure_lease_request, opts)
      nil
    end

    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_configure_lease_request [RabbitMqConfigureLeaseRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_configure_lease_with_http_info(rabbitmq_mount_path, rabbit_mq_configure_lease_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_configure_lease ...'
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_configure_lease"
      end
      # verify the required parameter 'rabbit_mq_configure_lease_request' is set
      if @api_client.config.client_side_validation && rabbit_mq_configure_lease_request.nil?
        fail ArgumentError, "Missing the required parameter 'rabbit_mq_configure_lease_request' when calling SecretsApi.rabbit_mq_configure_lease"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/config/lease'.sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rabbit_mq_configure_lease_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_configure_lease",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_configure_lease\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_delete_role(name, rabbitmq_mount_path, opts = {})
      rabbit_mq_delete_role_with_http_info(name, rabbitmq_mount_path, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_delete_role_with_http_info(name, rabbitmq_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.rabbit_mq_delete_role"
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_delete_role"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_list_roles(rabbitmq_mount_path, list, opts = {})
      rabbit_mq_list_roles_with_http_info(rabbitmq_mount_path, list, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_list_roles_with_http_info(rabbitmq_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_list_roles ...'
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.rabbit_mq_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/roles'.sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_read_lease_configuration(rabbitmq_mount_path, opts = {})
      rabbit_mq_read_lease_configuration_with_http_info(rabbitmq_mount_path, opts)
      nil
    end

    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_read_lease_configuration_with_http_info(rabbitmq_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_read_lease_configuration ...'
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_read_lease_configuration"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/config/lease'.sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_read_lease_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_read_lease_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_read_role(name, rabbitmq_mount_path, opts = {})
      rabbit_mq_read_role_with_http_info(name, rabbitmq_mount_path, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_read_role_with_http_info(name, rabbitmq_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.rabbit_mq_read_role"
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_read_role"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Request RabbitMQ credentials for a certain role.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_request_credentials(name, rabbitmq_mount_path, opts = {})
      rabbit_mq_request_credentials_with_http_info(name, rabbitmq_mount_path, opts)
      nil
    end

    # Request RabbitMQ credentials for a certain role.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_request_credentials_with_http_info(name, rabbitmq_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_request_credentials ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.rabbit_mq_request_credentials"
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_request_credentials"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/creds/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_request_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_request_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_write_role_request [RabbitMqWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rabbit_mq_write_role(name, rabbitmq_mount_path, rabbit_mq_write_role_request, opts = {})
      rabbit_mq_write_role_with_http_info(name, rabbitmq_mount_path, rabbit_mq_write_role_request, opts)
      nil
    end

    # Manage the roles that can be created with this backend.
    # @param name [String] Name of the role.
    # @param rabbitmq_mount_path [String] Path that the backend was mounted at
    # @param rabbit_mq_write_role_request [RabbitMqWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rabbit_mq_write_role_with_http_info(name, rabbitmq_mount_path, rabbit_mq_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.rabbit_mq_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.rabbit_mq_write_role"
      end
      # verify the required parameter 'rabbitmq_mount_path' is set
      if @api_client.config.client_side_validation && rabbitmq_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'rabbitmq_mount_path' when calling SecretsApi.rabbit_mq_write_role"
      end
      # verify the required parameter 'rabbit_mq_write_role_request' is set
      if @api_client.config.client_side_validation && rabbit_mq_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'rabbit_mq_write_role_request' when calling SecretsApi.rabbit_mq_write_role"
      end
      # resource path
      local_var_path = '/{rabbitmq_mount_path}/roles/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'rabbitmq_mount_path' + '}', CGI.escape(rabbitmq_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rabbit_mq_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.rabbit_mq_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#rabbit_mq_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_configure_ca_request [SshConfigureCaRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_configure_ca(ssh_mount_path, ssh_configure_ca_request, opts = {})
      ssh_configure_ca_with_http_info(ssh_mount_path, ssh_configure_ca_request, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_configure_ca_request [SshConfigureCaRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_configure_ca_with_http_info(ssh_mount_path, ssh_configure_ca_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_configure_ca ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_configure_ca"
      end
      # verify the required parameter 'ssh_configure_ca_request' is set
      if @api_client.config.client_side_validation && ssh_configure_ca_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_configure_ca_request' when calling SecretsApi.ssh_configure_ca"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/ca'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_configure_ca_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_configure_ca",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_configure_ca\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_configure_zero_address_request [SshConfigureZeroAddressRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_configure_zero_address(ssh_mount_path, ssh_configure_zero_address_request, opts = {})
      ssh_configure_zero_address_with_http_info(ssh_mount_path, ssh_configure_zero_address_request, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_configure_zero_address_request [SshConfigureZeroAddressRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_configure_zero_address_with_http_info(ssh_mount_path, ssh_configure_zero_address_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_configure_zero_address ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_configure_zero_address"
      end
      # verify the required parameter 'ssh_configure_zero_address_request' is set
      if @api_client.config.client_side_validation && ssh_configure_zero_address_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_configure_zero_address_request' when calling SecretsApi.ssh_configure_zero_address"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/zeroaddress'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_configure_zero_address_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_configure_zero_address",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_configure_zero_address\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_delete_ca_configuration(ssh_mount_path, opts = {})
      ssh_delete_ca_configuration_with_http_info(ssh_mount_path, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_delete_ca_configuration_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_delete_ca_configuration ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_delete_ca_configuration"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/ca'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_delete_ca_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_delete_ca_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the 'roles' that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_delete_role(role, ssh_mount_path, opts = {})
      ssh_delete_role_with_http_info(role, ssh_mount_path, opts)
      nil
    end

    # Manage the &#39;roles&#39; that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_delete_role_with_http_info(role, ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_delete_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_delete_role"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_delete_role"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/roles/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_delete_zero_address_configuration(ssh_mount_path, opts = {})
      ssh_delete_zero_address_configuration_with_http_info(ssh_mount_path, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_delete_zero_address_configuration_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_delete_zero_address_configuration ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_delete_zero_address_configuration"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/zeroaddress'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_delete_zero_address_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_delete_zero_address_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Creates a credential for establishing SSH connection with the remote host.
    # @param role [String] [Required] Name of the role
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_generate_credentials_request [SshGenerateCredentialsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_generate_credentials(role, ssh_mount_path, ssh_generate_credentials_request, opts = {})
      ssh_generate_credentials_with_http_info(role, ssh_mount_path, ssh_generate_credentials_request, opts)
      nil
    end

    # Creates a credential for establishing SSH connection with the remote host.
    # @param role [String] [Required] Name of the role
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_generate_credentials_request [SshGenerateCredentialsRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_generate_credentials_with_http_info(role, ssh_mount_path, ssh_generate_credentials_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_generate_credentials ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_generate_credentials"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_generate_credentials"
      end
      # verify the required parameter 'ssh_generate_credentials_request' is set
      if @api_client.config.client_side_validation && ssh_generate_credentials_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_generate_credentials_request' when calling SecretsApi.ssh_generate_credentials"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/creds/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_generate_credentials_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_generate_credentials",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_generate_credentials\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param role [String] The desired role with configuration for this request.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_issue_certificate_request [SshIssueCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_issue_certificate(role, ssh_mount_path, ssh_issue_certificate_request, opts = {})
      ssh_issue_certificate_with_http_info(role, ssh_mount_path, ssh_issue_certificate_request, opts)
      nil
    end

    # @param role [String] The desired role with configuration for this request.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_issue_certificate_request [SshIssueCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_issue_certificate_with_http_info(role, ssh_mount_path, ssh_issue_certificate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_issue_certificate ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_issue_certificate"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_issue_certificate"
      end
      # verify the required parameter 'ssh_issue_certificate_request' is set
      if @api_client.config.client_side_validation && ssh_issue_certificate_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_issue_certificate_request' when calling SecretsApi.ssh_issue_certificate"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/issue/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_issue_certificate_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_issue_certificate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_issue_certificate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the 'roles' that can be created with this backend.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_list_roles(ssh_mount_path, list, opts = {})
      ssh_list_roles_with_http_info(ssh_mount_path, list, opts)
      nil
    end

    # Manage the &#39;roles&#39; that can be created with this backend.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_list_roles_with_http_info(ssh_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_list_roles ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_list_roles"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.ssh_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/roles'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the roles associated with the given IP address.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_list_roles_by_ip_request [SshListRolesByIpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_list_roles_by_ip(ssh_mount_path, ssh_list_roles_by_ip_request, opts = {})
      ssh_list_roles_by_ip_with_http_info(ssh_mount_path, ssh_list_roles_by_ip_request, opts)
      nil
    end

    # List all the roles associated with the given IP address.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_list_roles_by_ip_request [SshListRolesByIpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_list_roles_by_ip_with_http_info(ssh_mount_path, ssh_list_roles_by_ip_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_list_roles_by_ip ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_list_roles_by_ip"
      end
      # verify the required parameter 'ssh_list_roles_by_ip_request' is set
      if @api_client.config.client_side_validation && ssh_list_roles_by_ip_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_list_roles_by_ip_request' when calling SecretsApi.ssh_list_roles_by_ip"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/lookup'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_list_roles_by_ip_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_list_roles_by_ip",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_list_roles_by_ip\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_read_ca_configuration(ssh_mount_path, opts = {})
      ssh_read_ca_configuration_with_http_info(ssh_mount_path, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_read_ca_configuration_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_read_ca_configuration ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_read_ca_configuration"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/ca'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_read_ca_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_read_ca_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve the public key.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_read_public_key(ssh_mount_path, opts = {})
      ssh_read_public_key_with_http_info(ssh_mount_path, opts)
      nil
    end

    # Retrieve the public key.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_read_public_key_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_read_public_key ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_read_public_key"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/public_key'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_read_public_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_read_public_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the 'roles' that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_read_role(role, ssh_mount_path, opts = {})
      ssh_read_role_with_http_info(role, ssh_mount_path, opts)
      nil
    end

    # Manage the &#39;roles&#39; that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_read_role_with_http_info(role, ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_read_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_read_role"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_read_role"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/roles/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_read_zero_address_configuration(ssh_mount_path, opts = {})
      ssh_read_zero_address_configuration_with_http_info(ssh_mount_path, opts)
      nil
    end

    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_read_zero_address_configuration_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_read_zero_address_configuration ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_read_zero_address_configuration"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/config/zeroaddress'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_read_zero_address_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_read_zero_address_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Request signing an SSH key using a certain role with the provided details.
    # @param role [String] The desired role with configuration for this request.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_sign_certificate_request [SshSignCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_sign_certificate(role, ssh_mount_path, ssh_sign_certificate_request, opts = {})
      ssh_sign_certificate_with_http_info(role, ssh_mount_path, ssh_sign_certificate_request, opts)
      nil
    end

    # Request signing an SSH key using a certain role with the provided details.
    # @param role [String] The desired role with configuration for this request.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_sign_certificate_request [SshSignCertificateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_sign_certificate_with_http_info(role, ssh_mount_path, ssh_sign_certificate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_sign_certificate ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_sign_certificate"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_sign_certificate"
      end
      # verify the required parameter 'ssh_sign_certificate_request' is set
      if @api_client.config.client_side_validation && ssh_sign_certificate_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_sign_certificate_request' when calling SecretsApi.ssh_sign_certificate"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/sign/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_sign_certificate_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_sign_certificate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_sign_certificate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # This endpoint removes the stored host keys used for the removed Dynamic Key feature, if present.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_tidy_dynamic_host_keys(ssh_mount_path, opts = {})
      ssh_tidy_dynamic_host_keys_with_http_info(ssh_mount_path, opts)
      nil
    end

    # This endpoint removes the stored host keys used for the removed Dynamic Key feature, if present.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_tidy_dynamic_host_keys_with_http_info(ssh_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_tidy_dynamic_host_keys ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_tidy_dynamic_host_keys"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/tidy/dynamic-keys'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_tidy_dynamic_host_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_tidy_dynamic_host_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Validate the OTP provided by OpenBao SSH Agent.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_verify_otp_request [SshVerifyOtpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_verify_otp(ssh_mount_path, ssh_verify_otp_request, opts = {})
      ssh_verify_otp_with_http_info(ssh_mount_path, ssh_verify_otp_request, opts)
      nil
    end

    # Validate the OTP provided by OpenBao SSH Agent.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_verify_otp_request [SshVerifyOtpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_verify_otp_with_http_info(ssh_mount_path, ssh_verify_otp_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_verify_otp ...'
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_verify_otp"
      end
      # verify the required parameter 'ssh_verify_otp_request' is set
      if @api_client.config.client_side_validation && ssh_verify_otp_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_verify_otp_request' when calling SecretsApi.ssh_verify_otp"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/verify'.sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_verify_otp_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_verify_otp",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_verify_otp\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the 'roles' that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_write_role_request [SshWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ssh_write_role(role, ssh_mount_path, ssh_write_role_request, opts = {})
      ssh_write_role_with_http_info(role, ssh_mount_path, ssh_write_role_request, opts)
      nil
    end

    # Manage the &#39;roles&#39; that can be created with this backend.
    # @param role [String] [Required for all types] Name of the role being created.
    # @param ssh_mount_path [String] Path that the backend was mounted at
    # @param ssh_write_role_request [SshWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ssh_write_role_with_http_info(role, ssh_mount_path, ssh_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.ssh_write_role ...'
      end
      # verify the required parameter 'role' is set
      if @api_client.config.client_side_validation && role.nil?
        fail ArgumentError, "Missing the required parameter 'role' when calling SecretsApi.ssh_write_role"
      end
      # verify the required parameter 'ssh_mount_path' is set
      if @api_client.config.client_side_validation && ssh_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_mount_path' when calling SecretsApi.ssh_write_role"
      end
      # verify the required parameter 'ssh_write_role_request' is set
      if @api_client.config.client_side_validation && ssh_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'ssh_write_role_request' when calling SecretsApi.ssh_write_role"
      end
      # resource path
      local_var_path = '/{ssh_mount_path}/roles/{role}'.sub('{' + 'role' + '}', CGI.escape(role.to_s)).sub('{' + 'ssh_mount_path' + '}', CGI.escape(ssh_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ssh_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.ssh_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#ssh_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param totp_create_key_request [TotpCreateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_create_key(name, totp_mount_path, totp_create_key_request, opts = {})
      totp_create_key_with_http_info(name, totp_mount_path, totp_create_key_request, opts)
      nil
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param totp_create_key_request [TotpCreateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_create_key_with_http_info(name, totp_mount_path, totp_create_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_create_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.totp_create_key"
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_create_key"
      end
      # verify the required parameter 'totp_create_key_request' is set
      if @api_client.config.client_side_validation && totp_create_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'totp_create_key_request' when calling SecretsApi.totp_create_key"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(totp_create_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_create_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_create_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_delete_key(name, totp_mount_path, opts = {})
      totp_delete_key_with_http_info(name, totp_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_delete_key_with_http_info(name, totp_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_delete_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.totp_delete_key"
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_delete_key"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_delete_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_delete_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_generate_code(name, totp_mount_path, opts = {})
      totp_generate_code_with_http_info(name, totp_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_generate_code_with_http_info(name, totp_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_generate_code ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.totp_generate_code"
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_generate_code"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/code/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_generate_code",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_generate_code\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Manage the keys that can be created with this backend.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_list_keys(totp_mount_path, list, opts = {})
      totp_list_keys_with_http_info(totp_mount_path, list, opts)
      nil
    end

    # Manage the keys that can be created with this backend.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_list_keys_with_http_info(totp_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_list_keys ...'
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_list_keys"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.totp_list_keys"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/keys'.sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_list_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_list_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_read_key(name, totp_mount_path, opts = {})
      totp_read_key_with_http_info(name, totp_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_read_key_with_http_info(name, totp_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_read_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.totp_read_key"
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_read_key"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_read_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_read_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param totp_validate_code_request [TotpValidateCodeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def totp_validate_code(name, totp_mount_path, totp_validate_code_request, opts = {})
      totp_validate_code_with_http_info(name, totp_mount_path, totp_validate_code_request, opts)
      nil
    end

    # @param name [String] Name of the key.
    # @param totp_mount_path [String] Path that the backend was mounted at
    # @param totp_validate_code_request [TotpValidateCodeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def totp_validate_code_with_http_info(name, totp_mount_path, totp_validate_code_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.totp_validate_code ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.totp_validate_code"
      end
      # verify the required parameter 'totp_mount_path' is set
      if @api_client.config.client_side_validation && totp_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'totp_mount_path' when calling SecretsApi.totp_validate_code"
      end
      # verify the required parameter 'totp_validate_code_request' is set
      if @api_client.config.client_side_validation && totp_validate_code_request.nil?
        fail ArgumentError, "Missing the required parameter 'totp_validate_code_request' when calling SecretsApi.totp_validate_code"
      end
      # resource path
      local_var_path = '/{totp_mount_path}/code/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'totp_mount_path' + '}', CGI.escape(totp_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(totp_validate_code_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.totp_validate_code",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#totp_validate_code\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backup the named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_back_up_key(name, transit_mount_path, opts = {})
      transit_back_up_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # Backup the named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_back_up_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_back_up_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_back_up_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_back_up_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/backup/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_back_up_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_back_up_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Securely export named encryption or signing key
    # @param destination [String] Destination key to export to; usually the public wrapping key of another Transit instance.
    # @param source [String] Source key to export; could be any present key within Transit.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_byok_key(destination, source, transit_mount_path, opts = {})
      transit_byok_key_with_http_info(destination, source, transit_mount_path, opts)
      nil
    end

    # Securely export named encryption or signing key
    # @param destination [String] Destination key to export to; usually the public wrapping key of another Transit instance.
    # @param source [String] Source key to export; could be any present key within Transit.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_byok_key_with_http_info(destination, source, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_byok_key ...'
      end
      # verify the required parameter 'destination' is set
      if @api_client.config.client_side_validation && destination.nil?
        fail ArgumentError, "Missing the required parameter 'destination' when calling SecretsApi.transit_byok_key"
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SecretsApi.transit_byok_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_byok_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/byok-export/{destination}/{source}'.sub('{' + 'destination' + '}', CGI.escape(destination.to_s)).sub('{' + 'source' + '}', CGI.escape(source.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_byok_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_byok_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Securely export named encryption or signing key
    # @param destination [String] Destination key to export to; usually the public wrapping key of another Transit instance.
    # @param source [String] Source key to export; could be any present key within Transit.
    # @param version [String] Optional version of the key to export, else all key versions are exported.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_byok_key_version(destination, source, version, transit_mount_path, opts = {})
      transit_byok_key_version_with_http_info(destination, source, version, transit_mount_path, opts)
      nil
    end

    # Securely export named encryption or signing key
    # @param destination [String] Destination key to export to; usually the public wrapping key of another Transit instance.
    # @param source [String] Source key to export; could be any present key within Transit.
    # @param version [String] Optional version of the key to export, else all key versions are exported.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_byok_key_version_with_http_info(destination, source, version, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_byok_key_version ...'
      end
      # verify the required parameter 'destination' is set
      if @api_client.config.client_side_validation && destination.nil?
        fail ArgumentError, "Missing the required parameter 'destination' when calling SecretsApi.transit_byok_key_version"
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SecretsApi.transit_byok_key_version"
      end
      # verify the required parameter 'version' is set
      if @api_client.config.client_side_validation && version.nil?
        fail ArgumentError, "Missing the required parameter 'version' when calling SecretsApi.transit_byok_key_version"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_byok_key_version"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/byok-export/{destination}/{source}/{version}'.sub('{' + 'destination' + '}', CGI.escape(destination.to_s)).sub('{' + 'source' + '}', CGI.escape(source.to_s)).sub('{' + 'version' + '}', CGI.escape(version.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_byok_key_version",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_byok_key_version\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configures a new cache of the specified size
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_cache_request [TransitConfigureCacheRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_configure_cache(transit_mount_path, transit_configure_cache_request, opts = {})
      transit_configure_cache_with_http_info(transit_mount_path, transit_configure_cache_request, opts)
      nil
    end

    # Configures a new cache of the specified size
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_cache_request [TransitConfigureCacheRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_configure_cache_with_http_info(transit_mount_path, transit_configure_cache_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_configure_cache ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_configure_cache"
      end
      # verify the required parameter 'transit_configure_cache_request' is set
      if @api_client.config.client_side_validation && transit_configure_cache_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_configure_cache_request' when calling SecretsApi.transit_configure_cache"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/cache-config'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_configure_cache_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_configure_cache",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_configure_cache\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure a named encryption key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_key_request [TransitConfigureKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_configure_key(name, transit_mount_path, transit_configure_key_request, opts = {})
      transit_configure_key_with_http_info(name, transit_mount_path, transit_configure_key_request, opts)
      nil
    end

    # Configure a named encryption key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_key_request [TransitConfigureKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_configure_key_with_http_info(name, transit_mount_path, transit_configure_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_configure_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_configure_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_configure_key"
      end
      # verify the required parameter 'transit_configure_key_request' is set
      if @api_client.config.client_side_validation && transit_configure_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_configure_key_request' when calling SecretsApi.transit_configure_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/config'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_configure_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_configure_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_configure_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_keys_request [TransitConfigureKeysRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_configure_keys(transit_mount_path, transit_configure_keys_request, opts = {})
      transit_configure_keys_with_http_info(transit_mount_path, transit_configure_keys_request, opts)
      nil
    end

    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_configure_keys_request [TransitConfigureKeysRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_configure_keys_with_http_info(transit_mount_path, transit_configure_keys_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_configure_keys ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_configure_keys"
      end
      # verify the required parameter 'transit_configure_keys_request' is set
      if @api_client.config.client_side_validation && transit_configure_keys_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_configure_keys_request' when calling SecretsApi.transit_configure_keys"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/config/keys'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_configure_keys_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_configure_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_configure_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_create_key_request [TransitCreateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_create_key(name, transit_mount_path, transit_create_key_request, opts = {})
      transit_create_key_with_http_info(name, transit_mount_path, transit_create_key_request, opts)
      nil
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_create_key_request [TransitCreateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_create_key_with_http_info(name, transit_mount_path, transit_create_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_create_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_create_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_create_key"
      end
      # verify the required parameter 'transit_create_key_request' is set
      if @api_client.config.client_side_validation && transit_create_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_create_key_request' when calling SecretsApi.transit_create_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_create_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_create_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_create_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Decrypt a ciphertext value using a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_decrypt_request [TransitDecryptRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_decrypt(name, transit_mount_path, transit_decrypt_request, opts = {})
      transit_decrypt_with_http_info(name, transit_mount_path, transit_decrypt_request, opts)
      nil
    end

    # Decrypt a ciphertext value using a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_decrypt_request [TransitDecryptRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_decrypt_with_http_info(name, transit_mount_path, transit_decrypt_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_decrypt ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_decrypt"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_decrypt"
      end
      # verify the required parameter 'transit_decrypt_request' is set
      if @api_client.config.client_side_validation && transit_decrypt_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_decrypt_request' when calling SecretsApi.transit_decrypt"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/decrypt/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_decrypt_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_decrypt",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_decrypt\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_delete_key(name, transit_mount_path, opts = {})
      transit_delete_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_delete_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_delete_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_delete_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_delete_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_delete_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_delete_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Encrypt a plaintext value or a batch of plaintext blocks using a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_encrypt_request [TransitEncryptRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_encrypt(name, transit_mount_path, transit_encrypt_request, opts = {})
      transit_encrypt_with_http_info(name, transit_mount_path, transit_encrypt_request, opts)
      nil
    end

    # Encrypt a plaintext value or a batch of plaintext blocks using a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_encrypt_request [TransitEncryptRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_encrypt_with_http_info(name, transit_mount_path, transit_encrypt_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_encrypt ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_encrypt"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_encrypt"
      end
      # verify the required parameter 'transit_encrypt_request' is set
      if @api_client.config.client_side_validation && transit_encrypt_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_encrypt_request' when calling SecretsApi.transit_encrypt"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/encrypt/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_encrypt_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_encrypt",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_encrypt\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Export named encryption or signing key
    # @param name [String] Name of the key
    # @param type [String] Type of key to export (encryption-key, signing-key, hmac-key, public-key)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_export_key(name, type, transit_mount_path, opts = {})
      transit_export_key_with_http_info(name, type, transit_mount_path, opts)
      nil
    end

    # Export named encryption or signing key
    # @param name [String] Name of the key
    # @param type [String] Type of key to export (encryption-key, signing-key, hmac-key, public-key)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_export_key_with_http_info(name, type, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_export_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_export_key"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SecretsApi.transit_export_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_export_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/export/{type}/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'type' + '}', CGI.escape(type.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_export_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_export_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Export named encryption or signing key
    # @param name [String] Name of the key
    # @param type [String] Type of key to export (encryption-key, signing-key, hmac-key, public-key)
    # @param version [String] Version of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_export_key_version(name, type, version, transit_mount_path, opts = {})
      transit_export_key_version_with_http_info(name, type, version, transit_mount_path, opts)
      nil
    end

    # Export named encryption or signing key
    # @param name [String] Name of the key
    # @param type [String] Type of key to export (encryption-key, signing-key, hmac-key, public-key)
    # @param version [String] Version of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_export_key_version_with_http_info(name, type, version, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_export_key_version ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_export_key_version"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SecretsApi.transit_export_key_version"
      end
      # verify the required parameter 'version' is set
      if @api_client.config.client_side_validation && version.nil?
        fail ArgumentError, "Missing the required parameter 'version' when calling SecretsApi.transit_export_key_version"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_export_key_version"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/export/{type}/{name}/{version}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'type' + '}', CGI.escape(type.to_s)).sub('{' + 'version' + '}', CGI.escape(version.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_export_key_version",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_export_key_version\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a data key
    # @param name [String] The backend key used for encrypting the data key
    # @param plaintext [String] \&quot;plaintext\&quot; will return the key in both plaintext and ciphertext; \&quot;wrapped\&quot; will return the ciphertext only.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_data_key_request [TransitGenerateDataKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_data_key(name, plaintext, transit_mount_path, transit_generate_data_key_request, opts = {})
      transit_generate_data_key_with_http_info(name, plaintext, transit_mount_path, transit_generate_data_key_request, opts)
      nil
    end

    # Generate a data key
    # @param name [String] The backend key used for encrypting the data key
    # @param plaintext [String] \&quot;plaintext\&quot; will return the key in both plaintext and ciphertext; \&quot;wrapped\&quot; will return the ciphertext only.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_data_key_request [TransitGenerateDataKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_data_key_with_http_info(name, plaintext, transit_mount_path, transit_generate_data_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_data_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_generate_data_key"
      end
      # verify the required parameter 'plaintext' is set
      if @api_client.config.client_side_validation && plaintext.nil?
        fail ArgumentError, "Missing the required parameter 'plaintext' when calling SecretsApi.transit_generate_data_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_data_key"
      end
      # verify the required parameter 'transit_generate_data_key_request' is set
      if @api_client.config.client_side_validation && transit_generate_data_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_data_key_request' when calling SecretsApi.transit_generate_data_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/datakey/{plaintext}/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'plaintext' + '}', CGI.escape(plaintext.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_data_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_data_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_data_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate an HMAC for input data using the named key
    # @param name [String] The key to use for the HMAC function
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_hmac_request [TransitGenerateHmacRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_hmac(name, transit_mount_path, transit_generate_hmac_request, opts = {})
      transit_generate_hmac_with_http_info(name, transit_mount_path, transit_generate_hmac_request, opts)
      nil
    end

    # Generate an HMAC for input data using the named key
    # @param name [String] The key to use for the HMAC function
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_hmac_request [TransitGenerateHmacRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_hmac_with_http_info(name, transit_mount_path, transit_generate_hmac_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_hmac ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_generate_hmac"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_hmac"
      end
      # verify the required parameter 'transit_generate_hmac_request' is set
      if @api_client.config.client_side_validation && transit_generate_hmac_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_hmac_request' when calling SecretsApi.transit_generate_hmac"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/hmac/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_hmac_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_hmac",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_hmac\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate an HMAC for input data using the named key
    # @param name [String] The key to use for the HMAC function
    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_hmac_with_algorithm_request [TransitGenerateHmacWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_hmac_with_algorithm(name, urlalgorithm, transit_mount_path, transit_generate_hmac_with_algorithm_request, opts = {})
      transit_generate_hmac_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_generate_hmac_with_algorithm_request, opts)
      nil
    end

    # Generate an HMAC for input data using the named key
    # @param name [String] The key to use for the HMAC function
    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_hmac_with_algorithm_request [TransitGenerateHmacWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_hmac_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_generate_hmac_with_algorithm_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_hmac_with_algorithm ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_generate_hmac_with_algorithm"
      end
      # verify the required parameter 'urlalgorithm' is set
      if @api_client.config.client_side_validation && urlalgorithm.nil?
        fail ArgumentError, "Missing the required parameter 'urlalgorithm' when calling SecretsApi.transit_generate_hmac_with_algorithm"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_hmac_with_algorithm"
      end
      # verify the required parameter 'transit_generate_hmac_with_algorithm_request' is set
      if @api_client.config.client_side_validation && transit_generate_hmac_with_algorithm_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_hmac_with_algorithm_request' when calling SecretsApi.transit_generate_hmac_with_algorithm"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/hmac/{name}/{urlalgorithm}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'urlalgorithm' + '}', CGI.escape(urlalgorithm.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_hmac_with_algorithm_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_hmac_with_algorithm",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_hmac_with_algorithm\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate random bytes
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_request [TransitGenerateRandomRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_random(transit_mount_path, transit_generate_random_request, opts = {})
      transit_generate_random_with_http_info(transit_mount_path, transit_generate_random_request, opts)
      nil
    end

    # Generate random bytes
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_request [TransitGenerateRandomRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_random_with_http_info(transit_mount_path, transit_generate_random_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_random ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_random"
      end
      # verify the required parameter 'transit_generate_random_request' is set
      if @api_client.config.client_side_validation && transit_generate_random_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_random_request' when calling SecretsApi.transit_generate_random"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/random'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_random_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_random",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_random\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate random bytes
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_bytes_request [TransitGenerateRandomWithBytesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_random_with_bytes(urlbytes, transit_mount_path, transit_generate_random_with_bytes_request, opts = {})
      transit_generate_random_with_bytes_with_http_info(urlbytes, transit_mount_path, transit_generate_random_with_bytes_request, opts)
      nil
    end

    # Generate random bytes
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_bytes_request [TransitGenerateRandomWithBytesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_random_with_bytes_with_http_info(urlbytes, transit_mount_path, transit_generate_random_with_bytes_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_random_with_bytes ...'
      end
      # verify the required parameter 'urlbytes' is set
      if @api_client.config.client_side_validation && urlbytes.nil?
        fail ArgumentError, "Missing the required parameter 'urlbytes' when calling SecretsApi.transit_generate_random_with_bytes"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_random_with_bytes"
      end
      # verify the required parameter 'transit_generate_random_with_bytes_request' is set
      if @api_client.config.client_side_validation && transit_generate_random_with_bytes_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_random_with_bytes_request' when calling SecretsApi.transit_generate_random_with_bytes"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/random/{urlbytes}'.sub('{' + 'urlbytes' + '}', CGI.escape(urlbytes.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_random_with_bytes_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_random_with_bytes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_random_with_bytes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate random bytes
    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_source_request [TransitGenerateRandomWithSourceRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_random_with_source(source, transit_mount_path, transit_generate_random_with_source_request, opts = {})
      transit_generate_random_with_source_with_http_info(source, transit_mount_path, transit_generate_random_with_source_request, opts)
      nil
    end

    # Generate random bytes
    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_source_request [TransitGenerateRandomWithSourceRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_random_with_source_with_http_info(source, transit_mount_path, transit_generate_random_with_source_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_random_with_source ...'
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SecretsApi.transit_generate_random_with_source"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_random_with_source"
      end
      # verify the required parameter 'transit_generate_random_with_source_request' is set
      if @api_client.config.client_side_validation && transit_generate_random_with_source_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_random_with_source_request' when calling SecretsApi.transit_generate_random_with_source"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/random/{source}'.sub('{' + 'source' + '}', CGI.escape(source.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_random_with_source_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_random_with_source",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_random_with_source\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate random bytes
    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_source_and_bytes_request [TransitGenerateRandomWithSourceAndBytesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_generate_random_with_source_and_bytes(source, urlbytes, transit_mount_path, transit_generate_random_with_source_and_bytes_request, opts = {})
      transit_generate_random_with_source_and_bytes_with_http_info(source, urlbytes, transit_mount_path, transit_generate_random_with_source_and_bytes_request, opts)
      nil
    end

    # Generate random bytes
    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_generate_random_with_source_and_bytes_request [TransitGenerateRandomWithSourceAndBytesRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_generate_random_with_source_and_bytes_with_http_info(source, urlbytes, transit_mount_path, transit_generate_random_with_source_and_bytes_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_generate_random_with_source_and_bytes ...'
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SecretsApi.transit_generate_random_with_source_and_bytes"
      end
      # verify the required parameter 'urlbytes' is set
      if @api_client.config.client_side_validation && urlbytes.nil?
        fail ArgumentError, "Missing the required parameter 'urlbytes' when calling SecretsApi.transit_generate_random_with_source_and_bytes"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_generate_random_with_source_and_bytes"
      end
      # verify the required parameter 'transit_generate_random_with_source_and_bytes_request' is set
      if @api_client.config.client_side_validation && transit_generate_random_with_source_and_bytes_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_generate_random_with_source_and_bytes_request' when calling SecretsApi.transit_generate_random_with_source_and_bytes"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/random/{source}/{urlbytes}'.sub('{' + 'source' + '}', CGI.escape(source.to_s)).sub('{' + 'urlbytes' + '}', CGI.escape(urlbytes.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_generate_random_with_source_and_bytes_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_generate_random_with_source_and_bytes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_generate_random_with_source_and_bytes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a hash sum for input data
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_hash_request [TransitHashRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_hash(transit_mount_path, transit_hash_request, opts = {})
      transit_hash_with_http_info(transit_mount_path, transit_hash_request, opts)
      nil
    end

    # Generate a hash sum for input data
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_hash_request [TransitHashRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_hash_with_http_info(transit_mount_path, transit_hash_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_hash ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_hash"
      end
      # verify the required parameter 'transit_hash_request' is set
      if @api_client.config.client_side_validation && transit_hash_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_hash_request' when calling SecretsApi.transit_hash"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/hash'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_hash_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_hash",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_hash\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a hash sum for input data
    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_hash_with_algorithm_request [TransitHashWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_hash_with_algorithm(urlalgorithm, transit_mount_path, transit_hash_with_algorithm_request, opts = {})
      transit_hash_with_algorithm_with_http_info(urlalgorithm, transit_mount_path, transit_hash_with_algorithm_request, opts)
      nil
    end

    # Generate a hash sum for input data
    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_hash_with_algorithm_request [TransitHashWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_hash_with_algorithm_with_http_info(urlalgorithm, transit_mount_path, transit_hash_with_algorithm_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_hash_with_algorithm ...'
      end
      # verify the required parameter 'urlalgorithm' is set
      if @api_client.config.client_side_validation && urlalgorithm.nil?
        fail ArgumentError, "Missing the required parameter 'urlalgorithm' when calling SecretsApi.transit_hash_with_algorithm"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_hash_with_algorithm"
      end
      # verify the required parameter 'transit_hash_with_algorithm_request' is set
      if @api_client.config.client_side_validation && transit_hash_with_algorithm_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_hash_with_algorithm_request' when calling SecretsApi.transit_hash_with_algorithm"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/hash/{urlalgorithm}'.sub('{' + 'urlalgorithm' + '}', CGI.escape(urlalgorithm.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_hash_with_algorithm_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_hash_with_algorithm",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_hash_with_algorithm\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Imports an externally-generated key into a new transit key
    # @param name [String] The name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_import_key_request [TransitImportKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_import_key(name, transit_mount_path, transit_import_key_request, opts = {})
      transit_import_key_with_http_info(name, transit_mount_path, transit_import_key_request, opts)
      nil
    end

    # Imports an externally-generated key into a new transit key
    # @param name [String] The name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_import_key_request [TransitImportKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_import_key_with_http_info(name, transit_mount_path, transit_import_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_import_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_import_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_import_key"
      end
      # verify the required parameter 'transit_import_key_request' is set
      if @api_client.config.client_side_validation && transit_import_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_import_key_request' when calling SecretsApi.transit_import_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/import'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_import_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_import_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_import_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Imports an externally-generated key into an existing imported key
    # @param name [String] The name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_import_key_version_request [TransitImportKeyVersionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_import_key_version(name, transit_mount_path, transit_import_key_version_request, opts = {})
      transit_import_key_version_with_http_info(name, transit_mount_path, transit_import_key_version_request, opts)
      nil
    end

    # Imports an externally-generated key into an existing imported key
    # @param name [String] The name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_import_key_version_request [TransitImportKeyVersionRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_import_key_version_with_http_info(name, transit_mount_path, transit_import_key_version_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_import_key_version ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_import_key_version"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_import_key_version"
      end
      # verify the required parameter 'transit_import_key_version_request' is set
      if @api_client.config.client_side_validation && transit_import_key_version_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_import_key_version_request' when calling SecretsApi.transit_import_key_version"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/import_version'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_import_key_version_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_import_key_version",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_import_key_version\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Managed named encryption keys
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_list_keys(transit_mount_path, list, opts = {})
      transit_list_keys_with_http_info(transit_mount_path, list, opts)
      nil
    end

    # Managed named encryption keys
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_list_keys_with_http_info(transit_mount_path, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_list_keys ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_list_keys"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SecretsApi.transit_list_keys"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_list_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_list_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the size of the active cache
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_read_cache_configuration(transit_mount_path, opts = {})
      transit_read_cache_configuration_with_http_info(transit_mount_path, opts)
      nil
    end

    # Returns the size of the active cache
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_read_cache_configuration_with_http_info(transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_read_cache_configuration ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_read_cache_configuration"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/cache-config'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_read_cache_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_read_cache_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_read_key(name, transit_mount_path, opts = {})
      transit_read_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_read_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_read_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_read_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_read_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_read_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_read_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_read_keys_configuration(transit_mount_path, opts = {})
      transit_read_keys_configuration_with_http_info(transit_mount_path, opts)
      nil
    end

    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_read_keys_configuration_with_http_info(transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_read_keys_configuration ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_read_keys_configuration"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/config/keys'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_read_keys_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_read_keys_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the public key to use for wrapping imported keys
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_read_wrapping_key(transit_mount_path, opts = {})
      transit_read_wrapping_key_with_http_info(transit_mount_path, opts)
      nil
    end

    # Returns the public key to use for wrapping imported keys
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_read_wrapping_key_with_http_info(transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_read_wrapping_key ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_read_wrapping_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/wrapping_key'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_read_wrapping_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_read_wrapping_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Restore the named key
    # @param name [String] If set, this will be the name of the restored key.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_restore_and_rename_key_request [TransitRestoreAndRenameKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_restore_and_rename_key(name, transit_mount_path, transit_restore_and_rename_key_request, opts = {})
      transit_restore_and_rename_key_with_http_info(name, transit_mount_path, transit_restore_and_rename_key_request, opts)
      nil
    end

    # Restore the named key
    # @param name [String] If set, this will be the name of the restored key.
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_restore_and_rename_key_request [TransitRestoreAndRenameKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_restore_and_rename_key_with_http_info(name, transit_mount_path, transit_restore_and_rename_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_restore_and_rename_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_restore_and_rename_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_restore_and_rename_key"
      end
      # verify the required parameter 'transit_restore_and_rename_key_request' is set
      if @api_client.config.client_side_validation && transit_restore_and_rename_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_restore_and_rename_key_request' when calling SecretsApi.transit_restore_and_rename_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/restore/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_restore_and_rename_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_restore_and_rename_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_restore_and_rename_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Restore the named key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_restore_key_request [TransitRestoreKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_restore_key(transit_mount_path, transit_restore_key_request, opts = {})
      transit_restore_key_with_http_info(transit_mount_path, transit_restore_key_request, opts)
      nil
    end

    # Restore the named key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_restore_key_request [TransitRestoreKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_restore_key_with_http_info(transit_mount_path, transit_restore_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_restore_key ...'
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_restore_key"
      end
      # verify the required parameter 'transit_restore_key_request' is set
      if @api_client.config.client_side_validation && transit_restore_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_restore_key_request' when calling SecretsApi.transit_restore_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/restore'.sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_restore_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_restore_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_restore_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Rewrap ciphertext
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_rewrap_request [TransitRewrapRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_rewrap(name, transit_mount_path, transit_rewrap_request, opts = {})
      transit_rewrap_with_http_info(name, transit_mount_path, transit_rewrap_request, opts)
      nil
    end

    # Rewrap ciphertext
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_rewrap_request [TransitRewrapRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_rewrap_with_http_info(name, transit_mount_path, transit_rewrap_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_rewrap ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_rewrap"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_rewrap"
      end
      # verify the required parameter 'transit_rewrap_request' is set
      if @api_client.config.client_side_validation && transit_rewrap_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_rewrap_request' when calling SecretsApi.transit_rewrap"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/rewrap/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_rewrap_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_rewrap",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_rewrap\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Rotate named encryption key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_rotate_key(name, transit_mount_path, opts = {})
      transit_rotate_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # Rotate named encryption key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_rotate_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_rotate_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_rotate_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_rotate_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/rotate'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_rotate_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_rotate_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a signature for input data using the named key
    # @param name [String] The key to use
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_sign_request [TransitSignRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_sign(name, transit_mount_path, transit_sign_request, opts = {})
      transit_sign_with_http_info(name, transit_mount_path, transit_sign_request, opts)
      nil
    end

    # Generate a signature for input data using the named key
    # @param name [String] The key to use
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_sign_request [TransitSignRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_sign_with_http_info(name, transit_mount_path, transit_sign_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_sign ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_sign"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_sign"
      end
      # verify the required parameter 'transit_sign_request' is set
      if @api_client.config.client_side_validation && transit_sign_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_sign_request' when calling SecretsApi.transit_sign"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/sign/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_sign_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_sign",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_sign\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a signature for input data using the named key
    # @param name [String] The key to use
    # @param urlalgorithm [String] Hash algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_sign_with_algorithm_request [TransitSignWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_sign_with_algorithm(name, urlalgorithm, transit_mount_path, transit_sign_with_algorithm_request, opts = {})
      transit_sign_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_sign_with_algorithm_request, opts)
      nil
    end

    # Generate a signature for input data using the named key
    # @param name [String] The key to use
    # @param urlalgorithm [String] Hash algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_sign_with_algorithm_request [TransitSignWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_sign_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_sign_with_algorithm_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_sign_with_algorithm ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_sign_with_algorithm"
      end
      # verify the required parameter 'urlalgorithm' is set
      if @api_client.config.client_side_validation && urlalgorithm.nil?
        fail ArgumentError, "Missing the required parameter 'urlalgorithm' when calling SecretsApi.transit_sign_with_algorithm"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_sign_with_algorithm"
      end
      # verify the required parameter 'transit_sign_with_algorithm_request' is set
      if @api_client.config.client_side_validation && transit_sign_with_algorithm_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_sign_with_algorithm_request' when calling SecretsApi.transit_sign_with_algorithm"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/sign/{name}/{urlalgorithm}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'urlalgorithm' + '}', CGI.escape(urlalgorithm.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_sign_with_algorithm_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_sign_with_algorithm",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_sign_with_algorithm\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_soft_delete_key(name, transit_mount_path, opts = {})
      transit_soft_delete_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_soft_delete_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_soft_delete_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_soft_delete_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_soft_delete_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/soft-delete'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_soft_delete_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_soft_delete_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_soft_delete_restore_key(name, transit_mount_path, opts = {})
      transit_soft_delete_restore_key_with_http_info(name, transit_mount_path, opts)
      nil
    end

    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_soft_delete_restore_key_with_http_info(name, transit_mount_path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_soft_delete_restore_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_soft_delete_restore_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_soft_delete_restore_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/soft-delete-restore'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_soft_delete_restore_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_soft_delete_restore_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Trim key versions of a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_trim_key_request [TransitTrimKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_trim_key(name, transit_mount_path, transit_trim_key_request, opts = {})
      transit_trim_key_with_http_info(name, transit_mount_path, transit_trim_key_request, opts)
      nil
    end

    # Trim key versions of a named key
    # @param name [String] Name of the key
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_trim_key_request [TransitTrimKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_trim_key_with_http_info(name, transit_mount_path, transit_trim_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_trim_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_trim_key"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_trim_key"
      end
      # verify the required parameter 'transit_trim_key_request' is set
      if @api_client.config.client_side_validation && transit_trim_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_trim_key_request' when calling SecretsApi.transit_trim_key"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/keys/{name}/trim'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_trim_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_trim_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_trim_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Verify a signature or HMAC for input data created using the named key
    # @param name [String] The key to use
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_verify_request [TransitVerifyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_verify(name, transit_mount_path, transit_verify_request, opts = {})
      transit_verify_with_http_info(name, transit_mount_path, transit_verify_request, opts)
      nil
    end

    # Verify a signature or HMAC for input data created using the named key
    # @param name [String] The key to use
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_verify_request [TransitVerifyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_verify_with_http_info(name, transit_mount_path, transit_verify_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_verify ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_verify"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_verify"
      end
      # verify the required parameter 'transit_verify_request' is set
      if @api_client.config.client_side_validation && transit_verify_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_verify_request' when calling SecretsApi.transit_verify"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/verify/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_verify_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_verify",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_verify\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Verify a signature or HMAC for input data created using the named key
    # @param name [String] The key to use
    # @param urlalgorithm [String] Hash algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_verify_with_algorithm_request [TransitVerifyWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def transit_verify_with_algorithm(name, urlalgorithm, transit_mount_path, transit_verify_with_algorithm_request, opts = {})
      transit_verify_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_verify_with_algorithm_request, opts)
      nil
    end

    # Verify a signature or HMAC for input data created using the named key
    # @param name [String] The key to use
    # @param urlalgorithm [String] Hash algorithm to use (POST URL parameter)
    # @param transit_mount_path [String] Path that the backend was mounted at
    # @param transit_verify_with_algorithm_request [TransitVerifyWithAlgorithmRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def transit_verify_with_algorithm_with_http_info(name, urlalgorithm, transit_mount_path, transit_verify_with_algorithm_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SecretsApi.transit_verify_with_algorithm ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SecretsApi.transit_verify_with_algorithm"
      end
      # verify the required parameter 'urlalgorithm' is set
      if @api_client.config.client_side_validation && urlalgorithm.nil?
        fail ArgumentError, "Missing the required parameter 'urlalgorithm' when calling SecretsApi.transit_verify_with_algorithm"
      end
      # verify the required parameter 'transit_mount_path' is set
      if @api_client.config.client_side_validation && transit_mount_path.nil?
        fail ArgumentError, "Missing the required parameter 'transit_mount_path' when calling SecretsApi.transit_verify_with_algorithm"
      end
      # verify the required parameter 'transit_verify_with_algorithm_request' is set
      if @api_client.config.client_side_validation && transit_verify_with_algorithm_request.nil?
        fail ArgumentError, "Missing the required parameter 'transit_verify_with_algorithm_request' when calling SecretsApi.transit_verify_with_algorithm"
      end
      # resource path
      local_var_path = '/{transit_mount_path}/verify/{name}/{urlalgorithm}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'urlalgorithm' + '}', CGI.escape(urlalgorithm.to_s)).sub('{' + 'transit_mount_path' + '}', CGI.escape(transit_mount_path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(transit_verify_with_algorithm_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SecretsApi.transit_verify_with_algorithm",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SecretsApi#transit_verify_with_algorithm\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
