/*-
 * Copyright (c) 1999,2000 Joao Cabral (jcnc@dhis.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      DHIS(c)  Dynamic Host Information System Release 4.0
 */


#include<stdio.h>
#include<stdlib.h>
#include<string.h>


void off_nl(unsigned char *s) {

	while(*s!='\0' && *s!='\n' && *s!='\r') s++;
	*s='\0';
	return;
}


unsigned char *line_entry(int idx,unsigned char *buff) {

	static unsigned char b2[1024],*pb2;
	int i;

	idx--;
	b2[0]='\0';
	pb2=b2;

	while((*buff==' ' || *buff=='\t') && *buff!='\0' && *buff!='\n')
		buff++;
	if(*buff=='\0' || *buff=='\n') return(b2);
		
	for(i=0;i<idx;i++) {
		while(*buff!=' ' && *buff!='\t' && *buff!='\0' &&
			*buff!='\n') buff++;
		if(*buff=='\0' || *buff=='\n') return(b2);
		while((*buff==' ' || *buff=='\t') && *buff!='\0' && *buff!='\n')
			buff++;
		if(*buff=='\0' || *buff=='\n') return(b2);
	}
	while(*buff!=' ' && *buff!='\t' && *buff!='\0' && *buff!='\n') {
		*pb2 = *buff;
		buff++;
		pb2++;
	}
	*pb2 = '\0';
	return(b2);
}

int main() {

	FILE *fp;
	unsigned char str[1024];
	int id=1000;

	fp=fopen("/etc/dhis/db/dhis.db","r");
	if(fp==NULL) return(0);
	while(fgets(str,1024,fp)!=NULL) {
	 off_nl(str);
	 if(!strcmp(line_entry(2,str),"{")) {
	  if(atoi(line_entry(1,str)) > id) id=atoi(line_entry(1,str));
	 }
	}
	fclose(fp);
	id++;
	printf("\thostid\t\t%d\n",id);
	exit(0);
}
