/*
  ViewModeInterface.h

  This file is part of Charm, a task-based time tracking application.

  Copyright (C) 2007-2018 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com

  Author: Mirko Boehm <mirko.boehm@kdab.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CHARM_UISTATEINTERFACE_H
#define CHARM_UISTATEINTERFACE_H

#include <Core/State.h>
#include <Core/CommandEmitterInterface.h>

class UIStateInterface : public CommandEmitterInterface
{
public:
    virtual ~UIStateInterface()
    {
    }

    virtual void saveGuiState() = 0;
    virtual void restoreGuiState() = 0;
    virtual void stateChanged(State previous) = 0;
    virtual void configurationChanged() = 0;
    virtual void emitCommand(CharmCommand *) = 0;
    virtual void emitCommandRollback(CharmCommand *) = 0;

    // CommandEmitterInterface
    virtual void commitCommand(CharmCommand *) override = 0;
};

#endif
