/****************************************************************************
 *              config.h
 *
 * This header file contains all constants and types required to run on a
 * UNIX system.
 *
 * from Persistence of Vision(tm) Ray Tracer version 3.6.
 * Copyright 1991-2003 Persistence of Vision Team
 * Copyright 2003-2004 Persistence of Vision Raytracer Pty. Ltd.
 *---------------------------------------------------------------------------
 * NOTICE: This source code file is provided so that users may experiment
 * with enhancements to POV-Ray and to port the software to platforms other
 * than those supported by the POV-Ray developers. There are strict rules
 * regarding how you are permitted to use this file. These rules are contained
 * in the distribution and derivative versions licenses which should have been
 * provided with this file.
 *
 * These licences may be found online, linked from the end-user license
 * agreement that is located at http://www.povray.org/povlegal.html
 *---------------------------------------------------------------------------
 * This program is based on the popular DKB raytracer version 2.12.
 * DKBTrace was originally written by David K. Buck.
 * DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
 *---------------------------------------------------------------------------
 * $File: //depot/povray/3.6-release/unix/config.h $
 * $Revision: #2 $
 * $Change: 2939 $
 * $DateTime: 2004/07/04 13:43:26 $
 * $Author: root $
 * $Log$
 *****************************************************************************/

/*
 * Modifications by Mike Fleetwood, February 1999
 *
 * Modifications by Nicolas Calimet [NC], August 2003
 * - removed all references to PARAMS() .
 * - added support for POVMS changes, removed obsolete #define DONT_USE_POVMS .
 * - moved all variables and function prototypes to sysproto.h .
 * - defines all replacement functions unconditionally.
 * - file reorganisation and cleanup.
 *
 * Modifications by Christoph Hormann, April 2004
 * - moved the function prototypes from sysproto.h here
 *
 */

/* 
 * Note: this is not the typical automatically generated by a configure script.
 * POV-Ray has been using a configure.h file since long before it was using
 * automake.  If you're looking for the automatically generated header file,
 * try conf.h in the parent directory.
 */


#ifndef POV_UNIX_CONFIG_H
#define POV_UNIX_CONFIG_H


/****************************************************************************
 * Includes
 ****************************************************************************/

#include <algorithm>
#include <limits.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>

/*
 * [NC] For POVMS message passing.
 * Workaround for the old "linux workaround" in pngconf.h (called by png.h).
 * The required  #include <setjmp.h>  is thus done only once.
 * Suggested by [trf].
 */
#ifdef __linux__
# include "png.h"
#else
# include <setjmp.h>
#endif

#ifdef HAVE_CONFIG_H
# include "conf.h"  // must come before unix.h
#else
# error "!!!!! conf.h is required !!!!!"
#endif

#include "unix.h"

using std::max;
using std::min;


/****************************************************************************
 * Constants
 ****************************************************************************/

/*
 * Who we are.
 */
#define POVRAY_PLATFORM_NAME        "Unix"


/*
 * POVMS stuff.
 */
#define POVMS_ALLOW_BINARY_MODE     1
#define ALTMAIN                     1
#define USE_LOCAL_POVMS_OUTPUT      1


/*
 * Try to use system specified values for the maximum filename length, or
 * at least some Unix sized ones, rather than DOS sized ones.
 */
#if defined (PATH_MAX)
# define POV_NAME_MAX   PATH_MAX
#elif defined (_POSIX_PATH_MAX)
# define POV_NAME_MAX   _POSIX_PATH_MAX
#else
# define POV_NAME_MAX   200
#endif

#define FILE_NAME_LENGTH  POV_NAME_MAX


/*
 * This is the image file format that POV will choose by default if none is
 * specified on the command-line.  Although the default value is already 't'
 * for TGA format files, many Unix sites may want to change this to 'p' to
 * get ppm format files, which more Unix utilities understand.
 */
#define DEFAULT_OUTPUT_FORMAT  'n'  // [NC] was 't' for TGA, now PNG


/*
 * This tells frame.h to use sysproto.h as the last include file.
 * Commented out [C.H.] Apr.2004
 */
//#define USE_SYSPROTO


/****************************************************************************
 * Macros
 ****************************************************************************/

// [NC]
// Moved the definition of FINISH_POVRAY to POV_MEM_RELEASE_ALL.
// Hence FINISH_POVRAY can contain calls to POV_MALLOC() and friends
// that won't be reported as memory leaks by mem_release_all().
#define STARTUP_POVRAY         UNIX_startup_povray();
#define FINISH_POVRAY          // nothing
#define POV_MEM_RELEASE_ALL()  UNIX_finish_povray(); \
                               UNIX_free_globals(); \
                               mem_release_all()


/*
 * POVMS stuff.
 */
#define POVRAY_BEGIN_COOPERATE  if(setjmp(globalSetJmpEnv) == 0) {
#define POVRAY_END_COOPERATE    }
#define EXIT_POVRAY(n)          longjmp(globalSetJmpEnv, 1)

/*
 * Namespace.
 */
#ifndef POV_NAMESPACE
# define POV_NAMESPACE pov
# define BEGIN_POV_NAMESPACE  namespace pov { using namespace std;
# define END_POV_NAMESPACE    }
# define USING_POV_NAMESPACE  using namespace pov;
#endif


/*
 * The UNIX precision timer.
 */
#if PRECISION_TIMER_AVAILABLE
# define PRECISION_TIMER_INIT
# define PRECISION_TIMER_START  UNIX_timer_start();
# define PRECISION_TIMER_STOP   UNIX_timer_stop();
# define PRECISION_TIMER_COUNT  UNIX_timer_count();
#endif

#define TIME_ELAPSED (tstop - tstart);


/*
 * This sets up the signal handler during a rendering so that if CTRL-C is
 * pressed, the normal user abort function is called.  If your system
 * doesn't support signal(), you can try to modify these functions to use
 * an available signal function, or just comment these out, although
 * in this case you will lose anything in the output buffer if the trace
 * is interrupted with CTRL-C.
 */
#define POV_PRE_RENDER    UNIX_abort_start();
#define POV_PRE_SHUTDOWN  UNIX_abort_handler(0);


/*
 * This is the render abort function.  It is not needed for the command-line
 * interface, since the abort is handled via interrupts.
 */
#define TEST_ABORT  Stop_Flag += UNIX_test_abort();


/*
 * I/O restrictions.
 */
#define POV_ALLOW_FILE_WRITE(f,t)  UNIX_allow_file_write((f),(t))
#define POV_ALLOW_FILE_READ(f,t)   UNIX_allow_file_read((f),(t))
#define POV_SYSTEM(s)              UNIX_system(s)


/*
 * These are the display routines.
 */
#define POV_DISPLAY_INIT(ref,w,h)  UNIX_display_init((w),(h))
#define POV_DISPLAY_FINISHED(ref)  UNIX_display_finished();
#define POV_DISPLAY_CLOSE(ref)     UNIX_display_close();

#define POV_DISPLAY_PLOT(ref,x,y,r,g,b,a) \
  UNIX_display_plot((x),(y),(r),(g),(b),(a))

#define POV_DISPLAY_PLOT_RECT(ref,x1,y1,x2,y2,r,g,b,a) \
  UNIX_display_plot_rect((x1),(y1),(x2),(y2),(r),(g),(b),(a))

#define POV_DISPLAY_PLOT_BOX(ref,x1,y1,x2,y2,r,g,b,a) \
  UNIX_display_plot_box((x1),(y1),(x2),(y2),(r),(g),(b),(a))


/****************************************************************************
 * Variables
 ****************************************************************************/

/*
 * For POVMS message passing.
 */
extern jmp_buf globalSetJmpEnv;

/*
 * NULL was causing g++ to whine, and 0 fixed the problem.  The solution below
 * is recommended by Stroustrop in _The C++ Programming Language, 3rd Ed_ p. 88
 */
#ifndef NULL
const int NULL 0
#endif


#endif  // POV_UNIX_CONFIG_H
