
/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: PixTimeControl.h,v 1.4 2003/09/16 17:35:32 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_PIXTIMECONTROL_H__
#define INCLUDED_PIXTIMECONTROL_H__

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#include "config.h"

#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include <vector>

#include "Control.h"
#include "Canvas.h"
#include "errors.h"

class PixTimeControl : public Control
{
    public:

               PixTimeControl(Window *pWindow, std::string &oName); 
      virtual ~PixTimeControl(void);
      
      void Transition(ControlTransitionEnum eTrans, Pos *pMousePos);
      virtual void Init(void);
      virtual bool UseToDragWindow(void);
 
      void SetPartName(std::string part, std::string name);

    private:
      void TextChanged(void);

      std::string m_MinuteColon, m_SecondColon, m_Minus, m_HourHundred;
      std::string m_HourTen;
      std::string m_HourOne, m_MinuteTen, m_MinuteOne, m_SecondTen; 
      std::string m_SecondOne;
};

#endif

/* arch-tag: 589f7d62-cb37-4bf9-a781-cf8dd4458433
   (do not change this comment) */
