/* -*- c++ -*-________________________________________________________________
 
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: musicdb.h,v 1.2 2003/09/29 02:29:46 kgk Exp $
 ____________________________________________________________________________*/


#ifndef _MUSICDB_H
#define _MUSICDB_H 1


#include <vector>
#include <map>
#include <set>
#include <string>

#include "config.h"
#include "event.h"
#include "playlist.h"
#include "timer.h"
#include "metadatadb.h"

class FAContext;
class Player;





/**-----------------------------------------------------------------
 * A MusicCollection is the entire accessible music world
 *------------------------------------------------------------------*/
class MusicCollection : public EventQueue
{
public:

public:
    typedef std::string url_t;

    typedef std::vector<std::string> tracklist_t;
    typedef std::vector<std::string> artistlist_t;
    typedef std::vector<std::string> albumlist_t;
    typedef std::vector<std::string> resultlist_t;
    typedef std::map<std::string,std::string> params_t;

    typedef std::vector<MetadataCollection>    vcollection_t;

 public:
    MusicCollection(FAContext *context);
    virtual ~MusicCollection();

    void add(const url_t&);
    void remove(const url_t&);
    /** 
     *  Initiate a search on all known collection to initialize
     *  all metadata.  
     *  @param path  a ':' seperated list of local directories.
     */
    void searchPath(const std::string& path);


    ///////////////////////////////////////////////////////
    //
    /** 
     *  read the contents of the URL.  This URL may be a real
     *  file URL, or a zinf generated URL representing some metadata
     *  For example: 
     *         zinf://artist            return a list of artist names.
     *         zinf://album?artist=<name>  
     *                                  returns a list of albums of the artist
     *         zinf://url?artist=<name>;album=<name> 
     *                                  return a list of tracks in the album
     *         zinf://url               return all tracks available.
     *         zinf://genre             return the list genres
     *         zinf://url?genre=<name>
     *
     *         file://dir1/                   return the contents of dir
     *         file://dir1/dir2/playlist.m3u  return the contents of playlist
     *         file://
     */
    Error readEntries(const url_t& url, resultlist_t& entries) ;

    bool readMetadata(const std::string&url, Metadata&md);
    bool saveMetadata(const std::string&url, const Metadata&md);

    void addURL(const url_t&url, Metadata&);
    void removeURL(const url_t& url);
    bool containsURL(const url_t&);

    ////////////////////////////////////
    //  Builtin queries

    /** append the list of known artists to the given list */
    Error getArtistList(resultlist_t& artistlist);
    Error getAlbumList(const std::string& artist, resultlist_t&albums);
    Error getTrackList(resultlist_t& tracks);
    Error getTrackList(const std::string&artist, resultlist_t&);
    Error getTrackList(const std::string&artist, const std::string&album,
                       resultlist_t& );
    Error getStreamList(resultlist_t& );
    Error getPlaylists(resultlist_t& );
    Error getGenres(resultlist_t& genrelist);

    /** find URLs with No metadata */
    Error getUncategorized(resultlist_t&);


    /** Listen for application events */
    virtual Error AcceptEvent(Event *e);

private:
    static void search_thread(void *arg);
    void search(const std::string&dir);

    /** Helper function for readEntries */


    Error readDirEntries(const url_t& url, tracklist_t&entries);
    Error readPlaylistEntries(const url_t&url,  resultlist_t&);
    Error readZinfEntries(const url_t& url, resultlist_t&entries);
    int32_t parseQueryPath(const std::string& path, 
                           std::string& target, params_t& params);

    Error   query(const std::string&, params_t&, resultlist_t&);
    
    FAContext *m_context;

    // MetadataCollection collect many metadata sources in
    // 
    vcollection_t m_collection;
    vcollection_t::iterator m_local;
    vcollection_t::iterator m_stream;
    vcollection_t::iterator m_cd;


    MetadataDB *m_mbdb;
    MetadataDB *m_tags;
    MetadataDB *m_localdb;
    MetadataDB *m_paths;
    //MetadataDB *m_cache;
};



#endif /* _MUSICDB_H */

/* arch-tag: 60f0de87-3c32-440d-9ab9-636f248ccec3 */
