/* -*- c++ -*-________________________________________________________________
 
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: cachedb.h,v 1.1 2003/09/16 17:58:14 kgk Exp $
 ____________________________________________________________________________*/

#ifndef _CACHEDB_H
#define _CACHEDB_H 1


#include "metadatadb.h"

/**
 *  In memory database used to either speed up slow databases or
 *  exapnd searching support for weak databases (key,val) style
 *
 *  This example is extremely simple and only a TEST of concept.
 *  Support for in memory indexes should be added.
 */
class CacheDB : public MetadataDB {
public:
     typedef map_t::iterator iterator;
     typedef map_t::const_iterator const_iterator;

public:
    CacheDB();
    ~CacheDB();
    
    bool add(const url_t& url, const Metadata&);
    bool remove(const url_t&url);
    bool contains(const url_t&url);

    bool getMetadata(const url_t&url, Metadata&m);
    bool setMetadata(const url_t&url, const Metadata&m);

    Error query (const std::string&target, 
                 const params_t& params,
                 result_t& results);



    bool permitWrites(bool) { return false; }
    void setPriority(int spot);
    int  getPriority();

    iterator begin() { return m_map.begin(); }
    iterator end() { return m_map.end(); }
private:
    void reload(MetadataDB* diskdb);
    void internalAdd(const element_t&);
    bool metadata_match(const params_t& params, Metadata& md);
    Error queryTracks(const params_t& params, result_t& results);

    map_t   m_map;
};

#endif /* _CACHEDB_H */

/* arch-tag: a8d328d0-8a74-43e5-81f1-f8c45c5836ed */
