/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

	Portions Copyright (C) 1998-1999 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: properties.cpp,v 1.2 2003/11/11 19:59:07 kgk Exp $
____________________________________________________________________________*/

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#ifdef WIN32
#pragma warning(disable:4786) 
#endif


#include <stdint.h>
// #include <map>
#include <vector>
#include <string>

using namespace std;
#include "properties.h"
#include "debug.h"



class PropElem 
{
   public:
       PropElem() 
         { m_val = NULL; }
      ~PropElem() 
         {  
            if (m_val) 
            {
               Debug_v("Propelem: delete %p", m_val);
               delete m_val; 
            }   
         }
         
      std::vector<PropertyWatcher *> m_propWatchers;
      PropValue *m_val;
};



Properties::Properties() 
{
}

Properties::~Properties() 
{
}

Error Properties::GetProperty(const std::string& prop, PropValue **ppVal) 
{
    Error rtn = kError_UnknownErr;
    m_lock.Acquire();
    if (ppVal) 
    {
	   *ppVal = NULL;

       map<string, PropElem *>::iterator i;
       i = m_props.find(prop);
       if (i != m_props.end()) 
         {
           *ppVal = (*i).second->m_val;
           rtn = kError_NoErr;
         }
    }
    m_lock.Release();
    return rtn;
}

Error Properties::SetProperty(const std::string& prop, PropValue *pVal) 
{
    Error rtn = kError_UnknownErr;
    m_lock.Acquire();

    map<string, PropElem *>::iterator  i;
    PropElem                                *ppe;
    i = m_props.find(prop);
       
    bool needToAddItem = false;
    if (i == m_props.end()) 
    {
      ppe = new PropElem();
      needToAddItem = true;
    }
    else
      ppe = (*i).second;
           
    if (ppe->m_val) 
    {
      delete ppe->m_val;
    }
    ppe->m_val = pVal;
    if (needToAddItem) 
    {
      m_props[prop] = ppe;
    }   
          
    PropertyWatcher *pw = NULL;
       
    for(uint32_t j = 0; j < ppe->m_propWatchers.size(); j++) 
    {
      pw = ppe->m_propWatchers[j];
      if (pw) 
        {
          pw->PropertyChange( prop, pVal);
        }
    }
    rtn = kError_NoErr;
    
    m_lock.Release();
    return rtn;
}

Error Properties::RegisterPropertyWatcher(const std::string& prop, PropertyWatcher *pw) 
{
    Error rtn = kError_UnknownErr;
    m_lock.Acquire();

    map<string, PropElem *>::iterator i;
    i = m_props.find(prop);
        
    if (i != m_props.end()) 
    {
      PropElem *ppe = (*i).second;
            
      ppe->m_propWatchers.push_back(pw);
      rtn = kError_NoErr;
    }

    m_lock.Release();
    return rtn;
}

Error Properties::RemovePropertyWatcher(const std::string& prop, PropertyWatcher *pw) 
{
    Error rtn = kError_UnknownErr;
    m_lock.Acquire();

    map<string, PropElem *>::iterator i;
    vector<PropertyWatcher *>::iterator j;
    i = m_props.find(prop);
        
    if (i != m_props.end()) 
    {
      PropElem *ppe = (*i).second;
           
      for (j = ppe->m_propWatchers. end(); 
           j >= ppe->m_propWatchers.begin(); j--)
      {
        if (pw == *j)
          ppe->m_propWatchers.erase(j);
      }
	       rtn = kError_NoErr;
    }
	
    m_lock.Release();
    return rtn;

}



/* arch-tag: 80e89c58-c93b-421a-85cc-06eb7cbf3973
   (do not change this comment) */
