/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import Ice.TimeoutException;
import IceGrid.ApplicationInfo;
import IceGrid.ApplicationUpdateInfo;
import IceGrid._ApplicationObserverDisp;
import IceGridGUI.Coordinator;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

class ApplicationObserverI
extends _ApplicationObserverDisp {
    private final Coordinator _coordinator;
    private final boolean _trace;
    private boolean _initialized = false;
    private final String _instanceName;
    private int _serial;
    private List _applications;

    ApplicationObserverI(String instanceName, Coordinator coordinator) {
        this._instanceName = instanceName;
        this._coordinator = coordinator;
        this._trace = coordinator.traceObservers();
    }

    synchronized void waitForInit() {
        long timeout = 10000L;
        if (!this._initialized) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this._initialized) {
            throw new TimeoutException();
        }
        this._coordinator.applicationInit(this._instanceName, this._serial, this._applications);
    }

    public synchronized void applicationInit(int serial, List applications, Current current) {
        if (this._trace) {
            if (applications.size() == 0) {
                this._coordinator.traceObserver("applicationInit (no application);serial is " + serial);
            } else {
                String names = "";
                Iterator p = applications.iterator();
                while (p.hasNext()) {
                    names = names + " " + ((ApplicationInfo)p.next()).descriptor.name;
                }
                this._coordinator.traceObserver("applicationInit for application" + (applications.size() == 1 ? "" : "s") + names + "; serial is " + serial);
            }
        }
        this._initialized = true;
        this._serial = serial;
        this._applications = applications;
        this.notify();
    }

    public void applicationAdded(final int serial, final ApplicationInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("applicationAdded for application " + info.descriptor.name + "; serial is " + serial);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ApplicationObserverI.this._coordinator.applicationAdded(serial, info);
            }
        });
    }

    public void applicationRemoved(final int serial, final String name, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("applicationRemoved for application " + name + "; serial is " + serial);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ApplicationObserverI.this._coordinator.applicationRemoved(serial, name);
            }
        });
    }

    public void applicationUpdated(final int serial, final ApplicationUpdateInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("applicationUpdated for application " + info.descriptor.name + "; serial is " + serial);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ApplicationObserverI.this._coordinator.applicationUpdated(serial, info);
            }
        });
    }
}

