/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import IceUtil.OutputBase;
import java.io.PrintWriter;
import java.util.LinkedList;

public class XMLOutput
extends OutputBase {
    private LinkedList _elementStack = new LinkedList();
    boolean _se = false;
    boolean _text = false;
    private boolean _sgml = false;
    private boolean _escape = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMLOutput() {
    }

    public XMLOutput(PrintWriter writer) {
        super(writer);
    }

    public XMLOutput(String s) {
        super(s);
    }

    public void setSGML(boolean sgml) {
        this._sgml = true;
    }

    public void print(String s) {
        if (this._se) {
            this._out.print('>');
            this._se = false;
        }
        this._text = true;
        if (this._escape) {
            String escaped = this.escape(s);
            super.print(escaped);
        } else {
            super.print(s);
        }
    }

    public XMLOutput write(String s) {
        this.print(s);
        return this;
    }

    public void nl() {
        if (this._se) {
            this._se = false;
            this._out.print('>');
        }
        super.nl();
    }

    public XMLOutput se(String element) {
        this.nl();
        if (this._escape) {
            this._out.print('<');
            this._out.print(this.escape(element));
        } else {
            this._out.print('<');
            this._out.print(element);
        }
        this._se = true;
        this._text = false;
        int pos = element.indexOf(32);
        if (pos == -1) {
            pos = element.indexOf(9);
        }
        if (pos == -1) {
            this._elementStack.addFirst(element);
        } else {
            this._elementStack.addFirst(element.substring(0, pos));
        }
        ++this._pos;
        this.inc();
        this._separator = false;
        return this;
    }

    public XMLOutput ee() {
        String element = (String)this._elementStack.removeFirst();
        this.dec();
        if (this._se) {
            if (this._sgml) {
                this._out.print("></");
                this._out.print(element);
                this._out.print(">");
            } else {
                this._out.print("/>");
            }
        } else {
            if (!this._text) {
                this.nl();
            }
            this._out.print("</");
            this._out.print(element);
            this._out.print(">");
        }
        --this._pos;
        this._se = false;
        this._text = false;
        return this;
    }

    public XMLOutput attr(String name, String value) {
        if (!$assertionsDisabled && !this._se) {
            throw new AssertionError();
        }
        this._out.print(" ");
        this._out.print(name);
        this._out.print("=\"");
        this._out.print(this.escape(value));
        this._out.print("\"");
        return this;
    }

    public XMLOutput startEscapes() {
        this._escape = true;
        return this;
    }

    public XMLOutput endEscapes() {
        this._escape = false;
        return this;
    }

    public String currentElement() {
        if (this._elementStack.size() > 0) {
            return (String)this._elementStack.getFirst();
        }
        return "";
    }

    private String escape(String input) {
        String v = input;
        String allReserved = "<>'\"&";
        boolean hasReserved = false;
        char[] arr = input.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if ("<>'\"&".indexOf(arr[i]) == -1) continue;
            hasReserved = true;
            break;
        }
        if (hasReserved) {
            if (v.indexOf(38) != -1) {
                v = v.replaceAll("&", "&amp;");
            }
            if (v.indexOf(62) != -1) {
                v = v.replaceAll(">", "&gt;");
            }
            if (v.indexOf(60) != -1) {
                v = v.replaceAll("<", "&lt;");
            }
            if (v.indexOf(39) != -1) {
                v = v.replaceAll("'", "&apos;");
            }
            if (v.indexOf(34) != -1) {
                v = v.replaceAll("\"", "&quot;");
            }
        }
        return v;
    }

    static {
        $assertionsDisabled = !XMLOutput.class.desiredAssertionStatus();
    }
}

