/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.Transceiver;
import IceUtil.Base64;
import java.util.ArrayList;

final class UnknownEndpointI
extends EndpointI {
    private short _type;
    private byte[] _rawBytes;
    private int _hashCode;

    public UnknownEndpointI(String str) {
        int topt = 0;
        int vopt = 0;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block6: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                throw new EndpointParseException("opaque " + str);
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-') {
                argument = arr[i++];
            }
            switch (option.charAt(1)) {
                case 't': {
                    int t;
                    if (argument == null) {
                        throw new EndpointParseException("opaque " + str);
                    }
                    try {
                        t = Integer.parseInt(argument);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("opaque " + str);
                    }
                    if (t < 0 || t > 65535) {
                        throw new EndpointParseException("opaque " + str);
                    }
                    this._type = (short)t;
                    ++topt;
                    continue block6;
                }
                case 'v': {
                    if (argument == null) {
                        throw new EndpointParseException("opaque " + str);
                    }
                    for (int j = 0; j < argument.length(); ++j) {
                        if (Base64.isBase64(argument.charAt(j))) continue;
                        throw new EndpointParseException("opaque " + str);
                    }
                    this._rawBytes = Base64.decode(argument);
                    ++vopt;
                    continue block6;
                }
            }
            throw new EndpointParseException("opaque " + str);
        }
        if (topt != 1 || vopt != 1) {
            throw new EndpointParseException("opaque " + str);
        }
    }

    public UnknownEndpointI(short type, BasicStream s) {
        this._type = type;
        s.startReadEncaps();
        int sz = s.getReadEncapsSize();
        this._rawBytes = s.readBlob(sz);
        s.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort(this._type);
        s.startWriteEncaps();
        s.writeBlob(this._rawBytes);
        s.endWriteEncaps();
    }

    public String _toString() {
        String val = Base64.encode(this._rawBytes);
        return "opaque -t " + this._type + " -v " + val;
    }

    public short type() {
        return this._type;
    }

    public int timeout() {
        return -1;
    }

    public EndpointI timeout(int t) {
        return this;
    }

    public EndpointI connectionId(String connectionId) {
        return this;
    }

    public boolean compress() {
        return false;
    }

    public EndpointI compress(boolean compress) {
        return this;
    }

    public boolean datagram() {
        return false;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return true;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Transceiver serverTransceiver(EndpointIHolder endpoint) {
        endpoint.value = null;
        return null;
    }

    public Connector connector() {
        return null;
    }

    public Acceptor acceptor(EndpointIHolder endpoint, String adapterName) {
        endpoint.value = null;
        return null;
    }

    public ArrayList expand(boolean server) {
        ArrayList<UnknownEndpointI> endps = new ArrayList<UnknownEndpointI>();
        this.calcHashValue();
        endps.add(this);
        return endps;
    }

    public boolean publish() {
        return false;
    }

    public boolean equivalent(Transceiver transceiver) {
        return false;
    }

    public boolean equivalent(Acceptor acceptor) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        UnknownEndpointI p = null;
        try {
            p = (UnknownEndpointI)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._type < p._type) {
            return -1;
        }
        if (p._type < this._type) {
            return 1;
        }
        if (this._rawBytes.length < p._rawBytes.length) {
            return -1;
        }
        if (p._rawBytes.length < this._rawBytes.length) {
            return 1;
        }
        for (int i = 0; i < this._rawBytes.length; ++i) {
            if (this._rawBytes[i] < p._rawBytes[i]) {
                return -1;
            }
            if (p._rawBytes[i] >= this._rawBytes[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean requiresThreadPerConnection() {
        return false;
    }

    private void calcHashValue() {
        this._hashCode = this._type;
        for (int i = 0; i < this._rawBytes.length; ++i) {
            this._hashCode = 5 * this._hashCode + this._rawBytes[i];
        }
    }
}

