/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.ObjectPrx;
import IceGrid.AdapterDescriptor;
import IceGrid.AdapterDynamicInfo;
import IceGrid.DbEnvDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.ServiceInstanceDescriptor;
import IceGridGUI.LiveDeployment.Adapter;
import IceGridGUI.LiveDeployment.DbEnv;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ListArrayTreeNode;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.Server;
import IceGridGUI.LiveDeployment.ServiceEditor;
import IceGridGUI.Utils;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Service
extends ListArrayTreeNode {
    private ServiceInstanceDescriptor _instanceDescriptor;
    private ServiceDescriptor _serviceDescriptor;
    private Utils.Resolver _resolver;
    private List _adapters = new LinkedList();
    private List _dbEnvs = new LinkedList();
    private static ServiceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/service.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/service.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new ServiceEditor();
        }
        _editor.show(this);
        return _editor;
    }

    Service(Server parent, String serviceName, Utils.Resolver resolver, ServiceInstanceDescriptor descriptor, ServiceDescriptor serviceDescriptor) {
        super(parent, serviceName, 2);
        this._resolver = resolver;
        this._instanceDescriptor = descriptor;
        this._serviceDescriptor = serviceDescriptor;
        this._childrenArray[0] = this._adapters;
        this._childrenArray[1] = this._dbEnvs;
        this.createAdapters();
        this.createDbEnvs();
    }

    boolean updateAdapter(AdapterDynamicInfo info) {
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(info)) continue;
            return true;
        }
        return false;
    }

    int updateAdapters(List infoList) {
        int result = 0;
        Iterator p = this._adapters.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(infoList)) continue;
            ++result;
        }
        return result;
    }

    void nodeDown() {
        Iterator p = this._adapters.iterator();
        while (p.hasNext()) {
            Adapter adapter = (Adapter)p.next();
            adapter.update((AdapterDynamicInfo)null);
        }
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    ServiceDescriptor getServiceDescriptor() {
        return this._serviceDescriptor;
    }

    SortedMap getProperties() {
        Utils.ExpandedPropertySet instancePropertySet = null;
        Node node = (Node)this._parent.getParent();
        String applicationName = ((Server)this._parent).getApplication().name;
        if (this._instanceDescriptor != null) {
            instancePropertySet = node.expand(this._instanceDescriptor.propertySet, applicationName, this._resolver);
        }
        Utils.ExpandedPropertySet propertySet = node.expand(this._serviceDescriptor.propertySet, applicationName, this._resolver);
        return Utils.propertySetToMap(propertySet, instancePropertySet, this._resolver);
    }

    private void createAdapters() {
        Iterator p = this._serviceDescriptor.adapters.iterator();
        while (p.hasNext()) {
            AdapterDescriptor descriptor = (AdapterDescriptor)p.next();
            String adapterName = Utils.substitute(descriptor.name, this._resolver);
            String adapterId = Utils.substitute(descriptor.id, this._resolver);
            ObjectPrx proxy = null;
            if (adapterId.length() > 0) {
                proxy = ((Node)this._parent.getParent()).getProxy(adapterId);
            }
            this.insertSortedChild(new Adapter(this, adapterName, this._resolver, adapterId, descriptor, proxy), this._adapters, null);
        }
    }

    private void createDbEnvs() {
        Iterator p = this._serviceDescriptor.dbEnvs.iterator();
        while (p.hasNext()) {
            DbEnvDescriptor descriptor = (DbEnvDescriptor)p.next();
            String dbEnvName = Utils.substitute(descriptor.name, this._resolver);
            this.insertSortedChild(new DbEnv(this, dbEnvName, this._resolver, descriptor), this._dbEnvs, null);
        }
    }
}

