/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---screen.h----*********************/


#ifndef __SCREEN_H__
#define __SCREEN_H__

#ifdef OPENSERVER
#include <sys/comcrt.h>
#endif

/*
 * Maximum number of control sequence parameters in
 * an escape sequence.
 */
#ifndef OPENSERVER
#define NCSPARAMS	5
#else
#define NCSPARAMS	3
#endif

/*
 * Commands to the (*v_sgr)() routine.
 * Defined by ANSI
 */
#define SGR_NORMAL		0	/* return attributes to normal	*/
#define SGR_BOLD		1	/* called INTENSE in video'ese	*/
#define SGR_FAINT		2	/* NOT-supported		*/
#define SGR_PRCOLORS		2	/* PR's set the normal colors	*/
#define SGR_ITALIC		3	/* NOT-supported		*/
#define SGR_PRBLKCTL		3	/* PR's blink bit control	*/
#define SGR_UNDERL		4	/* underline			*/
#define SGR_BLINK		5	/* blink			*/
#define SGR_FBLINK		6	/* turn off blink		*/
#define SGR_REVERSE		7	/* reverse video w/ setcolor	*/
#define SGR_CONCEALED		8	/* hide characters		*/
#define SGR_CROSSED		9	/* NOT-supported		*/
#define SGR_FONT		10	/* fonts 0 through 9 w/ 10-19	*/
#define SGR_GOTHIC		20	/* NOT-supported		*/
#define SGR_DLBUNDERL		21	/* NOT-supported		*/
#define SGR_NORMCI		22	/* NOT-supported		*/
#define SGR_0ITALIC		23	/* NOT-supported		*/
#define SGR_0UNDERL		24	/* NOT-supported		*/
#define SGR_0BLINK		25	/* NOT-supported		*/
#define SGR_RES1		26	/* RESERVED by ANSI		*/
#define SGR_0REVERSE		27	/* NOT-supported		*/
#define SGR_0CONCEALED		28	/* NOT-supported		*/
#define SGR_0CROSSED		29	/* NOT-supported		*/
#define SGR_FORECOLOR		30	/* ANSI foreground colors 30-37	*/
#define SGR_RES2		38	/* RESERVED by ANSI 		*/
#define SGR_DEFFOREFOL		39	/* NOT-supported		*/
#define SGR_BACKCOLOR		40	/* ANSI background colors 40-47	*/
#define SGR_RES3		48	/* RESERVED by ANSI		*/
#define SGR_DEFBACKCOL		49	/* NOT-supported		*/

#define	VGA_GETPALLET		75 	/* get current video pallet   	*/
#define	VGA_SETPALLET		76 	/* set video pallet 	     	*/
#define	VGA_RSTPALLET		77 	/* reset video pallet to std   	*/

/*
 * Commands to the (*v_adapctl)() routine.
 * Defined by SCO
 */
#define	AC_BLINKB		0	/* Clear or Set the blink bit	*/
#define	AC_FONTCHAR		1	/* display font character	*/
#define	AC_DEFCSR		2	/* define Cursor type		*/
#define AC_BOLDBKG		3	/* turn on intense bg color	*/
#define AC_BOLDF		4	/* geng turn on intense fg colo	*/

#define	AC_DEFNF		10	/* define normal foreground	*/
#define	AC_DEFNB		11	/* define normal background	*/
#define	AC_ONN			12	/* begin using normal colors	*/
#define	AC_DEFRF		13	/* define reverse foreground	*/
#define	AC_DEFRB		14	/* define reverse background	*/
#define	AC_ONR			15	/* turn on reverse colors	*/
#define	AC_DEFGF		16	/* define graphic foreground	*/
#define	AC_DEFGB		17	/* define graphic background	*/
#define	AC_ONG			18	/* turn on graphic colors	*/
#define	AC_SETOS		30	/* set overscan colors		*/
#define AC_PRIMODE		100	/* return primary text mode	*/
#define AC_SAVSZQRY		101	/* return size (bytes) of state	*/
#define AC_SAVSCRN		102	/* save screen			*/
#define AC_RESSCRN		103	/* restore screen		*/
#define AC_CSRCTL		104	/* arg=0 hide cursor, arg=1 show cursor	*/
#define AC_USERFONT		105	/* load or dump the soft font	*/
#define AC_IOPRIVL		106	/* grant or revoke IO privl	*/
#define AC_SOFTRESET		107	/* reset text mode (keep colors)*/
#define AC_SENDSCRN		108	/* write screen chars to stdin	*/
#define AC_ONSCREEN 		109 	/* turn video on.              	*/
#define AC_OFFSCREEN		110	/* turn video off		*/
#define AC_GETCOLOR		111	/* get current, reverse, graphic colour */

#define AC_VTKDPARAM		200	/* get VP/ix display parameters	VPIX	*/
#define AC_TXTRECVR		201	/* recover text mode from DOS	VPIX	*/
#define AC_TXTRELSE		202	/* release text mode to DOS	VPIX	*/
#define AC_OFFVIDEO		203	/* turn off video output	VPIX	*/

typedef short 			*vseg_t;	/* pointer to video segment of  short's */


struct colors {
	char fore;				/* foreground color	*/
	char back;				/* background colors	*/
};
/*** #endif*/


#define	BLACK		0x0
#define	BLUE		0x1
#define	GREEN		0x2
#define	CYAN		0x3
#define	RED		0x4
#define	MAGENTA		0x5
#define	BROWN		0x6
#define	WHITE		0x7
#define	GRAY		0x8
#define	LT_BLUE		0x9
#define	LT_GREEN	0xA
#define	LT_CYAN		0xB
#define	LT_RED		0xC
#define	LT_MAGENTA	0xD
#define	YELLOW		0xE
#define	HI_WHITE	0xF

#define CUR_HIDDEN	0x80
#define CUR_LOCK	0x40
#define CUR_ON		0x1

typedef char  		* faddr_t;
#define MAXFK 		30

/* Data for accessing an adapter driver.*/
struct adapter {
   	void (*v_scroll)();
	void (*v_copy)();
	void (*v_clear)();
	void (*v_pchar)();	/* put a string of characters	*/
	void (*v_scurs)();	/* set the active and cursor position	*/
	void (*v_sgr)();	/* set graphic rendition; see Ansi X.64	*/
        int (*v_adapctl)();	/* Adapter specific misc other stuff	*/
	faddr_t v_videoram;     /*Kernel pointer to video ram*/
        ushort v_vidoff;                /*Offset of video ram */
};

struct screen {
	struct adapter *mv_adapter;   	/* ptr to the screen's adapter	*/
	faddr_t 	mv_savscrn;	/* save screen RAM   		*/
	unsigned 	mv_savsz;	/* size of save screen used	*/
	faddr_t 	mv_smap;	/* font value translation table	*/
	u_char 		mv_font;	/* ANSI font, one of 0, 1, or 2	*/
	faddr_t 	mv_font_text;	/* ANSI text font	*/
	faddr_t 	mv_font_bold;	/* ANSI bold font	*/
	faddr_t 	mv_ch_font;	/* Chinese font		*/
	ushort 		mv_tmpcol;	/* used by ANSI.c	*/
	ushort 		mv_row, mv_col;	/* cursor position	*/
	ushort 		mv_rsz, mv_csz, mv_top;	/* text screen siz*/
	int 		mv_wrap;  
	unsigned int 	mv_tabstop[5];	
	ushort 		mv_csstate;	/* Ctl Sequ state		*/
	ushort 		mv_csparam[NCSPARAMS];	/* Ctl Sequ parameters	*/
	u_char 		mv_csindex;	/* Ctl Sequ parameter index	*/
	u_char 		mv_cstyp;	/* cursor type			*/
	u_char 		mv_curflg;	/* cursor statue flag		*/
	struct colors	mv_norm,	/* normal attributes		*/
			mv_rev,		/* reverse video attributes	*/
			mv_grfc;	/* graphic character attributes	*/
        u_char 		mv_ovscan;	/* border color			*/
      
	char 		mk_qstr[MAXFK];	/* work space for func. key conf*/
	ushort 		mb_time;	/* bell duration 1/10 secs 	*/
	ushort 		mb_freq;	/* bell frequency (pitch) 	*/

	ushort 		mf_savrow;	/* ^[7 or ^[[s save current row & col	*/
	ushort 		mf_savcol;	/* ^[8 or ^[[u restore row & col	*/
	ushort 		mf_status;	/* terminal status bit field		*/

	/*
	 * Defines for mf_status.
	 */
#define MFS_SND_SCRN	0x0001		/* currently send screening		*/
#define MFS_KBD_LOCK	0x0002		/* keyboard is locked			*/
#define MFS_TEXTMODE	0x0004		/* textmode (not graphics mode)		*/
#define MFS_LOSTPUTC	0x0008		/* kernl putc's lost in grafixs		*/
#define MFS_NOMARGIN	0x0010		/* no automargin mode			*/
#define MFS_PROCMODE	0x0020		/* screen has VPix handler proc	VPIX 	*/
#define MFS_VTWAIT	0x0040		/* writes to noncur scrs, block VPIX 	*/
#define MFS_VTMAPPED	0x0080		/* display is mapped VPix style	VPIX 	*/
#define	MFS_TMODES	0x0300		/* mask for text modes.			*/
#define	MFS_REVSTEXT	0x0100		/* display is reverse video text	*/
#define	MFS_GRAFTEXT	0x0200		/* display is in graphics text		*/
#define MFS_FILLNORM	0x0400		/* fill new region w/ norm attr 	*/
#define MFS_KEYCLICK	0x0800		/* keyclick is on               	*/
#define MFS_IBCS2	0x1000		/* CSI n g = clear tabs			*/
#define MFS_ANSI	0x2000		/* CSI 0 m, dont reset font		*/

#ifdef linux
#define MFS_BOLD	0x4000
#define MFS_BLINK	0x8000
#endif

	/*
	 * Per Screen hardware fields for use by the adapter drivers.
	 * Each adapter driver uses this area in any manner it choses.
	 * If the adapter driver wished to make use of m6845.c then
	 * the first 8 bytes of the adapter area must match m6845_a.
	 */
	u_char adp_area[32];	/***song change type from uchar_t to u_char*/
};


#define TEXTMODE(msp)	(MFS_TEXTMODE & (msp)->mf_status)
#define SCREENSZ(msp)	((msp)->mv_rsz * (msp)->mv_csz)
#define CURSOR(msp)	((msp)->mv_row * (msp)->mv_csz + (msp)->mv_col)
#define CURSOR_G(msp)	((msp)->mv_row * 18 * (msp)->mv_csz + (msp)->mv_col)

extern struct screen	g_scrn;
extern char		ansicolormap[];
extern int		bottom_disable;

void    redrawbottom(struct screen *scrn,int x,int y,int color);
void    ClearBottom(struct screen *scrn);
void    PutCC16(struct screen *scrn,int x,int y,int color, u_char *str);
void    Writebackground(struct screen *scrn);

struct port_io_struct {
   	char dir;	/*direction flag*/
        unsigned short port;
        char data;
};
        
#endif
