/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---impi.h----*********************/
/*
 * Input Method to Platform Interface
 */

#ifndef __IMPI_H__
#define __IMPI_H__

#define KEY_BACKSPACE		8
#define KEY_SPACE		32
#define KEY_ENTER		13

#ifdef __cplusplus
extern "C" {
#endif

/*
 * The input method should declare the following variables and functions
 */
extern char	imname[];				/* The name of IM */
extern char	imdscrpt[];				/* The description of IM */

int		IMInit();
int		IMClearup();
int		IMSelect(int select);
int		IMFilter(int ch);

/*
 * The input method should use the following variables to output
 */
extern int	maxeclen;				/* The maximum length of external code */
extern int	eclen;					/* The length of external code */
extern char	extcode[];				/* External code */
extern char	candstr[];				/* Candinate string */
extern char	result[];				/* Result string */

/*
 * handle_punct is designed for map a ban-jiao punctuation to quan-jiao
 * punctuation.
void	handle_punct(int ch);

/*
 * shmloadfile is designed for loading a file to a shared memory segment.
 */
void	*shmloadfile(char *path, int *plen, int magic);

#ifdef __cplusplus
}
#endif

#endif

