///
///  Copyright (C) 2004-2006 Andrej Vodopivec <andrejv@users.sourceforge.net>
///
///  This program is free software; you can redistribute it and/or modify
///  it under the terms of the GNU General Public License as published by
///  the Free Software Foundation; either version 2 of the License, or
///  (at your option) any later version.
///
///  This program is distributed in the hope that it will be useful,
///  but WITHOUT ANY WARRANTY; without even the implied warranty of
///  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
///  GNU General Public License for more details.
///
///
///  You should have received a copy of the GNU General Public License
///  along with this program; if not, write to the Free Software
///  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///

#ifndef _MATHPRINTOUT_H
#define _MATHPRINTOUT_H

#include "Setup.h"

#if WXM_PRINT

#include <wx/wx.h>
#include <wx/print.h>

#include <vector>

#include "MathCell.h"

using namespace std;

class MathPrintout : public wxPrintout
{
public:
  MathPrintout(wxString title);
  ~MathPrintout();
  void DestroyTree();
  void DestroyTree(MathCell* tree);
  void SetData(MathCell* tree);
  void SetupData();
  void BreakLines();
  void BreakPages();
  void RecalculateSize();
  bool OnPrintPage(int num);
  bool HasPage(int num);
  void GetPageInfo(int* minPage, int* maxPage, int* pageFrom, int* pageTo);
  bool OnBeginDocument(int startPage, int endPage);
  void OnPreparePrinting();
  void GetPageMargins(int* horizontal, int* vertical);
  int GetHeaderHeight();
  void PrintHeader(int pageNum, wxDC* dc, double scale);
  void RecalculateWidths();
  double GetPPIScale();
  void GetScreenScale(double *scaleX, double *scaleY);
  void BreakUpCells();
private:
  int m_numberOfPages;
  wxString m_title;
  MathCell* m_tree;
  vector<MathCell*> m_pages;
};

#endif

#endif
