/*
 * Program: wwl
 * 
 * Description: Given two Maidenhead locators, 
 *              calculates distance and azimuth.
 *
 * Revision: 1.2  2000/11/03
 * + fixed a compile warning telling main() was not
 *   of type int, infact it was void!
 * + added a Makefile
 * 
 * Revision: 1.1  1998/05/22
 * First release
 *
 * (C) 1998-2000 by IK0ZSN Mirko Caserta <ik0zsn@amsat.org>
 * This software is placed under the terms of the 
 * GNU General Public Licence that you may find at
 * http://www.gnu.org/
 *
 * Warning: this short program has been my first attempt in
 *          C programming. It is a translation in C of an original
 *          BASIC software written by I0FLY. My software shows most
 *          of C programming errors such as not commenting anything
 *          and using not-meaningful variable names. Never program
 *          like this! This program could have been written much better
 *          than I did but I have no time to fix it now. You are welcome
 *          to do it and send me patches anyhow.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main (int argc, char **argv) {

  int l, p;
  float z, y, n, h, x, w, f, t, s, v, u, c, d, e, lx;
  char my_wwl[6], dx_wwl[6];

  printf("wwl 1.2 - given two maidenhead locators,\n");
  printf("          calculates distance (qrb) and azimuth.\n\n");

  if (argc != 3) {
    printf("Usage: wwl my_ww_locator dx_ww_locator\n");
    return(1); /* return error */
  }

  if (strlen(argv[1]) != 6) {
    printf("%s: not a valid locator\n", argv[1]);
    return(1); /* return error */
  }
	
  if (strlen(argv[2]) != 6) {
    printf("%s: not a valid locator\n", argv[2]);
    return(1); /* return error */
  }	
	
  strcpy(my_wwl, argv[1]);
  strcpy(dx_wwl, argv[2]);

  if (my_wwl[0] > 97 && my_wwl[0] < 122) { my_wwl[0] = my_wwl[0] - 32; }
  z = my_wwl[0] - 65;
  if (my_wwl[1] > 97 && my_wwl[1] < 122) { my_wwl[1] = my_wwl[1] - 32; }
  y = my_wwl[1] - 65;
  n = my_wwl[2] - 48;
  h = my_wwl[3] - 48;
  if (my_wwl[4] > 97 && my_wwl[4] < 122) { my_wwl[4] = my_wwl[4] - 32; }
  x = my_wwl[4] - 65;
  if (my_wwl[5] > 97 && my_wwl[5] < 122) { my_wwl[5] = my_wwl[5] - 32; }
  w = my_wwl[5] - 65;
  
  if (my_wwl[0] < 65 || my_wwl[0] > 90 ||
      my_wwl[1] < 65 || my_wwl[1] > 90 ||
      my_wwl[2] < 48 || my_wwl[2] > 57 ||
      my_wwl[3] < 48 || my_wwl[3] > 57 ||
      my_wwl[4] < 65 || my_wwl[4] > 90 ||
      my_wwl[5] < 65 || my_wwl[5] > 90 ) {

    printf("%s: not a valid locator\n", my_wwl);
    return(1); /* return error */

  }

  t = z * 20 - 180 + n * 2 + x / 12 + 1;
  t = t * 3.1415926 / 180; 
  s = y * 10 - 90 + h + w / 24 + 1 / 48;
  s = s * 3.1415926 / 180;

  if (dx_wwl[0] > 97 && dx_wwl[0] < 122) { dx_wwl[0] = dx_wwl[0] - 32; }
  z = dx_wwl[0] - 65;
  if (dx_wwl[1] > 97 && dx_wwl[1] < 122) { dx_wwl[1] = dx_wwl[1] - 32; }
  y = dx_wwl[1] - 65;
  n = dx_wwl[2] - 48;
  h = dx_wwl[3] - 48;
  if (dx_wwl[4] > 97 && dx_wwl[4] < 122) { dx_wwl[4] = dx_wwl[4] - 32; }
  x = dx_wwl[4] - 65;
  if (dx_wwl[5] > 97 && dx_wwl[5] < 122) { dx_wwl[5] = dx_wwl[5] - 32; }
  w = dx_wwl[5] - 65;

  if (dx_wwl[0] < 65 || dx_wwl[0] > 90 ||
      dx_wwl[1] < 65 || dx_wwl[1] > 90 ||
      dx_wwl[2] < 48 || dx_wwl[2] > 57 ||
      dx_wwl[3] < 48 || dx_wwl[3] > 57 ||
      dx_wwl[4] < 65 || dx_wwl[4] > 90 ||
      dx_wwl[5] < 65 || dx_wwl[5] > 90 ) {
    printf("%s: not a valid locator\n", dx_wwl);
    return(1); /* return error */
  }

  v = z * 20 - 180 + n * 2 + x / 12 + 1;
  v = v * 3.1415926 / 180;
  u = y * 10 - 90 + h + w / 24 + 1 / 48;
  u = u * 3.1415926 / 180;
	
  c = cos(s) * cos(u) * cos(v - t) + sin(s) * sin(u);
  d = 1 - c * c;
  if (cos(u) * sqrt(d) != 0) {
    e = (sin(s) - sin(u) * c) / (cos(u) * sqrt(d));
    f = fabs(1 - e * e);
    lx = ((3.1415926 / 2) - (atan(- e / sqrt(f)))) * 180 / 3.1415926;
    l = (int) (lx + 0.5);
  } else { l = 0; }
	
  if ((v - t) < 0) { l = 360 - l; }
	
  p = (int) ((atan(sqrt(d) / c) * 6371.33) + .5);
  printf("qrb: %d kilometers, azimuth: %d degrees\n", p, l);

  return(0); /* return successful */
	
}

