/* searchop_resultstore.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "searchop.hh"
#include "nwc_virtualdir.hh"

SearchOp::ResultStore::ResultStore( const std::string &searchname, bool follow_symlinks, bool search_vfs, bool search_same_fs )
{
  _dir = new NWC::VirtualDir( searchname, follow_symlinks, search_vfs, search_same_fs );
  _res = new std::list<SearchThread::SearchResult>;
}

SearchOp::ResultStore::~ResultStore()
{
  delete _dir;
  delete _res;
}

NWC::VirtualDir *SearchOp::ResultStore::getDir()
{
  //TODO returning pointer sucks
  return _dir;
}

std::list<SearchThread::SearchResult> *SearchOp::ResultStore::getRes()
{
  //TODO returning pointer sucks
  return _res;
}

NWC::VirtualDir *SearchOp::ResultStore::getClonedDir() const
{
  NWC::VirtualDir *d = NULL;
  NWC::FSEntry *fse = _dir->clone();
  
  if ( fse != NULL ) {
    d = dynamic_cast<NWC::VirtualDir*>( fse );
  }
  
  if ( d == NULL ) {
      d = new NWC::VirtualDir( "searchdir1", _dir->getFollowSymlinks(), _dir->getSearchVFS(), _dir->getSearchSameFS() );
  }
  return d;
}

void SearchOp::ResultStore::setSearchSettings( const SearchSettings &sets )
{
  _settings = sets;
  _dir->setFollowSymlinks( sets.getFollowSymlinks() );
  _dir->setSearchVFS( sets.getSearchVFS() );
  _dir->setSearchSameFS( sets.getSearchSameFS() );
}

SearchOp::SearchSettings SearchOp::ResultStore::getSearchSettings() const
{
  return _settings;
}

void SearchOp::ResultStore::setActiveRow( int row )
{
  _settings.setActiveRow( row );
}

void SearchOp::ResultStore::removeEntries( const std::list<std::string> &entry_list )
{
  for ( std::list<std::string>::const_iterator it = entry_list.begin();
        it != entry_list.end();
        it++ ) {
    removeEntry( *it );
  }
}

void SearchOp::ResultStore::removeEntry( const std::string &entry )
{
  // firstly remove from _res all entries with equal fullname
  // then remove an entry in the dir with the fullname

  for ( std::list<SearchThread::SearchResult>::iterator it = _res->begin();
        it != _res->end(); ) {
    if ( (*it).getFullname() == entry ) {
      std::list<SearchThread::SearchResult>::iterator erase_it = it;
      it++;

      _res->erase( erase_it );
    } else {
      it++;
    }
  }

  _dir->removeFromList( entry );
}
