/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "qfunciones.h"
//#include "intern.h"
#include <qdir.h>
#include <stdlib.h>
//#include <string.h>

#ifndef NO_GRAPHICS_AT_ALL
#include <qcombobox.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include <qapplication.h>

#if QT_VERSION >=300
#include <qtextedit.h>
#else
#include <qtextbrowser.h>
#endif //QT_VERSION

#endif

bool check_arg(int nargs,int actual) {
	if ( (actual+1) < nargs )
		return true;
	else {
		printf( "Warning: parameter expected\n" );
		return false;
	}
}

QString qNomPersonal(QString name) {
	//debug("name: %s", name.data() );

	QDir d( QDir::home() );
	//debug("Directorio home: %s", d.absPath().data() );

	QString fullName= d.absPath(); //.data();
	fullName += "/";
	fullName += name;

	//debug("Nombre completo: %s", fullName.data() );

	return fullName;
}

int ejecuta(const char *comando) {
#ifdef NO_SYSTEM
	debug("Intento de ejecutar: '%s'",comando);
	return 0;
#else
	//debug("Ejecutando: '%s'",comando);
	return system(comando);
#endif
}


#ifndef NO_GRAPHICS_AT_ALL
void seleccionaItem( QComboBox *cb, const QString& texto ) {
	if (cb==NULL) return;

	for (int n=0; n < cb->count(); n++) {
		//if (strcmp( cb->text(n).latin1(), texto.latin1() ) == 0) {
		if ( cb->text(n) == texto ) {
			cb->setCurrentItem( n );
			return;
		}
	}
}

#if QT_VERSION >= 300
void imprimir_textview(QTextEdit *textview) {
#else
void imprimir_textview(QTextView *textview) {
#endif
	QPrinter printer;
    printer.setFullPage(TRUE);
    if ( printer.setup() ) {
		QPainter p( &printer );
		QPaintDeviceMetrics metrics(p.device());
		int dpix = metrics.logicalDpiX();
		int dpiy = metrics.logicalDpiY();
		const int margin = 72; // pt
		QRect body(margin*dpix/72, margin*dpiy/72,
			   metrics.width()-margin*dpix/72*2,
			   metrics.height()-margin*dpiy/72*2 );
		//QFont font("times", 10);
		QFont font = textview->font();
#if QT_VERSION >= 222
		QSimpleRichText richText( textview->text(), font, textview->context(), 
                      textview->styleSheet(),
					  textview->mimeSourceFactory(), body.height() );
#else
		QSimpleRichText richText( textview->text(), font, textview->context(), 
                      textview->styleSheet());
#endif
		richText.setWidth( &p, body.width() );
		QRect view( body );
		int page = 1;
		do {
			//p.setClipRect( body ); //Nuevo
		    richText.draw( &p, body.left(), body.top(), view, textview->colorGroup() );
			//p.setClipping( FALSE ); //Nuevo
		    view.moveBy( 0, body.height() );
		    p.translate( 0 , -body.height() );
		    p.setFont( font );
		    p.drawText( view.right() - p.fontMetrics().width( QString::number(page) ),
					view.bottom() + p.fontMetrics().ascent() + 5, QString::number(page) );
		    if ( view.top()  >= richText.height() ) break;
		    printer.newPage();
		    page++;
			qApp->processEvents();
		} while (TRUE);
    }
}

#endif

