/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qglobal.h>

#include "QMainWidget.h"
#include "aprender.h"
#include "QSimpleTextBrowser.h"
#include "intern.h"
#include "DiccionarioBase.h"
#include "qfunciones.h"
#include "qdialogos.h"
#include "QClipper.h"

#ifdef SIMPLE_INPUT
#include <qlineedit.h>
#else
#include <qcombobox.h>
#endif

#include <qapplication.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qcursor.h>
#include "pixmaps/traducir.xpm"
//#include "pixmaps/yes.xpm"

#include <qevent.h>
#include <qfont.h>
#include <qfontdialog.h>



QMainWidget::QMainWidget(DiccionarioBase *dict,
					     QWidget* parent, 
                         const char* name) : QWidget( parent, name ) 
{
	hay_error=false;
	con_formato=false;
	//busqueda_rapida=false;

	diccionario=dict;
	trabajando=false;

	creaWidgets();
	
}


QMainWidget::~QMainWidget() {
	delete vista;
	delete inputText;
	delete intro;
	delete box_input;
	delete box;

	delete clipper;
}

void QMainWidget::creaWidgets() {
	vista = new QSimpleTextBrowser( this, "vista" );
	//vista->viewport()->installEventFilter(this);
	//connect( vista, SIGNAL( anchor_clicked( QString ) ),
	//		 this, SLOT( getClipboard( QString ) ) );

	//vista->setTextFormat( Qt::RichText );
	//vista->setText("<qt title=\"Busqueda\"></qt>");

	vista->setMinimumSize( 280, 116 );
	QWhatsThis::add( vista, 
		_("<p>This is the window which shows the results of the search.</p>"
          "<p>You may right-click to pop up a context menu.</p>") );

	connect( vista, SIGNAL(fontCambiado(const QFont&)),
             this, SLOT(slot_cambiadoFontVista(const QFont&)) );

#if QT_VERSION
	connect( vista, SIGNAL(changedDefaultFont(const QFont&)),
             this, SLOT(slot_changedDefaultFont(const QFont&)) );
#endif

	//QToolTip::add( vista, _("This is the window with the results") );

#ifdef SIMPLE_INPUT
	inputText = new QLineEdit( this, "LineEdit_1" );
	inputText->setMinimumSize( 280, 26 );
	connect( inputText, SIGNAL(returnPressed()), SLOT(traduce_actual()) );
#else
	inputText = new QComboBox( true, this, "inputText" );
	inputText->setMinimumSize( 280, 26 );
	inputText->setInsertionPolicy( QComboBox::AtTop );
	inputText->setMaxCount( 30 );
	connect( inputText, SIGNAL(activated(int)), SLOT(traduce(int)) );
	//inputText->installEventFilter( this );
#endif
	QToolTip::add( inputText, _("Enter here the word you want to search") );
	QWhatsThis::add( inputText, 
		_("<p>Here is where you enter the word you want to look for. "
          "You may select the dictionary too, by entering it like in this example: "
          "<code>i2e:car</code</p>"
          "<p>You can also type the following sentences:"
          "<ul>"
          "<li>about:wordtrans</li><li>about:dictionary</li>"
          "<li>about:server</li><li>about:database</li>"
          "</ul></p>") );

	QPixmap icono_intro=QPixmap(traducir_xpm);
	//QPixmap icono_intro=QPixmap(yes_xpm);
	intro=new QPushButton( _("Translate"), this );
	intro->setPixmap(icono_intro);
	//intro->setAutoDefault(true);
	QToolTip::add( intro, _("Translate") );
	connect( intro, SIGNAL(clicked()), SLOT(traduce_actual()) );

	QLabel *label_word=new QLabel( _("&Word:"), this );
	label_word->setBuddy( inputText );

	box = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "box" );

	//box_input = new QBoxLayout(this, QBoxLayout::LeftToRight, 5, 5, NULL);
	box_input = new QBoxLayout(QBoxLayout::LeftToRight, -1, "box_input");
	box->addLayout( box_input, 1 );

	box_input->addWidget( label_word, 1, 0 );
	box_input->addWidget( inputText, 15, 0);
	box_input->addWidget( intro, 1, AlignRight);

	//box->addWidget( inputText, 1, AlignTop );
	//box->addWidget( box_input, 1, AlignTop );

	box->addWidget( vista, 5, 0); //AlignCenter );

	clipper = new QClipper();
	connect( clipper, SIGNAL(clipboardChanged(QString)),
			 this, SLOT( getClipboard(QString) ) );

	QWidget::setTabOrder(inputText, vista);
	QWidget::setTabOrder(vista, intro);

	inputText->setFocus();
}


void QMainWidget::setDiccionario(DiccionarioBase *dict, bool show_desc) { 
	diccionario=dict; 

	if (show_desc) {
		//showDesc();
		procesaEnlace("about:dictionary");
	}
}

void QMainWidget::showDesc() {
	//QString resultado="<qt title=\"Descripcion\">";
	QString resultado;

	QStringList desc=diccionario->getDesc();
	for (unsigned int n=0; n < desc.count(); n++) {
		QString linea=desc[n];
		resultado += linea;
		resultado += "<br/>\n";
	}

	//resultado += "</qt>";

	vista->setText(resultado);
	//vista->setContentsPos(0,0);
}


/*
#ifdef HAVE_QT2
void QMainWidget::procesaTexto(QString & texto, QString c_search) {
	//QString c_search( palabra_actual );
	QString rep= "<b>" + c_search + "</b>";

	if (c_search.isEmpty()) return;	

	//texto.replace( QRegExp(c_search), rep);

	int index=0;

	while (index != -1) {
		index = texto.find( c_search, index );
		if (index != -1) {
			texto.replace( index, c_search.length(), rep );
			index += c_search.length();
			index += 7; //La longitud de <b></b>
		}
	}
}
#endif
*/

void QMainWidget::setTextVista( QString texto ) {
	vista->setText( texto );
	//vista->setContentsPos(0,0);
}

void QMainWidget::setTextVista( QStringList & lista ) {
	QString resultado="<qt title=\"Busqueda\">\n";

	if (!lista.isEmpty() )  {
		QString item;
		for ( unsigned int n=0; n < lista.count(); n++ ) {
			item=lista[n];
			resultado += item;
			resultado += "<br/>\n";
		}
	}

	//last_search=diccionario->getBestMatch();

	//debug("%s", resultado.data() );
	resultado += "</qt>";
	//vista->setContentsPos(0,0);

	vista->setText(resultado);
}

/*
void QMainWidget::traducir(QString entrada) {

	if (trabajando) {
		debug("QMainWidget::traducir: ya se estaba traduciendo. "
              "Ignorando nueva peticin");
		return;
	}

	if (diccionario==NULL) {
		debug("QMainWidget::traducir: diccionario==NULL");
		return;
	}

	if (diccionario->estaBuscando()) {
		debug("QMainWidget::traducir: diccionario trabajando. "
              "Ignorando nueva peticin");
		return;
	}
	
	trabajando=true;

	//QCadena entrada(inputText->text() );
	//QCadena entrada( palabra_actual );
	entrada= entrada.simplifyWhiteSpace();
	palabra_actual=entrada;
	//debug("Entrada: %s", entrada.data() );

	if (entrada.isEmpty()) {
		trabajando=false;
		return;
	}

	if (diccionario->getTipo() == DiccionarioBase::Text_dict) {
		if (entrada.length()<2) {
			qmensaje( this, _("Warning"), _("Word too small") );
			trabajando=false;
			return;
		}
	}

	if (entrada.contains( "\"", FALSE)!=0 ) {
		qmensaje( this, _("Warning"), _("Quotation marks not allowed") );
		trabajando=false;
		return;
	}


	//QApplication::setOverrideCursor( waitCursor );
	if ( isVisibleToTLW() )
		qApp->setOverrideCursor( waitCursor );

	//debug("Entrada: %s", inputText->text().data() );

	//last_search="";

	QString resultado;
	bool ok=diccionario->busca(entrada, resultado, con_formato);

	if (con_formato)
		resultado = "<qt title=\"Bsqueda\">\n" + resultado + "</qt>\n";

	setTextVista( resultado );

	//QApplication::setOverrideCursor( arrowCursor );
	if ( isVisibleToTLW() )
		qApp->restoreOverrideCursor();


	if (!ok) qmensaje(this, _("Error"), diccionario->getError() );

#ifdef SIMPLE_INPUT
	inputText->selectAll();
#else
	inputText->clearEdit();
#endif

	emit fraseTraducida( diccionario->getBestMatch(), entrada, diccionario->getMatches() );	
	emit nuevaPalabra(entrada);

	trabajando=false;
}
*/

void QMainWidget::traduce(int item) {
#ifndef SIMPLE_INPUT
	//debug("QMainWidget::traduce(int item): %d", item);
	QString texto( inputText->text( inputText->currentItem() ) );
	//traducir(texto);

	procesaEnlace(texto);
#endif
}

void QMainWidget::traduce_actual() {
#ifdef SIMPLE_INPUT
	QString texto( inputText->text() );
#else
	QString texto( inputText->currentText() );
	inputText->insertItem( texto, 0 );
#endif
	//traducir(texto);

	procesaEnlace(texto);
}

void QMainWidget::procesaEnlace(const QString& texto) {
	//vista->setSource( "about:null" ); //Borramos el texto anterior
	vista->setSource( createLink(texto) );
	//emit aboutToSearch( texto );

#ifdef SIMPLE_INPUT
	inputText->selectAll();
#else
	inputText->clearEdit();
#endif
}

void QMainWidget::aprender() {
	if (diccionario==NULL) {
		debug("QMainWidget::aprender: diccionario==NULL");
		return;
	}

	Aprender d(this, "qaprender");
	
	d.setTitle1( diccionario->getIdioma1() );
	d.setTitle2( diccionario->getIdioma2() );

	if (!diccionario->getInvertirResultados()) 
		d.setIngles( palabra_actual );
	else
		d.setCastellano( palabra_actual );

	int r = d.exec();

	if (r == QDialog::Accepted ) {
		QString idioma1=d.getIngles();
		QString idioma2=d.getCastellano();

		if ( (idioma1.isEmpty()) || (idioma2.isEmpty()) ) {
			Dialogos::mensaje( this, _("Error"), _("Add text to both inputs.") );
			return;
		}

		if ( (idioma1.contains( "\"", FALSE)!=0 ) || 
             (idioma2.contains( "\"", FALSE)!=0 ) ) {
			Dialogos::mensaje( this, _("Warning"), _("Quotation marks not allowed") );
        	return;
		}

		if (!diccionario->aprende(idioma1,idioma2)) {
			QString s( _("Could not add new translation") );
			s += "\n"+ diccionario->getError();
			Dialogos::mensaje( this, _("Error"), s );
		}
	}
}

QString QMainWidget::createLink(const QString& palabra) {
	if ( palabra.contains(':') !=0 ) 
		return palabra;
	else
		//return diccionario->getAlias() + ":" + palabra;
		return "dict:"+palabra+"@"+diccionario->getAlias();
}

void QMainWidget::getClipboard(QString frase) {
	if (trabajando) {
		debug("QMainWidget::getClipboard: ya se estaba traduciendo. "
              "Ignorando nueva peticin");
		return;
	}

	debug("Clipboard cambiado: '%s'", frase.latin1() );

	if (frase.left(5)=="http:") {
		debug("Es un enlace a una pgina web. Se ignora.");
		return;
	}

	//Elimina las comillas
	int pos= frase.find('"',0);
	while (pos!=-1) {
		frase.remove(pos,1);
		pos= frase.find('"',0);
	}

	//Quitamos los espacios sobrantes.
	frase= frase.stripWhiteSpace();

	//Elimina posibles errores al seleccionar texto.
	//". palabra"
	if (frase.left(2)==". ") frase.remove(0,2);

	//".palabra"
	if (frase.left(1)==".") frase.remove(0,1);

	//"palabra."
	if (frase.right(1)==".") frase.remove( frase.length()-1, 1 );

	//"palabra. "
	//if (frase.right(2)==". ") frase.remove( frase.length()-2, 2 );

	//", palabra"
	if (frase.left(2)==", ") frase.remove(0,2);

	//",palabra"
	if (frase.left(1)==",") frase.remove(0,1);

	//"palabra,"
	if (frase.right(1)==",") frase.remove( frase.length()-1, 1 );

	//"palabra, "
	//if (frase.right(2)==", ") frase.remove( frase.length()-2, 2 );


	debug("Frase a buscar: '%s'", frase.latin1() );

	//QCadena old_text( palabra_actual );

	//if (strcmp(frase.latin1(), palabra_actual.latin1() )!=0) {
	if (frase != palabra_actual ) {	
#ifdef SIMPLE_INPUT
		inputText->setText( frase );
#else
		inputText->insertItem( frase, 0 );
#endif
		debug("Parando timer");
		clipper->stop();
		//traducir(frase);
		procesaEnlace(frase);
		//qApp->processEvents();
		debug("Arrancando timer");
		clipper->start();
	}
}

void QMainWidget::checkClipboard(bool b) {
	if (b) clipper->start(); else clipper->stop();
}

/*
void QMainWidget::changeClipProperties() {
	QAClipProp d(this, "clip_properties");
	d.setMilliseconds( clipper->getInterval() );

	int r=d.exec();

	if (r==1) {
		clipper->changeInterval( d.getMilliseconds() );
	}
}
*/

void QMainWidget::setClipInterval( int msec ) {
	clipper->changeInterval( msec );
}

int QMainWidget::getClipInterval() {
	return clipper->getInterval();
}


void QMainWidget::setFontVista( const QFont& font) {
	vista->setDefaultFont( font );
}

QFont QMainWidget::getFontVista() {
	return vista->defaultFont();
}

void QMainWidget::slot_cambiadoFontVista( const QFont& font) {
#if QT_VERSION < 300
	if (diccionario==NULL) return;

	qDebug("QMainWidget::slot_cambiadoFontVista");

	diccionario->f_family= font.family();
	diccionario->f_pointSize= font.pointSize();
	diccionario->f_weight= font.weight();
	diccionario->f_italic= font.italic();
	diccionario->f_bold= font.bold();
	diccionario->f_underline= font.underline();
	diccionario->f_strikeout= font.strikeOut();
	diccionario->f_charset= (int) font.charSet();
#endif
}

void QMainWidget::slot_changedDefaultFont( const QFont& font ) {
#if QT_VERSION >= 300
	DiccionarioBase::font_string = font.family();
#endif
}


#include "QMainWidget.moc.cpp"

