/*
 *  menu.c:			
 *
 *  Written by:		Ullrich Hafner
 *		
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/09/03 19:22:03 $
 *  $Author: hafner $
 *  $Revision: 1.37 $
 *  $State: Exp $
 */


#include "config.h"

#include <gtk/gtk.h>
#include <stdio.h>
#if HAVE_STRING_H
#	include <string.h>
#else /* not HAVE_STRING_H */
#	include <strings.h>
#endif /* not HAVE_STRING_H */

#include "window.h"
#include "icons.h"
#include "menu.h"
#include "dialog.h"
#include "themebrowser.h"
#include "error.h"

#define HOMEPAGE "http://ulli.linuxave.net/wmakerconf/"

/*****************************************************************************

			    global variables
  
*****************************************************************************/

extern proplist_t *orig_wmaker;		/* original WindowMaker file */
extern proplist_t *plist_changed;
extern proplist_t *pl_yes;

extern proplist_t  *orig_rootmenu;	/* original WMRootMenu file */
extern GtkWidget   *log_text;
extern GtkTooltips *tooltips;

/*****************************************************************************

			    static variables
  
*****************************************************************************/

static GtkWidget *revert_menu = NULL;
static GtkWidget *save_menu   = NULL;
static GtkWidget *save_button = NULL;

/*****************************************************************************

				prototypes
  
*****************************************************************************/

static void
toggle_tooltips (GtkWidget *menuitem, gpointer data);
static void
about (GtkWidget *w, gpointer ptr);
static void
readme (GtkWidget *w, gpointer ptr);
static void
wwwpage (GtkWidget *w, gpointer ptr);
static void
revert_popup (GtkWidget *w, gpointer ptr);
static void
revert_and_exit (GtkWidget *w, gpointer ptr);

#if defined(HAVE_POPEN) && defined(WWWUPDATE)
static void
upgrade (GtkWidget *w, gpointer ptr);
#endif /* HAVE_POPEN && WWWUPDATE */
static void
load_file (GtkWidget *button, gpointer data);
static void
load (GtkWidget *button, gpointer ptr);

/*******************************************************************************

				public code
  
*******************************************************************************/

GtkWidget *
make_menubar (GtkWidget *logwindow, bool_t show_themes_menu, bool_t noinet)
/*
 *  Generate menu bar.
 *
 *  Return value:
 *	menu bar widget
 */
{
   GtkWidget *file_menu   = gtk_menu_new ();
   GtkWidget *help_menu   = gtk_menu_new ();
   GtkWidget *themes_menu = gtk_menu_new ();
   GtkWidget *item, *menu_bar;
   
   save_menu = item = gtk_menu_item_new_with_label (_("Save"));
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (save_config_file), NULL);
   gtk_widget_set_sensitive (save_menu, FALSE);

   item = gtk_menu_item_new_with_label (_("Open..."));
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (load_file), NULL);

   if (orig_wmaker)
   {
      revert_menu = item = gtk_menu_item_new_with_label (_("Revert..."));
      gtk_menu_append (GTK_MENU (file_menu), item);
      gtk_signal_connect_object (GTK_OBJECT (item), "activate",
				 GTK_SIGNAL_FUNC (revert_popup), NULL);
      gtk_widget_set_sensitive (revert_menu, FALSE);
   }

   item = gtk_menu_item_new();
   gtk_menu_append (GTK_MENU (file_menu), item);

#if defined(HAVE_POPEN) && defined(WWWUPDATE)
    if (!noinet)
    {
       item = gtk_menu_item_new_with_label (_("Upgrade"));
       gtk_menu_append (GTK_MENU (file_menu), item);
       gtk_signal_connect_object (GTK_OBJECT (item), "activate",
				  GTK_SIGNAL_FUNC (upgrade), NULL);
    }
    
   item = gtk_menu_item_new();
   gtk_menu_append (GTK_MENU (file_menu), item);
#endif /* HAVE_POPEN  && WWWUPDATE */

   item = gtk_menu_item_new_with_label (_("Exit"));
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (quit), NULL);

   item = gtk_check_menu_item_new_with_label (_("Tooltips"));
   gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect (GTK_OBJECT (item), "activate",
		       GTK_SIGNAL_FUNC (toggle_tooltips), tooltips);

   item = gtk_menu_item_new_with_label (_("About"));
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (about), NULL);

   item = gtk_menu_item_new_with_label (_("Manual"));
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (readme), NULL);

   item = gtk_menu_item_new_with_label (_("Messages"));
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (gtk_widget_show_all),
			      GTK_OBJECT (logwindow));

   if (show_themes_menu)
   {
      item = gtk_menu_item_new_with_label (_("Update previews"));
      gtk_menu_append (GTK_MENU (themes_menu), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (generate_previews), NULL);
   }

#if defined(NETSCAPE)

   if (show_themes_menu && !noinet)
   {
      item = gtk_menu_item_new();
      gtk_menu_append (GTK_MENU (themes_menu), item);

      item = gtk_menu_item_new_with_label (_("wm.themes.org"));
      gtk_menu_append (GTK_MENU (themes_menu), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (wwwpage), "http://wm.themes.org");

      item = gtk_menu_item_new_with_label (_("Linuxberg themes"));
      gtk_menu_append (GTK_MENU (themes_menu), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (wwwpage),
			  "http://www.linuxberg.com/themes/");

      item = gtk_menu_item_new_with_label (_("Largo's themes"));
      gtk_menu_append (GTK_MENU (themes_menu), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (wwwpage),
			  "http://wm.current.nu/themes/");
   }
   if (!noinet)
   {
      item = gtk_menu_item_new();
      gtk_menu_append (GTK_MENU (help_menu), item);

      item = gtk_menu_item_new_with_label (_("Homepage"));
      gtk_menu_append (GTK_MENU (help_menu), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (wwwpage), HOMEPAGE);
   }
#endif /* defined(NETSCAPE) */

   menu_bar  = gtk_menu_bar_new ();
   
   item = gtk_menu_item_new_with_label (_("File"));
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), file_menu);
   gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), item);

   if (show_themes_menu)
   {
      item = gtk_menu_item_new_with_label (_("Themes"));
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), themes_menu);
      gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), item);
   }

   item = gtk_menu_item_new_with_label (_("Help"));
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), help_menu);
   gtk_menu_item_right_justify (GTK_MENU_ITEM (item));
   gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), item);

   gtk_widget_show_all (menu_bar);
   
   return menu_bar;
}

GtkWidget *
make_toolbar (bool_t noinet)
/*
 *  Generate toolbar.
 *
 *  Return value:
 *	toolbar widget
 */
{
   GtkWidget *toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
					 GTK_TOOLBAR_ICONS);

   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, _("Exit wmakerconf"),
			    "Toolbar/Exit",
			    gtk_pixmap_new ((p_array + P_EXIT)->pixmap,
					    (p_array + P_EXIT)->mask),
			    (GtkSignalFunc) quit, NULL);
   save_button
      = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
				 NULL, _("Save WindowMaker file"),
				 "Toolbar/Save",
				 gtk_pixmap_new ((p_array + P_DISK)->pixmap,
						 (p_array + P_DISK)->mask),
				 (GtkSignalFunc) save_config_file, NULL);
   gtk_widget_set_sensitive (save_button, FALSE);

   gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, _("Documentation"),
			    "Toolbar/Help",
			    gtk_pixmap_new ((p_array + P_HELP)->pixmap,
					    (p_array + P_HELP)->mask),
			    (GtkSignalFunc) readme, NULL);
#if defined(HAVE_POPEN) && defined(WWWUPDATE)
    if (!noinet) 
       gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
				NULL,
				_("Upgrade wmakerconf-data package via HTTP."),
				"Toolbar/Install",
				gtk_pixmap_new ((p_array + P_INSTALL)->pixmap,
						(p_array + P_INSTALL)->mask),
				(GtkSignalFunc) upgrade, NULL);
#endif /* HAVE_POPEN && WWWUPDATE */
#if defined(NETSCAPE)
    if (!noinet) 
       gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
				NULL, _("Wmakerconf homepage"),
				"Toolbar/WWW",
				gtk_pixmap_new ((p_array + P_HOME)->pixmap,
						(p_array + P_HOME)->mask),
				(GtkSignalFunc) wwwpage, HOMEPAGE);
#endif /* defined(NETSCAPE) */

   gtk_widget_show_all (toolbar);
   return toolbar;
}

/*******************************************************************************

				private code
  
*******************************************************************************/

static void
about (GtkWidget *w, gpointer ptr)
/*
 *  Popup 'about' window displaying some interesting information
 *  about the author of the package;-)
 *
 *  No return value.
 */
{
   static GtkWidget *window = NULL;

   if (!window)
   {
      GtkWidget *button;
      
      window = gtk_dialog_new ();
      gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
      gtk_window_set_title (GTK_WINDOW (window), _("About"));

      gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			  GTK_SIGNAL_FUNC (gtk_false), NULL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  (GtkSignalFunc) gtk_widget_destroyed,
			  &window);

      button = gtk_button_new_with_label (_("Close"));
      gtk_widget_show (button);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 (GtkSignalFunc) gtk_widget_destroy,
				 GTK_OBJECT (window));

      gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (window)->vbox), 5);

      
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  make_pixmap (PKGDATADIR "/wmakerconf.xpm", -1, -1,
				       NULL),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("Wmakerconf, Version " VERSION),
			  FALSE, FALSE, 5);
      /*
       *  Read version of WMWmakerconf file
       */
      {
	 FILE *version = fopen (PKGDATADIR "/wmaker-version", "r");

	 if (version)
	 {
	    char line [MAXSTRLEN];

	    strcpy (line, "Wmakerconf-data, Version ");
	    if (fgets (line + strlen (line), MAXSTRLEN - strlen (line), version))
	       gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
				   gtk_label_new (line), FALSE, FALSE, 5);
	    fclose (version);
	 }
      }
      
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("Copyright (C) 1998-2000 "
					 "Ullrich Hafner"),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("<hafner@bigfoot.de>"),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new (HOMEPAGE),
			  FALSE, FALSE, 5);
   }
   if (!GTK_WIDGET_VISIBLE (window))
      gtk_widget_show_all (window);
   else
      gtk_widget_hide (window);
}

static void
readme (GtkWidget *w, gpointer ptr)
/*
 *  Popup 'readme' window displaying the README file of the distribution.
 *
 *  No return value.
 */
{
   static GtkWidget *window = NULL;

   if (!window)
   {
      GtkWidget *button;
      FILE	*input = fopen (PKGDATADIR "/MANUAL", "r");

      if (!input)
	 return;
   
      window = gtk_dialog_new ();
      gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);
      gtk_window_set_title (GTK_WINDOW (window), _("Manual"));

      gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			  GTK_SIGNAL_FUNC (gtk_false), NULL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  (GtkSignalFunc) gtk_widget_destroyed,
			  &window);

      button = gtk_button_new_with_label (_("Close"));
      gtk_widget_show (button);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 (GtkSignalFunc) gtk_widget_destroy,
				 GTK_OBJECT (window));
   
      {
	 GtkWidget *text, *vscrollbar, *hscrollbar, *table;
	 char	buffer [MAXSTRLEN];
      
	 table = gtk_table_new (2, 2, FALSE);
	 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
	 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
	 gtk_widget_show (table);
	 gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (window)->vbox), 5);
	 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), table,
			     TRUE, TRUE, 5);

	 text = gtk_text_new (NULL, NULL);
	 gtk_text_set_editable (GTK_TEXT (text), FALSE);
	 gtk_table_attach (GTK_TABLE (table), text, 1, 2, 0, 1,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (text);

	 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
	 gtk_table_attach (GTK_TABLE (table), hscrollbar, 1, 2, 1, 2,
			   GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
	 gtk_widget_show (hscrollbar);

	 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
	 gtk_table_attach (GTK_TABLE (table), vscrollbar, 0, 1, 0, 2,
			   GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (vscrollbar);

	 gtk_text_freeze (GTK_TEXT (text));

	 gtk_widget_realize (text);
	 gtk_text_set_editable (GTK_TEXT (text), NO);

	 while (fgets (buffer, MAXSTRLEN, input))
	    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, buffer, -1);
	 fclose (input);
      }
      gtk_widget_set_usize (window, 500, 500);
   }
   if (!GTK_WIDGET_VISIBLE (window))
      gtk_widget_show_all (window);
   else
      gtk_widget_hide (window);
}

static void
wwwpage (GtkWidget *w, gpointer ptr)
/*
 *  Load homepage of wmakerconf.
 *
 *  No return value.
 */
{
#ifdef NETSCAPE
   char *www = (char *) ptr;
   char *tmp = g_strdup_printf (NETSCAPE " -remote 'openURL(%s,  new-window)' || "
				NETSCAPE " %s &", www, www);
   system (tmp);
   Free (tmp);
#endif
   ;
}

static void
revert_popup (GtkWidget *w, gpointer ptr)
/*
 *  Popup revert and quit dialog window.
 *
 *  No return value.
 */
{
   dialog (DIALOG_QUESTION, _("Cancel"), _("OK"), revert_and_exit, NULL,
	   _("Revert to backupfile of `WindowMaker' \n"
	     "and `WMRootMenu' and exit wmakerconf?"));
}

static void
revert_and_exit (GtkWidget *w, gpointer ptr)
/*
 *  Revert old WindowMaker file and quit.
 *
 *  No return value.
 */
{
   if (!PLSave (orig_wmaker, YES))
      warning (_("Can't revert to backupfile of `WindowMaker'. "
		 "Please manually revert from file WindowMaker.bak."));
   if (orig_rootmenu && !PLSave (orig_rootmenu, YES))
      warning (_("Can't revert to backupfile of `WMRootMenu'. "
		 "Please manually revert from file WMRootMenu.bak."));
   gtk_main_quit ();
}

#if defined(HAVE_POPEN) && defined(WWWUPDATE)
static void
upgrade (GtkWidget *w, gpointer ptr)
/*
 *  Upgrade wmakerconf attribute file.
 *
 *  No return value.
 */
{
   FILE	*pipe = popen (PERL " " PKGDATADIR "/upgrade.pl 2>&1 &", "r");
   char	tmp [MAXSTRLEN];

   gtk_widget_show_all (gtk_widget_get_toplevel (log_text));
   while (gtk_events_pending())
      gtk_main_iteration();

   while (fgets (tmp, MAXSTRLEN, pipe))
   {
      gtk_text_insert (GTK_TEXT (log_text), NULL, NULL, NULL, tmp, -1);
      while (gtk_events_pending())
	 gtk_main_iteration();
   }

   pclose (pipe);
}
#endif /* HAVE_POPEN && WWWUPDATE */

void
enable_revert (void)
{
   if (revert_menu)
      gtk_widget_set_sensitive (revert_menu, TRUE);
}

void
toggle_save (bool_t enable, proplist_t *key)
{
   gtk_widget_set_sensitive (save_menu, enable);
   gtk_widget_set_sensitive (save_button, enable);
   if (enable && key)
   {
      PLInsertDictionaryEntry (plist_changed, key, pl_yes);

      if (strcaseeq (PLGetString (key), "ThemePath"))
	 build_theme_list ();
   }
}

static void
load (GtkWidget *button, gpointer ptr)
{
   GtkFileSelection *fs       = GTK_FILE_SELECTION (ptr);
   char		    *filename = gtk_file_selection_get_filename (fs);

   if (!load_attributes (filename, NULL))
      dialog_popup (DIALOG_ERROR, NULL, NULL, _("Can't open selected file."));
}

static void
load_file (GtkWidget *button, gpointer data)
/*
 *  Open browser to select new file. 
 */
{
   static GtkWidget *filesel = NULL;

   if (!filesel)
   {
      GtkFileSelection *fs;

      filesel = gtk_file_selection_new (_("Open a style, theme, or"
					  " WindowMaker file."));
      fs = GTK_FILE_SELECTION (filesel);
      gtk_file_selection_hide_fileop_buttons (fs);
      gtk_window_set_position (GTK_WINDOW (filesel), GTK_WIN_POS_MOUSE);
      gtk_signal_connect (GTK_OBJECT (filesel), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                          &filesel);
      gtk_signal_connect (GTK_OBJECT (fs->ok_button), "clicked",
			  GTK_SIGNAL_FUNC (load), fs);
      
      gtk_signal_connect_object (GTK_OBJECT (fs->cancel_button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (filesel));
      gtk_signal_connect_object (GTK_OBJECT (fs->ok_button), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (filesel));
      {
	 char *tmp = g_strconcat (WMAKERDIR, "/", NULL);
	 gtk_file_selection_set_filename (fs, tmp);
	 Free (tmp);
      }
   }

   if (!GTK_WIDGET_VISIBLE (filesel))
      gtk_widget_show (filesel);
   else
      gtk_widget_destroy (filesel);
}

static void
toggle_tooltips (GtkWidget *menuitem, gpointer data)
{
   if (GTK_CHECK_MENU_ITEM (menuitem)->active)
      gtk_tooltips_enable (GTK_TOOLTIPS (data));
   else
      gtk_tooltips_disable (GTK_TOOLTIPS (data));
}
