/*
 * Interpolator.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _INTERPOLATOR_H
#define _INTERPOLATOR_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "MFFloat.h"

class FieldValue;
class CommandList;

class ProtoInterpolator : public Proto {
public:
			ProtoInterpolator(Scene *scene, const char *name,
					    int keyType, int keysType, 
					    FieldValue *defaultValue);
    virtual Node       *create(Scene *scene) = 0;
    FieldIndex          key;
    FieldIndex          keyValue;
};


class Interpolator : public Node {
public:
			Interpolator(Scene *scene, Proto *proto);
    
    int	    		getNumKeys() const;
    float		getKey(int index) const;
    float		getKeyValue(int channel, int index) const;
    void		setKey(int index, float value);
    virtual void	setKeyValue(int channel, int index, float value);
    void		backupKey(int index);
    void		backup(CommandList *list);
    void		receiveEvent(int eventIn, double timestamp, FieldValue *value);
    void		insertKey(int pos, float key, const float *values);
    void		deleteKeys(int start, int end);
    virtual void	interpolate(float k, float *values);
    void		sendInterpolatedEvent(double timestamp, float k);
    void		sendInterpolatedValue(double timestamp, float k);

    virtual int		getNumChannels() const = 0;
    virtual FieldValue *createKey(float *value) const = 0;
    virtual FieldValue *createKeys(float *value, int numKeys) const = 0;

    int			findKey(float value) const;
    int			findKeyInclusive(float value) const;
    int			findKeyExclusive(float value) const;
    bool		getNearestKeys(float k, float *k1, float *k2,
				       int *pos1, int *pos2);

    float		getFraction() const { return _fraction; }
    int			getNodeClass() const 
                           { 
                           return INTERPOLATOR_NODE | CHILD_NODE; 
                           }

    void		recordKey(FieldValue *value, bool isrunning);
    virtual void        recordValue(int key, FieldValue *value);

    void 		oldFraction(double timestamp, float fraction);
    bool 		isInterpolator() { return true; }



    fieldMacros(MFFloat, key, ProtoInterpolator);
    // keyValue can not use FieldMacros cause datatype is various at this point

protected:
    float		_fraction;
    float		_oldFraction;
    float		_veryOldFraction;
    double		_oldTimestamp;
    FieldIndex          _keyValueIndex;
    FieldIndex          _keyIndex;
    FieldIndex          _value_changedIndex;
};

Interpolator       *dynamic_cast_Interpolator(Node* node);

#define ADD_FLIP void flip(int index) { keyValue()->flip(index); }

#endif
