/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <CapacitorQ.h>

#include <Strings.h>

#include "../images/capacitorq.xpm"

QPixmap* CapacitorQ::pixmap_ = 0;

//-----------------------------------------------------------------
CapacitorQ::CapacitorQ( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
CapacitorQ::~CapacitorQ()
{}

//-----------------------------------------------------------------
const QString& CapacitorQ::getCatagory() const
  {
    return Strings::LumpedCatagory;
  }

//-----------------------------------------------------------------
const QString& CapacitorQ::getName() const
  {
    return Strings::CapacitorQName;
  }

//-----------------------------------------------------------------
const QPixmap& CapacitorQ::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap(capacitorq_xpm);
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void CapacitorQ::initComponent()
{
  boundingRect_ = QRect(-16, -8, 32, 16);
  addNode(-16,0);
  addNode(16,0);
  addAttribute( Strings::AttrCapacitance, "C" );
  addAttribute( Strings::AttrQFactor, "Q" );
  // Added by Budu on 3/04/02
}

//-----------------------------------------------------------------
void CapacitorQ::drawSymbol(QPainter* p)
{
  p->save();
  p->moveTo(-16,0);
  p->lineTo(-3,0);
  p->moveTo(-3, 7);
  p->lineTo(-3, -7);
  p->moveTo(3, 7);
  p->lineTo(3,-7);
  p->moveTo(3,0);
  p->lineTo(16,0);
  // make some perturbations
  QPen pen = p->pen();
  pen.setStyle( Qt::DashLine );
  p->setPen( pen );
  p->drawLine( -14,-10, 14,-10 );
  p->restore();
}

//-----------------------------------------------------------------
bool CapacitorQ::initSweep()
{
  TReal c = c_;
  TReal qc = qc_;
  c_ = getAttributeValue( "C" );
  c_ = c_ * getDimensionValue( Strings::CapacitanceDim );
  qc_ = getAttributeValue( "Q" );
  return ( (c_ != c) || (qc_ != qc) );
}

//-----------------------------------------------------------------
void CapacitorQ::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  TReal X = freq * c_;
  TReal R = qc_ / X;
  TComplex y( 1/R, X );
  // This impedances introduces loses
  //  TComplex y( 0, freq*c_ );
  yn->insertComponent( y, node(0)->getNodeNumber(), node(1)->getNodeNumber() );
}
