.TH iverilog 1 "$Date: 2002/02/03 07:05:37 $" Version "$Date: 2002/02/03 07:05:37 $"
.SH NAME
iverilog - Icarus Verilog compiler

.SH SYNOPSIS
.B iverilog
[-ESVv] [-Cpath] [-ccmdfile] [-Dmacro[=defn]] [-pflag=value]
[-Iincludedir] [-mmodule] [-Nfile] [-ooutputfilename] [-stopmodule]
[-ttype] [-Tmin/typ/max] [-Wclass] [-ypath] sourcefile

.SH DESCRIPTION
.PP
\fIiverilog\fP is a compiler that translates Verilog source code into
executable programs for simulation, or other netlist formats for
further processing. The currently supported targets are \fIvvm\fP (for
executable simulation) and \fIvvp\fP for simulation, and \fIxnf\fP for
synthesis. Other target types are added as code generators are
implemented.

.SH OPTIONS
.l
\fIiverilog\fP accepts the following options:
.TP 8
.B -B\fIbase\fP
The \fIiverilog\fP program uses external programs to preprocess and
compile the Verilog source. Normally, the path used to locate these
tools is built into the \fIiverilog\fP program. However, the \fB-B\fP
switch allows the user to select a different set of programs. The path
given is used to locate \fIivlpp\fP, \fIivl\fP and the VPI modules.
.TP 8
.B -c\fIfile\fP
This flag specifies an input file that contains a list of Verilog
source files. This is similar to the \fIcommand file\fP of other
Verilog simulators, in that it is a file that contains the file names
instead of taking them on the command line. See \fBCommand Files\fP below.
.TP 8
.B -C\fIpath\fP
This flag selects the driver configuration file to use. Normally, the
iverilog program will read its configuration file from
/usr/lib/ivl/iverilog.conf (or the install path configured at compile
time) but the user can specify the path to a different configuration
file. This is useful when testing new configuration files. See the
installed configuration file for a summary of the file format.
.TP 8
.B -D\fImacro\fP
Defines macro \fImacro\fP with the string `1' as its definition. This
form is normally only used to trigger ifdef conditionals in the
Verilog source.
.TP 8
.B -D\fImacro=defn\fP
Defines macro \fImacro\fP as \fIdefn\fP.
.TP 8
.B -E
Preprocess the Verilog source, but do not compile it. The output file
is the Verilog input, but with file inclusions and macro references
expanded and removed. This is useful, for example, to preprocess
Verilog source for use by other compilers.
.TP 8
.B -I\fIincludedir\fP 
Append directory \fIincludedir\fP to list of directories searched
for Verilog include files. The \fB-I\fP switch may be used many times
to specify several directories to search, the directories are searched
in the order they appear on the command line.
.TP 8
.B -m\fImodule\fP
Add this module to the list of VPI modules to be loaded by the
simulation. Many modules can be specified, and all will be loaded, in
the order specified. The system module is implicit and always included.
.TP 8
.B -N\fIpath\fP
This is used for debugging the compiler proper. Dump the final netlist
form of the design to the specified file. It otherwise does not affect
operation of the compiler. The dump happens after the design is
elaborated and optimized.
.TP 8
.B -o \fIfilename\fP
Place output in the file \fIfilename\fP. If no output file name is
specified, \fIiverilog\fP uses the default name \fBa.out\fP.
.TP 8
.B -p\fIflag=value\fP
Assign a value to a target specific flag. The \fB-p\fP switch may be
used as often as necessary to specify all the desired flags. The flags
that are used depend on the target that is selected, and are described
in target specific documentation. Flags that are not used are ignored.
.TP 8
.B -S
Synthesize. Normally, if the target can accept behavioral
descriptions the compiler will leave processes in behavioral
form. The \fB-S\fP switch causes the compiler to perform synthesis
even if it is not necessary for the target. If the target type is a
netlist format, the \fB-S\fP switch is unnecessary and has no effect.
.TP 8
.B -s \fItopmodule\fP
Specify the top level module to elaborate. Icarus Verilog will by default
choose modules that are not instantiated in any other modules, but
sometimes that is not sufficient, or instantiates too many modules. If
the user specifies one or more root modules with \fB-s\fP flags, then
they will be used as root modules instead.
.TP 8
.B -T\fImin|typ|max\fP
Use this switch to select min, typ or max times from min:typ:max
expressions. Normally, the compiler will simply use the typ value from
these expressions (with a warning) but this switch will tell the
compiler explicitly which value to use. This will suppress the
warning that the compiler is making a choice.
.TP 8
.B -t\fItarget\fP
Use this switch to specify the target output format. See the
\fBTARGETS\fP section below for a list of valid output formats.
.TP 8
.B -v
Turn on verbose messages. This will print the command lines that are
executed to perform the actual compilation, along with version
information from the various components, as well as the version of the
product as a whole.
.TP 8
.B -V
Print the version of the compiler, and exit.
.TP 8
.B -W\fIclass\fP
Turn on different classes of warnings. See the \fBWARNING TYPES\fP
section below for descriptions of the different warning groups. If
multiple \fB-W\fP switches are used, the warning set is the union of
all the requested classes.
.TP 8
.B -y\fIlibdir\fP
Append the directory to the library module search path. When the
compiler finds an undefined module, it looks in these directories for
files with the right name.

.SH MODULE LIBRARIES

The Icarus Verilog compiler supports module libraries as directories
that contain Verilog source files.  During elaboration, the compiler
notices the instantiation of undefined module types. If the user
specifies library search directories, the compiler will search the
directory for files with the name of the missing module type. If it
finds such a file, it loads it as a Verilog source file, they tries
again to elaborate the module.

Library module files should contain only a single module, but this is
not a requirement. Library modules may reference other modules in the
library or in the main design.

.SH TARGETS

The Icarus Verilog compiler supports a variety of targets, for
different purposes, and the \fB-t\fP switch is used to select the
desired target.

.TP 8
.B null
The null target causes no code to be generated. It is useful for
checking the syntax of the Verilog source.
.TP 8
.B vvm
The target is an executable program that uses the vvm simulation
runtime. The compiler actually generates C++ code, then compiles and
links that code to make the output executable.
.TP 8
.B vvp
This is the default. The vvp target generates code for the vvp
runtime. The output is a complete program that simulates the design
(like with vvm) but must be run by the \fBvvp\fP command. This target
is much faster then the \fBvvm\fP target, but not quite as complete.
.TP 8
.B xnf
This is the Xilinx Netlist Format used by many tools for placing
devices in FPGAs or other programmable devices. The Icarus Verilog XNF
code generator can generate complete designs or XNF macros that can be
imported into larger designs by other tools.
.TP 8
.B fpga
This is a variant of the XNF code generator that supports a wider
variety of target devices. It is intended as a future replacement for
the existing \fBxnf\fP target, but for now is still experimental.

.SH "WARNING TYPES"
These are the types of warnings that can be selected by the \fB-W\fP
switch.

.TP 8
.B all
This enables all supported warning categories.

.TP 8
.B implicit
This enables warnings for creation of implicit declarations. For
example, if a scalar wire X is used but not declared in the Verilog
source, this will print a warning at its first use.

.SH "COMMAND FILES"
The command file allows the user to place source file names and
certain command line switches into a text file instead of on a long
command line. Command files can include C or C++ style comments, as
well as # comments, if the # starts the line.

.TP 8
.I "file name"
A simple file name or file path is taken to be the name of a Verilog
source file. The path starts with the first non-white-space character.

.TP 8
.B -y\ \fIlibdir\fP
A \fB-y\fP token prefixes a library directory in the command file,
exactly like it does on the command line. The parameter to the \fB-y\fP
flag may be on the same line or the next non-comment line.

.TP 8
.B +incdir+\fIincludedir\fP
The \fB+incdir+\fP token in command files gives directories to search
for include files in much the same way that \fB-I\fP flags work on the
command line. The difference is that multiple \fI+includedir\fP
directories are valid parameters to a single \fB+incdir+\fP token,
although you may also have multiple \fB+incdir+\fP lines.

.TP 8
.B +libext+\fIext\fP
The \fB+libext\fP token in command files fives file extensions to try
when looking for a library file. This is useful in conjunction with
\fB-y\fP flags to list suffixes to try in each directory before moving
on to the next library directory.

.TP 8
.B +define+\fINAME\fP=\fIvalue\fP
The \fB+define+\fP token is the same as the \fB-D\fP option on the
command line. The value part of the token is optional.

.TP 8
.B +toupper-filename\fP
This token causes file names after this in the command file to be
translated to uppercase. This helps with situations where a directory
has passed through a DOS machine, and in the process the file names
become munged.

.TP 8
.B +tolower-filename\fP
This is similar to the \fB+toupper-filename\fP hack described above.

.SH EXAMPLES 
These examples assume that you have a Verilog source file called hello.v in
the current directory

To compile hello.v to an executable file called a.out:

	iverilog hello.v

To compile hello.v to an executable file called hello:

	iverilog -o hello hello.v

To compile and run explicitly using the vvp runtime:

	iverilog -ohello.vvp -tvvp hello.v

To compile hello.v to a file in XNF-format called hello.xnf

	iverilog -txnf -ohello.xnf hello.v


.SH "AUTHOR"
.nf
Steve Williams (steve@icarus.com)

.SH SEE ALSO
vvp(1),
.BR "<http://www.icarus.com/eda/verilog/>"

.SH COPYRIGHT
.nf
Copyright \(co  2000 Stephen Williams

This document can be freely redistributed according to the terms of the 
GNU General Public License version 2.0
