/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;

public class IvyReport
extends IvyTask {
    private File _todir;
    private String _organisation;
    private String _module;
    private String _conf;
    private File _cache;
    private boolean _graph = true;
    private boolean _xml = false;
    private boolean _xsl = true;
    private String _xslFile;
    private String _outputpattern;
    private String _xslext = "html";

    public File getTodir() {
        return this._todir;
    }

    public void setTodir(File todir) {
        this._todir = todir;
    }

    public File getCache() {
        return this._cache;
    }

    public void setCache(File cache) {
        this._cache = cache;
    }

    public String getConf() {
        return this._conf;
    }

    public void setConf(String conf) {
        this._conf = conf;
    }

    public String getModule() {
        return this._module;
    }

    public void setModule(String module) {
        this._module = module;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public void setOrganisation(String organisation) {
        this._organisation = organisation;
    }

    public boolean isGraph() {
        return this._graph;
    }

    public void setGraph(boolean graph) {
        this._graph = graph;
    }

    public String getXslfile() {
        return this._xslFile;
    }

    public void setXslfile(String xslFile) {
        this._xslFile = xslFile;
    }

    public String getOutputpattern() {
        return this._outputpattern;
    }

    public void setOutputpattern(String outputpattern) {
        this._outputpattern = outputpattern;
    }

    public void execute() throws BuildException {
        String t;
        Ivy ivy = this.getIvyInstance();
        this._organisation = this.getProperty(this._organisation, ivy, "ivy.organisation");
        this._module = this.getProperty(this._module, ivy, "ivy.module");
        if (this._cache == null) {
            this._cache = ivy.getDefaultCache();
        }
        this._conf = this.getProperty(this._conf, ivy, "ivy.resolved.configurations");
        if (this._conf.equals("*")) {
            this._conf = this.getProperty(ivy, "ivy.resolved.configurations");
        }
        if (this._conf == null) {
            throw new BuildException("no conf provided for ivy report task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        if (this._todir == null && (t = this.getProperty(ivy, "ivy.report.todir")) != null) {
            this._todir = new File(t);
        }
        this._outputpattern = this.getProperty(this._outputpattern, ivy, "ivy.report.output.pattern");
        if (this._todir != null && this._todir.exists()) {
            this._todir.mkdirs();
        }
        if (this._outputpattern == null) {
            this._outputpattern = "[organisation]-[module]-[conf].[ext]";
        }
        if (this._todir != null && this._todir.exists() && !this._todir.isDirectory()) {
            throw new BuildException("destination directory should be a directory !");
        }
        if (this._organisation == null) {
            throw new BuildException("no organisation provided for ivy report task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
        }
        if (this._module == null) {
            throw new BuildException("no module name provided for ivy report task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
        }
        try {
            String[] confs = this.splitConfs(this._conf);
            for (int i = 0; i < confs.length; ++i) {
                if (this._xsl) {
                    this.genreport(ivy, this._cache, this._organisation, this._module, confs[i]);
                }
                if (this._xml) {
                    this.genxml(ivy, this._cache, this._organisation, this._module, confs[i]);
                }
                if (!this._graph) continue;
                this.gengraph(ivy, this._cache, this._organisation, this._module, confs[i]);
            }
        }
        catch (IOException e) {
            throw new BuildException("impossible to generate report", (Throwable)e);
        }
    }

    private void genxml(Ivy ivy, File cache, String organisation, String module, String conf) throws IOException {
        File xml = new File(cache, XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), conf));
        File out = this._todir != null ? new File(this._todir, IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", "xml", conf)) : new File(IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", "xml", conf));
        FileUtil.copy(xml, out, null);
    }

    private void genreport(Ivy ivy, File cache, String organisation, String module, String conf) throws IOException {
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.setIn(new File(cache, XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), conf)));
        File out = this._todir != null ? new File(this._todir, IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", this._xslext, conf)) : new File(IvyPatternHelper.substitute(this._outputpattern, organisation, module, "", "", "", this._xslext, conf));
        if (out.getParentFile() != null && !out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        } else if (out.getParentFile() == null) {
            out = new File("./" + out.getPath());
        }
        xslt.setOut(out);
        xslt.setStyle(this.getReportStylePath(cache));
        XSLTProcess.Param param = xslt.createParam();
        param.setName("confs");
        param.setExpression(this._conf);
        param = xslt.createParam();
        param.setName("extension");
        param.setExpression(this._xslext);
        xslt.execute();
        if (this._todir != null && this._xslFile == null) {
            File css = new File(this._todir, "ivy-report.css");
            if (!css.exists()) {
                Message.debug("copying report css to " + this._todir);
                FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), css, null);
            }
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), new File(cache, "ivy-report.css"), null);
        }
    }

    private String getReportStylePath(File cache) throws IOException {
        if (this._xslFile != null) {
            return this._xslFile;
        }
        File style = new File(cache, "ivy-report.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), style, null);
        return style.getAbsolutePath();
    }

    private void gengraph(Ivy ivy, File cache, String organisation, String module, String conf) throws IOException {
        File out = this._todir != null ? this._todir : new File(".");
        XSLTProcess xslt = new XSLTProcess();
        xslt.setTaskName(this.getTaskName());
        xslt.setProject(this.getProject());
        xslt.setDestdir(out);
        xslt.setBasedir(cache);
        xslt.setExtension(".graphml");
        xslt.setIncludes(XmlReportOutputter.getReportFileName(new ModuleId(organisation, module), conf));
        xslt.setStyle(this.getGraphStylePath(cache));
        xslt.execute();
    }

    private String getGraphStylePath(File cache) throws IOException {
        File style = new File(cache, "ivy-report-graph.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report-graph.xsl"), style, null);
        return style.getAbsolutePath();
    }

    public boolean isXml() {
        return this._xml;
    }

    public void setXml(boolean xml) {
        this._xml = xml;
    }

    public boolean isXsl() {
        return this._xsl;
    }

    public void setXsl(boolean xsl) {
        this._xsl = xsl;
    }

    public String getXslext() {
        return this._xslext;
    }

    public void setXslext(String xslext) {
        this._xslext = xslext;
    }
}

