/* ========================================================================== */
/* === umfpack_get_lunz ===================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_get_lunz
(
    int *lnz,
    int *unz,
    int *n,
    void *Numeric
) ;

long umfpack_l_get_lunz
(
    long *lnz,
    long *unz,
    long *n,
    void *Numeric
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Numeric ;
    int status, lnz, unz, n ;
    status = umfpack_get_lunz (&lnz, &unz, &n, Numeric) ;

long Syntax:

    #include "umfpack.h"
    void *Numeric ;
    long status, lnz, unz, n ;
    status = umfpack_l_get_lunz (&lnz, &unz, &n, Numeric) ;

Purpose:

    Determines the size and number of nonzeros in the LU factors held by the
    Numeric object.  These are also the sizes of the output arrays required
    by umfpack_get_numeric.

    This routine may seem redundant, since n is a value originally passed to
    umfpack_symbolic by the user, and lnz and unz are available from the Info
    array.  However, the Info array is not always returned (its use is
    optional).  This routine is also useful in the context of many sparse linear
    systems, with many Numeric handles.  The user could store an array of
    Numeric objects in an array of (void *) pointers, for example.  The Info
    array is re-initialized each time an UMFPACK routine is called, and thus the
    lnz and unz information could be lost.  Lnz and unz can differ from
    different calls to umfpack_numeric with different numerical values (Ax),
    even when using the same Symbolic object.   This routine allows the LU
    factors to be extracted from the Numeric object (with umfpack_get_numeric)
    without the use of the corresponding Info array.

Returns:

    UMFPACK_OK if successful.
    UMFPACK_ERROR_invalid_Numeric_object if Numeric is not a valid object.
    UMFPACK_ERROR_argument_missing if lnz, unz, or n are (Int *) NULL

Arguments:

    Int *lnz ;		Output argument.

	The number of nonzeros in L, including the diagonal (which is all
	one's).  This value is the required size of the Li and Lx arrays as
	computed by umfpack_get_numeric.  The value of lnz is identical to
	Info [UMFPACK_LNZ], if that value was returned by umfpack_numeric.

    Int *unz ;		Output argument.

	The number of nonzeros in U, including the diagonal.  This value is the
	required size of the Ui and Ux arrays as computed by
	umfpack_get_numeric.  The value of unz is identical to
	Info [UMFPACK_UNZ], if that value was returned by umfpack_numeric.

    Int *n ;		Output argument.

	The order of the L and U matrices.  The size of Lp and Up, as required
	by umfpack_get_numeric, is n+1, and the size of P and Q are n.  The
	value of n is identical to that passed to umfpack_symbolic.

    void *Numeric ;	Input argument, not modified.

	Numeric must point to a valid Numeric object, computed by
	umfpack_numeric.

*/

