dnl Copyright (C) 2003-2004 VA Linux Systems Japan, K.K.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl $Id: ultrapossum.m4,v 1.8 2004/10/31 06:01:53 taru Exp $

AC_DEFUN([AC_PROG_ULTRAPOSSUMCONFIG],
[
  AC_PATH_TOOL([ULTRAPOSSUMCONFIG], [ultrapossum-config])
])

AC_DEFUN([AM_ULTRAPOSSUM_APPLICATION],
[
  AC_PROG_ULTRAPOSSUMCONFIG
  AC_MSG_CHECKING([for UltraPossum application directories])
  eval `$ULTRAPOSSUMCONFIG get APPSCONFDIR APPSDIR 2> /dev/null`

  if test "x$APPSCONFDIR" = "x"; then
    AC_MSG_ERROR([null])
  fi
  AC_SUBST([APPSCONFDIR])
  if test "x$APPSDIR" = "x"; then
    AC_MSG_ERROR([null])
  fi
  AC_SUBST([APPSDIR])

  AC_MSG_RESULT([ok])
]
)

AC_DEFUN([AM_ULTRAPOSSUM_MODULE],
[
  AC_PROG_ULTRAPOSSUMCONFIG

  AC_MSG_CHECKING([for UltraPossum module variables])

  vars="SHAREDIR TESTDIR TESTSCRIPTSDIR CONFDIR APPSDIR MODULEDIR UPDATEDIR BACKUPDIR SYSCONFDIR APPSCONFDIR TEMPLATEDIR MODULECONFDIR SSHKEYDIR"
  eval `$ULTRAPOSSUMCONFIG get $vars`

  AC_SUBST(SHAREDIR)
  AC_SUBST(TESTDIR)
  AC_SUBST(TESTSCRIPTSDIR)
  AC_SUBST(CONFDIR)
  AC_SUBST(APPSDIR)
  AC_SUBST(MODULEDIR)
  AC_SUBST(UPDATEDIR)
  AC_SUBST(BACKUPDIR)
  AC_SUBST(SYSCONFDIR)
  AC_SUBST(APPSCONFDIR)
  AC_SUBST(TEMPLATEDIR)
  AC_SUBST(MODULECONFDIR)
  AC_SUBST(SSHKEYDIR)
  
  AC_MSG_RESULT([ok])

]
)


dnl $1 variable name
dnl $2 directory candidates
dnl $3 file which should be there
dnl $4 variable description
AC_DEFUN([AM_ULTRAPOSSUM_DIRECTORY],
[
AC_ARG_WITH($1,
[  --with-]$1=DIR  $4,
case ["$withval"] in
        [*)]
                $1=["$withval"]
                ;;
esac
)dnl

AC_MSG_CHECKING(for $1)
if test "x[$]$1" = "x"; then
  for d in $2
  do
    d=$(eval echo `echo $d`)
    for f in $3
    do
      if test -e "$d/$f"; then
        $1="$d"
      fi
    done
  done
fi

if test "x[$]$1" = "x"; then
  if test "x$automodules" = "x"; then
    AC_MSG_ERROR([no])
  else
    AC_MSG_RESULT([no])
  fi
else
  AC_MSG_RESULT([$]$1)
fi

AC_SUBST($1)

])

