/*
 * @(#)QuaquaColorPreviewPanel.java  1.2  2005-12-18
 *
 * Copyright (c) 2005 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package contrib.ch.randelshofer.quaqua.colorchooser;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;

import contrib.ch.randelshofer.quaqua.*;
/**
 * QuaquaColorPreviewPanel.
 *
 * @author  Werner Randelshofer
 * @version 1.2 2005-12-18 Tweaked insets.
 * <br>1.1 2005-09-20 Added tooltip. This is not what the native 
 * NSColorPicker does, but it is very useful.
 * <br>1.0  30 March 2005  Created.
 */
public class QuaquaColorPreviewPanel extends JPanel implements UIResource {
    private final static Color previewBorderColor = new Color(0x949494);
    private final static Color previewBackgroundColor = new Color(0xffffff);
    /** Creates new form. */
    public QuaquaColorPreviewPanel() {
        initComponents();
        setBorder(new VisualMargin(3,0,3,0));
        setToolTipText("on"); // set dummy text, to switch tooltip on
    }
    
    public void paintComponent(Graphics g) {
        Insets insets = getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = getWidth() - insets.left - insets.right;
        int h = getHeight() - insets.top - insets.bottom;
        g.setColor(previewBackgroundColor);
        g.fillRect(x+1,y+1,w-2,h-2);
        g.setColor(previewBorderColor);
        g.drawRect(x,y,w-1,h-1);
        g.setColor(getForeground());
        g.fillRect(x+2,y+2,w-4,h-4);
    }
    
    public String getToolTipText(MouseEvent evt) {
        Color color = getForeground();
        return (color == null) ? null : color.getRed()+", "+ color.getGreen() + ", " + color.getBlue();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.BorderLayout());

        setPreferredSize(new java.awt.Dimension(26, 26));
    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
