/* child.h  --  The child of sigit, eventualy called with a fifo pointer, 
                  which it is monitoring.  

   Copyright (C) Kenneth 'Redhead' Nielsen <kn@redhead.dk>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */



/****
 * $Id: child.h,v 1.2 2002/10/18 18:25:23 redhead Exp $ 
 * $Log: child.h,v $
 * Revision 1.2  2002/10/18 18:25:23  redhead
 * Added the use of boxes to create a surrounding box around the signature
 * This introduced the --with-boxes flag to configure.
 * If that flag isn't used it will default be assumed boxes isn't installed
 * Else the configure script will search for boxes, if none should be found
 * in the search path, you can use --with-boxes=/where to specify it.
 *
 ****/



#ifndef __SIGIT__CHILD__H__
#define __SIGIT__CHILD__H__    1

#include "config.h"
#include "files.h"

#ifdef sigit
#include "deamoninit.h"
#endif


void* monitor_fifo(void * ptr);
void* monitor_nfs_fifo(void* ptr);

#endif
