//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

dnl Ignore the next line
// This is a generated file, do not edit. Generated from __file__.

include(template.macros.m4)
include(sigcperl.macros.m4)

#ifndef SIGC_PERL_SIGNAL_ARRAY_H
#define SIGC_PERL_SIGNAL_ARRAY_H

#include <set>

#include <sigcperl/signal_base.h>
#include <sigc++/adaptor.h>

define([PERL_ARRAY_SIGNAL],[// ---------- Perl Array Signal NUM($1) ----------

PERL_ARRAY_SIGNAL_IMPL(R,[$1],C)
PERL_ARRAY_SIGNAL_IMPL(void,[$1],C)
PERL_ARRAY_SIGNAL_IMPL(R,[$1],C&)
PERL_ARRAY_SIGNAL_IMPL(void,[$1],C&)
PERL_ARRAY_SIGNAL_IMPL(R,[$1],const C&)
PERL_ARRAY_SIGNAL_IMPL(void,[$1],const C&)
template<LIST(class R,ARG_CLASS($1),class C,class Marsh)>
SignalBase* WrapArraySignal([SigC::Signal]eval(NUM($1)+1)<LIST(R,ARG_TYPE($1),C,Marsh)> &signal,
	SV *parent = 0) throw()
{
  return new [SignalArray]NUM($1)<LIST(R,ARG_TYPE($1),C,Marsh)>(signal, parent);
}
])dnl

// This one is for a signal which emits a
// standard container of something
define([PERL_ARRAY_SIGNAL_IMPL],[dnl
ifelse($1,void,[dnl
template <LIST(ARG_CLASS($2),class C,class Marsh)>
class [SignalArray]NUM($2)<LIST(void,ARG_TYPE($2),$3,Marsh)> : public SignalBase
],[dnl
template <LIST(class $1,ARG_CLASS($2),class C,[class Marsh]ifelse($3,C,[=SigC::Marshal<$1> ],[]))>
class [SignalArray]NUM($2)ifelse($3,C,[],[<LIST(R,ARG_TYPE($2),$3,Marsh)>]) : public SignalBase
])dnl
{
 public:
  typedef [SigC::Signal]eval(NUM($2)+1)<LIST($1,ARG_TYPE($2),$3,Marsh)> SignalType;
  typedef [SigC::Slot]eval(NUM($2)+1)<LIST($1,ARG_TYPE($2),$3)> SlotType;

  [SignalArray]NUM($2)(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    ifelse(NUM($2),0,[],[if(data.size() < NUM($2))
      throw BadConvertVal();

    ARG_LOOP([DECLARE_SET_ARGS],[[;
    ]],$2);])

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    ifelse($1,void,[],[$1 val = ])m_signal.emit(
      LIST(ARG_LOOP([ARG_BOX_VALS],[[, ]],$2),c));

    ifelse($1,void,[return Data();],
    [if(VoidContext(flags))
      return Data();
    return Returns<$1>::getRetData(val);])
  }

 private:
  static $1 conv_func(LIST(NAMESPACE_ARG_REF($2),$3 c,SigC::AdaptorSlotNode* node))
  {
    Data data;
    I32 flags = ifelse($1,void,[G_VOID],[Returns<$1>::getFlags()]);
    ifelse($1,void,[],[R val;])

    dSP;
    ENTER;
    SAVETMPS;

    ifelse(NUM($2),0,[],[ARG_LOOP([PUSH_SV_ARGS],[[;
    ]],$2);])

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ifelse($1,void,[],[Data data_out =
      ])((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    ifelse($1,void,[],[try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }])

    SPAGAIN;
    FREETMPS;
    LEAVE;
    ifelse($1,void,[],[return val;])
  }

  [SignalArray]NUM($2)(const [SignalArray]NUM($2)&);
  [SignalArray]NUM($2)& operator=(const [SignalArray]NUM($2)&);

  SignalType &m_signal;
  ParentBox m_parent;
};
])dnl

namespace SigCPerl {

// This is a workaround to allow for
// std::set<>, where you need insert()
// instead of push_back()
template<class C>
inline void PushBack(C& c, const typename C::value_type& val) {c.push_back(val);}
template<class C>
inline void PushBack(std::set<C>& c, const C& val) {c.insert(val);}

// A SignalArray0<> actually wraps a SigC::Signal1<>, so we only go
// up to 4 as the default instead of 5

PERL_ARRAY_SIGNAL(ARGS(P,0))
PERL_ARRAY_SIGNAL(ARGS(P,1))
PERL_ARRAY_SIGNAL(ARGS(P,2))
PERL_ARRAY_SIGNAL(ARGS(P,3))
PERL_ARRAY_SIGNAL(ARGS(P,4))

} // namespace SigCPerl

#endif // SIGC_PERL_SIGNAL_ARRAY_H
